/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.logging.WMSLoggingThrottle;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerQuicktimeH264;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class RTPDePacketizerVP8
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    public static final int FLAGS_ISFIRST = 128;
    public static final int FLAGS_ISLAST = 64;
    public static final int FLAGS_ISKEY = 1;
    private RTPSequence seq = new RTPSequence();
    private RTPPacket workingPacket = null;
    private byte[] payloadDescription = null;
    private byte[] avccData = null;
    private Object payloadLock = new Object();
    private long lastTimecode = -1L;
    private long lastSeq = -1L;
    private boolean waitForEnd = false;
    private int waitForDropped = 0;
    private boolean isSendReady = false;
    private int fragmentSize = 0;
    private byte[] fragmentBuffer = null;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean isCodecConfig = false;
    private long lastSentTimecode = -1L;
    private long lastFlushTimecode = -1L;
    private RTPPacket saveSendPacket = null;
    private int lateCount = 0;
    private WMSLoggingThrottle logThrottle = new WMSLoggingThrottle();

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerVP8.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isVideo() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("vp8");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private void openPacket(long l) {
        if (this.workingPacket == null) {
            this.workingPacket = new RTPPacket();
            this.workingPacket.setType(9);
            this.workingPacket.setCodec(8);
            this.workingPacket.setFrameType(2);
            this.workingPacket.setTimecode(l);
        }
    }

    public static String logTimeContext(RTPTrack rTPTrack) {
        String string = "";
        Date date = new Date();
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"HH:mm:ss");
        string = (rTPTrack == null ? "unknown" : rTPTrack.getStream().getStreamName()) + ": " + fastDateFormat.format(date) + ": ";
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        this.setVideoCodecId(rTPTrack, 8);
        try {
            boolean bl;
            int n4;
            boolean bl2;
            int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
            boolean bl3 = bl2 = (byArray[n + 1] >> 7 & 1) == 1;
            if (this.waitForEnd) {
                if (bl2) {
                    this.lastTimecode = this.timecode.get();
                    this.lastSeq = this.seq.longValue();
                    this.waitForEnd = false;
                }
                ++this.waitForDropped;
                this.workingPacket = null;
                if (!this.debugLog) return;
                WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerVP8.logTimeContext(rTPTrack) + "  waitforend: dropped:" + this.waitForDropped);
                return;
            }
            long l2 = this.seq.longValue();
            if (this.lastSeq != -1L && this.lastSeq + 1L != l2) {
                n4 = 0;
                ++this.lateCount;
                if (this.lateCount > 30) {
                    n4 = 1;
                    this.waitForEnd = true;
                    this.waitForDropped = 0;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerVP8.logTimeContext(rTPTrack) + "  latecount: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                    }
                } else {
                    if (l2 <= this.lastSeq) {
                        if (!this.debugLog) return;
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerVP8.logTimeContext(rTPTrack) + "  latepacket: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                        return;
                    }
                    n4 = 1;
                    this.waitForEnd = true;
                    this.waitForDropped = 0;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerVP8.logTimeContext(rTPTrack) + "  dropmany: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                    }
                }
                if (this.waitForEnd) {
                    this.workingPacket = null;
                    this.lastSeq = this.seq.longValue();
                    return;
                }
            }
            this.lastTimecode = this.timecode.get();
            this.lastSeq = this.seq.longValue();
            this.lateCount = 0;
            n4 = n5;
            if (n4 >= n2) {
                return;
            }
            byte by = byArray[n + n4];
            boolean bl4 = bl = (by & 1) == 1;
            if (++n4 >= n2) {
                return;
            }
            this.openPacket(this.timecode.get());
            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n4, n2 - n4);
            this.workingPacket.addFragment(rTPPacketFragment);
            if (!bl2) return;
            if (this.workingPacket != null) {
                if (bl) {
                    this.workingPacket.setFrameType(1);
                }
                this.sendPacket(rTPTrack, this.workingPacket, false);
            }
            this.workingPacket = null;
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).error("RTPDePacketizerVP8.handleRTPPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

