/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.ts.TransportStreamUtils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.stream.IMediaStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerMPEGTS
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    public static final int PATINTERVAL = 90;
    public static final int PCRINTERVAL = 36;
    public static final int TS_PACKETLEN = 188;
    public static final int TS_RTPHEADER = 12;
    public static final int TS_SYNCBYTE = 71;
    public static final int TS_PACKETPERBLOCK = 6;
    protected RTPTrack transportTrack = null;
    protected long lastPAT = -1L;
    protected byte[] block = null;
    protected int pcount = 0;
    protected int pptr = 0;
    protected int videoPID = 256;
    protected byte videoStreamID = (byte)-32;
    protected int videoCodec = -1;
    protected int audioPID = 257;
    protected byte audioStreamID = (byte)-64;
    protected int audioCodec = -1;
    protected long videoCCounter = -1L;
    protected long audioCCounter = -1L;
    protected long patCCounter = 0L;
    protected AACFrame aacFrame = null;
    protected H264CodecConfigParts h264CodecConfigPart = null;
    protected long lastAudioTimecode = -1L;
    protected long lastVideoTimecode = -1L;
    protected long lastPCRTimecode = -1L;
    protected boolean isFirstAudioPacket = true;
    protected boolean isFirstVideoPacket = true;
    protected WaitingAAC waitingAAC = new WaitingAAC();
    protected boolean inited = false;
    protected int pcrBufferTime = 750;

    public RTPPacketizerMPEGTS() {
        this.sdpTypeId = 98;
    }

    private void nextBlock(OutputStream outputStream, RTPTrack rTPTrack, long l) {
        if (this.block == null || this.pcount >= 6) {
            if (this.block != null) {
                this.flushBlock(outputStream, rTPTrack, false, l);
            }
            this.block = new byte[(this.isRTPWrapped ? 12 : 0) + 1128];
            this.pcount = 1;
            this.pptr = this.isRTPWrapped ? 12 : 0;
        } else {
            ++this.pcount;
            this.pptr += 188;
        }
    }

    private void flushBlock(OutputStream outputStream, RTPTrack rTPTrack, boolean bl, long l) {
        block1: {
            if (this.block == null) break block1;
            if (this.isRTPWrapped) {
                long l2 = rTPTrack.getSSRC();
                this.fillHeader(this.block, false, this.sequence, l, l2, this.sdpTypeId);
                ++this.sequence;
            }
            int n = (this.isRTPWrapped ? 12 : 0) + this.pcount * 188;
            rTPTrack.sendRTPMessage(outputStream, this.block, 0, n);
        }
    }

    private int sendPAT(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, long l) {
        int n = 0;
        this.nextBlock(outputStream, this.transportTrack, l);
        TransportStreamUtils.fillPAT(this.block, this.pptr, this.patCCounter);
        n += 188;
        int n2 = TransportStreamUtils.videoCodecToStreamType(this.videoCodec);
        int n3 = TransportStreamUtils.audioCodecToStreamType(this.audioCodec);
        this.nextBlock(outputStream, this.transportTrack, l);
        TransportStreamUtils.fillPMT(this.block, this.pptr, this.patCCounter, this.videoPID, this.audioPID, n2, n3);
        ++this.patCCounter;
        return n += 188;
    }

    private long getPCRTimecode() {
        long l = -1L;
        if (this.lastAudioTimecode >= 0L && this.lastVideoTimecode >= 0L) {
            l = Math.min(this.lastAudioTimecode, this.lastVideoTimecode);
        } else if (this.lastAudioTimecode >= 0L) {
            l = this.lastAudioTimecode;
        } else if (this.lastVideoTimecode >= 0L) {
            l = this.lastVideoTimecode;
        }
        if (this.lastPCRTimecode != -1L && l < this.lastPCRTimecode) {
            l = this.lastPCRTimecode;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l >= (long)this.pcrBufferTime) {
            l -= (long)this.pcrBufferTime;
        }
        this.lastPCRTimecode = l;
        return l;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n;
        block56: {
            int n2;
            int n3;
            byte[] byArray;
            int n4;
            int n5;
            boolean bl;
            boolean bl2;
            int n6;
            int n7;
            int n8;
            Object object;
            boolean bl3;
            long l2;
            long l3;
            int n9;
            int n10;
            int n11;
            block61: {
                int n12;
                int n13;
                block57: {
                    block60: {
                        int n14;
                        byte[] byArray2;
                        block59: {
                            block58: {
                                n = 0;
                                if (!this.inited) {
                                    WMSProperties wMSProperties;
                                    if (iMediaStream != null && (wMSProperties = iMediaStream.getProperties()) != null) {
                                        this.pcrBufferTime = wMSProperties.getPropertyInt("pcrBufferTime", this.pcrBufferTime);
                                    }
                                    this.inited = true;
                                }
                                long l4 = System.currentTimeMillis();
                                if (this.lastPAT == -1L || l4 - this.lastPAT > 90L) {
                                    this.lastPAT = l4;
                                    n += this.sendPAT(outputStream, iMediaStream, rTPTrack, l * 90L);
                                }
                                if (this.transportTrack == null) {
                                    this.transportTrack = rTPTrack.getRTPStream().getTrack("mpegts-transport");
                                }
                                if (this.transportTrack == null) break block56;
                                RTPStream rTPStream = rTPTrack.getRTPStream();
                                if (aMFPacket.getSize() < 2) break block56;
                                n13 = aMFPacket.getType();
                                n11 = aMFPacket.getFirstByte();
                                n12 = aMFPacket.getSecondByte();
                                if (n13 != 8) break block57;
                                byArray2 = aMFPacket.getData();
                                n14 = aMFPacket.getSize();
                                n10 = FLVUtils.getAudioCodec(n11);
                                if (n10 != 10 || n12 == 1) break block58;
                                if (n12 != 0) break block56;
                                this.aacFrame = AACUtils.decodeAACCodecConfig(byArray2, 2);
                                break block56;
                            }
                            if (n10 == 10 && this.aacFrame == null) break block56;
                            if (n10 != 10) break block59;
                            this.aacFrame.setSize(n14 - 2 + 7);
                            byte[] byArray3 = new byte[7];
                            AACUtils.frameToDTSBuffer(this.aacFrame, byArray3, 0);
                            this.waitingAAC.fragments.add(new RTPPacketFragment(byArray3, 0, byArray3.length));
                            this.waitingAAC.size += byArray3.length;
                            this.waitingAAC.fragments.add(new RTPPacketFragment(byArray2, 2, n14 - 2));
                            this.waitingAAC.size += n14 - 2;
                            ++this.waitingAAC.count;
                            if (this.waitingAAC.timecode == -1L) {
                                this.waitingAAC.timecode = l;
                            }
                            this.waitingAAC.lastTimecode = l;
                            break block60;
                        }
                        if (n10 != 2) break block56;
                        this.waitingAAC.fragments.add(new RTPPacketFragment(byArray2, 1, n14 - 1));
                        this.waitingAAC.size += n14 - 1;
                        ++this.waitingAAC.count;
                        if (this.waitingAAC.timecode == -1L) {
                            this.waitingAAC.timecode = l;
                        }
                        this.waitingAAC.lastTimecode = l;
                    }
                    if (this.waitingAAC.count < 3) break block56;
                    this.lastAudioTimecode = this.waitingAAC.timecode;
                    n9 = this.waitingAAC.size;
                    l2 = l3 = this.waitingAAC.timecode * 90L;
                    bl3 = false;
                    int n15 = 0;
                    object = this.waitingAAC.fragments.remove(0);
                    n8 = 0;
                    n7 = ((RTPPacketFragment)object).getOffset();
                    n6 = ((RTPPacketFragment)object).getLen();
                    byte[] byArray4 = ((RTPPacketFragment)object).getBuffer();
                    bl2 = true;
                    bl = false;
                    long l5 = l3;
                    if (this.videoCodec == -1) {
                        l5 = this.getPCRTimecode();
                        bl = true;
                    }
                    do {
                        long l6;
                        int n16;
                        int n17;
                        n5 = 0;
                        this.nextBlock(outputStream, this.transportTrack, l * 90L);
                        this.block[this.pptr + n5] = 71;
                        this.block[this.pptr + ++n5] = (byte)((bl2 ? 64 : 0) + (0x1F & this.audioPID >> 8));
                        this.block[this.pptr + ++n5] = (byte)(this.audioPID & 0xFF);
                        this.audioCCounter = this.audioCCounter == -1L ? 1L : ++this.audioCCounter;
                        this.block[this.pptr + ++n5] = (byte)(16L + (this.audioCCounter & 0xFL));
                        ++n5;
                        int n18 = 0;
                        if (bl2) {
                            n18 = 9 + (bl3 ? 10 : 5);
                        }
                        if ((n17 = 188 - n5 - n18) > n9 - n15) {
                            n17 = n9 - n15;
                        }
                        if (bl) {
                            int n19 = this.pptr + 3;
                            this.block[n19] = (byte)(this.block[n19] | 0x20);
                            n16 = 8;
                            n17 = 188 - n5 - n18 - n16;
                            if (n17 > n9 - n15) {
                                n17 = n9 - n15;
                            }
                            if ((n4 = 188 - (n5 + n17 + n18 + n16)) < 0) {
                                n4 = 0;
                            }
                            this.block[this.pptr + n5] = (byte)(n16 - 1 + n4 & 0xFF);
                            this.block[this.pptr + ++n5] = (byte)(this.isFirstAudioPacket ? 144 : 16);
                            l6 = l5 * 90L;
                            byte[] byArray5 = BufferUtils.longToByteArray(l6 <<= 7);
                            this.block[this.pptr + ++n5 + 4] = (byte)((byArray5[7] & 0x80) + 126);
                            this.block[this.pptr + n5 + 3] = (byte)(byArray5[6] & 0xFF);
                            this.block[this.pptr + n5 + 2] = (byte)(byArray5[5] & 0xFF);
                            this.block[this.pptr + n5 + 1] = (byte)(byArray5[4] & 0xFF);
                            this.block[this.pptr + n5 + 0] = (byte)(byArray5[3] & 0xFF);
                            n5 += 6;
                            if (n4 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n5, n4);
                                n5 += n4;
                            }
                            if ((n17 = 188 - n5 - n18) > n9 - n15) {
                                n17 = n9 - n15;
                            }
                        } else if (n5 + n17 + n18 < 188) {
                            n16 = 188 - (n5 + n17 + n18);
                            int n20 = this.pptr + 3;
                            this.block[n20] = (byte)(this.block[n20] | 0x20);
                            if (n16 > 1) {
                                this.block[this.pptr + n5] = (byte)(--n16 & 0xFF);
                                this.block[this.pptr + ++n5] = 0;
                                ++n5;
                                if (--n16 > 0) {
                                    System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n5, n16);
                                }
                                n5 += n16;
                            } else {
                                this.block[this.pptr + n5] = 0;
                                ++n5;
                            }
                        }
                        bl = false;
                        if (bl2) {
                            this.block[this.pptr + n5] = 0;
                            this.block[this.pptr + ++n5] = 0;
                            this.block[this.pptr + ++n5] = 1;
                            this.block[this.pptr + ++n5] = this.audioStreamID;
                            n16 = bl3 ? 10 : 5;
                            n4 = n9 + n16 + 3;
                            BufferUtils.intToByteArray(n4, this.block, this.pptr + ++n5, 2);
                            this.block[this.pptr + (n5 += 2)] = -128;
                            this.block[this.pptr + ++n5] = (byte)(bl3 ? 192 : 128);
                            this.block[this.pptr + ++n5] = (byte)n16;
                            l6 = l2;
                            this.block[this.pptr + ++n5 + 4] = (byte)(((l6 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n5 + 3] = (byte)((l6 >>= 7) & 0xFFL);
                            this.block[this.pptr + n5 + 2] = (byte)((((l6 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n5 + 1] = (byte)((l6 >>= 7) & 0xFFL);
                            this.block[this.pptr + n5 + 0] = (byte)((((l6 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                            n5 += 5;
                            if (bl3) {
                                l6 = l3;
                                this.block[this.pptr + n5 + 4] = (byte)(((l6 & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n5 + 3] = (byte)((l6 >>= 7) & 0xFFL);
                                this.block[this.pptr + n5 + 2] = (byte)((((l6 >>= 8) & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n5 + 1] = (byte)((l6 >>= 7) & 0xFFL);
                                this.block[this.pptr + n5 + 0] = (byte)((((l6 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                                n5 += 5;
                            }
                        }
                        do {
                            if ((n16 = n17) > n6 - n8) {
                                n16 = n6 - n8;
                            }
                            System.arraycopy(byArray4, n7 + n8, this.block, this.pptr + n5, n16);
                            n5 += n16;
                            n15 += n16;
                            n17 -= n16;
                            if ((n8 += n16) < n6) continue;
                            n8 = 0;
                            if (this.waitingAAC.fragments.size() <= 0) continue;
                            object = this.waitingAAC.fragments.remove(0);
                            n7 = ((RTPPacketFragment)object).getOffset();
                            n6 = ((RTPPacketFragment)object).getLen();
                            byArray4 = ((RTPPacketFragment)object).getBuffer();
                        } while (n5 < 188 && n15 < n9);
                        bl2 = false;
                        this.isFirstAudioPacket = false;
                    } while (n15 < n9);
                    this.waitingAAC.clear();
                }
                if (n13 != 9) break block56;
                this.lastVideoTimecode = l;
                int n21 = FLVUtils.getVideoCodec(n11);
                byArray = aMFPacket.getData();
                n10 = aMFPacket.getSize();
                if (n21 != 7 || n12 == 1) break block61;
                if (n12 != 0) break block56;
                this.h264CodecConfigPart = H264Utils.breakApartAVCC(byArray, 5, n10 - 5);
                H264CodecConfigInfo h264CodecConfigInfo = H264Utils.decodeAVCC(byArray, 5);
                break block56;
            }
            n9 = BufferUtils.byteArrayToInt(byArray, 2, 3);
            if ((n9 & 0x800000) == 0x800000) {
                n9 |= 0xFF000000;
            }
            l3 = l * 90L;
            l2 = n9 == 0 ? l3 : (l + (long)n9) * 90L;
            bl3 = n9 != 0;
            ArrayList<RTPPacketFragment> arrayList = new ArrayList<RTPPacketFragment>();
            object = new byte[4];
            object[3] = 1;
            n8 = 0;
            n7 = 0;
            n6 = 5;
            boolean bl4 = false;
            bl2 = false;
            bl = false;
            while (n6 + 4 <= n10 && (n3 = BufferUtils.byteArrayToInt(byArray, n6, 4)) > 0 && (n6 += 4) + n3 <= n10) {
                n2 = byArray[n6] & 0x1F;
                if (n2 == 7) {
                    bl4 = true;
                } else if (n2 == 8) {
                    bl2 = true;
                } else if (n2 == 9) {
                    bl = true;
                }
                arrayList.add(new RTPPacketFragment((byte[])object, 0, ((Object)object).length));
                arrayList.add(new RTPPacketFragment(byArray, n6, n3));
                n8 += n3 + ((Object)object).length;
                ++n7;
                if ((n6 += n3) < n10) continue;
                break;
            }
            boolean bl5 = false;
            n2 = FLVUtils.getFrameType(n11);
            n5 = 0;
            if (!bl && !bl) {
                byte[] byArray6 = new byte[6];
                byArray6[3] = 1;
                byArray6[4] = 9;
                byArray6[5] = n2 == 1 ? 16 : (n2 == 3 ? 80 : 48);
                arrayList.add(n5, new RTPPacketFragment(byArray6, 0, byArray6.length));
                ++n5;
                n8 += byArray6.length;
                ++n7;
                bl5 = true;
            }
            if (!(n2 != 1 || bl2 && bl)) {
                if (n2 == 1 && !bl4 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.sps != null) {
                    byte[] byArray7 = new byte[4];
                    byArray7[3] = 1;
                    arrayList.add(n5, new RTPPacketFragment(byArray7, 0, byArray7.length));
                    arrayList.add(++n5, new RTPPacketFragment(this.h264CodecConfigPart.sps, 0, this.h264CodecConfigPart.sps.length));
                    ++n5;
                    n8 += this.h264CodecConfigPart.sps.length + byArray7.length;
                    ++n7;
                    bl5 = true;
                }
                if (n2 == 1 && !bl2 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.ppss != null) {
                    for (byte[] byArray8 : this.h264CodecConfigPart.ppss) {
                        byte[] byArray9 = new byte[4];
                        byArray9[3] = 1;
                        arrayList.add(n5, new RTPPacketFragment(byArray9, 0, byArray9.length));
                        arrayList.add(++n5, new RTPPacketFragment(byArray8, 0, byArray8.length));
                        ++n5;
                        n8 += byArray8.length + byArray9.length;
                        ++n7;
                        bl5 = true;
                    }
                }
            }
            if (n7 <= 0) break block56;
            int n22 = 0;
            RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
            int n23 = 0;
            n4 = rTPPacketFragment.getOffset();
            int n24 = rTPPacketFragment.getLen();
            byte[] byArray10 = rTPPacketFragment.getBuffer();
            long l7 = this.getPCRTimecode();
            boolean bl6 = true;
            boolean bl7 = true;
            int n25 = 9000;
            do {
                bl6 = true;
                bl7 = true;
                int n26 = 0;
                int n27 = n8 - n22;
                if (n27 > n25) {
                    n27 = n25;
                }
                do {
                    long l8;
                    int n28;
                    int n29;
                    int n30;
                    int n31 = 0;
                    this.nextBlock(outputStream, this.transportTrack, l * 90L);
                    this.block[this.pptr + n31] = 71;
                    this.block[this.pptr + ++n31] = (byte)((bl6 ? 64 : 0) + (0x1F & this.videoPID >> 8));
                    this.block[this.pptr + ++n31] = (byte)(this.videoPID & 0xFF);
                    this.videoCCounter = this.videoCCounter == -1L ? 1L : ++this.videoCCounter;
                    this.block[this.pptr + ++n31] = (byte)(16L + (this.videoCCounter & 0xFL));
                    ++n31;
                    int n32 = 0;
                    if (bl6) {
                        n32 = 9 + (bl3 ? 10 : 5);
                    }
                    if ((n30 = 188 - n31 - n32) > n27 - n26) {
                        n30 = n27 - n26;
                    }
                    if (bl7) {
                        int n33 = this.pptr + 3;
                        this.block[n33] = (byte)(this.block[n33] | 0x20);
                        n29 = 8;
                        n30 = 188 - n31 - n32 - n29;
                        if (n30 > n27 - n26) {
                            n30 = n27 - n26;
                        }
                        n28 = 0;
                        if (n31 + n30 + n32 + n29 < 188) {
                            n28 = 188 - (n31 + n30 + n32 + n29);
                        }
                        this.block[this.pptr + n31] = (byte)(n29 - 1 + n28 & 0xFF);
                        this.block[this.pptr + ++n31] = (byte)(this.isFirstVideoPacket ? 144 : 16);
                        l8 = l7 * 90L;
                        byte[] byArray11 = BufferUtils.longToByteArray(l8 <<= 7);
                        this.block[this.pptr + ++n31 + 4] = (byte)((byArray11[7] & 0x80) + 126);
                        this.block[this.pptr + n31 + 3] = (byte)(byArray11[6] & 0xFF);
                        this.block[this.pptr + n31 + 2] = (byte)(byArray11[5] & 0xFF);
                        this.block[this.pptr + n31 + 1] = (byte)(byArray11[4] & 0xFF);
                        this.block[this.pptr + n31 + 0] = (byte)(byArray11[3] & 0xFF);
                        n31 += 6;
                        if (n28 > 0) {
                            System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n31, n28);
                            n31 += n28;
                        }
                        if ((n30 = 188 - n31 - n32) > n27 - n26) {
                            n30 = n27 - n26;
                        }
                    } else if (n31 + n30 + n32 < 188) {
                        n29 = 188 - (n31 + n30 + n32);
                        int n34 = this.pptr + 3;
                        this.block[n34] = (byte)(this.block[n34] | 0x20);
                        if (n29 > 1) {
                            this.block[this.pptr + n31] = (byte)(--n29 & 0xFF);
                            this.block[this.pptr + ++n31] = 0;
                            ++n31;
                            if (--n29 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n31, n29);
                            }
                            n31 += n29;
                        } else {
                            this.block[this.pptr + n31] = 0;
                            ++n31;
                        }
                    }
                    bl7 = false;
                    if (bl6) {
                        this.block[this.pptr + n31] = 0;
                        this.block[this.pptr + ++n31] = 0;
                        this.block[this.pptr + ++n31] = 1;
                        this.block[this.pptr + ++n31] = this.videoStreamID;
                        ++n31;
                        n29 = bl3 ? 10 : 5;
                        n28 = n27 + n29 + 3;
                        if (n28 >= 65536) {
                            System.out.println("toolong: " + n28);
                        }
                        BufferUtils.intToByteArray(n28, this.block, this.pptr + n31, 2);
                        this.block[this.pptr + (n31 += 2)] = -124;
                        this.block[this.pptr + ++n31] = (byte)(bl3 ? 192 : 128);
                        this.block[this.pptr + ++n31] = (byte)n29;
                        l8 = l2;
                        this.block[this.pptr + ++n31 + 4] = (byte)(((l8 & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n31 + 3] = (byte)((l8 >>= 7) & 0xFFL);
                        this.block[this.pptr + n31 + 2] = (byte)((((l8 >>= 8) & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n31 + 1] = (byte)((l8 >>= 7) & 0xFFL);
                        this.block[this.pptr + n31 + 0] = (byte)((((l8 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                        n31 += 5;
                        if (bl3) {
                            l8 = l3;
                            this.block[this.pptr + n31 + 4] = (byte)(((l8 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n31 + 3] = (byte)((l8 >>= 7) & 0xFFL);
                            this.block[this.pptr + n31 + 2] = (byte)((((l8 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n31 + 1] = (byte)((l8 >>= 7) & 0xFFL);
                            this.block[this.pptr + n31 + 0] = (byte)((((l8 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                            n31 += 5;
                        }
                    }
                    do {
                        if ((n29 = n30) > n24 - n23) {
                            n29 = n24 - n23;
                        }
                        System.arraycopy(byArray10, n4 + n23, this.block, this.pptr + n31, n29);
                        n31 += n29;
                        n22 += n29;
                        n30 -= n29;
                        n26 += n29;
                        if ((n23 += n29) < n24) continue;
                        n23 = 0;
                        if (arrayList.size() <= 0) continue;
                        rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                        n4 = rTPPacketFragment.getOffset();
                        n24 = rTPPacketFragment.getLen();
                        byArray10 = rTPPacketFragment.getBuffer();
                    } while (n31 < 188 && n26 < n27 && n22 < n8);
                    bl6 = false;
                    this.isFirstVideoPacket = false;
                } while (n26 < n27 && n22 < n8);
            } while (n22 < n8);
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        int n = 0;
        return n;
    }

    public void extractStreamInfo(RTPTrack rTPTrack, AMFPacket aMFPacket, AMFPacket aMFPacket2) {
        if (aMFPacket != null) {
            if (aMFPacket.getType() == 8) {
                this.audioCodec = FLVUtils.getAudioCodec(aMFPacket);
            } else if (aMFPacket.getType() == 9) {
                this.videoCodec = FLVUtils.getVideoCodec(aMFPacket);
            }
        }
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 90000;
        try {
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " MP2T/" + n2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(n2);
        rTPDescribeInfo.setSDPTypeId(this.sdpTypeId);
        return rTPDescribeInfo;
    }

    class WaitingAAC {
        long timecode = -1L;
        long lastTimecode = -1L;
        int count = 0;
        int size = 0;
        List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();

        WaitingAAC() {
        }

        public void clear() {
            this.timecode = -1L;
            this.lastTimecode = -1L;
            this.count = 0;
            this.size = 0;
            this.fragments.clear();
        }
    }
}

