/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC3984H264
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1438;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected boolean isBalanced = true;
    protected int maxVideoGroupSize = 4;
    protected int pendingCount = 0;
    protected int pendingSize = 0;
    protected long pendingTimecode = -1L;
    protected long lastTimecode = -1L;

    public RTPPacketizerRFC3984H264() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 97;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n;
        block18: {
            n = 0;
            n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
            try {
                if (aMFPacket.getSize() < 9) break block18;
                int n2 = aMFPacket.getFirstByte();
                int n3 = aMFPacket.getSecondByte();
                int n4 = FLVUtils.getVideoCodec(n2);
                if (FLVUtils.isVideoCodecConfig(aMFPacket)) break block18;
                byte[] byArray = aMFPacket.getData();
                int n5 = aMFPacket.getSize();
                int n6 = rTPTrack.getTimescale();
                int n7 = BufferUtils.byteArrayToInt(byArray, 2, 3);
                if ((n7 & 0x800000) == 0x800000) {
                    n7 |= 0xFF000000;
                }
                long l2 = (l + (long)n7) * (long)n6 / 1000L;
                long l3 = 0L;
                if (this.lastTimecode >= 0L) {
                    l3 = l2 - this.lastTimecode;
                }
                this.lastTimecode = l2;
                int n8 = 5;
                while (n8 + 4 <= n5) {
                    int n9 = BufferUtils.byteArrayToInt(byArray, n8, 4);
                    if (n9 > 0 && (n8 += 4) + n9 <= n5) {
                        int n10;
                        if (n9 > this.maxPacketSize) {
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            if (this.pendingCount > 0) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
                                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                                this.pendingTimecode = -1L;
                            }
                            if (this.isBalanced) {
                                int n15;
                                n10 = (n9 - 1) / (this.maxPacketSize - 2) + ((n9 - 1) % (this.maxPacketSize - 2) > 0 ? 1 : 0);
                                n14 = (n9 - 1) / n10 + ((n9 - 1) % n10 > 0 ? 1 : 0);
                                n13 = 1;
                                n12 = byArray[n8];
                                n11 = 0;
                                do {
                                    if (n13 + (n15 = n14) > n9) {
                                        n15 = n9 - n13;
                                    }
                                    int n16 = 14 + n15;
                                    byte[] byArray2 = new byte[n16];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n16, l2));
                                    byArray2[12] = (byte)((n12 & 0xE0) + 28);
                                    byArray2[13] = (byte)((n11 == 0 ? 128 : 0) + (n13 + n15 == n9 ? 64 : 0) + (n12 & 0x1F));
                                    System.arraycopy(byArray, n8 + n13, byArray2, 14, n15);
                                    ++n11;
                                } while ((n13 += n15) < n9);
                            } else {
                                n10 = 1;
                                n14 = byArray[n8];
                                n13 = 0;
                                do {
                                    if (n10 + (n12 = this.maxPacketSize - 2) > n9) {
                                        n12 = n9 - n10;
                                    }
                                    n11 = 14 + n12;
                                    byte[] byArray3 = new byte[n11];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n11, l2));
                                    byArray3[12] = (byte)((n14 & 0xE0) + 28);
                                    byArray3[13] = (byte)((n13 == 0 ? 128 : 0) + (n10 + n12 == n9 ? 64 : 0) + (n14 & 0x1F));
                                    System.arraycopy(byArray, n8 + n10, byArray3, 14, n12);
                                    ++n13;
                                } while ((n10 += n12) < n9);
                            }
                            n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                        } else {
                            n10 = 1 + 2 * (this.pendingCount + 1) + (this.pendingSize + n9);
                            if (this.pendingCount >= this.maxVideoGroupSize || n10 > this.maxPacketSize) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
                                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                                this.pendingTimecode = -1L;
                            }
                            this.pendingFragments.add(new RTPPacketFragment(byArray, n8, n9));
                            ++this.pendingCount;
                            this.pendingSize += n9;
                            if (this.pendingTimecode == -1L) {
                                this.pendingTimecode = l2;
                            }
                            if (this.pendingCount > 0) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
                                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                                this.pendingTimecode = -1L;
                            }
                        }
                        if ((n8 += n9) < n5) continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPPacketizerRFC3984H264.class).error("RTPPacketizerRFC3984H264.handleAMFPacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return n;
    }

    private void flushPending(OutputStream outputStream, int n, int n2, long l) {
        int n3 = this.pendingFragments.size();
        if (n3 > 0) {
            if (n3 == 1) {
                RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                int n4 = 12 + rTPPacketFragment.getLen();
                byte[] byArray = new byte[n4];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n4, l));
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12, rTPPacketFragment.getLen());
            } else {
                int n5 = 13 + 2 * n + n2;
                byte[] byArray = new byte[n5];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
                byArray[12] = 24;
                int n6 = 1;
                while (n3 > 0) {
                    RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                    BufferUtils.intToByteArray(rTPPacketFragment.getLen(), byArray, 12 + n6, 2);
                    System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + (n6 += 2), rTPPacketFragment.getLen());
                    n6 += rTPPacketFragment.getLen();
                    --n3;
                }
            }
        }
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        int n = 0;
        if (this.pendingCount > 0) {
            this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
            n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
            this.pendingCount = 0;
            this.pendingSize = 0;
            this.pendingTimecode = -1L;
        }
        return n;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 0) {
            n2 = 90000;
        }
        try {
            RTPStream rTPStream;
            Object object2;
            Object object3;
            int n3;
            long l;
            object = "packetization-mode=1";
            String string = null;
            Object object4 = null;
            long l2 = l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 7) {
                n3 = 5;
                object3 = H264Utils.breakApartAVCC(aMFPacket2.getData(), n3, aMFPacket2.getSize() - n3);
                if (object3 != null) {
                    String string2;
                    try {
                        object2 = H264Utils.decodeAVCC(aMFPacket2.getData(), n3);
                        if (object2 != null) {
                            string = ((H264CodecConfigInfo)object2).width + "-" + ((H264CodecConfigInfo)object2).height;
                            object4 = "0,0," + ((H264CodecConfigInfo)object2).height + "," + ((H264CodecConfigInfo)object2).width;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object2 = ((H264CodecConfigParts)object3).getProfileLevelIdStr();
                    if (((String)object2).length() > 0) {
                        object = (String)object + ";profile-level-id=" + ((String)object2).toUpperCase();
                    }
                    if ((string2 = ((H264CodecConfigParts)object3).getSpropParameterSetsStr()).length() > 0) {
                        object = (String)object + ";sprop-parameter-sets=" + string2;
                    }
                }
            }
            if ((object4 == null || string == null) && iMediaStream != null && (rTPStream = iMediaStream.getRTPStream()) != null && (object3 = rTPStream.getVideoTrack()) != null) {
                if (object4 == null && (object2 = ((RTPTrack)object3).getTrackInfo("cliprect")) != null) {
                    object4 = object2;
                }
                if (string == null) {
                    int n4 = ((RTPTrack)object3).getWidth();
                    int n5 = ((RTPTrack)object3).getHeight();
                    if (n4 > 0 && n5 > 0) {
                        string = n4 + "-" + n5;
                    }
                }
            }
            n3 = this.sdpTypeId;
            stringBuffer.append("a=rtpmap:" + n3 + " H264/" + n2 + "\r\n");
            stringBuffer.append("a=fmtp:" + n3 + " " + (String)object + "\r\n");
            if (object4 != null) {
                stringBuffer.append("a=cliprect:" + (String)object4 + "\r\n");
            }
            if (string != null) {
                stringBuffer.append("a=framesize:" + n3 + " " + string + "\r\n");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(n2);
        ((RTPDescribeInfo)object).setSDPTypeId(this.sdpTypeId);
        return object;
    }

    public int getMaxVideoGroupSize() {
        return this.maxVideoGroupSize;
    }

    public void setMaxVideoGroupSize(int n) {
        this.maxVideoGroupSize = n;
    }
}

