/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.DebugUtils;
import com.wowza.util.FasterByteArrayOutputStream;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayDynamicStreaming;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IResponseListener;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtmpResponseMessage {
    public static final String HTTPLEVEL_HTTP10 = "HTTP/1.0";
    public static final String HTTPLEVEL_HTTP11 = "HTTP/1.1";
    public static final int HTTP_STATUS_SUCCESS = 200;
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    public static final int HTTP_STATUS_REDIRECT = 302;
    private Map<String, String> headers = null;
    private IFasterByteArrayOutputStream body = null;
    private int responseCode = 200;
    private boolean responseTouched = false;
    private int clientId = -1;
    private IClient client = null;
    private boolean didClose = false;
    private boolean immediateIdle = false;
    private String vhostName = "";
    private List<IResponseListener> responseListeners = new ArrayList<IResponseListener>();
    private boolean sendBody = true;
    private String protocolStr = "HTTP/1.1";
    private boolean addCRLF = false;
    private long forcedContentLength = -1L;
    private boolean sendHeader = true;

    public RtmpResponseMessage(String string) {
        this.vhostName = string;
    }

    public int getHeaderSize() {
        int n = 0;
        n += this.protocolStr.length() + 1 + String.valueOf(this.responseCode).length() + 1 + HTTPUtils.statusCodeToStr(this.responseCode).length() + 2;
        if (this.headers != null) {
            for (String string : this.headers.keySet()) {
                if (string == null) continue;
                n += string.length() + 2;
                String string2 = this.headers.get(string);
                if (string2 == null) continue;
                n += string2.length() + 2;
            }
        }
        if (this.sendBody && this.body != null) {
            n += "Content-Length: ".length() + String.valueOf(this.body.size()).length() + 2;
        }
        return n += 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(IResponseListener iResponseListener) {
        List<IResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.add(iResponseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponseListener(IResponseListener iResponseListener) {
        List<IResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.remove(iResponseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponseStart() {
        ArrayList<IResponseListener> arrayList = null;
        List<IResponseListener> list = this.responseListeners;
        synchronized (list) {
            arrayList = new ArrayList<IResponseListener>(this.responseListeners);
        }
        for (IResponseListener iResponseListener : arrayList) {
            iResponseListener.onResponseWriteStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponseStop() {
        ArrayList<IResponseListener> arrayList = null;
        List<IResponseListener> list = this.responseListeners;
        synchronized (list) {
            arrayList = new ArrayList<IResponseListener>(this.responseListeners);
        }
        for (IResponseListener iResponseListener : arrayList) {
            iResponseListener.onResponseWriteStop(this);
        }
    }

    private void initHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put("Cache-Control", "no-cache");
            this.headers.put("Connection", "Keep-Alive");
            this.headers.put("Server", "FlashCom/3.5.2");
            this.headers.put("Content-Type", "application/x-fcs");
        }
    }

    public void initHeadersHTTP() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put("Cache-Control", "no-cache");
            this.headers.put("Connection", "Keep-Alive");
            this.headers.put("Server", "FlashCom/3.5.2");
            this.headers.put("Content-Type", "text/html");
        }
    }

    public void initHeadersMinimal() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put("Server", "FlashCom/3.5.2");
        }
    }

    private IFasterByteArrayOutputStream initBody() {
        if (this.body == null) {
            VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
            this.body = vHost == null ? new FasterByteArrayOutputStream(10240) : vHost.getOutputStream();
        }
        return this.body;
    }

    public void setHeader(String string, String string2) {
        this.initHeaders();
        this.headers.put(string, string2);
    }

    public Map<String, String> getHeaders() {
        this.initHeaders();
        return this.headers;
    }

    public void setContentType(String string) {
        this.initHeaders();
        this.headers.put("Content-Type", string);
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
        this.responseTouched = true;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void appendBody(byte[] byArray) {
        try {
            this.initBody();
            this.body.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OutputStream getOutputStream() {
        return this.initBody();
    }

    public void appendBody(String string) {
        try {
            this.initBody();
            byte[] byArray = string.getBytes();
            this.body.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ByteBuffer getBody() {
        return this.body == null ? null : this.body.toByteBuffer();
    }

    public List<ByteBuffer> getBodyList() {
        return this.body == null ? new ArrayList() : this.body.getBuffers();
    }

    public List<ByteBuffer> getBeforeBlocks() {
        if (this.body != null && this.body instanceof IFasterByteArrayDynamicStreaming) {
            IFasterByteArrayDynamicStreaming iFasterByteArrayDynamicStreaming = (IFasterByteArrayDynamicStreaming)((Object)this.body);
            return iFasterByteArrayDynamicStreaming.getBeforeBlocks();
        }
        return null;
    }

    public List<ByteBuffer> getAfterBlocks() {
        if (this.body != null && this.body instanceof IFasterByteArrayDynamicStreaming) {
            IFasterByteArrayDynamicStreaming iFasterByteArrayDynamicStreaming = (IFasterByteArrayDynamicStreaming)((Object)this.body);
            return iFasterByteArrayDynamicStreaming.getAfterBlocks();
        }
        return null;
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.reset();
        }
        this.body = null;
    }

    public int getBodyLength() {
        return this.body == null ? 0 : this.body.size();
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public int getContentLength() {
        return this.body == null ? 0 : this.body.size();
    }

    public boolean isResponseValid() {
        return this.body != null || this.responseTouched;
    }

    public IClient getClient() {
        return this.client;
    }

    public void setClient(IClient iClient) {
        this.client = iClient;
    }

    public boolean isDidClose() {
        return this.didClose;
    }

    public void setDidClose(boolean bl) {
        this.didClose = bl;
    }

    public void checkContentLength() {
        if (this.getContentLength() != this.getBodyLength()) {
            WMSLoggerFactory.getLogger(RtmpResponseMessage.class).error("Bad Content Length: " + this.getContentLength() + ":" + this.getBodyLength());
            if (this.body != null) {
                WMSLoggerFactory.getLogger(RtmpResponseMessage.class).info("msg\n" + DebugUtils.formatBytes(this.body.toByteArray()));
            }
        }
    }

    public boolean isImmediateIdle() {
        return this.immediateIdle;
    }

    public void setImmediateIdle(boolean bl) {
        this.immediateIdle = bl;
    }

    public boolean isSendBody() {
        return this.sendBody;
    }

    public void setSendBody(boolean bl) {
        this.sendBody = bl;
    }

    public String getProtocolStr() {
        return this.protocolStr;
    }

    public void setProtocolStr(String string) {
        this.protocolStr = string;
    }

    public boolean isHTTP10() {
        return this.protocolStr == null ? false : this.protocolStr.equals(HTTPLEVEL_HTTP10);
    }

    public boolean isAddCRLF() {
        return this.addCRLF;
    }

    public void setAddCRLF(boolean bl) {
        this.addCRLF = bl;
    }

    public long getForcedContentLength() {
        return this.forcedContentLength;
    }

    public void setForcedContentLength(long l) {
        this.forcedContentLength = l;
    }

    public boolean isSendHeader() {
        return this.sendHeader;
    }

    public void setSendHeader(boolean bl) {
        this.sendHeader = bl;
    }
}

