/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiveStreamPacketizerUtils {
    public static LiveStreamPacketizerItem loadLiveStreamPacketizerItem(Element element) {
        LiveStreamPacketizerItem liveStreamPacketizerItem = null;
        try {
            Element element2 = element;
            Node node = XMLUtils.getNodeByTagName(element2, "Name");
            Node node2 = XMLUtils.getNodeByTagName(element2, "Description");
            Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
            Node node4 = XMLUtils.getNodeByTagName(element2, "IsRepeater");
            Node node5 = XMLUtils.getNodeByTagName(element2, "LiveRepeaterPlayerClass");
            Node node6 = XMLUtils.getNodeByTagName(element2, "LiveRepeaterReceiverClass");
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "Properties/Property";
            XPathExpression xPathExpression = xPath.compile(string);
            if (node != null && node3 != null) {
                String string2 = XMLUtils.getNodeValue(node);
                String string3 = XMLUtils.getNodeValue(node2);
                String string4 = XMLUtils.getNodeValue(node3);
                String string5 = XMLUtils.getNodeValue(node4);
                String string6 = XMLUtils.getNodeValue(node5);
                String string7 = XMLUtils.getNodeValue(node6);
                liveStreamPacketizerItem = new LiveStreamPacketizerItem(string2, string4);
                if (string6 != null) {
                    liveStreamPacketizerItem.setLiveRepeaterPlayerClass(string6);
                }
                if (string7 != null) {
                    liveStreamPacketizerItem.setLiveRepeaterReceiverClass(string7);
                }
                if (string5 != null) {
                    boolean bl = string5.toLowerCase().startsWith("t") || string5.toLowerCase().startsWith("y");
                    liveStreamPacketizerItem.setRepeater(bl);
                }
                if (string3 != null) {
                    liveStreamPacketizerItem.setDescription(string3);
                }
                WMSProperties wMSProperties = liveStreamPacketizerItem.getProperties();
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                if (nodeList != null) {
                    XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(liveStreamPacketizerItem.toString());
            } else {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("HTTPStreamerUtils.loadMediaCaster: Error parsing server properties: Name, BaseClas and StreamType required.");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("HTTPStreamerUtils.loadMediaCaster: Error parsing properties: " + exception.toString());
            exception.printStackTrace();
        }
        return liveStreamPacketizerItem;
    }

    public static void loadLiveStreamPacketizerList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    LiveStreamPacketizerItem liveStreamPacketizerItem = LiveStreamPacketizerUtils.loadLiveStreamPacketizerItem(element2);
                    iVHost.getLiveStreamPacketizerList().getLiveStreamPacketizerDefs().put(liveStreamPacketizerItem.getName(), liveStreamPacketizerItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("HTTPStreamerUtils.loadHTTPStreamerList: Error load HTTPStreamerList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/LiveStreamPacketizers/LiveStreamPacketizer";
                LiveStreamPacketizerUtils.loadLiveStreamPacketizerList(element, string2, iVHost);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("HTTPStreamerUtils.loadConfigFile: Error parsing HTTPStreamer config file (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }
}

