/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestProcessData;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class RequestUtils {
    public static void dumpRequestPacket(String string, byte[] byArray, int n, int n2, IVHost iVHost, Client client, IMediaStream iMediaStream, AMFObj aMFObj, String string2) {
        try {
            String string3 = iVHost.getHomePath();
            Date date = new Date();
            FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd-HH-mm-ss");
            String string4 = string3 + "/core/" + string + "-packetdump-" + fastDateFormat.format(date);
            File file = new File(string3 + "/core");
            if (!file.exists()) {
                file.mkdir();
            }
            int n3 = 0;
            String string5 = string4;
            File file2 = new File(string5 + ".log");
            while (file2.exists()) {
                string5 = string4 + "[" + ++n3 + "]";
                file2 = new File(string5 + ".log");
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2, false));
            printWriter.println("VHost: " + iVHost.getName());
            if (client != null) {
                if (client.getAppInstance() != null) {
                    printWriter.println("Application: " + client.getApplication().getName());
                    printWriter.println("Instance: " + client.getAppInstance().getName());
                }
                printWriter.println("Client: " + client.getClientId());
            }
            if (iMediaStream != null) {
                printWriter.println("Stream: " + iMediaStream.getSrc());
                printWriter.println("  audio: " + iMediaStream.getAudioSize() + ":" + iMediaStream.getAudioMissing() + ":" + iMediaStream.getAudioTC());
                printWriter.println("  video: " + iMediaStream.getVideoSize() + ":" + iMediaStream.getVideoMissing() + ":" + iMediaStream.getVideoTC());
                printWriter.println("  data: " + iMediaStream.getDataSize() + ":" + iMediaStream.getDataMissing() + ":" + iMediaStream.getDataTC());
            }
            if (aMFObj != null) {
                printWriter.println("AMFObj: " + aMFObj.toString());
            }
            printWriter.println("Length: " + n);
            printWriter.println("Offset: " + n2);
            printWriter.println("Message: " + string2);
            printWriter.println("");
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            int n4 = n2 / 16;
            String string6 = DebugUtils.formatBytes(byArray2);
            String[] stringArray = string6.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = i == n4 ? "[" + Integer.toHexString(n2 % 16) + "]" : "   ";
                printWriter.println(string7 + stringArray[i]);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestProcessData.class).error("dumpPacket: error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

