/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.io.IOScheduler;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.FileUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.util.RandomIdGenerator;
import com.wowza.util.URLUtils;
import com.wowza.wms.admin.AdminServerNotifier;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationList;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientID;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionCounterSimple;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IClient;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerList;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.smil.SmilMediaList;
import com.wowza.wms.mediacaster.MediaCasterConnection;
import com.wowza.wms.mediacaster.MediaCasterID;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterSettings;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.netconnection.NetConnectionConnection;
import com.wowza.wms.netconnection.NetConnectionID;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.UDPTransportManager;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.stream.MediaWriterList;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.util.HTTPStreamerUtils;
import com.wowza.wms.util.IIdleWorkerNotify;
import com.wowza.wms.util.IdleWorkersUtil;
import com.wowza.wms.util.LiveStreamPacketizerUtils;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.MediaReaderUtils;
import com.wowza.wms.util.MediaWriterUtils;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.util.SmilUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.util.VHostUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.HostPortConfig;
import com.wowza.wms.vhost.HostPortList;
import com.wowza.wms.vhost.IAcceptorNotify;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StartupStream;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.ThreadPool;
import com.wowza.wms.vhost.VHostSessionMap;
import com.wowza.wms.vhost.VHostWatchdog;
import com.wowza.wms.vhost.VHostWorkerThread;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VHost
implements IVHost {
    private Map<Integer, IClient> clientMap = new HashMap<Integer, IClient>();
    private Map applicationMap = new HashMap();
    private ClientID nextClientId = new ClientID(100);
    private NetConnectionID nextNetConnectionId = new NetConnectionID(100);
    private MediaCasterID nextMediaCasterId = new MediaCasterID(100);
    private int clientTimeout = 90000;
    private int clientIdleFrequency = 250;
    private int rtpIdleFrequency = 1000;
    private int netConnectionIdleFrequency = 3000;
    private int applicationTimeout = 6000;
    private int pingTimeout = 12000;
    private int validationFrequency = 8000;
    private int maximumPendingWriteBytes = 0;
    private int maximumSetBufferTime = 0;
    private int idleWorkerCount = 4;
    private int idleCheckFrequency = 100;
    private int idleMinimumWaitTime = 5;
    private int keepAliveTimeout = 2000;
    private int coreTransportPoolSize = 100;
    private int coreHandlerPoolSize = 100;
    private int fileIOPoolSize = 20;
    private VHostWatchdog vhostWatchdog = null;
    private HostPortList hostPortList = new HostPortList();
    private HostPort adminInterfaceHostPort = null;
    private int netConnectionProcessorCount = 2;
    private HostPortConfig netConnectionHostPortConfig = new HostPortConfig();
    private MediaCasterSettings mediaCasterSettings = new MediaCasterSettings();
    private MediaCasterList mediaCasterList = new MediaCasterList();
    private AuthenticationList authenticationList = new AuthenticationList();
    private Map acceptors = new HashMap();
    private StreamList streamTypes = new StreamList();
    private MediaReaderList mediaReaders = new MediaReaderList();
    private MediaWriterList mediaWriters = new MediaWriterList();
    private String homePath = null;
    protected WMSProperties properties = new WMSProperties();
    private ThreadPool transportThreadPool = null;
    private ThreadPool handlerThreadPool = null;
    private String name;
    private NetConnectionConnection netConnectionConnection = null;
    private MediaCasterConnection mediaCasterConnection = null;
    private List applicationListeners = new ArrayList();
    private List acceptorListeners = new ArrayList();
    private IOScheduler ioScheduler = new IOScheduler();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private IOPerformanceCounter[] ioPerformanceCounters = new IOPerformanceCounter[6];
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionCounterSimple[] connectionCounters = new ConnectionCounterSimple[6];
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private IServer server = null;
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private int connectionLimit = 0;
    public Map mp3TagMap = new HashMap();
    private WMSReadWriteLock applicationLock = new WMSReentrantReadWriteLock();
    private boolean removeApplications = true;
    private IdleWorkersUtil idleWorkers = null;
    private VHostSessionMap sessionMap = new VHostSessionMap(this);
    private String byteArrayOutputStreamBaseClassPath = "";
    private Class byteArrayOutputStreamBaseClass = null;
    private RTPContext rtpContext = new RTPContext(this);
    private HTTPStreamerContext httpStreamerContext = new HTTPStreamerContext(this);
    private RTPUDPDatagramConfig rtpDatagramConfigIncoming = new RTPUDPDatagramConfig();
    private RTPUDPDatagramConfig rtpDatagramConfigOutgoing = new RTPUDPDatagramConfig();
    private boolean shuttingDown = false;
    private RandomIdGenerator clientIdGenerator = null;
    private Properties dynamicLogProperties = null;
    private UDPTransportManager udpTransportManager = new UDPTransportManager();
    private HTTPStreamerList httpStreamerList = new HTTPStreamerList();
    private Map<String, IHTTPStreamerAdapter> httpStreamerAdapters = new HashMap<String, IHTTPStreamerAdapter>();
    private LiveStreamPacketizerList liveStreamPacketizerList = new LiveStreamPacketizerList();
    private List<StartupStream> startupStreams = new ArrayList<StartupStream>();
    private boolean startStarupStreams = true;

    public VHost(String string) {
        this.name = string;
        this.netConnectionConnection = new NetConnectionConnection(this);
        this.mediaCasterConnection = new MediaCasterConnection(this);
        this.idleWorkers = new IdleWorkersUtil();
        this.clientIdGenerator = Server.getInstance().getClientIdGenerator();
        this.setByteArrayOutputStreamBaseClassPath("com.wowza.util.FasterByteArrayOutputStream");
        for (int i = 0; i < this.ioPerformanceCounters.length; ++i) {
            this.ioPerformanceCounters[i] = new IOPerformanceCounter();
            this.connectionCounters[i] = new ConnectionCounterSimple();
        }
        this.createWinMedia();
    }

    private void createWinMedia() {
        try {
            Method method;
            Object obj;
            Class<?> clazz = Class.forName("com.wowza.wms.plugin.winmedia.model.WinMediaContext");
            if (clazz != null && (obj = clazz.newInstance()) != null && (method = clazz.getMethod("init", IVHost.class)) != null) {
                method.invoke(obj, this);
                this.properties.put("WindowsMedia", obj);
                this.properties.put("WindowsMediaClass", clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invokeWinMedia(String string) {
        try {
            Method method;
            Object v;
            Class clazz = (Class)this.properties.get("WindowsMediaClass");
            if (clazz != null && (v = this.properties.get("WindowsMedia")) != null && (method = clazz.getMethod(string, new Class[0])) != null) {
                method.invoke(v, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initWinMedia() {
        this.invokeWinMedia("initWinMedia");
    }

    public void startWinMedia() {
        this.invokeWinMedia("startWinMedia");
    }

    public void stopWinMedia() {
        this.invokeWinMedia("stopWinMedia");
    }

    @NoMBean
    public void setServer(IServer iServer) {
        this.server = iServer;
    }

    @Override
    @NoMBean
    public void init(String string) {
        this.homePath = this.loadHomePath(string);
        this.loadConfig();
        this.initLogging();
        this.vhostWatchdog = new VHostWatchdog(this, 500);
        this.vhostWatchdog.setName("vhostWatchdog");
        this.vhostWatchdog.setDaemon(true);
        this.vhostWatchdog.start();
        this.ioScheduler.init(this.fileIOPoolSize);
        if (this.coreTransportPoolSize > 0) {
            this.transportThreadPool = new ThreadPool(this, "VHostTransport." + this.name);
            this.transportThreadPool.init(this.coreTransportPoolSize);
        }
        if (this.coreHandlerPoolSize > 0) {
            this.handlerThreadPool = new ThreadPool(this, "VHostHandler." + this.name);
            this.handlerThreadPool.init(this.coreHandlerPoolSize);
        }
        this.idleWorkers.setWorkerCount(this.getIdleWorkerCount());
        this.idleWorkers.setPollFreq(this.getIdleCheckFrequency());
        this.idleWorkers.setMinimumWaitTime(this.getIdleMinimumWaitTime());
        this.idleWorkers.start();
        this.udpTransportManager.init(this);
        this.rtpContext.init();
        this.httpStreamerContext.init();
        this.initWinMedia();
    }

    public boolean isHomePathAppPath() {
        if (Bootstrap.isServerURLConfig()) {
            return false;
        }
        String string = Bootstrap.getServerHome((int)1);
        return new File(this.homePath).equals(new File(string));
    }

    private void initLogging() {
        if (!this.isHomePathAppPath()) {
            String string = this.homePath + File.separatorChar + "conf" + File.separatorChar + "log4j.properties";
            if (new File(string).exists()) {
                WMSLoggerFactory.initializeLogging(URLUtils.pathToFileURL(string), this);
            } else if (Bootstrap.getConfigURL() != null) {
                WMSLoggerFactory.initializeLogging(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/log4j.properties")), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.rtpContext.shutdown();
        this.httpStreamerContext.shutdown();
        this.idleWorkers.halt();
        this.applicationLock.writeLock().lock();
        try {
            arrayList.addAll(this.clientMap.keySet());
            for (Object object : arrayList) {
                this.killClient((Integer)object);
            }
            arrayList.clear();
            for (Object object : this.applicationMap.keySet()) {
                arrayList.add(new String((String)object));
            }
            for (Object object : arrayList) {
                IApplication iApplication = this.getApplication((String)object);
                VHostUtils.clearLoggingContext();
                if (iApplication != null) {
                    this.removeApplication(iApplication, true);
                }
                VHostUtils.clearLoggingContext();
            }
            arrayList.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.shutdown: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.vhostWatchdog.halt();
        if (this.transportThreadPool != null) {
            this.transportThreadPool.terminate();
            this.transportThreadPool = null;
        }
        if (this.handlerThreadPool != null) {
            this.handlerThreadPool.terminate();
            this.handlerThreadPool = null;
        }
        if (this.ioScheduler != null) {
            this.ioScheduler.terminate();
        }
        this.ioScheduler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownApplication(String string) {
        this.applicationLock.writeLock().lock();
        try {
            Application application = (Application)this.applicationMap.get(string);
            if (application == null) {
            } else {
                List<String> list = application.getAppInstanceNames();
                for (String string2 : list) {
                    application.shutdownAppInstance(string2);
                }
                this.removeApplication(application, false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("shutdownApplication: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
    }

    @Override
    public boolean startApplicationInstance(String string) {
        return this.startApplicationInstance(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startApplicationInstance(String string, String string2) {
        boolean bl = false;
        this.applicationLock.writeLock().lock();
        try {
            IApplication iApplication;
            if (string == null) {
                string = "_defapp_";
            }
            if (string2 == null) {
                string2 = "_definst_";
            }
            if ((iApplication = this.getApplication(string)) == null) {
            } else {
                IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string2);
                if (iApplicationInstance == null) {
                } else {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.startApplicationInstance: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        return bl;
    }

    @Override
    public boolean touchApplicationInstance(String string) {
        return this.touchApplicationInstance(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touchApplicationInstance(String string, String string2) {
        boolean bl = false;
        this.applicationLock.writeLock().lock();
        try {
            IApplication iApplication;
            if (string == null) {
                string = "_defapp_";
            }
            if (string2 == null) {
                string2 = "_definst_";
            }
            if ((iApplication = this.getApplication(string)) == null) {
            } else {
                IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string2);
                if (iApplicationInstance == null) {
                } else {
                    iApplicationInstance.touch();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.touchApplicationInstance: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        return bl;
    }

    @Override
    public List getApplicationFolderNames() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getHomePath() + "/applications";
        File file = new File(string);
        if (file.exists()) {
            object = file.listFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                File file2 = object[i];
                if (file2.getName().startsWith(".") || !file2.exists() || !file2.isDirectory()) continue;
                arrayList.add(file2.getName());
            }
        }
        if (Bootstrap.getConfigURL() != null) {
            object = VHostUtils.getApplicationFolders(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/ApplicationList.xml")));
            arrayList.addAll((Collection<String>)object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getApplicationNames() {
        ArrayList arrayList = new ArrayList();
        this.applicationLock.readLock().lock();
        try {
            arrayList.addAll(this.applicationMap.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("getApplicationNames: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplication(IApplication iApplication, boolean bl) {
        ((Application)iApplication).addIOPerformance(this.ioPerformanceCounter);
        iApplication.shutdown(bl);
        this.applicationLock.writeLock().lock();
        try {
            String string = iApplication.getName();
            this.applicationMap.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("removeApplication: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.notifyApplicationDestroy(iApplication);
    }

    private String loadHomePath(String string) {
        return string;
    }

    @Override
    public String getProperty(String string) {
        return this.properties.getPropertyStr(string);
    }

    private void loadConfig() {
        String string = Bootstrap.getConfigURL();
        String string2 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "Streams.xml";
        if (new File(string2).exists()) {
            StreamUtils.loadConfigFile(this.streamTypes, URLUtils.pathToFileURL(string2));
        } else if (string != null) {
            StreamUtils.loadConfigFile(this.streamTypes, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/Streams.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: Streams.xml missing: " + string2);
        }
        String string3 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaReaders.xml";
        if (new File(string3).exists()) {
            MediaReaderUtils.loadConfigFile(this.mediaReaders, URLUtils.pathToFileURL(string3));
        } else if (string != null) {
            MediaReaderUtils.loadConfigFile(this.mediaReaders, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaReaders.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaReaders.xml missing: " + string3);
        }
        String string4 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaWriters.xml";
        if (new File(string4).exists()) {
            MediaWriterUtils.loadConfigFile(this.mediaWriters, URLUtils.pathToFileURL(string4));
        } else if (string != null) {
            MediaWriterUtils.loadConfigFile(this.mediaWriters, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaWriters.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaWriters.xml missing: " + string4);
        }
        String string5 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MP3Tags.xml";
        if (new File(string5).exists()) {
            VHostUtils.loadMP3TagMap(this.mp3TagMap, URLUtils.pathToFileURL(string5));
        } else if (string != null) {
            VHostUtils.loadMP3TagMap(this.mp3TagMap, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MP3Tags.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MP3Tags.xml missing: " + string5);
        }
        String string6 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "HTTPStreamers.xml";
        if (new File(string6).exists()) {
            HTTPStreamerUtils.loadConfigFile(this, URLUtils.pathToFileURL(string6));
        } else if (string != null) {
            HTTPStreamerUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/HTTPStreamers.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: HTTPStreamers.xml missing: " + string6);
        }
        String string7 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "LiveStreamPacketizers.xml";
        if (new File(string7).exists()) {
            LiveStreamPacketizerUtils.loadConfigFile(this, URLUtils.pathToFileURL(string7));
        } else if (string != null) {
            LiveStreamPacketizerUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/LiveStreamPacketizers.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: LiveStreamPacketizers.xml missing: " + string7);
        }
        String string8 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "VHost.xml";
        if (new File(string8).exists()) {
            VHostUtils.loadConfigFile(this, URLUtils.pathToFileURL(string8));
        } else if (string != null) {
            VHostUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/VHost.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: VHost.xml missing: " + string8);
        }
        String string9 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaCasters.xml";
        if (new File(string9).exists()) {
            MediaCasterUtils.loadConfigFile(this, URLUtils.pathToFileURL(string9));
        } else if (string != null) {
            MediaCasterUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaCasters.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaCasters.xml missing: " + string9);
        }
        String string10 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "RTP.xml";
        if (new File(string10).exists()) {
            RTPUtils.loadConfigFile(this.getRTPContext(), URLUtils.pathToFileURL(string10));
        } else if (string != null) {
            RTPUtils.loadConfigFile(this.getRTPContext(), URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/RTP.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: RTP.xml missing: " + string10);
        }
        String string11 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "Authentication.xml";
        if (new File(string11).exists()) {
            AuthenticationUtils.loadConfigFile(this, URLUtils.pathToFileURL(string11));
        } else if (string != null) {
            AuthenticationUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/Authentication.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: Authentication.xml missing: " + string11);
        }
        String string12 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "StartupStreams.xml";
        if (new File(string12).exists()) {
            VHostUtils.loadStartupStreams(this, URLUtils.pathToFileURL(string12));
        } else if (string != null) {
            VHostUtils.loadStartupStreams(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/StartupStreams.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: StartupStreams.xml missing: " + string12);
        }
        this.initHTTPStreamerAdapters();
    }

    @Override
    @NoMBean
    public StreamList getStreamTypes() {
        return this.streamTypes;
    }

    @Override
    public int getClientTimeout() {
        return this.clientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextNetConnectionId() {
        int n;
        NetConnectionID netConnectionID = this.nextNetConnectionId;
        synchronized (netConnectionID) {
            n = this.nextNetConnectionId.incNetConnectionID();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextMediaCasterId() {
        int n;
        MediaCasterID mediaCasterID = this.nextMediaCasterId;
        synchronized (mediaCasterID) {
            n = this.nextMediaCasterId.incMediaCasterID();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public IClient getClient(int n, boolean bl) {
        IClient iClient = null;
        if (n == -1) {
            if (bl) {
                n = this.clientIdGenerator.getNextId();
                this.applicationLock.writeLock().lock();
                try {
                    iClient = new Client(this, n);
                    this.clientMap.put(new Integer(n), iClient);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHost.class).error("getClient: " + exception.toString());
                }
                finally {
                    this.applicationLock.writeLock().unlock();
                }
            }
        } else {
            this.applicationLock.readLock().lock();
            iClient = this.clientMap.get(new Integer(n));
            this.applicationLock.readLock().unlock();
        }
        return iClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void reparentClient(IClient iClient) {
        VHost vHost = (VHost)iClient.getVHost();
        vHost.applicationLock.writeLock().lock();
        int n = iClient.getClientId();
        try {
            vHost.clientMap.remove(new Integer(n));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("reparentClient(old): " + exception.toString());
        }
        finally {
            vHost.applicationLock.writeLock().unlock();
        }
        this.applicationLock.writeLock().lock();
        try {
            iClient.reparentClient(this);
            this.clientMap.put(new Integer(n), iClient);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("reparentClient(new): " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
    }

    @Override
    @NoMBean
    public IClient getClient(int n) {
        return this.getClient(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkApplicationTimeout() {
        this.applicationLock.readLock().lock();
        ArrayList arrayList = new ArrayList(this.applicationMap.keySet());
        this.applicationLock.readLock().unlock();
        for (String string : arrayList) {
            Application application = (Application)this.getApplication(string);
            if (application == null) continue;
            VHostUtils.clearLoggingContext();
            application.doWatchdog();
            WMSReadWriteLock wMSReadWriteLock = this.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (application.getInstanceCount() == 0) {
                    this.removeApplication(application, false);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog2: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
            VHostUtils.clearLoggingContext();
        }
        arrayList.clear();
    }

    @NoMBean
    public void doWatchdog() {
        boolean bl = false;
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: checkClientTimeout");
            }
            this.checkClientTimeout();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: checkClientTimeout: " + exception.toString());
        }
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: checkApplicationTimeout");
            }
            this.checkApplicationTimeout();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: checkApplicationTimeout: " + exception.toString());
        }
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance");
            }
            this.updateApplicationIOPerformance();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: updateApplicationIOPerformance: " + exception.toString());
        }
        try {
            this.getUDPTransportManager().doIdle();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: UDPTransportManager.doIdle(): " + exception.toString());
        }
        try {
            this.getRTPContext().doWatchdog();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: getRTPContext().doWatchdog(): " + exception.toString());
        }
    }

    @NoMBean
    public void updateApplicationIOPerformance() {
        boolean bl = false;
        this.applicationLock.readLock().lock();
        ArrayList arrayList = new ArrayList(this.applicationMap.values());
        this.applicationLock.readLock().unlock();
        if (bl) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: size: " + arrayList.size());
        }
        for (Application application : arrayList) {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: name: " + application.getName());
            }
            application.updateIOPerformance();
        }
    }

    @NoMBean
    public void checkClientTimeout() {
        long l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = null;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.applicationLock.readLock().lock();
        arrayList2.addAll(this.clientMap.keySet());
        this.applicationLock.readLock().unlock();
        for (Integer object : arrayList2) {
            this.applicationLock.readLock().lock();
            Object object2 = this.clientMap.get(object);
            this.applicationLock.readLock().unlock();
            if (object2 == null) continue;
            long n = ((Client)object2).getTouch();
            boolean exception = ((Client)object2).isWaitingForIO();
            if (!exception && n > 0L && l - n > (long)this.clientTimeout) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(object);
                continue;
            }
            if (n != 0L) continue;
            ((Client)object2).touch();
        }
        if (arrayList != null) {
            for (Object object2 : arrayList) {
                int n = (Integer)object2;
                this.applicationLock.readLock().lock();
                Client client = (Client)this.clientMap.get(object2);
                this.applicationLock.readLock().unlock();
                try {
                    if (client != null) {
                        client.setThreadContext();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WMSLoggerFactory.getLogger(VHost.class).info("client connectionClosed [" + n + "] watchdog", "session", "comment", 401, client.getClientId() + "");
                this.killClient(n);
                try {
                    if (!(Thread.currentThread() instanceof VHostWorkerThread)) continue;
                    ((VHostWorkerThread)Thread.currentThread()).clear();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void killRTSPSession(String string) {
        try {
            IoSession ioSession = null;
            List<Object> list = this.sessionMap.getSessions();
            for (IoSession ioSession2 : list) {
                String string2;
                RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession2.getAttribute("wmsSessionInfo");
                if (rtmpSessionInfo == null || (string2 = rtmpSessionInfo.getRTSPSessionId()) == null || !string2.equals(string)) continue;
                ioSession = ioSession2;
                break;
            }
            if (ioSession != null) {
                ioSession.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("killRTSPSession: " + exception.toString());
        }
    }

    @Override
    public void killClient(int n) {
        List<Object> list = this.sessionMap.getSessions();
        Iterator<Object> iterator = list.iterator();
        ArrayList<IoSession> arrayList = new ArrayList<IoSession>();
        while (iterator.hasNext()) {
            IoSession ioSession = (IoSession)iterator.next();
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            if (rtmpSessionInfo == null || rtmpSessionInfo.getClientId() != n) continue;
            arrayList.add(ioSession);
        }
        for (IoSession ioSession : arrayList) {
            WMSLoggerFactory.getLogger(VHost.class).debug("client killClient [session:" + n + "]");
            try {
                ioSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.removeSession(ioSession);
            }
            catch (Exception exception) {}
        }
        WMSLoggerFactory.getLogger(VHost.class).debug("client killClient [remove:" + n + ":" + arrayList.size() + "]");
        try {
            this.removeClient(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClient(int n) {
        IClient iClient = null;
        this.applicationLock.writeLock().lock();
        try {
            iClient = this.clientMap.remove(new Integer(n));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("removeClient: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.clientIdGenerator.releaseId(n);
        if (iClient != null) {
            ((Client)iClient).shutdownClientInternal();
        }
    }

    @Override
    public int getClientCount() {
        int n = 0;
        this.applicationLock.readLock().lock();
        n = this.clientMap.size();
        this.applicationLock.readLock().unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isApplicationLoaded(String string) {
        if (string.length() == 0) {
            return false;
        }
        boolean bl = false;
        this.applicationLock.readLock().lock();
        try {
            bl = this.applicationMap.containsKey(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("isApplicationLoaded: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public IApplication getApplication(String string) {
        IApplication iApplication = null;
        if (string.length() == 0) {
            return null;
        }
        this.applicationLock.readLock().lock();
        try {
            iApplication = (IApplication)this.applicationMap.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("getApplication[1]");
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        if (iApplication == null) {
            this.applicationLock.writeLock().lock();
            try {
                iApplication = (IApplication)this.applicationMap.get(string);
                if (iApplication == null && this.applicationExists(string)) {
                    iApplication = new Application(string, this);
                    this.applicationMap.put(string, iApplication);
                    WMSLoggerFactory.initContextLogging(iApplication);
                    ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
                    iApplication.getConnectionCounter().addConnectionListener(connectionNotifier);
                    this.notifyApplicationCreate(iApplication);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHost.class).error("getApplication[2]");
            }
            finally {
                this.applicationLock.writeLock().unlock();
            }
        }
        return iApplication;
    }

    @Override
    public boolean applicationExists(String string) {
        boolean bl;
        String string2 = this.getHomePath() + "/applications/" + string;
        File file = new File(string2);
        boolean bl2 = bl = file.exists() && file.isDirectory();
        if (!bl && Bootstrap.getConfigURL() != null) {
            bl = VHostUtils.doesApplicationExist(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/ApplicationExists.xml") + "&applicationName=" + string));
        }
        return bl;
    }

    @Override
    public String getHomePath() {
        return this.homePath;
    }

    @Override
    @NoMBean
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public int getCoreTransportPoolSize() {
        return this.coreTransportPoolSize;
    }

    @Override
    public void setCoreTransportPoolSize(int n) {
        this.coreTransportPoolSize = n;
    }

    @Override
    public int getCoreHandlerPoolSize() {
        return this.coreHandlerPoolSize;
    }

    @Override
    public void setCoreHandlerPoolSize(int n) {
        this.coreHandlerPoolSize = n;
    }

    @Override
    public void setClientTimeout(int n) {
        this.clientTimeout = n;
    }

    @Override
    @NoMBean
    public HostPortList getHostPortsList() {
        return this.hostPortList;
    }

    @Override
    @NoMBean
    public ThreadPool getThreadPool() {
        return this.getHandlerThreadPool();
    }

    @Override
    @NoMBean
    public ThreadPool getTransportThreadPool() {
        return this.transportThreadPool == null ? Server.getInstance().getTransportThreadPool() : this.transportThreadPool;
    }

    @Override
    @NoMBean
    public ThreadPool getHandlerThreadPool() {
        return this.handlerThreadPool == null ? Server.getInstance().getHandlerThreadPool() : this.handlerThreadPool;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @NoMBean
    public HostPort getAdminInterfaceHostPort() {
        return this.adminInterfaceHostPort;
    }

    @Override
    @NoMBean
    public void setAdminInterfaceHostPort(HostPort hostPort) {
        this.adminInterfaceHostPort = hostPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addAcceptor(HostPort hostPort, IoAcceptor ioAcceptor, IoHandlerAdapter ioHandlerAdapter) {
        Map map = this.acceptors;
        synchronized (map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("acceptor", ioAcceptor);
            hashMap.put("handlerAdapter", ioHandlerAdapter);
            this.acceptors.put(hostPort, hashMap);
            this.notifyAcceptorCreate(hostPort, hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeAcceptor(HostPort hostPort) {
        Map map = this.acceptors;
        synchronized (map) {
            Map map2 = (Map)this.acceptors.remove(hostPort);
            this.notifyAcceptorDestroy(hostPort, map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public Map getAcceptors() {
        Map map = this.acceptors;
        synchronized (map) {
            return new HashMap(this.acceptors);
        }
    }

    @Override
    @NoMBean
    public void addIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        this.idleWorkers.addIdleWorkerListener(iIdleWorkerNotify);
    }

    @Override
    @NoMBean
    public void removeIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        this.idleWorkers.removeIdleWorkerListener(iIdleWorkerNotify);
    }

    @NoMBean
    public void addSession(Object object) {
        this.sessionMap.addSession(object);
    }

    @NoMBean
    public void notifySessionOpen(Object object, int n, IClient iClient) {
        this.sessionMap.notifySessionOpen(object, n, iClient);
    }

    @NoMBean
    public void removeSession(Object object) {
        this.sessionMap.removeSession(object);
    }

    @NoMBean
    public List getSessions() {
        return this.sessionMap.getSessions();
    }

    @Override
    public int getFileIOPoolSize() {
        return this.fileIOPoolSize;
    }

    @Override
    public void setFileIOPoolSize(int n) {
        this.fileIOPoolSize = n;
    }

    @NoMBean
    public NetConnectionConnection getNetConnectionConnection() {
        return this.netConnectionConnection;
    }

    @NoMBean
    public MediaCasterConnection getMediaCasterConnection() {
        return this.mediaCasterConnection;
    }

    @NoMBean
    public void setNetConnectionConnection(NetConnectionConnection netConnectionConnection) {
        this.netConnectionConnection = netConnectionConnection;
    }

    @Override
    public int getNetConnectionProcessorCount() {
        return this.netConnectionProcessorCount;
    }

    @Override
    public void setNetConnectionProcessorCount(int n) {
        this.netConnectionProcessorCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void addApplicationListener(IApplicationNotify iApplicationNotify) {
        List list = this.applicationListeners;
        synchronized (list) {
            this.applicationListeners.add(iApplicationNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void removeApplicationListener(IApplicationNotify iApplicationNotify) {
        List list = this.applicationListeners;
        synchronized (list) {
            this.applicationListeners.remove(iApplicationNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyApplicationCreate(IApplication iApplication) {
        ArrayList arrayList = null;
        List list = this.applicationListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.applicationListeners);
        }
        for (IApplicationNotify iApplicationNotify : arrayList) {
            iApplicationNotify.onApplicationCreate(iApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyApplicationDestroy(IApplication iApplication) {
        ArrayList arrayList = null;
        List list = this.applicationListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.applicationListeners);
        }
        for (IApplicationNotify iApplicationNotify : arrayList) {
            iApplicationNotify.onApplicationDestroy(iApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void addAcceptorListener(IAcceptorNotify iAcceptorNotify) {
        List list = this.acceptorListeners;
        synchronized (list) {
            this.acceptorListeners.add(iAcceptorNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void removeAcceptorListener(IAcceptorNotify iAcceptorNotify) {
        List list = this.acceptorListeners;
        synchronized (list) {
            this.acceptorListeners.remove(iAcceptorNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyAcceptorCreate(HostPort hostPort, Map map) {
        ArrayList arrayList = null;
        List list = this.acceptorListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.acceptorListeners);
        }
        for (IAcceptorNotify iAcceptorNotify : arrayList) {
            iAcceptorNotify.onAcceptorCreate(hostPort, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyAcceptorDestroy(HostPort hostPort, Map map) {
        ArrayList arrayList = null;
        List list = this.acceptorListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.acceptorListeners);
        }
        for (IAcceptorNotify iAcceptorNotify : arrayList) {
            iAcceptorNotify.onAcceptorDestroy(hostPort, map);
        }
    }

    @Override
    @NoMBean
    public IOScheduler getIOScheduler() {
        return this.ioScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IOPerformanceCounter updateIOPerformance() {
        ArrayList arrayList = null;
        this.applicationLock.readLock().lock();
        try {
            arrayList = new ArrayList(this.applicationMap.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("updateIOPerformance: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (Application application : arrayList) {
                application.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        return this.ioPerformanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IOPerformanceCounter updateIOPerformance(int n) {
        ArrayList arrayList = null;
        this.applicationLock.readLock().lock();
        try {
            arrayList = new ArrayList(this.applicationMap.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("updateIOPerformance: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (Application application : arrayList) {
                application.addIOPerformance(n, this.ioPerformanceCounters[n]);
            }
        }
        return this.ioPerformanceCounters[n];
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter(int n) {
        return this.ioPerformanceCounters[n];
    }

    @Override
    @NoMBean
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @Override
    @NoMBean
    public ConnectionCounterSimple getConnectionCounter(int n) {
        return this.connectionCounters[n];
    }

    @NoMBean
    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    public void setConnectionLimit(int n) {
        this.connectionLimit = n;
    }

    @Override
    @NoMBean
    public MediaReaderList getMediaReaders() {
        return this.mediaReaders;
    }

    @Override
    @NoMBean
    public MediaWriterList getMediaWriters() {
        return this.mediaWriters;
    }

    @Override
    @NoMBean
    public Map getMp3TagMap() {
        return this.mp3TagMap;
    }

    @Override
    @NoMBean
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    @Override
    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    @Override
    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    @Override
    public int getPingTimeout() {
        return this.pingTimeout;
    }

    @Override
    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    @Override
    public int getValidationFrequency() {
        return this.validationFrequency;
    }

    @Override
    public void setValidationFrequency(int n) {
        this.validationFrequency = n;
    }

    @Override
    public int getMaximumPendingWriteBytes() {
        return this.maximumPendingWriteBytes;
    }

    @Override
    public void setMaximumPendingWriteBytes(int n) {
        this.maximumPendingWriteBytes = n;
    }

    @Override
    public int getMaximumSetBufferTime() {
        return this.maximumSetBufferTime;
    }

    @Override
    public void setMaximumSetBufferTime(int n) {
        this.maximumSetBufferTime = n;
    }

    @Override
    @NoMBean
    public WMSReadWriteLock getApplicationLock() {
        return this.applicationLock;
    }

    public boolean isRemoveApplications() {
        return this.removeApplications;
    }

    public void setRemoveApplications(boolean bl) {
        this.removeApplications = bl;
    }

    @Override
    public int getClientIdleFrequency() {
        return this.clientIdleFrequency;
    }

    @Override
    public void setClientIdleFrequency(int n) {
        this.clientIdleFrequency = n;
    }

    @Override
    public int getRTPIdleFrequency() {
        return this.rtpIdleFrequency;
    }

    @Override
    public void setRTPIdleFrequency(int n) {
        this.rtpIdleFrequency = n;
    }

    @Override
    public int getIdleCheckFrequency() {
        return this.idleCheckFrequency;
    }

    @Override
    public void setIdleCheckFrequency(int n) {
        this.idleCheckFrequency = n;
    }

    @Override
    public int getIdleWorkerCount() {
        return this.idleWorkerCount;
    }

    @Override
    public void setIdleWorkerCount(int n) {
        this.idleWorkerCount = n;
    }

    @Override
    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    @Override
    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    @Override
    public HostPortConfig getNetConnectionHostPortConfig() {
        return this.netConnectionHostPortConfig;
    }

    @Override
    public MediaCasterSettings getMediaCasterSettings() {
        return this.mediaCasterSettings;
    }

    @Override
    public MediaCasterList getMediaCasterList() {
        return this.mediaCasterList;
    }

    @Override
    public int getNetConnectionIdleFrequency() {
        return this.netConnectionIdleFrequency;
    }

    @Override
    public void setNetConnectionIdleFrequency(int n) {
        this.netConnectionIdleFrequency = n;
    }

    public String getByteArrayOutputStreamBaseClassPath() {
        return this.byteArrayOutputStreamBaseClassPath;
    }

    public void setByteArrayOutputStreamBaseClassPath(String string) {
        this.byteArrayOutputStreamBaseClassPath = string;
        this.byteArrayOutputStreamBaseClass = null;
        try {
            this.byteArrayOutputStreamBaseClass = Class.forName(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("VHost setByteArrayOutputStreamBaseClassPath: " + string + " :" + exception.toString());
        }
    }

    public IFasterByteArrayOutputStream getOutputStream() {
        IFasterByteArrayOutputStream iFasterByteArrayOutputStream = null;
        try {
            if (this.byteArrayOutputStreamBaseClass != null) {
                iFasterByteArrayOutputStream = (IFasterByteArrayOutputStream)this.byteArrayOutputStreamBaseClass.newInstance();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("VHost getOutputStream: " + exception.toString());
        }
        return iFasterByteArrayOutputStream;
    }

    public long getScheduledWriteMaxSessionBytes() {
        return this.sessionMap.getScheduledWriteMaxSessionBytes();
    }

    public int getScheduledWriteMaxSessionClientId() {
        return this.sessionMap.getScheduledWriteMaxSessionClientId();
    }

    public long getScheduledWriteSessions() {
        return this.sessionMap.getScheduledWriteSessions();
    }

    public long getScheduledWriteRequests() {
        return this.sessionMap.getScheduledWriteRequests();
    }

    public long getScheduledWriteBytes() {
        return this.sessionMap.getScheduledWriteBytes();
    }

    public long getScheduledReadMaxSessionBytes() {
        return this.sessionMap.getScheduledReadMaxSessionBytes();
    }

    public long getWaitingReadBytes() {
        return this.sessionMap.getWaitingReadBytes();
    }

    @Override
    public RTPContext getRTPContext() {
        return this.rtpContext;
    }

    @Override
    public HTTPStreamerContext getHTTPStreamerContext() {
        return this.httpStreamerContext;
    }

    @Override
    public RTPUDPDatagramConfig getRTPDatagramConfigIncoming() {
        return this.rtpDatagramConfigIncoming;
    }

    @Override
    public RTPUDPDatagramConfig getRTPDatagramConfigOutgoing() {
        return this.rtpDatagramConfigOutgoing;
    }

    @Override
    public AuthenticationList getAuthenticationList() {
        return this.authenticationList;
    }

    @Override
    public int getIdleMinimumWaitTime() {
        return this.idleMinimumWaitTime;
    }

    @Override
    public void setIdleMinimumWaitTime(int n) {
        this.idleMinimumWaitTime = n;
    }

    @Override
    public IdleWorkersUtil getIdleWorkers() {
        return this.idleWorkers;
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public void setShuttingDown(boolean bl) {
        this.shuttingDown = bl;
    }

    @Override
    public Properties getDynamicLogProperties() {
        return this.dynamicLogProperties;
    }

    @Override
    public void setDynamicLogProperties(Properties properties) {
        this.dynamicLogProperties = properties;
    }

    @Override
    public UDPTransportManager getUDPTransportManager() {
        return this.udpTransportManager;
    }

    @Override
    public void unbindAllHostPorts() {
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            this.closeHostPort(hostPort, false);
        }
    }

    @Override
    public void suspendAllHostPorts() {
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            this.closeHostPort(hostPort, true);
        }
    }

    @Override
    public boolean isSuspended() {
        boolean bl = true;
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            if (hostPort.isSuspended()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    @NoMBean
    public void closeHostPort(HostPort hostPort, boolean bl) {
        List<IHTTPProvider> list2;
        Map map = (Map)this.acceptors.get(hostPort);
        IoAcceptor ioAcceptor = (IoAcceptor)map.get("acceptor");
        Set set = ioAcceptor.getManagedServiceAddresses();
        for (List<IHTTPProvider> list2 : set) {
            WMSLoggerFactory.getLogger(VHost.class).info("VHost." + (bl ? "suspend" : "unbind") + "[" + this.getName() + "]: " + list2);
            try {
                if (!(ioAcceptor instanceof SocketAcceptor)) continue;
                ((SocketAcceptor)ioAcceptor).suspend((SocketAddress)((Object)list2));
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHost.class).error("VHost." + (bl ? "suspend" : "unbind") + "[" + this.getName() + "]: " + list2 + ": " + exception.toString());
            }
        }
        list2 = hostPort.getHttpProviders();
        if (list2 != null) {
            for (IHTTPProvider iHTTPProvider : list2) {
                if (iHTTPProvider == null) continue;
                iHTTPProvider.onUnbind(this, hostPort);
            }
        }
        hostPort.setSuspended(true);
    }

    @Override
    @NoMBean
    public HTTPStreamerList getHTTPStreamerList() {
        return this.httpStreamerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public IHTTPStreamerAdapter getHTTPStreamerAdapter(String string) {
        Map<String, IHTTPStreamerAdapter> map = this.httpStreamerAdapters;
        synchronized (map) {
            return this.httpStreamerAdapters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHTTPStreamerAdapter(String string, IHTTPStreamerAdapter iHTTPStreamerAdapter) {
        Map<String, IHTTPStreamerAdapter> map = this.httpStreamerAdapters;
        synchronized (map) {
            this.httpStreamerAdapters.put(string, iHTTPStreamerAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHTTPStreamerAdapters() {
        ArrayList<IHTTPStreamerAdapter> arrayList = new ArrayList<IHTTPStreamerAdapter>();
        Map<String, IHTTPStreamerAdapter> map = this.httpStreamerAdapters;
        synchronized (map) {
            arrayList.addAll(this.httpStreamerAdapters.values());
        }
        for (IHTTPStreamerAdapter iHTTPStreamerAdapter : arrayList) {
            iHTTPStreamerAdapter.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getHTTPStreamerAdapterIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, IHTTPStreamerAdapter> map = this.httpStreamerAdapters;
        synchronized (map) {
            arrayList.addAll(this.httpStreamerAdapters.keySet());
        }
        return arrayList;
    }

    @Override
    @NoMBean
    public LiveStreamPacketizerList getLiveStreamPacketizerList() {
        return this.liveStreamPacketizerList;
    }

    @Override
    @NoMBean
    public List<StartupStream> getStartupStreams() {
        return this.startupStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStartupStream(StartupStream startupStream) {
        List<StartupStream> list = this.startupStreams;
        synchronized (list) {
            this.startupStreams.add(startupStream);
        }
    }

    @Override
    public boolean isStartStarupStreams() {
        return this.startStarupStreams;
    }

    @Override
    public void setStartStarupStreams(boolean bl) {
        this.startStarupStreams = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStartupStreams() {
        for (StartupStream startupStream : this.startupStreams) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            boolean bl;
            IApplicationInstance iApplicationInstance;
            IApplicationInstance iApplicationInstance2;
            String string;
            String string2;
            block26: {
                String string3 = startupStream.getApplicationName();
                String string4 = "_definst_";
                string2 = startupStream.getMediaCasterType();
                string = startupStream.getStreamName();
                int n = string3.indexOf("/");
                if (n >= 0) {
                    string4 = string3.substring(n + 1);
                    string3 = string3.substring(0, n);
                }
                IApplication iApplication = null;
                iApplicationInstance2 = null;
                WMSReadWriteLock wMSReadWriteLock = this.getApplicationLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    iApplication = this.getApplication(string3);
                    if (iApplication != null) {
                        iApplicationInstance2 = iApplication.getAppInstance(string4);
                        if (iApplicationInstance2 == null) {
                            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: Application instance could not be created: " + string3 + "/" + string4);
                        }
                    } else {
                        WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: Application folder ([install-location]/applications/" + string3 + ") is missing");
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHost.class).error("VHost.startStartupStreams: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
                if (iApplication == null || iApplicationInstance2 == null) continue;
                iApplicationInstance = iApplicationInstance2;
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                bl = true;
                Object object6 = "flv";
                String string5 = "";
                if (string != null) {
                    object5 = string;
                    string = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string);
                }
                object5 = new ArrayList();
                if (string != null) {
                    object4 = ModuleUtils.decodeStreamExtension(string, (String)object6);
                    string = object4[0];
                    object6 = object4[1];
                    boolean bl2 = string.indexOf("://") >= 0;
                    int n2 = string.indexOf("?");
                    if (!bl2 && n2 >= 0) {
                        string5 = string.substring(n2 + 1);
                        string = string.substring(0, n2);
                    }
                    if (((String)object6).equals("smil")) {
                        try {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).info("VHost[" + iApplicationInstance.getContextStr() + "]: Starting SMIL file.");
                            object3 = SmilUtils.parseSmilFile(iApplicationInstance, string, (String)object6);
                            if (object3 == null) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("VHost.startStartupStreams[" + iApplicationInstance.getContextStr() + "]: SMIL file: Error parsing file.");
                                break block26;
                            }
                            if (((SmilMediaList)object3).size() <= 0) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("VHost.startStartupStreams[" + iApplicationInstance.getContextStr() + "]: SMIL file: File is empty.");
                                break block26;
                            }
                            object2 = ((SmilMediaList)object3).getStreamNames();
                            object5.addAll(object2);
                            object = new MediaStreamMapGroup();
                            ((MediaStreamMapGroup)object).setName(string);
                            ((MediaStreamMapGroup)object).addAll((Collection<String>)object2);
                            object = mediaStreamMap.addNameGroup((MediaStreamMapGroup)object);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).error("VHost.startStartupStreams[" + iApplicationInstance.getContextStr() + "]: SMIL file: " + exception.toString());
                        }
                    } else {
                        object5.add((String)object6 + ":" + string);
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            object4 = iApplicationInstance2.getMediaCasterStreams();
            MediaCasterStreamManager mediaCasterStreamManager = ((MediaCasterStreamMap)object4).getStreamManager();
            MediaCasterList mediaCasterList = this.getMediaCasterList();
            object3 = mediaCasterList.getMediaCasterDef(string2);
            if (object3 == null) {
                WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: MediaCaster type not found[" + iApplicationInstance.getContextStr() + "]: " + string2);
                continue;
            }
            try {
                object2 = object5.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    boolean bl3 = mediaCasterStreamManager.startStream((String)object, string2);
                    if (bl3) {
                        WMSLoggerFactory.getLogger(VHost.class).info("VHost.startStartupStreams: Stream successfully started [" + iApplicationInstance.getContextStr() + "]: " + (String)object);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: Stream could not be started[" + iApplicationInstance.getContextStr() + "]: " + (String)object);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHost.class).error("VHost.startStartupStreams[" + iApplicationInstance.getContextStr() + ":" + string + "]: " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStartupStreams() {
        for (StartupStream startupStream : this.startupStreams) {
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            IApplicationInstance iApplicationInstance;
            String string;
            String string2;
            block26: {
                string2 = startupStream.getApplicationName();
                string = "_definst_";
                String string3 = startupStream.getMediaCasterType();
                String string4 = startupStream.getStreamName();
                int n = string2.indexOf("/");
                if (n >= 0) {
                    string = string2.substring(n + 1);
                    string2 = string2.substring(0, n);
                }
                IApplication iApplication = null;
                iApplicationInstance = null;
                WMSReadWriteLock wMSReadWriteLock = this.getApplicationLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    if (!this.isApplicationLoaded(string2)) {
                    } else {
                        iApplication = this.getApplication(string2);
                        if (iApplication != null) {
                            if (!iApplication.isAppInstanceLoaded(string)) {
                            } else {
                                iApplicationInstance = iApplication.getAppInstance(string);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHost.class).error("VHost.stopStartupStreams: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
                if (iApplication == null || iApplicationInstance == null) {
                    WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: Stream not found[" + string2 + "/" + string + "]: " + string4);
                    continue;
                }
                IApplicationInstance iApplicationInstance2 = iApplicationInstance;
                MediaStreamMap mediaStreamMap = iApplicationInstance2.getStreams();
                bl = true;
                Object object4 = "flv";
                String string5 = "";
                if (string4 != null) {
                    object3 = string4;
                    string4 = ((ApplicationInstance)iApplicationInstance2).internalResolvePlayAlias(string4);
                }
                object3 = new ArrayList();
                if (string4 != null) {
                    object2 = ModuleUtils.decodeStreamExtension(string4, (String)object4);
                    string4 = object2[0];
                    object4 = object2[1];
                    boolean bl2 = string4.indexOf("://") >= 0;
                    int n2 = string4.indexOf("?");
                    if (!bl2 && n2 >= 0) {
                        string5 = string4.substring(n2 + 1);
                        string4 = string4.substring(0, n2);
                    }
                    if (((String)object4).equals("smil")) {
                        try {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).info("VHost[" + iApplicationInstance2.getContextStr() + "]: Starting SMIL file.");
                            object = SmilUtils.parseSmilFile(iApplicationInstance2, string4, (String)object4);
                            if (object == null) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("VHost.startStartupStreams[" + iApplicationInstance2.getContextStr() + "]: SMIL file: Error parsing file.");
                                break block26;
                            }
                            if (((SmilMediaList)object).size() <= 0) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("VHost.startStartupStreams[" + iApplicationInstance2.getContextStr() + "]: SMIL file: File is empty.");
                                break block26;
                            }
                            List<String> list = ((SmilMediaList)object).getStreamNames();
                            object3.addAll(list);
                            MediaStreamMapGroup mediaStreamMapGroup = new MediaStreamMapGroup();
                            mediaStreamMapGroup.setName(string4);
                            mediaStreamMapGroup.addAll(list);
                            mediaStreamMap.removeNameGroup(mediaStreamMapGroup);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).error("VHost.startStartupStreams[" + iApplicationInstance2.getContextStr() + "]: SMIL file: " + exception.toString());
                        }
                    } else {
                        object3.add((String)object4 + ":" + string4);
                    }
                } else {
                    bl = false;
                }
            }
            object2 = iApplicationInstance.getMediaCasterStreams();
            MediaCasterStreamManager mediaCasterStreamManager = ((MediaCasterStreamMap)object2).getStreamManager();
            if (!bl) continue;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                boolean bl3 = mediaCasterStreamManager.stopStream((String)object);
                if (bl3) {
                    WMSLoggerFactory.getLogger(VHost.class).info("VHost.startStartupStreams: Stream successfully stopped [" + string2 + "/" + string + "]: " + (String)object);
                    continue;
                }
                WMSLoggerFactory.getLogger(VHost.class).warn("VHost.startStartupStreams: Stream not found[" + string2 + "/" + string + "]: " + (String)object);
            }
        }
    }

    public List getApplicationNamesStatic() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getHomePath() + "/applications/";
        File file = new File(string);
        for (String string2 : stringArray = file.list()) {
            if (string2.startsWith(".")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public boolean createApplication(String string, String string2, String string3) {
        String string4;
        File file;
        List list = this.getApplicationFolderNames();
        if (list.contains(string)) {
            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: application already exists![" + string + "]");
            return false;
        }
        String string5 = this.getHomePath() + "/applications/" + string + "/";
        File file2 = new File(string5);
        if (file2.mkdirs() && (file = new File(string4 = this.getHomePath() + "/conf/" + string + "/")).mkdirs()) {
            try {
                String string6 = this.getHomePath() + "/conf/" + string + "/Application.xml";
                File file3 = new File(string6);
                if (!file3.createNewFile()) {
                    return false;
                }
                FileUtils.copyFile2(new File(this.getHomePath() + "/conf/template-Application.xml"), file3);
                VHost.updateXMLElementValue(string6, "StreamType", string2);
                if (string3 == "global") {
                    VHost.updateXMLElementValue(string6, "StorageDir", "${com.wowza.wms.context.VHostConfigHome}/content");
                } else if (string3 == "application") {
                    VHost.updateXMLElementValue(string6, "StorageDir", "${com.wowza.wms.AppHome}/content");
                } else {
                    VHost.updateXMLElementValue(string6, "StorageDir", string3);
                }
            }
            catch (IOException iOException) {
                WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: failed to generate Application.xml");
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean updateXMLElementValue(String string, String string2, String string3) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: failed to modify Application.xml");
            return false;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(string);
        }
        catch (IOException iOException) {
            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: failed to modify Application.xml");
            return false;
        }
        catch (SAXException sAXException) {
            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: failed to modify Application.xml");
            return false;
        }
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName(string2);
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0).getFirstChild();
            String string4 = node.getNodeValue();
            node.setNodeValue(string3);
            VHost.writeXmlFile(document, string);
            return true;
        }
        WMSLoggerFactory.getLogger(VHost.class).warn("VHost.createApplication: failed to modify Application.xml");
        return false;
    }

    public static void writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public boolean removeApplication(String string) {
        List list = this.getApplicationFolderNames();
        if (!list.contains(string)) {
            WMSLoggerFactory.getLogger(VHost.class).warn("VHost.removeApplication: application does not exist![" + string + "]");
            return false;
        }
        if (FileUtils.deleteDirectory(new File(this.getHomePath() + "/applications/" + string + "/"))) {
            return FileUtils.deleteDirectory(new File(this.getHomePath() + "/conf/" + string + "/"));
        }
        return false;
    }

    @Override
    public String readVHostConfig(String string) {
        String string2 = this.getHomePath() + "/conf/" + string;
        return Server.readXMLConfig(string2);
    }

    @Override
    public boolean writeVHostConfig(String string, String string2) {
        String string3 = this.getHomePath() + "/conf/" + string;
        return Server.writeXMLConfig(string3, string2);
    }

    public VHostWatchdog getWatchDogThread() {
        return this.vhostWatchdog;
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private VHost vhost = null;
        private byte[] control = null;

        public ConnectionNotifier(VHost vHost2) {
            this.vhost = vHost2;
            this.control = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray = bigInteger.toByteArray();
            for (int i = 0; i < this.control.length; ++i) {
                int n = i;
                this.control[n] = (byte)(this.control[n] ^ byArray[(i + 11) % byArray.length]);
            }
        }

        private void checkLicense(byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("VHost checkLicense exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(0);
            }
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.incrementAccept(connectionHolder, date, l, byArray);
            VHost.this.connectionCounters[connectionHolder.getConnectionType()].incrementAccept(connectionHolder, date, l);
            this.checkLicense(byArray);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.incrementReject(connectionHolder, n, date, l, byArray);
            VHost.this.connectionCounters[connectionHolder.getConnectionType()].incrementReject(connectionHolder, n, date, l);
            this.checkLicense(byArray);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.decrement(connectionHolder, bl, date, l, byArray);
            VHost.this.connectionCounters[connectionHolder.getConnectionType()].decrement(connectionHolder, bl, date, l);
            this.checkLicense(byArray);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private VHost vhost = null;

        public ConnectionValidator(VHost vHost2) {
            this.vhost = vHost2;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            int n;
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (n = 0; n < byArray.length; ++n) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[(n + 2) % byArray2.length]);
            }
            n = ((Server)this.vhost.server).getConnectionValidator().validateConnection(connectionCounter, connectionHolder, byArray) ? 1 : 0;
            int n3 = this.vhost.getConnectionLimit();
            if (n3 > 0 && this.vhost.getConnectionCounter().getCurrent() >= (long)n3) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.ErrorVHostLimit");
                return false;
            }
            return n != 0;
        }
    }
}

