/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class SmoothStreamingMediaInfoVideo {
    private int videoBitrate = -1;
    private int videoWidth = -1;
    private int videoHeight = -1;
    private long videoTrackDuration = 0L;
    private String videoFourCC = "";
    private byte[] videoCodecPrivateData = null;

    public static SmoothStreamingMediaInfoVideo deserialize(byte[] byArray, int n, int n2) {
        SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = new SmoothStreamingMediaInfoVideo();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte by = dataInputStream.readByte();
            smoothStreamingMediaInfoVideo.videoBitrate = dataInputStream.readInt();
            smoothStreamingMediaInfoVideo.videoWidth = dataInputStream.readInt();
            smoothStreamingMediaInfoVideo.videoHeight = dataInputStream.readInt();
            smoothStreamingMediaInfoVideo.videoTrackDuration = dataInputStream.readLong();
            smoothStreamingMediaInfoVideo.videoFourCC = dataInputStream.readUTF();
            short s = dataInputStream.readShort();
            if (s > 0) {
                smoothStreamingMediaInfoVideo.videoCodecPrivateData = new byte[s];
                dataInputStream.read(smoothStreamingMediaInfoVideo.videoCodecPrivateData);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamingMediaInfoVideo.class).error("SmoothStreamingMediaInfoVideo.deserialize: " + exception.toString());
        }
        return smoothStreamingMediaInfoVideo;
    }

    public byte[] serialize() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(this.videoBitrate);
            dataOutputStream.writeInt(this.videoWidth);
            dataOutputStream.writeInt(this.videoHeight);
            dataOutputStream.writeLong(this.videoTrackDuration);
            dataOutputStream.writeUTF(this.videoFourCC);
            if (this.videoCodecPrivateData != null) {
                dataOutputStream.writeShort((short)this.videoCodecPrivateData.length);
                dataOutputStream.write(this.videoCodecPrivateData);
            } else {
                dataOutputStream.writeShort(0);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamingMediaInfoVideo.class).error("SmoothStreamingMediaInfoVideo.serialize: " + exception.toString());
        }
        return byArray;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(int n) {
        this.videoBitrate = n;
    }

    public String getVideoFourCC() {
        return this.videoFourCC;
    }

    public void setVideoFourCC(String string) {
        this.videoFourCC = string;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public void setVideoWidth(int n) {
        this.videoWidth = n;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void setVideoHeight(int n) {
        this.videoHeight = n;
    }

    public long getVideoTrackDuration() {
        return this.videoTrackDuration;
    }

    public void setVideoTrackDuration(long l) {
        this.videoTrackDuration = l;
    }

    public byte[] getVideoCodecPrivateData() {
        return this.videoCodecPrivateData;
    }

    public void setVideoCodecPrivateData(byte[] byArray) {
        this.videoCodecPrivateData = byArray;
    }
}

