/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.drm.playready.PlayReadyEncryptionResult;
import com.wowza.wms.drm.playready.PlayReadyEncryptor;
import com.wowza.wms.drm.playready.PlayReadySampleData;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentHeader;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriter;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPendingFragment;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.PLims;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothStreamingPacketHandler {
    protected H264CodecConfigParts h264CodecConfigPart = null;
    protected SmoothStreamingMediaInfoAudio mediaInfoAudio = new SmoothStreamingMediaInfoAudio();
    protected SmoothStreamingMediaInfoVideo mediaInfoVideo = new SmoothStreamingMediaInfoVideo();
    protected SmoothStreamingPendingFragment pendingVideoFragment = null;
    protected SmoothStreamingPendingFragment pendingAudioFragment = null;
    protected List<SmoothStreamingPendingFragment> pendingVideoFragments = new ArrayList<SmoothStreamingPendingFragment>();
    protected List<SmoothStreamingPendingFragment> pendingAudioFragments = new ArrayList<SmoothStreamingPendingFragment>();
    protected boolean waitingForKeyFrame = true;
    protected long lastAdjAudioTimecode = -1L;
    protected long lastAdjVideoTimecode = -1L;
    protected boolean lastAdjAudioTimecodeWarning = true;
    protected boolean lastAdjVideoTimecodeWarning = true;
    protected int lastAdjTimecodeBackwardsCount = 0;
    protected LiveStreamPacketizerSmoothStreaming smoothStreamingPacketizer = null;
    protected long ftc = -1L;
    protected long mtc = Long.MAX_VALUE;
    protected boolean rtc = true;
    protected PlayReadyEncryptor playReadyEncryptorAudio = null;
    protected PlayReadyEncryptor playReadyEncryptorVideo = null;

    public SmoothStreamingPacketHandler() {
        try {
            int n;
            Object[] objectArray;
            String[] stringArray;
            Object object;
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            String string3 = (String)MediaStreamBase.sinfo.get("slp");
            int n2 = -2;
            String[] stringArray2 = string2.split("[|]");
            String string4 = "p" + string3 + "=";
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                if (!((String)object).startsWith(string4)) continue;
                object = ((String)object).substring(string4.length());
                stringArray = ((String)object).split("[,]");
                for (int j = 0; j < stringArray.length; ++j) {
                    objectArray = stringArray[j].split(":");
                    if (!objectArray[0].equals("s")) continue;
                    n2 = Integer.parseInt((String)objectArray[1]);
                }
            }
            BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
            object = bigInteger2.toByteArray();
            stringArray = (String[])MediaStreamBase.sinfo.get("r1");
            byte[] byArray = stringArray.toByteArray();
            objectArray = new byte[ModuleConnect.lc.length];
            byte[] byArray2 = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, objectArray, 0, ModuleConnect.lc.length);
            System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
            for (n = 0; n < byArray2.length; ++n) {
                int n3 = n;
                objectArray[n3] = (byte)(objectArray[n3] ^ byArray[(n + 11) % byArray.length]);
            }
            this.mtc = PLims.getInstance().check((long)n2, objectArray);
            for (n = 0; n < byArray2.length; ++n) {
                int n4 = n;
                byArray2[n4] = (byte)(byArray2[n4] ^ byArray[(n + 11) % byArray.length]);
                int n5 = n;
                byArray2[n5] = (byte)(byArray2[n5] ^ object[(n + 5) % ((Object)object).length]);
            }
            for (n = 0; n < ModuleConnect.lc.length; ++n) {
                if (objectArray[n] == byArray2[n]) continue;
                System.out.println(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)14)));
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming) {
        this.smoothStreamingPacketizer = liveStreamPacketizerSmoothStreaming;
    }

    public void startStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.startStream[" + this.smoothStreamingPacketizer.getContextStr() + "]");
    }

    public void resetStream(IMediaStream iMediaStream) {
    }

    private void doStreamReset() {
        this.waitingForKeyFrame = true;
        this.lastAdjAudioTimecode = -1L;
        this.lastAdjVideoTimecode = -1L;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAdjTimecodeBackwardsCount = 0;
        this.ftc = -1L;
        this.pendingAudioFragment = null;
        this.pendingVideoFragment = null;
        this.pendingAudioFragments.clear();
        this.pendingVideoFragments.clear();
        this.smoothStreamingPacketizer.clearFragmentAudio();
        this.smoothStreamingPacketizer.clearFragmentVideo();
    }

    public void handlePacket(long l, IMediaStream iMediaStream, AMFPacket aMFPacket) {
        block62: {
            int n = aMFPacket.getType();
            int n2 = aMFPacket.getSize();
            long l2 = aMFPacket.getAbsTimecode();
            long l3 = l2 * 10000L;
            try {
                if (n == 8) {
                    Object object4;
                    Object object2;
                    Object object3;
                    if (n2 < 2) break block62;
                    byte[] byArray = aMFPacket.getData();
                    int n3 = byArray[0] & 0xFF;
                    int n4 = byArray[1] & 0xFF;
                    int n5 = FLVUtils.getAudioCodec((int)n3);
                    if (n5 != 10 && n5 != 2) break block62;
                    if (n5 == 10 && n4 != 1) {
                        if (n4 == 0) {
                            AACFrame aACFrame = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)2);
                            if (aACFrame != null) {
                                this.mediaInfoAudio.setAudioSamplingRate(aACFrame.getSampleRate());
                                this.mediaInfoAudio.setAudioChannels(aACFrame.getChannels());
                                this.mediaInfoAudio.setAudioBitsPerSample(16);
                                this.mediaInfoAudio.setAudioPacketSize(aACFrame.getChannels() * 2);
                            }
                            this.mediaInfoAudio.setAudioFourCC("AACL");
                            this.mediaInfoAudio.setAudioTag("255");
                            byte[] byArray2 = AACUtils.codecConfigToWaveFormatEX((byte[])byArray, (int)2, (int)(n2 - 2));
                            this.mediaInfoAudio.setAudioWaveFormatEx(byArray2);
                        }
                        break block62;
                    }
                    if (n5 == 2 && this.mediaInfoAudio.getAudioWaveFormatEx() == null) {
                        int n6;
                        if (n2 < 5) break block62;
                        object3 = new byte[4];
                        System.arraycopy(byArray, 1, object3, 0, ((byte[])object3).length);
                        object2 = MP3Utils.mp3FrameToWaveFormatEX((byte[])object3);
                        if (object2 != null) {
                            this.mediaInfoAudio.setAudioWaveFormatEx((byte[])object2);
                        }
                        if ((n6 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])object3, (MP3HeaderData)(object4 = new MP3HeaderData()))) != 0) {
                            MP3BufferedDecoder.decodeHeader((int)n6, (int)0, (MP3HeaderData)object4);
                            int n7 = 2;
                            int n8 = MP3BufferedDecoder.frequency((MP3HeaderData)object4);
                            switch (((MP3HeaderData)object4).h_mode) {
                                case 0: {
                                    n7 = 2;
                                    break;
                                }
                                case 1: {
                                    n7 = 2;
                                    break;
                                }
                                case 2: {
                                    n7 = 2;
                                    break;
                                }
                                case 3: {
                                    n7 = 1;
                                }
                            }
                            this.mediaInfoAudio.setAudioSamplingRate(n8);
                            this.mediaInfoAudio.setAudioChannels(n7);
                            this.mediaInfoAudio.setAudioBitsPerSample(16);
                            this.mediaInfoAudio.setAudioPacketSize(n7 * 2);
                        }
                        this.mediaInfoAudio.setAudioFourCC("WMAP");
                        this.mediaInfoAudio.setAudioTag("85");
                    }
                    if (this.mediaInfoAudio.getAudioWaveFormatEx() == null) break block62;
                    if (this.pendingAudioFragment != null && this.pendingAudioFragment.startTime >= 0L && (l3 < this.pendingAudioFragment.startTime || l3 - this.pendingAudioFragment.startTime > (long)(this.smoothStreamingPacketizer.smoothFragmentTargetAudioDuration * 10000))) {
                        this.pendingAudioFragment.duration = l3 - this.pendingAudioFragment.startTime;
                        this.pendingAudioFragments.add(this.pendingAudioFragment);
                        this.smoothStreamingPacketizer.endFragmentAudio(this.pendingAudioFragment.startTime, l3);
                        object3 = this.getPendingAudioHeaders(this.pendingAudioFragments);
                        for (Object object4 : object3.keySet()) {
                            SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = (SmoothStreamingFragmentHeader)object3.get(object4);
                            this.smoothStreamingPacketizer.setFragmentAudioHeader((Long)object4, smoothStreamingFragmentHeader, this.mediaInfoAudio);
                        }
                        object3.clear();
                        this.pendingAudioFragment = null;
                    }
                    if (this.pendingAudioFragment == null) {
                        this.pendingAudioFragment = new SmoothStreamingPendingFragment();
                        if (this.pendingAudioFragment.startTime == -1L) {
                            this.pendingAudioFragment.startTime = l3;
                        }
                        this.smoothStreamingPacketizer.startFragmentAudio(this.pendingAudioFragment.startTime);
                        if (this.smoothStreamingPacketizer.playReadyEncryptorAudio != null) {
                            this.pendingAudioFragment.playReadySampleData = new PlayReadySampleData();
                        }
                    }
                    if (this.lastAdjAudioTimecode >= 0L && l3 < this.lastAdjAudioTimecode) {
                        if (this.lastAdjAudioTimecodeWarning) {
                            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Timecode out of order [audio]: " + l3 + ":" + this.lastAdjAudioTimecode);
                            this.lastAdjAudioTimecodeWarning = false;
                        }
                        ++this.lastAdjTimecodeBackwardsCount;
                    } else {
                        this.lastAdjAudioTimecode = l3;
                        this.lastAdjTimecodeBackwardsCount = 0;
                        int n9 = n5 == 10 ? 2 : 1;
                        object2 = new SmoothStreamingMediaPacket();
                        ((SmoothStreamingMediaPacket)object2).setType(8);
                        ((SmoothStreamingMediaPacket)object2).setTimecode(l3);
                        if (this.smoothStreamingPacketizer.playReadyEncryptorAudio != null) {
                            object4 = PlayReadyUtils.encryptAudio((PlayReadyEncryptor)this.smoothStreamingPacketizer.playReadyEncryptorAudio, (byte[])byArray, (int)n9, (int)(n2 - n9));
                            if (object4 != null) {
                                ((SmoothStreamingMediaPacket)object2).setFragmentList(object4.getFragments());
                                this.pendingAudioFragment.playReadySampleData.add((PlayReadyEncryptionResult)object4);
                            }
                        } else {
                            ((SmoothStreamingMediaPacket)object2).getFragmentList().addPacketFragment(new RTPPacketFragment(byArray, n9, n2 - n9));
                        }
                        object4 = object2;
                        if (this.mtc < Long.MAX_VALUE) {
                            if (this.ftc == -1L) {
                                this.ftc = l;
                            } else if (l - this.ftc > this.mtc) {
                                object4 = null;
                                if (this.rtc) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                                    this.rtc = false;
                                }
                            }
                        }
                        this.smoothStreamingPacketizer.addFragmentAudioMediaPacket(this.pendingAudioFragment.startTime, (SmoothStreamingMediaPacket)object4);
                        this.pendingAudioFragment.frames.add((SmoothStreamingMediaPacket)object2);
                        this.pendingAudioFragment.size += ((SmoothStreamingMediaPacket)object2).getSize();
                    }
                    break block62;
                }
                if (n == 9 && n2 >= 5) {
                    byte[] byArray = aMFPacket.getData();
                    int n10 = byArray[0] & 0xFF;
                    int n11 = byArray[1] & 0xFF;
                    int n12 = FLVUtils.getVideoCodec((int)n10);
                    if (n12 == 7) {
                        if (n12 == 7 && n11 != 1) {
                            if (n11 == 0) {
                                this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n2 - 5));
                                H264CodecConfigInfo h264CodecConfigInfo = H264Utils.decodeAVCC((byte[])byArray, (int)5);
                                if (this.h264CodecConfigPart != null) {
                                    byte[] byArray3 = H264Utils.configPartsToSmoothPrivateData((H264CodecConfigParts)this.h264CodecConfigPart);
                                    this.mediaInfoVideo.setVideoCodecPrivateData(byArray3);
                                }
                                this.mediaInfoVideo.setVideoWidth(h264CodecConfigInfo.width);
                                this.mediaInfoVideo.setVideoHeight(h264CodecConfigInfo.height);
                                this.mediaInfoVideo.setVideoFourCC("H264");
                            }
                        } else {
                            int n13 = FLVUtils.getFrameType((int)n10);
                            int n14 = 0;
                            if (n12 == 7 && n2 >= 5) {
                                n14 = BufferUtils.byteArrayToInt((byte[])byArray, (int)2, (int)3) * 10000;
                            }
                            if (!this.waitingForKeyFrame || n13 == 1) {
                                Object object;
                                Object object5;
                                this.waitingForKeyFrame = false;
                                if (this.h264CodecConfigPart == null && (object5 = iMediaStream.getVideoCodecConfigPacket(l2)) != null) {
                                    object = object5.getData();
                                    int n15 = object5.getSize();
                                    this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])object, (int)5, (int)(n15 - 5));
                                }
                                if (this.h264CodecConfigPart != null) {
                                    if (this.pendingVideoFragment != null && n13 == 1 && this.pendingVideoFragment.frames.size() > 0) {
                                        this.pendingVideoFragment.duration = l3 - this.pendingVideoFragment.startTime;
                                        this.pendingVideoFragments.add(this.pendingVideoFragment);
                                        this.smoothStreamingPacketizer.endFragmentVideo(this.pendingVideoFragment.startTime, l3);
                                        object5 = this.getPendingVideoHeaders(this.pendingVideoFragments);
                                        object = object5.keySet().iterator();
                                        while (object.hasNext()) {
                                            Long l4 = (Long)object.next();
                                            SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = (SmoothStreamingFragmentHeader)object5.get(l4);
                                            this.smoothStreamingPacketizer.setFragmentVideoHeader(l4, smoothStreamingFragmentHeader, this.mediaInfoVideo);
                                        }
                                        object5.clear();
                                        this.pendingVideoFragment = null;
                                    }
                                    if (this.pendingVideoFragment == null) {
                                        this.pendingVideoFragment = new SmoothStreamingPendingFragment();
                                        if (this.pendingVideoFragment.startTime == -1L) {
                                            this.pendingVideoFragment.startTime = l3;
                                        }
                                        this.smoothStreamingPacketizer.startFragmentVideo(l3);
                                        if (this.smoothStreamingPacketizer.playReadyEncryptorVideo != null) {
                                            this.pendingVideoFragment.playReadySampleData = new PlayReadySampleData();
                                        }
                                    }
                                    if (this.lastAdjVideoTimecode >= 0L && l3 < this.lastAdjVideoTimecode) {
                                        if (this.lastAdjVideoTimecodeWarning) {
                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Timecode out of order [video]: " + l3 + ":" + this.lastAdjVideoTimecode);
                                            this.lastAdjVideoTimecodeWarning = false;
                                        }
                                        ++this.lastAdjTimecodeBackwardsCount;
                                    } else {
                                        this.lastAdjVideoTimecode = l3;
                                        this.lastAdjTimecodeBackwardsCount = 0;
                                        object5 = null;
                                        if (this.smoothStreamingPacketizer.smoothStreamingMediaMajorVersion >= 2) {
                                            if (this.smoothStreamingPacketizer.playReadyEncryptorVideo != null) {
                                                object = PlayReadyUtils.encryptVideo((PlayReadyEncryptor)this.smoothStreamingPacketizer.playReadyEncryptorVideo, (byte[])byArray, (int)5, (int)(n2 - 5), (int)this.smoothStreamingPacketizer.smoothPlayReadyH264ClearSize);
                                                if (object != null) {
                                                    object5 = object.getFragments();
                                                    this.pendingVideoFragment.playReadySampleData.add((PlayReadyEncryptionResult)object);
                                                }
                                            } else {
                                                object5 = new RTPPacketFragmentList();
                                                object = new RTPPacketFragment(byArray, 5, n2 - 5);
                                                object5.addPacketFragment((RTPPacketFragment)object);
                                            }
                                        } else {
                                            object5 = H264Utils.breakH264PacketIntoDelimitedNALUnits((byte[])byArray, (int)5, (int)(n2 - 5), (int)n13, (H264CodecConfigParts)this.h264CodecConfigPart);
                                        }
                                        if (object5 != null) {
                                            object = new SmoothStreamingMediaPacket();
                                            ((SmoothStreamingMediaPacket)object).setType(9);
                                            ((SmoothStreamingMediaPacket)object).getFragmentList().addPacketFragments((RTPPacketFragmentList)object5);
                                            ((SmoothStreamingMediaPacket)object).setTimecode(l3);
                                            ((SmoothStreamingMediaPacket)object).setCTTS(n14);
                                            ((SmoothStreamingMediaPacket)object).setFrameType(n13);
                                            Object object6 = object;
                                            if (this.mtc < Long.MAX_VALUE) {
                                                if (this.ftc == -1L) {
                                                    this.ftc = l;
                                                } else if (l - this.ftc > this.mtc) {
                                                    object6 = null;
                                                    if (this.rtc) {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                                                        this.rtc = false;
                                                    }
                                                }
                                            }
                                            this.smoothStreamingPacketizer.addFragmentVideoMediaPacket(this.pendingVideoFragment.startTime, (SmoothStreamingMediaPacket)object6);
                                            this.pendingVideoFragment.frames.add((SmoothStreamingMediaPacket)object);
                                            this.pendingVideoFragment.size += object5.size();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.handlePacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (this.lastAdjTimecodeBackwardsCount > 10) {
            this.lastAdjTimecodeBackwardsCount = 0;
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.resetStream[" + this.smoothStreamingPacketizer.getContextStr() + "]: Timecodes jumped back in time.");
            this.resetStream(iMediaStream);
        }
    }

    private int calculateBitrate(List<SmoothStreamingPendingFragment> list) {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        for (SmoothStreamingPendingFragment smoothStreamingPendingFragment : list) {
            l += smoothStreamingPendingFragment.duration;
            l2 += (long)smoothStreamingPendingFragment.size;
        }
        if (l > 0L) {
            n = (int)(l2 * 8L * 10000000L / l);
        }
        return n;
    }

    private Map<Long, SmoothStreamingFragmentHeader> getPendingVideoHeaders(List<SmoothStreamingPendingFragment> list) {
        HashMap<Long, SmoothStreamingFragmentHeader> hashMap = new HashMap<Long, SmoothStreamingFragmentHeader>();
        while (list.size() > this.smoothStreamingPacketizer.readAheadSize) {
            int n;
            if (this.mediaInfoVideo.getVideoBitrate() <= 0 && (n = this.calculateBitrate(list)) > 0) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.flushPendingVideo: Bitrate[" + this.smoothStreamingPacketizer.getContextStr() + "]: " + n);
                this.mediaInfoVideo.setVideoBitrate(n);
            }
            try {
                int n2;
                SmoothStreamingPendingFragment smoothStreamingPendingFragment = list.remove(0);
                long l = list.get((int)0).startTime;
                SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
                SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia = new SmoothStreamingFragmentWriterMedia();
                smoothStreamingFragmentWriterMedia.packets = smoothStreamingPendingFragment.frames;
                smoothStreamingFragmentWriterMedia.lastTimecode = l;
                smoothStreamingFragmentWriterMedia.timescale = 1L;
                smoothStreamingFragmentWriterMedia.playReadySampleData = smoothStreamingPendingFragment.playReadySampleData;
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    smoothStreamingFragmentWriterMedia.playReadySampleData.flush();
                }
                smoothStreamingFragmentWriterMedia.readAheadDurations = new long[this.smoothStreamingPacketizer.readAheadSize];
                smoothStreamingFragmentWriterMedia.readAheadStartTimes = new long[this.smoothStreamingPacketizer.readAheadSize];
                for (n2 = 0; n2 < this.smoothStreamingPacketizer.readAheadSize; ++n2) {
                    smoothStreamingFragmentWriterMedia.readAheadStartTimes[n2] = list.get((int)n2).startTime;
                    smoothStreamingFragmentWriterMedia.readAheadDurations[n2] = list.get((int)n2).duration;
                }
                n2 = SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, false);
                int n3 = SmoothStreamingFragmentWriter.getMediaSize(smoothStreamingFragmentWriterMedia);
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n4 = SmoothStreamingFragmentWriter.writeStartMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomMFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStartTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomTFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomTRUN(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomSDTP(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    n4 = SmoothStreamingFragmentWriter.writeAtomPlayReadyTrackUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                }
                n4 = SmoothStreamingFragmentWriter.writeAtomUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStopTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStartMDAT(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMDAT(byArray, n4, smoothStreamingFragmentWriterContext, n3);
                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = new SmoothStreamingFragmentHeader();
                smoothStreamingFragmentHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n2));
                hashMap.put(new Long(smoothStreamingPendingFragment.startTime), smoothStreamingFragmentHeader);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.getPendingVideoHeaders: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    private Map<Long, SmoothStreamingFragmentHeader> getPendingAudioHeaders(List<SmoothStreamingPendingFragment> list) {
        HashMap<Long, SmoothStreamingFragmentHeader> hashMap = new HashMap<Long, SmoothStreamingFragmentHeader>();
        while (list.size() > this.smoothStreamingPacketizer.readAheadSize) {
            int n;
            if (this.mediaInfoAudio.getAudioBitrate() <= 0 && (n = this.calculateBitrate(list)) > 0) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.flushPendingAudio: Bitrate[" + this.smoothStreamingPacketizer.getContextStr() + "]: " + n);
                this.mediaInfoAudio.setAudioBitrate(n);
            }
            try {
                int n2;
                SmoothStreamingPendingFragment smoothStreamingPendingFragment = list.remove(0);
                long l = list.get((int)0).startTime;
                SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
                SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia = new SmoothStreamingFragmentWriterMedia();
                smoothStreamingFragmentWriterMedia.packets = smoothStreamingPendingFragment.frames;
                smoothStreamingFragmentWriterMedia.lastTimecode = l;
                smoothStreamingFragmentWriterMedia.timescale = 1L;
                smoothStreamingFragmentWriterMedia.playReadySampleData = smoothStreamingPendingFragment.playReadySampleData;
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    smoothStreamingFragmentWriterMedia.playReadySampleData.flush();
                }
                smoothStreamingFragmentWriterMedia.readAheadDurations = new long[this.smoothStreamingPacketizer.readAheadSize];
                smoothStreamingFragmentWriterMedia.readAheadStartTimes = new long[this.smoothStreamingPacketizer.readAheadSize];
                for (n2 = 0; n2 < this.smoothStreamingPacketizer.readAheadSize; ++n2) {
                    smoothStreamingFragmentWriterMedia.readAheadStartTimes[n2] = list.get((int)n2).startTime;
                    smoothStreamingFragmentWriterMedia.readAheadDurations[n2] = list.get((int)n2).duration;
                }
                n2 = SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, false);
                int n3 = SmoothStreamingFragmentWriter.getMediaSize(smoothStreamingFragmentWriterMedia);
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n4 = SmoothStreamingFragmentWriter.writeStartMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomMFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStartTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomTFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomTRUN(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomSDTP(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    n4 = SmoothStreamingFragmentWriter.writeAtomPlayReadyTrackUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                }
                n4 = SmoothStreamingFragmentWriter.writeAtomUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStopTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStartMDAT(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMDAT(byArray, n4, smoothStreamingFragmentWriterContext, n3);
                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = new SmoothStreamingFragmentHeader();
                smoothStreamingFragmentHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n2));
                hashMap.put(new Long(smoothStreamingPendingFragment.startTime), smoothStreamingFragmentHeader);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.getPendingAudioHeaders: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hashMap;
    }
}

