/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang.SerializationException;

public class SerializationUtils {
    public static Object clone(Serializable serializable) {
        return SerializationUtils.deserialize(SerializationUtils.serialize(serializable));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (objectOutputStream == null) throw throwable;
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectOutputStream == null) return;
        objectOutputStream.close();
        return;
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
                Object var4_5 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(classNotFoundException);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (objectInputStream == null) throw throwable;
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return object;
        }
        if (objectInputStream == null) return object;
        objectInputStream.close();
        return object;
    }

    public static Object deserialize(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return SerializationUtils.deserialize(byteArrayInputStream);
    }
}

