/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int n) {
        this.port = n;
        this.startServer();
    }

    public void activateOptions() {
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(0);
            if (objectOutputStream == null) continue;
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                LogLog.error("could not close oos.", iOException);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent == null || this.oosList.size() == 0) {
            return;
        }
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        for (int i = 0; i < this.oosList.size(); ++i) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (objectOutputStream == null) break;
            try {
                objectOutputStream.writeObject(loggingEvent);
                objectOutputStream.flush();
                objectOutputStream.reset();
                continue;
            }
            catch (IOException iOException) {
                this.oosList.removeElementAt(i);
                LogLog.debug("dropped connection");
                --i;
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int n, Vector vector) {
            this.port = n;
            this.oosList = vector;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(1000);
            }
            catch (Exception exception) {
                LogLog.error("exception setting timeout, shutting down server socket.", exception);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    serverSocket.setSoTimeout(1000);
                }
                catch (SocketException socketException) {
                    LogLog.error("exception setting timeout, shutting down server socket.", socketException);
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                while (this.keepRunning) {
                    Socket socket = null;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (SocketException socketException) {
                        LogLog.error("exception accepting socket, shutting down server socket.", socketException);
                        this.keepRunning = false;
                    }
                    catch (IOException iOException) {
                        LogLog.error("exception accepting socket.", iOException);
                    }
                    if (socket == null) continue;
                    try {
                        InetAddress inetAddress = socket.getInetAddress();
                        LogLog.debug("accepting connection from " + inetAddress.getHostName() + " (" + inetAddress.getHostAddress() + ")");
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                        this.oosList.addElement(objectOutputStream);
                    }
                    catch (IOException iOException) {
                        LogLog.error("exception creating output stream on socket.", iOException);
                    }
                }
            }
            finally {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

