/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.IRandomAccessReader;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264CursorPosition;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;

public class H264ReadAheadRequest
implements Runnable {
    public static final int BLOCKSIZE = 100;
    H264ReadAheadPacket[] packetsAudio = null;
    long packetsAudioStart = 0L;
    int packetsAudioCount = 0;
    H264ReadAheadPacket[] packetsVideo = null;
    long packetsVideoStart = 0L;
    int packetsVideoCount = 0;
    private byte[] buffer = null;
    private IRandomAccessReader fileStream = null;
    private boolean isComplete = false;
    private long readAheadTrigger = 0L;
    private H264CursorPosition cursorPosition = null;

    public H264CursorPosition getCursorPosition() {
        return this.cursorPosition;
    }

    public void clear() {
        this.packetsAudioStart = 0L;
        this.packetsAudioCount = 0;
        this.packetsVideoStart = 0L;
        this.packetsVideoCount = 0;
        this.fileStream = null;
        this.isComplete = false;
        this.readAheadTrigger = 0L;
        this.cursorPosition = null;
    }

    public void setCursorPosition(H264CursorPosition h264CursorPosition) {
        this.cursorPosition = h264CursorPosition;
    }

    public void addPacket(int n, long l, long l2, long l3, long l4) {
        H264ReadAheadPacket h264ReadAheadPacket = new H264ReadAheadPacket(l2, l3, l4);
        if (n == 8) {
            int n2;
            if (this.packetsAudio == null) {
                this.packetsAudio = new H264ReadAheadPacket[100];
            }
            if (this.packetsAudioCount == 0) {
                this.packetsAudioStart = l;
            }
            if ((n2 = (int)(l - this.packetsAudioStart)) >= this.packetsAudio.length) {
                H264ReadAheadPacket[] h264ReadAheadPacketArray = new H264ReadAheadPacket[this.packetsAudio.length + 100];
                System.arraycopy(this.packetsAudio, 0, h264ReadAheadPacketArray, 0, this.packetsAudio.length);
                this.packetsAudio = h264ReadAheadPacketArray;
            }
            this.packetsAudio[n2] = h264ReadAheadPacket;
            ++this.packetsAudioCount;
        } else {
            int n3;
            if (this.packetsVideo == null) {
                this.packetsVideo = new H264ReadAheadPacket[100];
            }
            if (this.packetsVideoCount == 0) {
                this.packetsVideoStart = l;
            }
            if ((n3 = (int)(l - this.packetsVideoStart)) >= this.packetsVideo.length) {
                H264ReadAheadPacket[] h264ReadAheadPacketArray = new H264ReadAheadPacket[this.packetsVideo.length + 100];
                System.arraycopy(this.packetsVideo, 0, h264ReadAheadPacketArray, 0, this.packetsVideo.length);
                this.packetsVideo = h264ReadAheadPacketArray;
            }
            this.packetsVideo[n3] = h264ReadAheadPacket;
            ++this.packetsVideoCount;
        }
    }

    public void setReadAheadTrigger(long l) {
        this.readAheadTrigger = l;
    }

    public void setFileStream(IRandomAccessReader iRandomAccessReader) {
        this.fileStream = iRandomAccessReader;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        if (n == 8) {
            int n2 = (int)(l - this.packetsAudioStart);
            if (n2 >= 0 && n2 < this.packetsAudioCount) {
                return this.packetsAudio[n2];
            }
        } else {
            int n3 = (int)(l - this.packetsVideoStart);
            if (n3 >= 0 && n3 < this.packetsVideoCount) {
                return this.packetsVideo[n3];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete() {
        if (this.isComplete) {
            return;
        }
        H264ReadAheadRequest h264ReadAheadRequest = this;
        synchronized (h264ReadAheadRequest) {
            if (this.isComplete) {
                return;
            }
            try {
                this.wait();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(H264ReadAheadRequest.class).error("H264ReadAheadRequest.waitForComplete " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        H264ReadAheadRequest h264ReadAheadRequest = this;
        synchronized (h264ReadAheadRequest) {
            H264ReadAheadPacket[] h264ReadAheadPacketArray = new H264ReadAheadPacket[this.packetsAudioCount + this.packetsVideoCount];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            long l = 0L;
            do {
                long l2;
                long l3 = n < this.packetsVideoCount ? this.packetsVideo[n].foffset : Long.MAX_VALUE;
                long l4 = l2 = n2 < this.packetsAudioCount ? this.packetsAudio[n2].foffset : Long.MAX_VALUE;
                if (l2 < l3) {
                    h264ReadAheadPacketArray[n3] = this.packetsAudio[n2];
                    ++n2;
                } else {
                    h264ReadAheadPacketArray[n3] = this.packetsVideo[n];
                    ++n;
                }
                l += h264ReadAheadPacketArray[n3].size;
            } while (++n3 < h264ReadAheadPacketArray.length);
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(H264ReadAheadRequest.class);
            if (this.buffer == null) {
                this.buffer = new byte[(int)l];
            }
            if ((long)this.buffer.length < l) {
                this.buffer = new byte[(int)l];
            }
            int n4 = 0;
            class LastBlock {
                long foffset = -1L;
                long size = 0L;
                int boffset = 0;

                LastBlock() {
                }
            }
            LastBlock lastBlock = null;
            for (int i = 0; i < h264ReadAheadPacketArray.length; ++i) {
                H264ReadAheadPacket h264ReadAheadPacket = h264ReadAheadPacketArray[i];
                if (lastBlock == null) {
                    lastBlock = new LastBlock();
                    lastBlock.foffset = h264ReadAheadPacket.foffset;
                    lastBlock.size = h264ReadAheadPacket.size;
                    lastBlock.boffset = 0;
                } else if (h264ReadAheadPacket.foffset == lastBlock.foffset + lastBlock.size) {
                    lastBlock.size += h264ReadAheadPacket.size;
                } else {
                    try {
                        this.fileStream.seek(lastBlock.foffset);
                        this.fileStream.read(this.buffer, lastBlock.boffset, (int)lastBlock.size);
                    }
                    catch (Exception exception) {
                        wMSLogger.error("H264ReadAheadRequest.run[1]: " + exception.toString());
                    }
                    lastBlock.foffset = h264ReadAheadPacket.foffset;
                    lastBlock.boffset = (int)((long)lastBlock.boffset + lastBlock.size);
                    lastBlock.size = h264ReadAheadPacket.size;
                }
                try {
                    h264ReadAheadPacket.boffset = n4;
                    h264ReadAheadPacket.isAfterTrigger = (long)n4 >= this.readAheadTrigger;
                    h264ReadAheadPacket.buffer = this.buffer;
                    n4 = (int)((long)n4 + h264ReadAheadPacket.size);
                    continue;
                }
                catch (Exception exception) {
                    wMSLogger.error("H264ReadAheadRequest.run[1]: " + exception.toString());
                }
            }
            if (lastBlock != null) {
                try {
                    this.fileStream.seek(lastBlock.foffset);
                    this.fileStream.read(this.buffer, lastBlock.boffset, (int)lastBlock.size);
                }
                catch (Exception exception) {
                    wMSLogger.error("H264ReadAheadRequest.run[2]: " + exception.toString());
                }
            }
            this.isComplete = true;
            try {
                this.notify();
            }
            catch (Exception exception) {
                wMSLogger.error("H264ReadAheadRequest.run[2]: " + exception.toString());
            }
        }
    }
}

