/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.atom;

import com.wowza.util.IFastIntBuffer;
import com.wowza.util.IFastLongBuffer;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import java.util.SortedMap;
import java.util.TreeMap;

public class QTMediaCursor {
    public static final int KEY_UP = 1;
    public static final int KEY_DOWN = 2;
    public static final int KEY_CLOSESTS = 3;
    public static final int KEYOFFSET = 1;
    public static final int TYPE_FULL = 0;
    public static final int TYPE_SIZES = 1;
    public static final int TYPE_TIMECODES = 2;
    public static final int SAMPLEINDEXFREQ = 600;
    private QTAtomtrak trakAtom = null;
    private long sampleSize = 0L;
    private IFastIntBuffer timeToSample = null;
    private long timeToSampleLen = 0L;
    private int singleSampleDuration = -1;
    private IFastLongBuffer syncSamples = null;
    private IFastIntBuffer sampleSizes = null;
    private IFastLongBuffer chunkOffsets = null;
    private IFastIntBuffer sampleToChunk = null;
    private IFastIntBuffer cttsValues = null;
    private long cttsLen = 0L;
    private long timeScale = 0L;
    private long sampleCount = 0L;
    private TreeMap<Long, TimeToSampleIndex> timeToSampleSampleIndex = new TreeMap();
    private TreeMap<Long, TimeToSampleIndex> timeToSampleTimecodeIndex = new TreeMap();
    private long timeToSampleLastAccumSample = -1L;
    private long timeToSampleLastTimecode = -1L;
    private int timeToSampleLastIndex = -1;
    private long s2cCacheStartSample = -1L;
    private long s2cCacheStopSample = -1L;
    private int s2cCacheSamplesPerChunk = -1;
    private int s2cCacheSampleDesc = -1;
    private int s2cCacheChunkOffset = -1;
    private int s2cChunkIndex = -1;
    private long s2cChunkSample = -1L;
    private int s2cChunkChunk = -1;
    private int cttsCacheLastIndex = -1;
    private long cttsCacheLastSample = -1L;
    private int c2fCacheChunkLoc0 = -1;
    private int c2fCacheChunkLoc1 = -1;
    private long c2fCacheFilePos = -1L;
    private int cursorType = 0;
    private long sampleDescCount = 0L;
    Cursor current = new Cursor();

    public QTMediaCursor(QTAtomtrak qTAtomtrak) {
        this.trakAtom = qTAtomtrak;
        this.init();
        this.moveToSample(0L);
    }

    private int getChunkCount(int n) {
        int n2 = 0;
        if (n < this.sampleToChunk.length() - 1) {
            n2 = this.sampleToChunk.get(n + 1, 0) - this.sampleToChunk.get(n, 0);
        }
        return n2;
    }

    private void init() {
        QTAtomstbl qTAtomstbl = this.trakAtom.getMdiaAtom().getMinfAtom().getStblAtom();
        this.sampleSize = qTAtomstbl.getSampleSize();
        this.timeToSample = qTAtomstbl.getTimeToSample();
        long l = this.timeToSampleLen = this.timeToSample == null ? 0L : (long)this.timeToSample.length();
        if (this.timeToSampleLen == 1L) {
            this.singleSampleDuration = this.timeToSample.get(0, 1);
        }
        this.syncSamples = qTAtomstbl.getSyncSamples();
        this.sampleToChunk = qTAtomstbl.getSampleToChunk();
        this.sampleSizes = qTAtomstbl.getSampleSizes();
        this.chunkOffsets = qTAtomstbl.getChunkOffsets();
        this.timeScale = this.trakAtom.getMdiaAtom().getTimescale();
        this.cttsValues = qTAtomstbl.getCttsValues();
        this.cttsLen = this.cttsValues == null ? 0L : (long)this.cttsValues.length();
        this.sampleDescCount = qTAtomstbl.getSampleDescriptionCount();
        this.sampleCount = 0L;
        long l2 = 0L;
        long l3 = 600L;
        if (this.timeToSample != null) {
            int n = 0;
            while ((long)n < this.timeToSampleLen) {
                int n2 = this.timeToSample.get(n, 0);
                int n3 = this.timeToSample.get(n, 1);
                if ((long)n >= l3) {
                    l3 = n + 600;
                    TimeToSampleIndex timeToSampleIndex = new TimeToSampleIndex(n, l2, this.sampleCount);
                    this.timeToSampleSampleIndex.put(this.sampleCount, timeToSampleIndex);
                    this.timeToSampleTimecodeIndex.put(l2, timeToSampleIndex);
                }
                this.sampleCount += (long)n2;
                l2 += (long)(n2 * n3);
                ++n;
            }
        }
        if (this.sampleSize <= 0L) {
            this.sampleCount = this.sampleSizes.length();
        }
    }

    public long getTotalTrackSize() {
        long l = 0L;
        if (this.sampleSize > 0L) {
            l = this.sampleSize * this.sampleCount;
        } else {
            int n = this.sampleSizes.length();
            for (int i = 0; i < n; ++i) {
                l += (long)this.sampleSizes.get(i);
            }
        }
        return l;
    }

    private boolean sampleToIsKey(long l) {
        if (this.syncSamples != null) {
            return this.syncSamples.binarySearch(l + 1L) >= 0;
        }
        return true;
    }

    public int getCTTS() {
        return this.current.ctts;
    }

    public int getCTTSMillis() {
        long l = Math.round((double)this.current.timecode * 1000.0 / (double)this.timeScale);
        long l2 = Math.round((double)(this.current.timecode + (long)this.current.ctts) * 1000.0 / (double)this.timeScale);
        return (int)(l2 - l);
    }

    public long getTimeMillis() {
        return Math.round((double)this.current.timecode * 1000.0 / (double)this.timeScale);
    }

    public long getTimeSL() {
        return this.current.timecode * 10000000L / this.timeScale;
    }

    public long getTimeScaled(int n) {
        return Math.round((double)(this.current.timecode * (long)n) / (double)this.timeScale);
    }

    public long timeMillisToTimecode(long l) {
        return Math.round((double)l * (double)this.timeScale / 1000.0);
    }

    public long timecodeToTimeMillis(long l) {
        return Math.round((double)l * 1000.0 / (double)this.timeScale);
    }

    public long timecodeToTimeSL(long l) {
        return Math.round((double)l * 1000.0 / (double)this.timeScale) * 10000L;
    }

    public int getKeyFrameCount() {
        if (this.syncSamples == null) {
            return 0;
        }
        return this.syncSamples.length();
    }

    public long getKeyFrameSample(int n) {
        if (this.syncSamples == null) {
            return -1L;
        }
        return this.syncSamples.get(n) - 1L;
    }

    public long findKeySample(long l, int n) {
        long l2 = l;
        if (this.syncSamples == null) {
            return l2;
        }
        int n2 = this.syncSamples.binarySearch(l + 1L);
        if (n2 < 0) {
            int n3 = this.syncSamples.length();
            if ((n2 = -n2 - 1) == 0) {
                return 0L;
            }
            if (n2 >= n3) {
                return this.syncSamples.get(n3 - 1) - 1L;
            }
            if (n == 1) {
                long l3 = this.syncSamples.get(n2 - 1) - 1L;
                return l3;
            }
            if (n == 2) {
                long l4 = this.syncSamples.get(n2) - 1L;
                return l4;
            }
            long l5 = this.syncSamples.get(n2 - 1) - 1L;
            long l6 = this.syncSamples.get(n2) - 1L;
            if (Math.abs(l - l5) <= Math.abs(l - l6)) {
                return l5;
            }
            return l6;
        }
        return l2;
    }

    public int sampleToCTTS(long l) {
        int n;
        block3: {
            n = 0;
            if (this.cttsLen <= 0L) break block3;
            long l2 = 0L;
            int n2 = 0;
            if (this.cttsCacheLastSample != -1L && l >= this.cttsCacheLastSample) {
                l2 = this.cttsCacheLastSample;
                n2 = this.cttsCacheLastIndex;
            }
            int n3 = n2;
            do {
                int n4;
                if (l < l2 + (long)(n4 = this.cttsValues.get(n2, 0))) {
                    n = this.cttsValues.get(n2, 1);
                    this.cttsCacheLastIndex = n2;
                    this.cttsCacheLastSample = l2;
                    break;
                }
                l2 += (long)n4;
            } while ((long)(++n2) < this.cttsLen);
        }
        return n;
    }

    public long sampleToTimecode(long l) {
        long l2;
        block8: {
            l2 = 0L;
            if (l <= 0L) break block8;
            if (this.timeToSampleLen == 1L) {
                l2 = l * (long)this.singleSampleDuration;
            } else {
                SortedMap<Long, TimeToSampleIndex> sortedMap;
                long l3 = 0L;
                int n = 0;
                if (this.timeToSampleLastIndex >= 0) {
                    if (l >= this.timeToSampleLastAccumSample && l - this.timeToSampleLastAccumSample < 200L) {
                        l3 = this.timeToSampleLastAccumSample;
                        l2 = this.timeToSampleLastTimecode;
                        n = this.timeToSampleLastIndex;
                    } else {
                        this.timeToSampleLastIndex = -1;
                    }
                }
                if (this.timeToSampleLastIndex < 0 && (sortedMap = this.timeToSampleSampleIndex.headMap(l + 1L)).size() > 0) {
                    TimeToSampleIndex timeToSampleIndex = (TimeToSampleIndex)sortedMap.get(sortedMap.lastKey());
                    l3 = timeToSampleIndex.sample;
                    n = timeToSampleIndex.index;
                    l2 = timeToSampleIndex.duration;
                }
                this.timeToSampleLastIndex = -1;
                do {
                    int n2 = this.timeToSample.get(n, 0);
                    int n3 = this.timeToSample.get(n, 1);
                    if (l < l3 + (long)n2) {
                        this.timeToSampleLastAccumSample = l3;
                        this.timeToSampleLastTimecode = l2;
                        this.timeToSampleLastIndex = n;
                        l2 += (l - l3) * (long)n3;
                        break;
                    }
                    l3 += (long)n2;
                    l2 += (long)n2 * (long)n3;
                } while ((long)(++n) < this.timeToSampleLen);
            }
        }
        return l2;
    }

    public long timecodeToSample(long l) {
        long l2;
        block5: {
            l2 = 0L;
            if (l <= 0L) break block5;
            if (this.timeToSampleLen == 1L) {
                l2 = l / (long)this.singleSampleDuration;
            } else {
                long l3 = 0L;
                int n = 0;
                SortedMap<Long, TimeToSampleIndex> sortedMap = this.timeToSampleTimecodeIndex.headMap(l);
                if (sortedMap.size() > 0) {
                    TimeToSampleIndex timeToSampleIndex = (TimeToSampleIndex)sortedMap.get(sortedMap.lastKey());
                    l2 = timeToSampleIndex.sample;
                    n = timeToSampleIndex.index;
                    l3 = timeToSampleIndex.duration;
                }
                do {
                    int n2;
                    int n3;
                    if (l < l3 + (long)((n3 = this.timeToSample.get(n, 0)) * (n2 = this.timeToSample.get(n, 1)))) {
                        l2 += (l - l3) / (long)n2;
                        break;
                    }
                    l2 += (long)n3;
                    l3 += (long)n3 * (long)n2;
                } while ((long)(++n) < this.timeToSampleLen);
            }
        }
        return l2;
    }

    private long chunkLocToFilePos(long l, int[] nArray) {
        long l2 = 0L;
        if (this.sampleSize > 0L) {
            l2 = this.chunkOffsets.get(nArray[0]) + this.sampleSize * (long)nArray[1];
        } else {
            if (this.c2fCacheChunkLoc0 == nArray[0] && nArray[1] > 0 && this.c2fCacheChunkLoc1 == nArray[1] - 1) {
                int n = (int)(l - (long)nArray[1]);
                l2 = this.c2fCacheFilePos;
                l2 += (long)this.sampleSizes.get(n + nArray[1] - 1);
            } else {
                l2 = this.chunkOffsets.get(nArray[0]);
                int n = (int)(l - (long)nArray[1]);
                for (int i = 0; i < nArray[1]; ++i) {
                    l2 += (long)this.sampleSizes.get(n + i);
                }
            }
            this.c2fCacheChunkLoc0 = nArray[0];
            this.c2fCacheChunkLoc1 = nArray[1];
            this.c2fCacheFilePos = l2;
        }
        return l2;
    }

    private int[] sampleToChunkLoc(long l) {
        int[] nArray = new int[3];
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        if (l >= this.s2cCacheStartSample && l < this.s2cCacheStopSample) {
            n = (int)((long)this.s2cCacheChunkOffset + (l - this.s2cCacheStartSample) / (long)this.s2cCacheSamplesPerChunk);
            n2 = (int)((l - this.s2cCacheStartSample) % (long)this.s2cCacheSamplesPerChunk);
            n3 = this.s2cCacheSampleDesc;
        } else {
            long l2 = 0L;
            int n4 = 0;
            if (this.s2cChunkIndex >= 0 && l >= this.s2cChunkSample) {
                n4 = this.s2cChunkIndex;
                l2 = this.s2cChunkSample;
                n = this.s2cChunkChunk;
            }
            this.s2cChunkIndex = -1;
            while (true) {
                int n5 = this.getChunkCount(n4);
                int n6 = this.sampleToChunk.get(n4, 1);
                int n7 = this.sampleToChunk.get(n4, 2);
                if (n5 == 0) {
                    this.s2cCacheStartSample = l2;
                    this.s2cCacheStopSample = l2 + (long)(n5 * n6);
                    this.s2cCacheSamplesPerChunk = n6;
                    this.s2cCacheSampleDesc = n7;
                    this.s2cCacheChunkOffset = n;
                    n = (int)((long)n + (l - l2) / (long)n6);
                    n2 = (int)((l - l2) % (long)n6);
                    n3 = this.s2cCacheSampleDesc;
                    break;
                }
                if (l < l2 + (long)(n5 * n6)) {
                    this.s2cCacheStartSample = l2;
                    this.s2cCacheStopSample = l2 + (long)(n5 * n6);
                    this.s2cCacheSamplesPerChunk = n6;
                    this.s2cCacheSampleDesc = n7;
                    this.s2cCacheChunkOffset = n;
                    this.s2cChunkIndex = n4;
                    this.s2cChunkSample = l2;
                    this.s2cChunkChunk = n;
                    n = (int)((long)n + (l - l2) / (long)n6);
                    n2 = (int)((l - l2) % (long)n6);
                    n3 = this.s2cCacheSampleDesc;
                    break;
                }
                l2 += (long)(n5 * n6);
                n += n5;
                ++n4;
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        return nArray;
    }

    public long getAudioTime() {
        return this.current.timecode * 8000L * 4L / this.timeScale;
    }

    public long get90HzTime() {
        return Math.round((double)this.current.timecode * 90000.0 / (double)this.timeScale);
    }

    public double getSeekPoint() {
        return (double)this.current.timecode / (double)this.timeScale;
    }

    public long getFileLoc() {
        return this.current.fileLoc;
    }

    public long getSample() {
        return this.current.sample;
    }

    public long getSampleDesc() {
        if (this.current.sampleDesc >= 1L) {
            return this.current.sampleDesc - 1L;
        }
        if (this.sampleDescCount <= 1L) {
            return 0L;
        }
        int[] nArray = this.sampleToChunkLoc(this.current.sample);
        return nArray[2] - 1;
    }

    public boolean isKeyFrame() {
        return this.current.isKeyFrame;
    }

    public long getSize() {
        return this.current.sampleSize;
    }

    private void loadSample(Cursor cursor) {
        int[] nArray = null;
        switch (this.cursorType) {
            case 0: {
                this.current.timecode = this.sampleToTimecode(this.current.sample);
                nArray = this.sampleToChunkLoc(this.current.sample);
                this.current.fileLoc = this.chunkLocToFilePos(this.current.sample, nArray);
                this.current.isKeyFrame = this.sampleToIsKey(this.current.sample);
                this.current.ctts = this.sampleToCTTS(this.current.sample);
                this.current.sampleSize = this.sampleSize > 0L ? this.sampleSize : (long)this.sampleSizes.get((int)this.current.sample);
                this.current.sampleDesc = nArray[2];
                break;
            }
            case 1: {
                nArray = this.sampleToChunkLoc(this.current.sample);
                this.current.fileLoc = this.chunkLocToFilePos(this.current.sample, nArray);
                this.current.sampleSize = this.sampleSize > 0L ? this.sampleSize : (long)this.sampleSizes.get((int)this.current.sample);
                this.current.sampleDesc = nArray[2];
                break;
            }
            case 2: {
                this.current.timecode = this.sampleToTimecode(this.current.sample);
                nArray = this.sampleToChunkLoc(this.current.sample);
                this.current.isKeyFrame = this.sampleToIsKey(this.current.sample);
                this.current.ctts = this.sampleToCTTS(this.current.sample);
                this.current.sampleDesc = -1L;
            }
        }
    }

    public void setCursorType(int n) {
        this.cursorType = n;
    }

    public boolean isSampleValid(long l) {
        return l >= 0L && l < this.sampleCount;
    }

    public boolean moveToSample(long l) {
        if (l >= 0L && l < this.sampleCount) {
            this.current.sample = l;
            this.loadSample(this.current);
            return true;
        }
        return false;
    }

    public boolean movePrevSample() {
        boolean bl = false;
        if (this.current.sample <= 0L) {
            bl = true;
        } else {
            --this.current.sample;
            this.loadSample(this.current);
        }
        return !bl;
    }

    public boolean moveNextSample() {
        boolean bl = false;
        if (this.current.sample >= this.sampleCount - 1L) {
            bl = true;
        } else {
            ++this.current.sample;
            this.loadSample(this.current);
        }
        return !bl;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public long[] getKeyFrameTimecodes() {
        long[] lArray = null;
        if (this.syncSamples != null) {
            int n = this.syncSamples.length();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                long l = this.syncSamples.get(i);
                lArray[i] = this.sampleToTimecode(l);
            }
        }
        return lArray;
    }

    public long[] getKeyFrameTimesMillis() {
        long[] lArray = null;
        if (this.syncSamples != null) {
            int n = this.syncSamples.length();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                long l = this.syncSamples.get(i);
                lArray[i] = Math.round((double)this.sampleToTimecode(l) * 1000.0 / (double)this.timeScale);
            }
        }
        return lArray;
    }

    public void close() {
        this.trakAtom = null;
        this.sampleSize = 0L;
        this.timeToSample = null;
        this.timeToSampleLen = 0L;
        this.singleSampleDuration = -1;
        this.syncSamples = null;
        this.sampleSizes = null;
        this.chunkOffsets = null;
        this.sampleToChunk = null;
        this.cttsValues = null;
        this.cttsLen = 0L;
        this.timeScale = 0L;
        this.sampleCount = 0L;
        this.s2cCacheStartSample = -1L;
        this.s2cCacheStopSample = -1L;
        this.s2cCacheSamplesPerChunk = -1;
        this.s2cCacheSampleDesc = -1;
        this.s2cCacheChunkOffset = -1;
        this.cttsCacheLastIndex = -1;
        this.cttsCacheLastSample = -1L;
        this.c2fCacheChunkLoc0 = -1;
        this.c2fCacheChunkLoc1 = -1;
        this.c2fCacheFilePos = -1L;
    }

    class Cursor {
        public long sample = 0L;
        public long timecode = 0L;
        public long fileLoc = 0L;
        public boolean isKeyFrame = false;
        public int ctts;
        public long sampleSize;
        public long sampleDesc = 0L;

        Cursor() {
        }

        public String toString() {
            return "Cursor: s:" + this.sample + " tc:" + this.timecode + " fl:" + this.fileLoc + " key:" + this.isKeyFrame;
        }
    }

    class TimeToSampleIndex {
        public int index = -1;
        public long duration = -1L;
        public long sample = -1L;

        public TimeToSampleIndex(int n, long l, long l2) {
            this.index = n;
            this.duration = l;
            this.sample = l2;
        }
    }
}

