/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerApplicationContextBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;

public class HTTPStreamerApplicationContextCupertinoStreamer
extends HTTPStreamerApplicationContextBase {
    private boolean autoCreateMultibitratePlaylist = false;
    private boolean useCalculatedVideoBitrate = false;
    private boolean useCalculatedAudioBitrate = false;
    private boolean calculatePlaylistBitrates = false;
    private int defaultVideoBitrate = 64000;
    private int defaultAudioBitrate = 64000;
    private int maxCalulatedAudioBitrate = 0;
    private int maxCalulatedVideoBitrate = 0;
    private int bitrateAdjustmentFactor = 110;
    private String playlistHostOverride = null;

    public void init(IApplicationInstance iApplicationInstance, HTTPStreamerItem hTTPStreamerItem) {
        super.init(iApplicationInstance, hTTPStreamerItem);
        WMSProperties wMSProperties = this.getProperties();
        this.defaultVideoBitrate = wMSProperties.getPropertyInt("cupertinoDefaultVideoBitrate", this.defaultVideoBitrate);
        this.maxCalulatedVideoBitrate = wMSProperties.getPropertyInt("cupertinoMaxCalulatedVideoBitrate", this.maxCalulatedVideoBitrate);
        this.defaultAudioBitrate = wMSProperties.getPropertyInt("cupertinoDefaultAudioBitrate", this.defaultAudioBitrate);
        this.maxCalulatedAudioBitrate = wMSProperties.getPropertyInt("cupertinoMaxCalulatedAudioBitrate", this.maxCalulatedAudioBitrate);
        this.bitrateAdjustmentFactor = wMSProperties.getPropertyInt("cupertinoBitrateAdjustmentFactor", this.bitrateAdjustmentFactor);
        this.autoCreateMultibitratePlaylist = wMSProperties.getPropertyBoolean("cupertinoAutoCreateMultibitratePlaylist", this.autoCreateMultibitratePlaylist);
        this.useCalculatedVideoBitrate = wMSProperties.getPropertyBoolean("cupertinoUseCalculatedVideoBitrate", this.useCalculatedVideoBitrate);
        this.useCalculatedAudioBitrate = wMSProperties.getPropertyBoolean("cupertinoUseCalculatedAudioBitrate", this.useCalculatedAudioBitrate);
        this.playlistHostOverride = wMSProperties.getPropertyStr("cupertinoPlaylistHostOverride", this.playlistHostOverride);
        this.calculatePlaylistBitrates = this.useCalculatedVideoBitrate || this.useCalculatedAudioBitrate;
    }

    public boolean isAutoCreateMultibitratePlaylist() {
        return this.autoCreateMultibitratePlaylist;
    }

    public void setAutoCreateMultibitratePlaylist(boolean bl) {
        this.autoCreateMultibitratePlaylist = bl;
    }

    public boolean isUseCalculatedVideoBitrate() {
        return this.useCalculatedVideoBitrate;
    }

    public void setUseCalculatedVideoBitrate(boolean bl) {
        this.useCalculatedVideoBitrate = bl;
    }

    public boolean isUseCalculatedAudioBitrate() {
        return this.useCalculatedAudioBitrate;
    }

    public void setUseCalculatedAudioBitrate(boolean bl) {
        this.useCalculatedAudioBitrate = bl;
    }

    public boolean isCalculatePlaylistBitrates() {
        return this.calculatePlaylistBitrates;
    }

    public void setCalculatePlaylistBitrates(boolean bl) {
        this.calculatePlaylistBitrates = bl;
    }

    public int getDefaultVideoBitrate() {
        return this.defaultVideoBitrate;
    }

    public void setDefaultVideoBitrate(int n) {
        this.defaultVideoBitrate = n;
    }

    public int getDefaultAudioBitrate() {
        return this.defaultAudioBitrate;
    }

    public void setDefaultAudioBitrate(int n) {
        this.defaultAudioBitrate = n;
    }

    public int getMaxCalulatedAudioBitrate() {
        return this.maxCalulatedAudioBitrate;
    }

    public void setMaxCalulatedAudioBitrate(int n) {
        this.maxCalulatedAudioBitrate = n;
    }

    public int getMaxCalulatedVideoBitrate() {
        return this.maxCalulatedVideoBitrate;
    }

    public void setMaxCalulatedVideoBitrate(int n) {
        this.maxCalulatedVideoBitrate = n;
    }

    public int getBitrateAdjustmentFactor() {
        return this.bitrateAdjustmentFactor;
    }

    public void setBitrateAdjustmentFactor(int n) {
        this.bitrateAdjustmentFactor = n;
    }

    public String getPlaylistHostOverride() {
        return this.playlistHostOverride;
    }

    public void setPlaylistHostOverride(String string) {
        this.playlistHostOverride = string;
    }
}

