/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.ts.TransportStreamUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import com.wowza.wms.server.PLims;
import com.wowza.wms.stream.MediaStreamBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CupertinoTSPacketizer {
    public static final int TS_PACKETLEN = 188;
    public static final int TS_MAXLEN = 32725;
    public static final int TS_MAXLEN_PACKETS = 178;
    public static final int TS_VIDEO_LEN_1ST = 157;
    public static final int TS_VIDEO_LEN = 184;
    public static final int TS_AUDIO_LEN_1ST = 170;
    public static final int TS_AUDIO_LEN = 184;
    private int videoPID = 256;
    private int audioPID = 257;
    private byte videoStreamID = (byte)-32;
    private byte audioStreamID = (byte)-64;
    private long videoCCounter = -1L;
    private long audioCCounter = -1L;
    private long patCCounter = 0L;
    private H264CodecConfigParts h264CodecConfigPart = null;
    private boolean forceH264BaselineProfile = false;
    private int forceAACProfile = -1;
    private AACFrame aacFrame = null;
    private long ftc = -1L;
    private long mtc = Long.MAX_VALUE;
    private boolean rtc = true;

    public CupertinoTSPacketizer() {
        try {
            int n;
            Object[] objectArray;
            String[] stringArray;
            Object object;
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            String string3 = (String)MediaStreamBase.sinfo.get("slp");
            int n2 = -2;
            String[] stringArray2 = string2.split("[|]");
            String string4 = "p" + string3 + "=";
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                if (!((String)object).startsWith(string4)) continue;
                object = ((String)object).substring(string4.length());
                stringArray = ((String)object).split("[,]");
                for (int j = 0; j < stringArray.length; ++j) {
                    objectArray = stringArray[j].split(":");
                    if (!objectArray[0].equals("c")) continue;
                    n2 = Integer.parseInt((String)objectArray[1]);
                }
            }
            BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
            object = bigInteger2.toByteArray();
            stringArray = (String[])MediaStreamBase.sinfo.get("r1");
            byte[] byArray = stringArray.toByteArray();
            objectArray = new byte[ModuleConnect.lc.length];
            byte[] byArray2 = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, objectArray, 0, ModuleConnect.lc.length);
            System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
            for (n = 0; n < byArray2.length; ++n) {
                int n3 = n;
                objectArray[n3] = (byte)(objectArray[n3] ^ byArray[(n + 11) % byArray.length]);
            }
            this.mtc = PLims.getInstance().check((long)n2, objectArray);
            for (n = 0; n < byArray2.length; ++n) {
                int n4 = n;
                byArray2[n4] = (byte)(byArray2[n4] ^ byArray[(n + 11) % byArray.length]);
                int n5 = n;
                byArray2[n5] = (byte)(byArray2[n5] ^ object[(n + 5) % ((Object)object).length]);
            }
            for (n = 0; n < ModuleConnect.lc.length; ++n) {
                if (objectArray[n] == byArray2[n]) continue;
                System.out.println(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)14)));
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LiveStreamingCupertinoBlock rewriteH264Profile(byte[] byArray, int n, int n2) {
        byte by;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length > 1) {
            byArray2[1] = 66;
        }
        if (byArray2.length > 3 && (by = byArray2[3]) > 30) {
            byArray2[3] = 30;
        }
        return new LiveStreamingCupertinoBlock(byArray2, 0, n2);
    }

    private int getNumberOfAudioTSPackets(int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 > 0) {
            ++n2;
            if ((n3 -= 170) > 0) {
                n2 += n3 / 184 + (n3 % 184 > 0 ? 1 : 0);
            }
        }
        return n2;
    }

    private int getNumberOfVideoTSPackets(int n) {
        int n2 = n / 32725 * 178;
        int n3 = n % 32725;
        if (n3 > 0) {
            ++n2;
            if ((n3 -= 157) > 0) {
                n2 += n3 / 184 + (n3 % 184 > 0 ? 1 : 0);
            }
        }
        return n2;
    }

    public byte[] getAudioID3TagHeader(long l) {
        byte[] byArray = BufferUtils.decodeHexString((String)"4944330400000000003F50524956000000350000636F6D2E6170706C652E73747265616D696E672E7472616E73706F727453747265616D54696D657374616D700000000000018092A0");
        long l2 = 0x1FFFFFFFFL;
        BufferUtils.longToByteArray((long)(l & l2), (byte[])byArray, (int)(byArray.length - 8), (int)8);
        return byArray;
    }

    public byte[] getTSHeader(int n, int n2) {
        byte[] byArray = null;
        try {
            int n3 = 0;
            byArray = new byte[376];
            TransportStreamUtils.fillPAT((byte[])byArray, (int)n3, (long)this.patCCounter);
            int n4 = TransportStreamUtils.videoCodecToStreamType((int)n);
            int n5 = TransportStreamUtils.audioCodecToStreamType((int)n2);
            TransportStreamUtils.fillPMT((byte[])byArray, (int)(n3 += 188), (long)this.patCCounter, (int)this.videoPID, (int)this.audioPID, (int)n4, (int)n5);
            ++this.patCCounter;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.getProgramTable: " + exception.toString());
        }
        return byArray;
    }

    public byte[] audioPacketsToMP3(List<CupertinoPacketHolder> list) {
        byte[] byArray = null;
        try {
            int n = 0;
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                AMFPacket object = cupertinoPacketHolder.getPacket();
                n += object.getSize() - 1;
            }
            if (n > 0) {
                byArray = new byte[n];
                int n2 = 0;
                for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                    AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                    int n3 = aMFPacket.getSize();
                    byte[] byArray2 = aMFPacket.getData();
                    System.arraycopy(byArray2, 1, byArray, n2, n3 - 1);
                    n2 += n3 - 1;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.audioPacketsToMP3: " + exception.toString());
        }
        if (this.mtc < Long.MAX_VALUE) {
            long l = System.currentTimeMillis();
            if (this.ftc == -1L) {
                this.ftc = l;
            } else if (l - this.ftc > this.mtc) {
                byArray = null;
                if (this.rtc) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                    this.rtc = false;
                }
            }
        }
        return byArray;
    }

    public byte[] audioPacketsToAAC(List<CupertinoPacketHolder> list) {
        byte[] byArray = null;
        try {
            WaitingAudio waitingAudio = new WaitingAudio();
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                long l = cupertinoPacketHolder.getTimecode90();
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                byte[] byArray2 = aMFPacket.getData();
                int n3 = aMFPacket.getSize();
                int n4 = FLVUtils.getAudioCodec((int)n);
                if (n4 == 10 && n2 != 1) {
                    if (n2 != 0) continue;
                    this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])byArray2, (int)2);
                    continue;
                }
                if (n4 != 10 || this.aacFrame == null) continue;
                this.aacFrame.setSize(n3 - 2 + 7);
                byte[] byArray3 = new byte[7];
                if (this.forceAACProfile >= 0) {
                    this.aacFrame.setProfileObjectType(this.forceAACProfile);
                }
                AACUtils.frameToDTSBuffer((AACFrame)this.aacFrame, (byte[])byArray3, (int)0);
                waitingAudio.fragments.add(new RTPPacketFragment(byArray3, 0, byArray3.length));
                waitingAudio.size += byArray3.length;
                waitingAudio.fragments.add(new RTPPacketFragment(byArray2, 2, n3 - 2));
                waitingAudio.size += n3 - 2;
                waitingAudio.codec = n4;
                ++waitingAudio.count;
                if (waitingAudio.timecode == -1L) {
                    waitingAudio.timecode = l;
                }
                waitingAudio.lastTimecode = l;
            }
            int n = waitingAudio.size;
            if (n > 0) {
                byArray = new byte[n];
                int n5 = 0;
                for (RTPPacketFragment rTPPacketFragment : waitingAudio.fragments) {
                    System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n5, rTPPacketFragment.getLen());
                    n5 += rTPPacketFragment.getLen();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.audioPacketsToAAC: " + exception.toString());
        }
        if (this.mtc < Long.MAX_VALUE) {
            long l = System.currentTimeMillis();
            if (this.ftc == -1L) {
                this.ftc = l;
            } else if (l - this.ftc > this.mtc) {
                byArray = null;
                if (this.rtc) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                    this.rtc = false;
                }
            }
        }
        return byArray;
    }

    public byte[] audioPacketsToTS(List<CupertinoPacketHolder> list) {
        byte[] byArray = null;
        try {
            int n;
            int n2;
            int n3;
            WaitingAudio waitingAudio = new WaitingAudio();
            boolean bl = true;
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                long l = cupertinoPacketHolder.getTimecode90();
                int n4 = aMFPacket.getFirstByte();
                n3 = aMFPacket.getSecondByte();
                byte[] byArray2 = aMFPacket.getData();
                n2 = aMFPacket.getSize();
                n = FLVUtils.getAudioCodec((int)n4);
                if (n == 10 && n3 != 1) {
                    if (n3 != 0) continue;
                    this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])byArray2, (int)2);
                    continue;
                }
                if (n == 10 && this.aacFrame == null) continue;
                if (n == 10) {
                    this.aacFrame.setSize(n2 - 2 + 7);
                    byte[] byArray3 = new byte[7];
                    if (this.forceAACProfile >= 0) {
                        this.aacFrame.setProfileObjectType(this.forceAACProfile);
                    }
                    AACUtils.frameToDTSBuffer((AACFrame)this.aacFrame, (byte[])byArray3, (int)0);
                    waitingAudio.fragments.add(new RTPPacketFragment(byArray3, 0, byArray3.length));
                    waitingAudio.size += byArray3.length;
                    waitingAudio.fragments.add(new RTPPacketFragment(byArray2, 2, n2 - 2));
                    waitingAudio.size += n2 - 2;
                    waitingAudio.codec = n;
                    ++waitingAudio.count;
                    if (waitingAudio.timecode == -1L) {
                        waitingAudio.timecode = l;
                    }
                    waitingAudio.lastTimecode = l;
                } else {
                    if (n != 2) continue;
                    int n5 = bl ? 1 : 2;
                    n5 = 1;
                    waitingAudio.fragments.add(new RTPPacketFragment(byArray2, n5, n2 - n5));
                    waitingAudio.size += n2 - n5;
                    waitingAudio.codec = n;
                    ++waitingAudio.count;
                    if (waitingAudio.timecode == -1L) {
                        waitingAudio.timecode = l;
                    }
                    waitingAudio.lastTimecode = l;
                }
                bl = false;
            }
            int n6 = waitingAudio.size;
            if (n6 > 0) {
                long l;
                long l2 = l = waitingAudio.timecode;
                n3 = 0;
                boolean bl2 = false;
                n2 = 0;
                n = this.getNumberOfAudioTSPackets(n6);
                byArray = new byte[n * 188];
                int n7 = 0;
                RTPPacketFragment rTPPacketFragment = waitingAudio.fragments.remove(0);
                int n8 = 0;
                int n9 = rTPPacketFragment.getOffset();
                int n10 = rTPPacketFragment.getLen();
                byte[] byArray4 = rTPPacketFragment.getBuffer();
                boolean bl3 = true;
                int n11 = 0;
                do {
                    long l3;
                    int n12;
                    int n13;
                    int n14;
                    int n15 = 0;
                    byArray[n11 + n15] = 71;
                    byArray[n11 + ++n15] = (byte)((bl3 ? 64 : 0) + (0x1F & this.audioPID >> 8));
                    byArray[n11 + ++n15] = (byte)(this.audioPID & 0xFF);
                    this.audioCCounter = this.audioCCounter == -1L ? 1L : ++this.audioCCounter;
                    byArray[n11 + ++n15] = (byte)(16L + (this.audioCCounter & 0xFL));
                    ++n15;
                    int n16 = 0;
                    if (bl3) {
                        n16 = 9 + (n3 != 0 ? 10 : 5);
                    }
                    if ((n14 = 188 - n15 - n16) > n6 - n7) {
                        n14 = n6 - n7;
                    }
                    if (bl2) {
                        int n17 = n11 + 3;
                        byArray[n17] = (byte)(byArray[n17] | 0x20);
                        n13 = 8;
                        n14 = 188 - n15 - n16 - n13;
                        if (n14 > n6 - n7) {
                            n14 = n6 - n7;
                        }
                        if ((n12 = 188 - (n15 + n14 + n16 + n13)) < 0) {
                            n12 = 0;
                        }
                        byArray[n11 + n15] = (byte)(n13 - 1 + n12 & 0xFF);
                        byArray[n11 + ++n15] = (byte)(n2 != 0 ? 144 : 16);
                        l3 = l;
                        System.out.println("audioPCR: " + l3);
                        byte[] byArray5 = BufferUtils.longToByteArray((long)(l3 <<= 7));
                        byArray[n11 + ++n15 + 4] = (byte)((byArray5[7] & 0x80) + 126);
                        byArray[n11 + n15 + 3] = (byte)(byArray5[6] & 0xFF);
                        byArray[n11 + n15 + 2] = (byte)(byArray5[5] & 0xFF);
                        byArray[n11 + n15 + 1] = (byte)(byArray5[4] & 0xFF);
                        byArray[n11 + n15 + 0] = (byte)(byArray5[3] & 0xFF);
                        n15 += 6;
                        if (n12 > 0) {
                            System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n11 + n15, n12);
                            n15 += n12;
                        }
                        if ((n14 = 188 - n15 - n16) > n6 - n7) {
                            n14 = n6 - n7;
                        }
                    } else if (n15 + n14 + n16 < 188) {
                        n13 = 188 - (n15 + n14 + n16);
                        int n18 = n11 + 3;
                        byArray[n18] = (byte)(byArray[n18] | 0x20);
                        if (n13 > 1) {
                            byArray[n11 + n15] = (byte)(--n13 & 0xFF);
                            byArray[n11 + ++n15] = 0;
                            ++n15;
                            if (--n13 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n11 + n15, n13);
                            }
                            n15 += n13;
                        } else {
                            byArray[n11 + n15] = 0;
                            ++n15;
                        }
                    }
                    if (bl3) {
                        byArray[n11 + n15] = 0;
                        byArray[n11 + ++n15] = 0;
                        byArray[n11 + ++n15] = 1;
                        byArray[n11 + ++n15] = this.audioStreamID;
                        n13 = n3 != 0 ? 10 : 5;
                        n12 = n6 + n13 + 3;
                        BufferUtils.intToByteArray((int)n12, (byte[])byArray, (int)(n11 + ++n15), (int)2);
                        byArray[n11 + (n15 += 2)] = -128;
                        byArray[n11 + ++n15] = (byte)(n3 != 0 ? 192 : 128);
                        byArray[n11 + ++n15] = (byte)n13;
                        l3 = l2;
                        byArray[n11 + ++n15 + 4] = (byte)(((l3 & 0x7FL) << 1) + 1L);
                        byArray[n11 + n15 + 3] = (byte)((l3 >>= 7) & 0xFFL);
                        byArray[n11 + n15 + 2] = (byte)((((l3 >>= 8) & 0x7FL) << 1) + 1L);
                        byArray[n11 + n15 + 1] = (byte)((l3 >>= 7) & 0xFFL);
                        byArray[n11 + n15 + 0] = (byte)((((l3 >>= 8) & 7L) << 1) + 1L + (long)(n3 != 0 ? 48 : 32));
                        n15 += 5;
                        if (n3 != 0) {
                            l3 = l;
                            byArray[n11 + n15 + 4] = (byte)(((l3 & 0x7FL) << 1) + 1L);
                            byArray[n11 + n15 + 3] = (byte)((l3 >>= 7) & 0xFFL);
                            byArray[n11 + n15 + 2] = (byte)((((l3 >>= 8) & 0x7FL) << 1) + 1L);
                            byArray[n11 + n15 + 1] = (byte)((l3 >>= 7) & 0xFFL);
                            byArray[n11 + n15 + 0] = (byte)((((l3 >>= 8) & 7L) << 1) + 1L + (long)(n3 != 0 ? 16 : 32));
                            n15 += 5;
                        }
                    }
                    do {
                        if ((n13 = n14) > n10 - n8) {
                            n13 = n10 - n8;
                        }
                        System.arraycopy(byArray4, n9 + n8, byArray, n11 + n15, n13);
                        n15 += n13;
                        n7 += n13;
                        n14 -= n13;
                        if ((n8 += n13) < n10) continue;
                        n8 = 0;
                        if (waitingAudio.fragments.size() <= 0) continue;
                        rTPPacketFragment = waitingAudio.fragments.remove(0);
                        n9 = rTPPacketFragment.getOffset();
                        n10 = rTPPacketFragment.getLen();
                        byArray4 = rTPPacketFragment.getBuffer();
                    } while (n15 < 188 && n7 < n6);
                    bl3 = false;
                    n2 = 0;
                    n11 += 188;
                } while (n7 < n6);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.audioPacketsToTS: " + exception.toString());
        }
        if (this.mtc < Long.MAX_VALUE) {
            long l = System.currentTimeMillis();
            if (this.ftc == -1L) {
                this.ftc = l;
            } else if (l - this.ftc > this.mtc) {
                byArray = null;
                if (this.rtc) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                    this.rtc = false;
                }
            }
        }
        return byArray;
    }

    public byte[] videoPacketToTS(CupertinoPacketHolder cupertinoPacketHolder) {
        byte[] byArray = null;
        try {
            AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
            long l = cupertinoPacketHolder.getTimecode90();
            if (aMFPacket.getSize() >= 2) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec((int)n);
                byte[] byArray2 = aMFPacket.getData();
                int n4 = aMFPacket.getSize();
                if ((n3 != 7 || n2 == 1) && n3 == 7) {
                    int n5;
                    Object object;
                    int n6;
                    int n7;
                    int n8 = BufferUtils.byteArrayToInt((byte[])byArray2, (int)2, (int)3) * 90;
                    long l2 = l;
                    long l3 = l2 + (long)n8;
                    boolean bl = true;
                    ArrayList<RTPPacketFragment> arrayList = new ArrayList<RTPPacketFragment>();
                    byte[] byArray3 = new byte[4];
                    byArray3[3] = 1;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 5;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    while (n11 + 4 <= n4 && (n7 = BufferUtils.byteArrayToInt((byte[])byArray2, (int)n11, (int)4)) > 0 && (n11 += 4) + n7 <= n4) {
                        n6 = byArray2[n11] & 0x1F;
                        if (n6 == 7) {
                            bl2 = true;
                        } else if (n6 == 8) {
                            bl3 = true;
                        } else if (n6 == 9) {
                            bl4 = true;
                        }
                        arrayList.add(new RTPPacketFragment(byArray3, 0, byArray3.length));
                        byte[] byArray4 = byArray2;
                        int n12 = n11;
                        int n13 = n7;
                        if (n6 == 7 && this.forceH264BaselineProfile) {
                            object = this.rewriteH264Profile(byArray4, n12, n13);
                            byArray4 = object.buffer;
                            n12 = object.offset;
                            n13 = object.len;
                        }
                        arrayList.add(new RTPPacketFragment(byArray4, n12, n13));
                        n9 += n7 + byArray3.length;
                        ++n10;
                        if ((n11 += n7) < n4) continue;
                        break;
                    }
                    n7 = 0;
                    n6 = FLVUtils.getFrameType((int)n);
                    int n14 = 0;
                    if (!bl4) {
                        if (!bl4) {
                            byte[] byArray5 = new byte[6];
                            byArray5[3] = 1;
                            byArray5[4] = 9;
                            byArray5[5] = n6 == 1 ? 16 : (n6 == 3 ? 80 : 48);
                            arrayList.add(n14, new RTPPacketFragment(byArray5, 0, byArray5.length));
                            ++n14;
                            n9 += byArray5.length;
                            ++n10;
                            n7 = 1;
                        }
                    } else {
                        n14 = 2;
                    }
                    if (!(n6 != 1 || bl3 && bl2)) {
                        if (n6 == 1 && !bl2 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.sps != null) {
                            byte[] byArray6 = new byte[4];
                            byArray6[3] = 1;
                            arrayList.add(n14, new RTPPacketFragment(byArray6, 0, byArray6.length));
                            ++n14;
                            byte[] byArray7 = this.h264CodecConfigPart.sps;
                            int n15 = 0;
                            n5 = this.h264CodecConfigPart.sps.length;
                            if (this.forceH264BaselineProfile) {
                                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = this.rewriteH264Profile(byArray7, n15, n5);
                                byArray7 = liveStreamingCupertinoBlock.buffer;
                                n15 = liveStreamingCupertinoBlock.offset;
                                n5 = liveStreamingCupertinoBlock.len;
                            }
                            arrayList.add(n14, new RTPPacketFragment(byArray7, n15, n5));
                            ++n14;
                            n9 += this.h264CodecConfigPart.sps.length + byArray6.length;
                            ++n10;
                            n7 = 1;
                        }
                        if (n6 == 1 && !bl3 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.ppss != null) {
                            for (byte[] byArray8 : this.h264CodecConfigPart.ppss) {
                                object = new byte[4];
                                object[3] = (RTPPacketFragment)true;
                                arrayList.add(n14, new RTPPacketFragment((byte[])object, 0, ((RTPPacketFragment)object).length));
                                arrayList.add(++n14, new RTPPacketFragment(byArray8, 0, byArray8.length));
                                ++n14;
                                n9 += byArray8.length + ((RTPPacketFragment)object).length;
                                ++n10;
                                n7 = 1;
                            }
                        }
                    }
                    if (n10 > 0) {
                        int n16 = this.getNumberOfVideoTSPackets(n9);
                        byArray = new byte[n16 * 188];
                        int n17 = 0;
                        object = (RTPPacketFragment)arrayList.remove(0);
                        n5 = 0;
                        int n18 = object.getOffset();
                        int n19 = object.getLen();
                        byte[] byArray9 = object.getBuffer();
                        long l4 = l2;
                        int n20 = 32725;
                        int n21 = 0;
                        boolean bl5 = false;
                        do {
                            boolean bl6 = true;
                            boolean bl7 = true;
                            int n22 = 0;
                            int n23 = n9 - n17;
                            if (n23 > n20) {
                                n23 = n20;
                            }
                            do {
                                long l5;
                                int n24;
                                int n25;
                                int n26;
                                int n27 = 0;
                                byArray[n21 + n27] = 71;
                                byArray[n21 + ++n27] = (byte)((bl6 ? 64 : 0) + (0x1F & this.videoPID >> 8));
                                byArray[n21 + ++n27] = (byte)(this.videoPID & 0xFF);
                                this.videoCCounter = this.videoCCounter == -1L ? 1L : ++this.videoCCounter;
                                byArray[n21 + ++n27] = (byte)(16L + (this.videoCCounter & 0xFL));
                                ++n27;
                                int n28 = 0;
                                if (bl6) {
                                    n28 = 9 + (bl ? 10 : 5);
                                }
                                if ((n26 = 188 - n27 - n28) > n23 - n22) {
                                    n26 = n23 - n22;
                                }
                                if (bl7) {
                                    int n29 = n21 + 3;
                                    byArray[n29] = (byte)(byArray[n29] | 0x20);
                                    n25 = 8;
                                    n26 = 188 - n27 - n28 - n25;
                                    if (n26 > n23 - n22) {
                                        n26 = n23 - n22;
                                    }
                                    n24 = 0;
                                    if (n27 + n26 + n28 + n25 < 188) {
                                        n24 = 188 - (n27 + n26 + n28 + n25);
                                    }
                                    byArray[n21 + n27] = (byte)(n25 - 1 + n24 & 0xFF);
                                    byArray[n21 + ++n27] = (byte)(bl5 ? 144 : 16);
                                    l5 = l4;
                                    byte[] byArray10 = BufferUtils.longToByteArray((long)(l5 <<= 7));
                                    byArray[n21 + ++n27 + 4] = (byte)((byArray10[7] & 0x80) + 126);
                                    byArray[n21 + n27 + 3] = (byte)(byArray10[6] & 0xFF);
                                    byArray[n21 + n27 + 2] = (byte)(byArray10[5] & 0xFF);
                                    byArray[n21 + n27 + 1] = (byte)(byArray10[4] & 0xFF);
                                    byArray[n21 + n27 + 0] = (byte)(byArray10[3] & 0xFF);
                                    n27 += 6;
                                    if (n24 > 0) {
                                        System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n21 + n27, n24);
                                        n27 += n24;
                                    }
                                    if ((n26 = 188 - n27 - n28) > n23 - n22) {
                                        n26 = n23 - n22;
                                    }
                                    bl7 = false;
                                } else if (n27 + n26 + n28 < 188) {
                                    n25 = 188 - (n27 + n26 + n28);
                                    int n30 = n21 + 3;
                                    byArray[n30] = (byte)(byArray[n30] | 0x20);
                                    if (n25 > 1) {
                                        byArray[n21 + n27] = (byte)(--n25 & 0xFF);
                                        byArray[n21 + ++n27] = 0;
                                        ++n27;
                                        if (--n25 > 0) {
                                            System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n21 + n27, n25);
                                        }
                                        n27 += n25;
                                    } else {
                                        byArray[n21 + n27] = 0;
                                        ++n27;
                                    }
                                }
                                if (bl6) {
                                    byArray[n21 + n27] = 0;
                                    byArray[n21 + ++n27] = 0;
                                    byArray[n21 + ++n27] = 1;
                                    byArray[n21 + ++n27] = this.videoStreamID;
                                    ++n27;
                                    n25 = bl ? 10 : 5;
                                    n24 = n23 + n25 + 3;
                                    if (n24 >= 65536) {
                                        System.out.println("toolong: " + n24);
                                    }
                                    BufferUtils.intToByteArray((int)n24, (byte[])byArray, (int)(n21 + n27), (int)2);
                                    byArray[n21 + (n27 += 2)] = -124;
                                    byArray[n21 + ++n27] = (byte)(bl ? 192 : 128);
                                    byArray[n21 + ++n27] = (byte)n25;
                                    l5 = l3;
                                    byArray[n21 + ++n27 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                                    byArray[n21 + n27 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                                    byArray[n21 + n27 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                                    byArray[n21 + n27 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                                    byArray[n21 + n27 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl ? 48 : 32));
                                    n27 += 5;
                                    if (bl) {
                                        l5 = l2;
                                        byArray[n21 + n27 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                                        byArray[n21 + n27 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                                        byArray[n21 + n27 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                                        byArray[n21 + n27 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                                        byArray[n21 + n27 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl ? 16 : 32));
                                        n27 += 5;
                                    }
                                }
                                do {
                                    if ((n25 = n26) > n19 - n5) {
                                        n25 = n19 - n5;
                                    }
                                    System.arraycopy(byArray9, n18 + n5, byArray, n21 + n27, n25);
                                    n27 += n25;
                                    n17 += n25;
                                    n26 -= n25;
                                    n22 += n25;
                                    if ((n5 += n25) < n19) continue;
                                    n5 = 0;
                                    if (arrayList.size() <= 0) continue;
                                    object = (RTPPacketFragment)arrayList.remove(0);
                                    n18 = object.getOffset();
                                    n19 = object.getLen();
                                    byArray9 = object.getBuffer();
                                } while (n27 < 188 && n22 < n23 && n17 < n9);
                                bl6 = false;
                                bl5 = false;
                                n21 += 188;
                            } while (n22 < n23 && n17 < n9);
                        } while (n17 < n9);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.videoPacketToTS: " + exception.toString());
        }
        if (this.mtc < Long.MAX_VALUE) {
            long l = System.currentTimeMillis();
            if (this.ftc == -1L) {
                this.ftc = l;
            } else if (l - this.ftc > this.mtc) {
                byArray = null;
                if (this.rtc) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                    this.rtc = false;
                }
            }
        }
        return byArray;
    }

    public void audioCodecConfigIngest(AMFPacket aMFPacket) {
        try {
            if (aMFPacket.getSize() >= 2) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec((int)n);
                byte[] byArray = aMFPacket.getData();
                int n4 = aMFPacket.getSize();
                if (n3 == 10 && n2 != 1 && n2 == 0) {
                    this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)2);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.audioCodecConfigIngest: " + exception.toString());
        }
    }

    public void videoCodecConfigIngest(AMFPacket aMFPacket) {
        try {
            if (aMFPacket.getSize() >= 2) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec((int)n);
                byte[] byArray = aMFPacket.getData();
                int n4 = aMFPacket.getSize();
                if (n3 == 7 && n2 != 1 && n2 == 0) {
                    this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n4 - 5));
                    H264CodecConfigInfo h264CodecConfigInfo = H264Utils.decodeAVCC((byte[])byArray, (int)5);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error("CupertinoTSPacketizer.videoCodecConfigIngest: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isForceH264BaselineProfile() {
        return this.forceH264BaselineProfile;
    }

    public void setForceH264BaselineProfile(boolean bl) {
        this.forceH264BaselineProfile = bl;
    }

    public int getForceAACProfile() {
        return this.forceAACProfile;
    }

    public void setForceAACProfile(int n) {
        this.forceAACProfile = n;
    }

    class WaitingAudio {
        long timecode = -1L;
        long lastTimecode = -1L;
        int count = 0;
        int size = 0;
        int codec = 0;
        List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();

        WaitingAudio() {
        }

        public void clear() {
            this.timecode = -1L;
            this.lastTimecode = -1L;
            this.count = 0;
            this.size = 0;
            this.fragments.clear();
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size();
        }
    }
}

