/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264;

import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.FileUtils;
import com.wowza.util.MediaUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaWriter;
import com.wowza.wms.stream.MediaWriterItem;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWriterH264
implements IMediaWriter {
    private IMediaStream parent = null;
    private MediaWriterItem mediaWriterItem = null;
    private Map extraMetadata = new HashMap();
    private boolean versionFile = false;
    private boolean isFirstAudio = true;
    private boolean isFirstVideo = true;
    private boolean isFirstWriteAudio = true;
    private boolean isFirstWriteVideo = true;
    private int audioType = -1;
    private int videoType = -1;
    private int videoPacketDataOffset = 1;
    private int audioPacketDataOffset = 1;
    private QTWriterContext qtContext = new QTWriterContext();
    private QTWriterContextTrack audioTrack = null;
    private QTWriterContextTrack videoTrack = null;
    private long[] currentTCs = new long[3];
    private boolean sendUnsupportedAudioCodecWarning = true;
    private boolean sendUnsupportedVideoCodecWarning = true;
    private boolean waitForVideoKeyFrame = false;
    private boolean audioWaitForVideoKeyFrame = false;
    private boolean hitVideoKeyFrame = false;
    private long timecodeOffset = 0L;
    private boolean hitFirstRealFrame = false;
    private double duration = 0.0;
    private long maxTimecodeWritten = 0L;

    public void setMediaWriterItem(MediaWriterItem mediaWriterItem) {
        this.mediaWriterItem = mediaWriterItem;
    }

    public void setParent(IMediaStream iMediaStream) {
        this.parent = iMediaStream;
    }

    public void writePackets(List list, List list2, List list3, List list4, List list5, List list6, List list7, boolean bl, boolean bl2) {
        this.writePacketsInternal(list, list2, list3, list4, list5, list6, list7, bl, bl2);
        list.clear();
        list2.clear();
        list3.clear();
        list4.clear();
        list5.clear();
        list6.clear();
        if (list7 != null) {
            list7.clear();
        }
    }

    public void writePacketsInternal(List<ByteBuffer> list, List<ByteBuffer> list2, List<ByteBuffer> list3, List<Long> list4, List<Long> list5, List<Long> list6, List list7, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        WowzaRandomAccessFile wowzaRandomAccessFile;
        WMSLoggerFactory.getLogger(MediaWriterH264.class).debug("MediaWriterH264: writePackets: isFirst:" + bl + " isLast:" + bl2 + " audio:" + list.size() + " video:" + list2.size() + " data:" + list3.size());
        File file = this.parent.getStreamFileForWrite();
        File file2 = new File(file.getAbsolutePath() + ".tmp");
        boolean bl3 = false;
        if (bl) {
            WMSLoggerFactory.getLogger(MediaWriterH264.class).debug("MediaWriterH264: newFile:" + file.getAbsolutePath() + " tmpFile:" + file2.getAbsolutePath());
            boolean bl4 = this.versionFile;
            bl3 = this.parent.isAppend();
            this.qtContext.setOutPath(file.getAbsolutePath());
            if (file2.exists()) {
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (file.exists()) {
                if (bl3) {
                    wowzaRandomAccessFile = null;
                    object3 = null;
                    try {
                        wowzaRandomAccessFile = new WowzaRandomAccessFile(file, "rw");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (wowzaRandomAccessFile != null) {
                        try {
                            object3 = new WowzaRandomAccessFile(file2, "rw");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object3 != null && !QTWriterUtils.loadForAppend((RandomAccessFile)wowzaRandomAccessFile, (RandomAccessFile)object3, this.qtContext)) {
                            bl3 = false;
                            bl4 = true;
                        }
                    }
                    if (object3 != null) {
                        try {
                            ((RandomAccessFile)object3).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object3 = null;
                    if (wowzaRandomAccessFile != null) {
                        try {
                            wowzaRandomAccessFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    wowzaRandomAccessFile = null;
                }
                if (!bl3) {
                    if (bl4) {
                        FileUtils.versionFile((File)file);
                    } else {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                bl3 = false;
            }
        }
        if (this.isFirstAudio && list.size() > 0) {
            long l = list4.get(0);
            object3 = list.get(0);
            if (((Buffer)object3).limit() > 0) {
                this.audioType = ((ByteBuffer)object3).get(0) >> 4 & 0xF;
                object2 = MediaUtils.audioCodecTypeToString((int)this.audioType);
                WMSLoggerFactory.getLogger(MediaWriterH264.class).debug("MediaWriterH264: AUDIO: timecode:" + l + " format[" + Integer.toHexString(this.audioType) + "]:" + (String)object2 + " audioPacketDataOffset:" + this.audioPacketDataOffset);
                if (this.audioType == 10) {
                    this.audioPacketDataOffset = 2;
                    if (this.audioTrack == null) {
                        this.audioTrack = this.qtContext.getAudioTrack();
                    }
                    QTWriterUtils.extractAACCodecInfoFromStream(this.parent, this.audioTrack, l);
                } else if (this.audioType == 2) {
                    object = list.get(0);
                    byte[] byArray = ((ByteBuffer)object).array();
                    if (this.audioTrack == null) {
                        this.audioTrack = this.qtContext.getAudioTrack();
                    }
                    QTWriterUtils.extractMP3CodecInfoFromPacket(byArray, this.audioTrack);
                } else {
                    WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported audio format for MP4 container: " + (String)object2);
                }
                this.isFirstAudio = false;
            }
        }
        if (this.isFirstVideo && list2.size() > 0) {
            long l = list5.get(0);
            object3 = list2.get(0);
            if (((Buffer)object3).limit() > 0) {
                this.videoType = ((ByteBuffer)object3).get(0) & 0xF;
                object2 = MediaUtils.videoCodecTypeToString((int)this.videoType);
                WMSLoggerFactory.getLogger(MediaWriterH264.class).debug("MediaWriterH264: VIDEO: timecode:" + l + " format[" + Integer.toHexString(this.videoType) + "]:" + (String)object2 + " videoPacketDataOffset:" + this.videoPacketDataOffset);
                if (this.videoType == 7) {
                    this.videoPacketDataOffset = 5;
                    if (this.videoTrack == null) {
                        this.videoTrack = this.qtContext.getVideoTrack();
                    }
                    QTWriterUtils.extractH264CodecInfoFromStream(this.parent, this.videoTrack, l);
                } else {
                    WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported video format for MP4 container: " + (String)object2);
                }
                this.isFirstVideo = false;
            }
        }
        if (bl && this.waitForVideoKeyFrame) {
            this.audioWaitForVideoKeyFrame = list2.size() > 2;
        }
        WowzaRandomAccessFile wowzaRandomAccessFile2 = null;
        wowzaRandomAccessFile = null;
        try {
            wowzaRandomAccessFile2 = new WowzaRandomAccessFile(file, "rw");
            wowzaRandomAccessFile2.seek(wowzaRandomAccessFile2.length());
            wowzaRandomAccessFile = new WowzaRandomAccessFile(file2, "rw");
            wowzaRandomAccessFile.seek(wowzaRandomAccessFile.length());
            this.qtContext.setTmpOut((RandomAccessFile)wowzaRandomAccessFile);
            if (bl && !bl3) {
                QTWriterUtils.writeNewFileHeader((RandomAccessFile)wowzaRandomAccessFile2, this.qtContext);
            }
            object3 = FLVUtils.interleavePackets(list, list2, list3, list4, list5, list6, (List)list7, (long[])this.currentTCs);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                long l;
                boolean bl5;
                int n;
                object = (AMFPacket)object2.next();
                long l2 = object.getAbsTimecode() - this.timecodeOffset;
                if (l2 < 0L) {
                    l2 = 0L;
                }
                byte[] byArray = object.getData();
                int n2 = object.getSize();
                int n3 = object.getType();
                if (n2 <= 0) continue;
                int n4 = object.getFirstByte();
                if (n3 == 8) {
                    n = FLVUtils.getAudioCodec((int)n4);
                    if (n != 10 && n != 2) {
                        if (!this.sendUnsupportedAudioCodecWarning) continue;
                        String string = MediaUtils.audioCodecTypeToString((int)n);
                        WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported audio format for MP4 container: " + string);
                        this.sendUnsupportedAudioCodecWarning = false;
                        continue;
                    }
                    if (n2 >= 2) {
                        int n5 = object.getSecondByte();
                        if (n == 10 && n5 != 1) continue;
                    }
                    if (this.audioWaitForVideoKeyFrame) continue;
                    if (!this.hitFirstRealFrame) {
                        this.timecodeOffset = l2;
                        l2 = 0L;
                        this.hitFirstRealFrame = true;
                    }
                    if (this.isFirstWriteAudio) {
                        l2 = 0L;
                        this.isFirstWriteAudio = false;
                    }
                    this.audioTrack.addPacket((RandomAccessFile)wowzaRandomAccessFile2, byArray, this.audioPacketDataOffset, n2 - this.audioPacketDataOffset, false, this.audioTrack.millisToTimecode(l2));
                    if (l2 <= this.maxTimecodeWritten) continue;
                    this.maxTimecodeWritten = l2;
                    continue;
                }
                if (n3 != 9) continue;
                n = FLVUtils.getVideoCodec((int)n4);
                if (n != 7) {
                    if (!this.sendUnsupportedVideoCodecWarning) continue;
                    String string = MediaUtils.videoCodecTypeToString((int)n);
                    WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported video format for MP4 container: " + string);
                    this.sendUnsupportedVideoCodecWarning = false;
                    continue;
                }
                if (n2 >= 2) {
                    int n6 = object.getSecondByte();
                    if (n2 == 2 && (n4 & 0x50) == 80 && (n6 == 0 || n6 == 1) || n == 7 && n6 != 1) continue;
                }
                boolean bl6 = bl5 = FLVUtils.getFrameType((int)n4) == 1;
                if (this.waitForVideoKeyFrame && !this.hitVideoKeyFrame) {
                    if (!bl5) continue;
                    this.hitVideoKeyFrame = true;
                    this.audioWaitForVideoKeyFrame = false;
                }
                if (!this.hitFirstRealFrame) {
                    this.timecodeOffset = l2;
                    l2 = 0L;
                    this.hitFirstRealFrame = true;
                }
                if (this.isFirstWriteVideo) {
                    l2 = 0L;
                    this.isFirstWriteVideo = false;
                }
                long l3 = 0L;
                if (n == 7 && n2 > 5 && (l = (long)BufferUtils.byteArrayToInt((byte[])byArray, (int)2, (int)3)) != 0L) {
                    long l4 = this.videoTrack.millisToTimecode(l2 + l);
                    long l5 = this.videoTrack.millisToTimecode(l2);
                    l3 = l4 - l5;
                }
                this.videoTrack.addPacket((RandomAccessFile)wowzaRandomAccessFile2, byArray, this.videoPacketDataOffset, n2 - this.videoPacketDataOffset, bl5, this.videoTrack.millisToTimecode(l2), l3);
                if (l2 <= this.maxTimecodeWritten) continue;
                this.maxTimecodeWritten = l2;
            }
            if (bl2) {
                QTWriterUtils.flush((RandomAccessFile)wowzaRandomAccessFile2, (RandomAccessFile)wowzaRandomAccessFile, this.qtContext);
                QTWriterUtils.writeMOOVAtom((RandomAccessFile)wowzaRandomAccessFile2, this.qtContext);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaWriterH264.class).error("MediaWriterH264: Error writing to file[" + file.getPath() + "]: " + exception.toString());
            exception.printStackTrace();
        }
        if (wowzaRandomAccessFile2 != null) {
            try {
                wowzaRandomAccessFile2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wowzaRandomAccessFile2 = null;
        }
        if (wowzaRandomAccessFile != null) {
            try {
                wowzaRandomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wowzaRandomAccessFile = null;
        }
        if (bl2) {
            try {
                if (file2.exists()) {
                    file2.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.parent != null) {
                this.parent.getStreams().getAppInstance().notifyMediaWriterOnWriteComplete(this.parent, file);
            }
        }
    }

    public Map getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map map) {
        this.extraMetadata = map;
    }

    public boolean isVersionFile() {
        return this.versionFile;
    }

    public void setVersionFile(boolean bl) {
        this.versionFile = bl;
    }

    public void putMetaData(String string, AMFData aMFData) {
        this.extraMetadata.put(string, aMFData);
    }

    public boolean isWaitForVideoKeyFrame() {
        return this.waitForVideoKeyFrame;
    }

    public void setWaitForVideoKeyFrame(boolean bl) {
        this.waitForVideoKeyFrame = bl;
    }

    public long getDuration() {
        return this.maxTimecodeWritten;
    }
}

