/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexItemH264;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IMediaReaderCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunker;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameAttachedPicture;
import com.wowza.wms.media.mp3.model.idtags.IID3V2Frame;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import java.util.ArrayList;
import java.util.List;

public class MediaReaderMP3Cupertino
extends MediaReaderMP3
implements IMediaReaderCupertino {
    private int chunkDurationTolerance = 500;
    private int chunkDurationTarget = 10000;
    private int audioGroupCount = 3;
    private LiveStreamPacketizerCupertinoChunker chunker = null;
    private boolean init = true;

    private void init(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        if (this.init) {
            IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = iHTTPStreamerCupertinoIndex.getApplicationContext();
            if (iHTTPStreamerApplicationContext != null) {
                WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
                WMSProperties wMSProperties2 = iHTTPStreamerApplicationContext.getAppInstance().getHTTPStreamerProperties();
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.audioGroupCount = wMSProperties.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
            }
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFile(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        this.init(iHTTPStreamerCupertinoIndex);
        Object object = this.lock;
        synchronized (object) {
            try {
                long l;
                double d;
                iHTTPStreamerCupertinoIndex.setStreamMode(2);
                iHTTPStreamerCupertinoIndex.setAudioCodec(2);
                if (this.attachedPictures.size() > 0) {
                    ID3Frames iD3Frames;
                    ID3V2FrameAttachedPicture iD3V2FrameAttachedPicture = null;
                    if (this.attachedPictures.size() == 1 && iD3V2FrameAttachedPicture == null && (iD3Frames = this.attachedPictures.values().iterator()).hasNext()) {
                        iD3V2FrameAttachedPicture = (ID3V2FrameAttachedPicture)iD3Frames.next();
                    }
                    if (iD3V2FrameAttachedPicture == null) {
                        iD3V2FrameAttachedPicture = (ID3V2FrameAttachedPicture)this.attachedPictures.get(new Integer(16));
                    }
                    if (iD3V2FrameAttachedPicture == null) {
                        iD3V2FrameAttachedPicture = (ID3V2FrameAttachedPicture)this.attachedPictures.get(new Integer(3));
                    }
                    if (iD3V2FrameAttachedPicture == null && (iD3Frames = this.attachedPictures.values().iterator()).hasNext()) {
                        iD3V2FrameAttachedPicture = (ID3V2FrameAttachedPicture)iD3Frames.next();
                    }
                    if (iD3V2FrameAttachedPicture != null && (iD3Frames = iHTTPStreamerCupertinoIndex.getID3FramesHeader()) != null) {
                        iD3Frames.putFrame((IID3V2Frame)iD3V2FrameAttachedPicture);
                    }
                }
                if ((d = (double)this.duration / 1000.0) > 0.0 && this.streamSize > 0L) {
                    iHTTPStreamerCupertinoIndex.setAudioBitrate((int)Math.round((double)(this.streamSize * 8L) / d));
                }
                long l2 = 0L;
                int n = 0;
                do {
                    if (l2 + (l = (long)this.chunkDurationTarget) > this.duration) {
                        l = this.duration - l2;
                    }
                    if (l <= 0L) break;
                    HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                    hTTPStreamerCupertinoIndexItemH264.setIndex(++n);
                    hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l2);
                    hTTPStreamerCupertinoIndexItemH264.setStopTimecode(l2 + l);
                    hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(-1L);
                    hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(-1L);
                    iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                } while ((l2 += l) < this.duration);
                IHTTPStreamerSession iHTTPStreamerSession = iHTTPStreamerCupertinoIndex.getHttpStreamerSession();
                if (iHTTPStreamerSession != null) {
                    HTTPStreamerFileInfo hTTPStreamerFileInfo = new HTTPStreamerFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), this.length, (double)this.duration / 1000.0);
                    iHTTPStreamerSession.putFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), hTTPStreamerFileInfo);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3Cupertino.class).error("MediaReaderMP3Cupertino.indexFile:" + exception.toString());
            }
        }
    }

    private LiveStreamPacketizerCupertinoChunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new LiveStreamPacketizerCupertinoChunker();
            this.chunker.setAudioGroupCount(this.audioGroupCount);
        }
        return this.chunker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Object object2;
                LiveStreamPacketizerCupertinoChunker liveStreamPacketizerCupertinoChunker = this.getChunker();
                long l = iHTTPStreamerCupertinoIndexItem.getStartTimecode();
                long l2 = iHTTPStreamerCupertinoIndexItem.getStopTimecode();
                liveStreamPacketizerCupertinoChunk.setStartTimecode(l);
                liveStreamPacketizerCupertinoChunk.setDuration(l2 - l);
                liveStreamPacketizerCupertinoChunk.setStreamMode(2);
                long l3 = this.sample2TC(this.currentSample);
                long l4 = l3 * 90L;
                if ((l3 < l || l3 >= l + (long)(this.chunkDurationTarget / 2)) && (object2 = this.seek(l, 3)) != null) {
                    IMediaReaderStreamPosition iMediaReaderStreamPosition = object2.getStreamPos();
                    this.setStreamPosition(iMediaReaderStreamPosition);
                    l3 = this.sample2TC(this.currentSample);
                    l4 = l3 * 90L;
                }
                object2 = new ArrayList();
                while ((this.h = this.bitstream.readFrame()) != null) {
                    if (this.bitstream.framesize <= 0) {
                        if (this.bitrateErrorSent) break;
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.writePackets: Negative frame size (" + this.bitstream.framesize + "). May be due to unsupported MP3 bitrate higher than 128 kbps.");
                        this.bitrateErrorSent = true;
                        break;
                    }
                    int n = this.bitstream.framesize + 5;
                    if (n > 0) {
                        AMFPacket aMFPacket = null;
                        aMFPacket = new AMFPacket(8, 0, n);
                        aMFPacket.setAbsTimecode(l3);
                        object2.add(new CupertinoPacketHolder(aMFPacket, l4));
                        byte[] byArray = aMFPacket.getData();
                        this.h.getSyncHeader(this.syncHeader);
                        int n2 = 0;
                        byArray[n2] = this.packetHeader[0];
                        System.arraycopy(this.syncHeader, 0, byArray, ++n2, this.syncHeader.length);
                        System.arraycopy(this.bitstream.frame_bytes, 0, byArray, n2 += this.syncHeader.length, this.bitstream.framesize);
                        n2 += this.bitstream.framesize;
                    }
                    this.bitstream.closeFrame();
                    this.currentSample += (long)this.samplesPerFrame;
                    l3 = this.sample2TC(this.currentSample);
                    l4 = l3 * 90L;
                    if (l3 < l2) continue;
                    break;
                }
                liveStreamPacketizerCupertinoChunker.fillChunk(liveStreamPacketizerCupertinoChunk, (List<CupertinoPacketHolder>)object2, -1, 2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3Cupertino.class).error("MediaReaderMP3Cupertino.fillChunk: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

