/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    public static String streamModeToFileExtension(int n) {
        String string = ".ts";
        switch (n) {
            case 3: {
                string = ".aac";
                break;
            }
            case 2: {
                string = ".mp3";
            }
        }
        return string;
    }

    public static int chunkFilenameToIndex(String string) {
        int n;
        block2: {
            int n2;
            n = -1;
            int n3 = string.lastIndexOf("_");
            if (n3 < 0 || (n2 = string.lastIndexOf(".")) < 0 || n3 >= n2) break block2;
            String string2 = string.substring(n3 + 1, n2);
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        if (cupertinoEncInfo != null) {
            if (initProvider) {
                try {
                    SystemUtils.addBouncyCastleSecurityProvider();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.flushPackets: addBouncyCastleSecurityProvider: " + exception.toString());
                }
                initProvider = false;
            }
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), "AES");
                long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
                byte[] byArray = new byte[16];
                BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                List<LiveStreamingCupertinoBlock> list = liveStreamPacketizerCupertinoChunk.getBlockList();
                ArrayList<LiveStreamingCupertinoBlock> arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
                int n = list.size();
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(i);
                    n3 += liveStreamingCupertinoBlock.getLen();
                    byte[] byArray2 = null;
                    byArray2 = i == n - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
                    if (byArray2 == null) continue;
                    n2 += byArray2.length;
                    LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray2, 0, byArray2.length);
                    arrayList.add(liveStreamingCupertinoBlock2);
                }
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertinoUtils.encryptChunk: AES-128 encryption: " + exception.toString());
            }
        }
    }

    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + ".key");
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get("url");
            if (string3 != null || (string3 = (String)object.get("uri")) != null || (string3 = (String)object.get("cupertinostreaming-aes128-url")) != null || (string3 = (String)object.get("cupertinostreaming-aes128-uri")) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get("key")) != null || (string2 = (String)object.get("cupertinostreaming-aes128-key")) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.init: Key length incorrect. Must be 16 bytes (32 characters) long [" + file + "]: " + string2.length());
                }
            }
        }
        object = null;
        if (string3 != null && string2 != null) {
            object = new CupertinoEncInfo(string2, byArray, string3);
        }
        return object;
    }
}

