/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.HTTPCrossdomainHandler;
import com.wowza.wms.http.HTTPRequestAdapter;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.smoothstreaming.file.IHTTPStreamerSmoothStreamerIndex;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerApplicationContextSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamerFragmentId;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamingURL;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylist;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylistEntry;
import com.wowza.wms.httpstreamer.smoothstreaming.util.LiveStreamPacketizerSmoothStreamerUtils;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterSmoothStreamer
extends HTTPStreamerAdapterBase {
    public static boolean doDebug = false;
    public static final int CLIENTACCESSPOLICY_READ_FREQUENCY = 5000;
    protected String clientAccessPolicyPath = "${com.wowza.wms.context.VHostConfigHome}/conf/clientaccesspolicy.xml";
    protected boolean clientAccessPolicyResolved = false;
    protected long lastClientAccessPolicyRead = -1L;
    protected String clientAccessPolicyStr = null;
    protected boolean debugLog = false;
    protected int requestTimeout = 12000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    private Map<String, DebugSession> debugRequests = null;
    private DebugThread debugThread = null;

    public HTTPStreamerAdapterSmoothStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        if (this.debugRequests != null) {
            this.debugThread.start();
        }
    }

    public void init() {
        super.init();
        this.clientAccessPolicyPath = this.properties.getPropertyStr("clientAccessPolicyPath", this.clientAccessPolicyPath);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.debugLog = WMSLoggerFactory.getLogger(null).isDebugEnabled();
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (doDebug) {
            WMSLoggerFactory.getLogger(null).info("HTTPStreamerAdapterSmoothStreamer.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebugRequests() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dumpDebugRequests:\n");
        Map<String, DebugSession> map = this.debugRequests;
        synchronized (map) {
            for (String string : this.debugRequests.keySet()) {
                DebugSession debugSession = this.debugRequests.get(string);
                if (debugSession == null) continue;
                for (String string2 : debugSession.debugRequests.keySet()) {
                    DebugRequest debugRequest = debugSession.debugRequests.get(string2);
                    stringBuffer.append("  " + string + ":" + string2 + ":" + debugRequest.type + "\n");
                }
            }
        }
        if (stringBuffer.length() > 0) {
            System.out.println(stringBuffer.toString());
        }
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterSmoothStreamer.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            int n = string.indexOf("?");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string2 != null && string2.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            if (string.endsWith("Manifest")) {
                this.onManifest(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ismv")) {
                this.onISMVData(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith("clientaccesspolicy.xml")) {
                this.onClientAccessPolicy(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public File getClientAccessPolicyFile() {
        if (!this.clientAccessPolicyResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.clientAccessPolicyPath = SystemUtils.expandEnvironmentVariables((String)this.clientAccessPolicyPath, hashMap);
            this.clientAccessPolicyResolved = true;
        }
        return new File(this.clientAccessPolicyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientAccessPolicy(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        block23: {
            try {
                Object object;
                Closeable closeable;
                File file;
                if ((this.clientAccessPolicyStr == null || l - this.lastClientAccessPolicyRead > 5000L) && (file = this.getClientAccessPolicyFile()).exists()) {
                    closeable = null;
                    try {
                        object = new StringBuffer();
                        closeable = new BufferedReader(new FileReader(file));
                        String string = null;
                        while ((string = ((BufferedReader)closeable).readLine()) != null) {
                            ((StringBuffer)object).append(string + "\n");
                        }
                        this.clientAccessPolicyStr = ((StringBuffer)object).toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                ((BufferedReader)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.lastClientAccessPolicyRead = l;
                }
                boolean bl = true;
                if (this.clientAccessPolicyStr == null) {
                    bl = false;
                } else if (this.clientAccessPolicyStr.length() == 0) {
                    bl = false;
                }
                try {
                    if (bl) {
                        iHTTPResponse.setHeader("Content-Type", "text/xml");
                        closeable = iHTTPResponse.getOutputStream();
                        object = this.clientAccessPolicyStr.getBytes();
                        ((OutputStream)closeable).write((byte[])object);
                        break block23;
                    }
                    iHTTPResponse.setResponseCode(404);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPCrossdomainHandler.class).error("HTTPCrossdomainHandler.onClientAccessPolicy: " + exception.toString());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPRequestAdapter.class).error("HTTPStreamerAdapterSmoothStreaming.onClientAccessPolicy: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionSmoothStreamer hTTPStreamerSessionSmoothStreamer = new HTTPStreamerSessionSmoothStreamer();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionSmoothStreamer.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = 80;
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionSmoothStreamer.setServerIp(string4);
        hTTPStreamerSessionSmoothStreamer.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionSmoothStreamer.setUri(string5);
        hTTPStreamerSessionSmoothStreamer.setQueryStr(string6);
        hTTPStreamerSessionSmoothStreamer.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionSmoothStreamer.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionSmoothStreamer.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionSmoothStreamer, iApplicationInstance, string);
        return hTTPStreamerSessionSmoothStreamer;
    }

    public void onManifest(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block57: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                String string;
                Object object;
                Object object2;
                Object object3;
                int n;
                Object object4;
                boolean bl3;
                int n2;
                MediaStreamMap mediaStreamMap;
                String string2;
                SmoothStreamingURL smoothStreamingURL;
                String string3 = iHTTPRequest.getHeader("context");
                if (string3 == null) break block57;
                string3 = HTTPStreamerUtils.urlDecode((String)string3);
                if (doDebug) {
                    System.out.println("onManifest: " + string3);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string3, true)) == null) break block57;
                String string4 = smoothStreamingURL.getAppName();
                String string5 = smoothStreamingURL.getAppInstanceName();
                String string6 = smoothStreamingURL.getStreamName();
                String string7 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string7);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string4, string5, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Application context not loaded [" + string3 + "]: " + string4 + "/" + string5);
                    break block57;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string8 = this.getStreamDomainStr(iApplicationInstance, string6);
                boolean bl4 = this.isLive(iApplicationInstance);
                boolean bl5 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl5, string6);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block57;
                ILiveStreamPacketizer iLiveStreamPacketizer = null;
                SmoothStreamingLivePlaylist smoothStreamingLivePlaylist = null;
                boolean bl6 = false;
                String string9 = string2 = bl5 ? this.liveStreamRepeater : this.liveStreamPacketizer;
                if (bl4) {
                    mediaStreamMap = iApplicationInstance.getStreams();
                    bl6 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    int n3 = n2 = hTTPStreamerApplicationContextSmoothStreamer != null ? hTTPStreamerApplicationContextSmoothStreamer.getMinPlaylistStartDuration() : 10000;
                    if (bl6) {
                        smoothStreamingLivePlaylist = LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: Playlist cound not be parsed: " + string3);
                            break block57;
                        }
                        bl3 = false;
                        object4 = smoothStreamingLivePlaylist.getBitrates();
                        Iterator<String> iterator = object4.iterator();
                        n = 0;
                        while (iterator.hasNext()) {
                            long l2;
                            ++n;
                            object3 = iterator.next();
                            object2 = smoothStreamingLivePlaylist.get((String)object3);
                            object = this.resolveStreamName(null, iApplicationInstance, bl5, ((SmoothStreamingLivePlaylistEntry)object2).getStreamName());
                            if (hTTPStreamerStreamNameParts.resolvedName == null) break;
                            string = mediaStreamMap.getLiveStreamPacketizer(object.resolvedName, string2, false);
                            if (string == null && bl5) {
                                this.startLiveStreamRepeat(iApplicationInstance, object.repeaterName);
                                string = mediaStreamMap.getLiveStreamPacketizer(object.resolvedName, this.liveStreamPacketizer, false);
                            }
                            if (string == null) {
                                if (n != 1) continue;
                                if (bl5) {
                                    bl = true;
                                } else {
                                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + object.resolvedName + "]: " + this.liveStreamPacketizer);
                                }
                                bl3 = true;
                                continue;
                            }
                            if (!(string instanceof LiveStreamPacketizerSmoothStreaming)) {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer wrong type [" + object.resolvedName + "]: " + this.liveStreamPacketizer);
                                continue;
                            }
                            if (n2 <= 0 || n != 1 || (l2 = ((LiveStreamPacketizerSmoothStreaming)((Object)string)).getPlaylistDuration()) >= (long)n2) continue;
                            bl = true;
                            bl3 = true;
                        }
                        if (bl3) {
                            break block57;
                        }
                    } else {
                        long l3;
                        iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, string2, false);
                        if (iLiveStreamPacketizer == null && bl5) {
                            this.startLiveStreamRepeat(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
                            iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        }
                        if (iLiveStreamPacketizer == null) {
                            if (bl5) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer not found [" + string3 + "]: " + this.liveStreamPacketizer);
                            }
                            break block57;
                        }
                        if (!(iLiveStreamPacketizer instanceof LiveStreamPacketizerSmoothStreaming)) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.onManifest: LiveStreamPacketizer wrong type [" + string3 + "]: " + this.liveStreamPacketizer);
                            break block57;
                        }
                        if (n2 > 0 && (l3 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getPlaylistDuration()) < (long)n2) {
                            bl = true;
                            break block57;
                        }
                    }
                }
                mediaStreamMap = null;
                n2 = 0;
                if (mediaStreamMap == null) {
                    n2 = 1;
                    mediaStreamMap = this.createSession(iHTTPRequest, iApplicationInstance, null, string8);
                }
                if (n2 != 0) {
                    mediaStreamMap.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    mediaStreamMap.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                if (mediaStreamMap == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onManifest: Should not get here [" + string3 + "]: " + string4 + "/" + string5);
                    break block57;
                }
                rtmpSessionInfo.addHTTPSession((IHTTPStreamerSession)mediaStreamMap);
                if (!mediaStreamMap.isValidated()) {
                    mediaStreamMap.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string7, "smoothstreaming", (IHTTPStreamerSession)mediaStreamMap, iHTTPRequest.getRemoteAddr());
                    mediaStreamMap.setSessionType(bl4 ? 1 : 2);
                }
                if (n2 != 0) {
                    this.notifySessionCreate((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance);
                }
                if (!mediaStreamMap.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block57;
                }
                if (!mediaStreamMap.isValidStreamDomainStr(string8)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block57;
                }
                mediaStreamMap.touch(l);
                if (bl6) {
                    ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).setLivePlaylist(smoothStreamingLivePlaylist);
                }
                if (!(bl3 = mediaStreamMap.isActive())) break block57;
                object4 = "";
                boolean bl7 = true;
                if (!bl4) {
                    IHTTPStreamerSmoothStreamerIndex iHTTPStreamerSmoothStreamerIndex = ((HTTPStreamerSessionSmoothStreamer)mediaStreamMap).getIndex((IHTTPStreamerSession)mediaStreamMap, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (iHTTPStreamerSmoothStreamerIndex == null) break block57;
                    object3 = iHTTPStreamerSmoothStreamerIndex.getStreamNames();
                    mediaStreamMap.addStreamDomainStrs((List)object3);
                    object4 = iHTTPStreamerSmoothStreamerIndex.getPlaylistStr();
                } else if (bl4) {
                    if (bl6) {
                        if (smoothStreamingLivePlaylist != null) {
                            String string10;
                            LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming;
                            ILiveStreamPacketizer iLiveStreamPacketizer2;
                            HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts2;
                            SmoothStreamingLivePlaylistEntry smoothStreamingLivePlaylistEntry;
                            String string102 = "";
                            boolean bl8 = false;
                            object2 = "";
                            object = "";
                            string = "";
                            boolean bl9 = false;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            String string11 = "";
                            String string12 = "";
                            String string13 = "";
                            String string14 = "";
                            String string15 = "";
                            int n4 = 0;
                            MediaStreamMap mediaStreamMap2 = iApplicationInstance.getStreams();
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            boolean bl12 = true;
                            boolean bl13 = ((HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext).isSmoothStreamingUseSMILBitrates();
                            String string16 = null;
                            String string17 = smoothStreamingLivePlaylist.getAudioStreamName();
                            String string18 = null;
                            List<String> list = smoothStreamingLivePlaylist.getBitrates();
                            for (String charSequence22 : list) {
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(charSequence22);
                                hTTPStreamerStreamNameParts2 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl5, smoothStreamingLivePlaylistEntry.getStreamName());
                                if (hTTPStreamerStreamNameParts2.resolvedName == null) break;
                                iLiveStreamPacketizer2 = mediaStreamMap2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts2.resolvedName, bl5 ? this.liveStreamPacketizer : string2, false);
                                if (iLiveStreamPacketizer2 == null) continue;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer2;
                                if (string18 == null) {
                                    string18 = hTTPStreamerStreamNameParts2.resolvedName;
                                }
                                if (hTTPStreamerStreamNameParts2.resolvedName.equals(string17)) {
                                    string16 = hTTPStreamerStreamNameParts2.resolvedName;
                                }
                                String string19 = string10 = bl13 ? charSequence22 : liveStreamPacketizerSmoothStreaming.getVideoBitrate() + "";
                                if (!hashMap.containsKey(string10)) {
                                    hashMap.put(charSequence22, string10);
                                    continue;
                                }
                                bl12 = false;
                            }
                            if (bl12) {
                                smoothStreamingLivePlaylist.remapBitrates(hashMap);
                            }
                            if (string16 == null) {
                                string16 = string18;
                            }
                            list = smoothStreamingLivePlaylist.getBitrates();
                            Iterator<String> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                ++n4;
                                String string20 = iterator.next();
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(string20);
                                hTTPStreamerStreamNameParts2 = this.resolveStreamName((IHTTPStreamerSession)mediaStreamMap, iApplicationInstance, bl5, smoothStreamingLivePlaylistEntry.getStreamName());
                                if (hTTPStreamerStreamNameParts2.resolvedName == null) break;
                                iLiveStreamPacketizer2 = mediaStreamMap2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts2.resolvedName, bl5 ? this.liveStreamPacketizer : string2, false);
                                if (iLiveStreamPacketizer2 == null) continue;
                                liveStreamPacketizerSmoothStreaming = (LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer2;
                                string10 = liveStreamPacketizerSmoothStreaming.getXMLQualityLevelVideo();
                                string10 = string10.replace("{videobitrate}", string20);
                                if (hTTPStreamerStreamNameParts2.resolvedName.equals(string16)) {
                                    bl8 = liveStreamPacketizerSmoothStreaming.isXMLIsVideo();
                                    bl9 = liveStreamPacketizerSmoothStreaming.isXMLIsAudio();
                                    bl10 = liveStreamPacketizerSmoothStreaming.isXMLIsData();
                                    bl11 = liveStreamPacketizerSmoothStreaming.isXMLIsProtection();
                                    String string21 = liveStreamPacketizerSmoothStreaming.getXMLQualityLevelAudio();
                                    int n5 = liveStreamPacketizerSmoothStreaming.getAudioBitrate();
                                    String string22 = n5 + "";
                                    if (bl13 && smoothStreamingLivePlaylist.getAudioBitrate() != null) {
                                        string22 = smoothStreamingLivePlaylist.getAudioBitrate();
                                    }
                                    string21 = string21.replace("{audiobitrate}", string22);
                                    string102 = liveStreamPacketizerSmoothStreaming.getXMLSmoothStreamingMedia();
                                    object2 = liveStreamPacketizerSmoothStreaming.getXMLStreamIndexVideo();
                                    object = string10;
                                    string = liveStreamPacketizerSmoothStreaming.getXMLSamplesVideo();
                                    string11 = liveStreamPacketizerSmoothStreaming.getXMLStreamIndexAudio();
                                    string12 = string21;
                                    string13 = liveStreamPacketizerSmoothStreaming.getXMLSamplesAudio();
                                    string14 = liveStreamPacketizerSmoothStreaming.getXMLData();
                                    string15 = liveStreamPacketizerSmoothStreaming.getXMLProtection();
                                    continue;
                                }
                                object = (String)object + string10;
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                            stringBuffer.append(string102);
                            if (bl8) {
                                stringBuffer.append((String)object2);
                                stringBuffer.append((String)object);
                                stringBuffer.append(string);
                                stringBuffer.append("</StreamIndex>\n");
                            }
                            if (bl9) {
                                stringBuffer.append(string11);
                                stringBuffer.append(string12);
                                stringBuffer.append(string13);
                                stringBuffer.append("</StreamIndex>\n");
                            }
                            if (bl10) {
                                stringBuffer.append(string14);
                            }
                            if (bl11) {
                                stringBuffer.append(string15);
                            }
                            stringBuffer.append("</SmoothStreamingMedia>\n");
                            object4 = stringBuffer.toString();
                        }
                        if (mediaStreamMap != null) {
                            List<String> list = smoothStreamingLivePlaylist.getStreamNames();
                            mediaStreamMap.addStreamDomainStrs(list);
                            if (bl5) {
                                mediaStreamMap.lockRepeaterStreams(list, this.liveStreamPacketizer, this.liveStreamRepeater, this.getStreamTypeStr());
                            }
                        }
                    } else {
                        if (iLiveStreamPacketizer == null) break block57;
                        object4 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getXMLISMC();
                        n = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getVideoBitrate();
                        int n6 = ((LiveStreamPacketizerSmoothStreaming)iLiveStreamPacketizer).getAudioBitrate();
                        object4 = ((String)object4).replace("{videobitrate}", n + "");
                        object4 = ((String)object4).replace("{audiobitrate}", n6 + "");
                    }
                }
                mediaStreamMap.touch(l);
                if (bl7) {
                    object4 = ((String)object4).replace("{sessionid}", mediaStreamMap.getSessionId());
                }
                if (doDebug) {
                    System.out.println((String)object4);
                }
                iHTTPResponse.setHeader("Content-Type", "text/xml");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                byte[] byArray = ((String)object4).getBytes();
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(byArray);
                bl2 = true;
                mediaStreamMap.touch(l);
                if (byArray != null && mediaStreamMap != null) {
                    mediaStreamMap.getIOPerformanceCounter().incrementMessagesOut((long)(byArray.length + iHTTPResponse.getHeaderSize()), 1L);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onManifest: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onISMVData(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block50: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                Object object3;
                SmoothStreamingLivePlaylist smoothStreamingLivePlaylist;
                Object object4;
                Object object5;
                SmoothStreamingURL smoothStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block50;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (doDebug) {
                    System.out.println("onISMVData: " + string);
                }
                if ((smoothStreamingURL = new SmoothStreamingURL(string, true)) == null) break block50;
                String string2 = smoothStreamingURL.getAppName();
                String string3 = smoothStreamingURL.getAppInstanceName();
                String string4 = smoothStreamingURL.getStreamName();
                String string5 = smoothStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreamer.onISMVData: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block50;
                }
                HTTPStreamerApplicationContextSmoothStreamer hTTPStreamerApplicationContextSmoothStreamer = iHTTPStreamerApplicationContext instanceof HTTPStreamerApplicationContextSmoothStreamer ? (HTTPStreamerApplicationContextSmoothStreamer)iHTTPStreamerApplicationContext : null;
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                boolean bl5 = false;
                String string7 = bl4 ? this.liveStreamRepeater : this.liveStreamPacketizer;
                SmoothStreamerFragmentId smoothStreamerFragmentId = SmoothStreamerFragmentId.parseURL(string);
                if (smoothStreamerFragmentId == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: Error decoding fragment name [" + string + "]");
                    break block50;
                }
                DebugSession debugSession = null;
                DebugRequest debugRequest = null;
                if (this.debugRequests != null) {
                    object5 = this.debugRequests;
                    synchronized (object5) {
                        debugSession = this.debugRequests.get(smoothStreamerFragmentId.getSessionId());
                        if (debugSession == null) {
                            debugSession = new DebugSession();
                            debugSession.sessionId = smoothStreamerFragmentId.getSessionId();
                            this.debugRequests.put(debugSession.sessionId, debugSession);
                        }
                        if ((debugRequest = debugSession.debugRequests.get(smoothStreamerFragmentId.getChunkId() + "")) == null) {
                            debugRequest = new DebugRequest();
                            debugRequest.type = smoothStreamerFragmentId.getFragmentType();
                            debugRequest.requestId = smoothStreamerFragmentId.getStartTimecode() + "";
                            debugSession.debugRequests.put(debugRequest.requestId, debugRequest);
                        }
                    }
                }
                object5 = smoothStreamerFragmentId.getSessionId();
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                boolean bl6 = false;
                if (object5 != null && (iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession((String)object5)) == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, (String)object5, string6);
                    bl6 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block50;
                if (bl6) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl7 = true;
                int n = 0;
                if (iHTTPStreamerSession == null) break block50;
                if (!iHTTPStreamerSession.isValidated()) {
                    this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "smoothstreaming", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                }
                iHTTPStreamerSession.touch(l);
                bl7 = iHTTPStreamerSession.isActive();
                n = iHTTPStreamerSession.getSessionType();
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (!bl7) break block50;
                if (bl6) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block50;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block50;
                }
                RTPPacketFragmentList rTPPacketFragmentList = null;
                if (!bl3) {
                    object4 = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getIndex(iHTTPStreamerSession, iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object4 == null) break block50;
                    rTPPacketFragmentList = object4.getFragment(smoothStreamerFragmentId.getFragmentType(), smoothStreamerFragmentId.getBitrate(), smoothStreamerFragmentId.getChunkId());
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logVODFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                } else {
                    bl5 = hTTPStreamerStreamNameParts.streamExt.equals("smil");
                    object4 = iApplicationInstance.getStreams();
                    if (bl5) {
                        SmoothStreamingLivePlaylistEntry smoothStreamingLivePlaylistEntry;
                        smoothStreamingLivePlaylist = ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).getLivePlaylist();
                        if (smoothStreamingLivePlaylist == null) break block50;
                        if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(0);
                            object3 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, smoothStreamingLivePlaylistEntry.getStreamName());
                            if (hTTPStreamerStreamNameParts.resolvedName == null) break block50;
                            object2 = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object3).resolvedName, bl4 ? this.liveStreamPacketizer : string7, false);
                            if (object2 == null) break block50;
                            object = (LiveStreamPacketizerSmoothStreaming)((Object)object2);
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)object)).getAudioPacket(smoothStreamerFragmentId.getStartTimecode());
                        } else if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(smoothStreamerFragmentId.getBitrate() + "");
                            if (smoothStreamingLivePlaylistEntry == null) {
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(0);
                            }
                            object3 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, smoothStreamingLivePlaylistEntry.getStreamName());
                            if (hTTPStreamerStreamNameParts.resolvedName == null) break block50;
                            object2 = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object3).resolvedName, bl4 ? this.liveStreamPacketizer : string7, false);
                            if (object2 == null) break block50;
                            object = (LiveStreamPacketizerSmoothStreaming)((Object)object2);
                            if (smoothStreamingLivePlaylistEntry.getIndex() > 0) {
                                int n2 = hTTPStreamerApplicationContextSmoothStreamer.getKeyFrameAlignmentTolerance();
                                rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)object)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode(), n2);
                            } else {
                                rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)object)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode());
                            }
                            if (rTPPacketFragmentList == null && smoothStreamingLivePlaylistEntry.getIndex() > 0) {
                                smoothStreamingLivePlaylistEntry = smoothStreamingLivePlaylist.get(0);
                                object3 = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, smoothStreamingLivePlaylistEntry.getStreamName());
                                if (hTTPStreamerStreamNameParts.resolvedName == null || (object2 = object4.getLiveStreamPacketizer(((HTTPStreamerStreamNameParts)object3).resolvedName, string7, false)) == null) break block50;
                                object = (LiveStreamPacketizerSmoothStreaming)((Object)object2);
                                rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)object)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode());
                            }
                        }
                    } else {
                        smoothStreamingLivePlaylist = object4.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        if (smoothStreamingLivePlaylist == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                            break block50;
                        }
                        if (!(smoothStreamingLivePlaylist instanceof LiveStreamPacketizerSmoothStreaming)) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSmoothStreaming.getAppInstance: LiveStreamPacketizer wrong type [" + string + "]: " + this.liveStreamPacketizer);
                            break block50;
                        }
                        if (smoothStreamerFragmentId.getFragmentType() == 9) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getVideoPacket(smoothStreamerFragmentId.getStartTimecode());
                        } else if (smoothStreamerFragmentId.getFragmentType() == 8) {
                            rTPPacketFragmentList = ((LiveStreamPacketizerSmoothStreaming)((Object)smoothStreamingLivePlaylist)).getAudioPacket(smoothStreamerFragmentId.getStartTimecode());
                        }
                    }
                    ((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession).logLiveFragment(smoothStreamerFragmentId, rTPPacketFragmentList);
                }
                if (rTPPacketFragmentList == null) {
                    if (doDebug) {
                        System.out.println("missing[" + string + "]");
                    }
                    bl = true;
                    break block50;
                }
                if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                }
                iHTTPResponse.setHeader("Content-Type", "video/mp4");
                iHTTPResponse.setHeader("Pragma", "no-cache");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                object4 = iHTTPResponse.getOutputStream();
                smoothStreamingLivePlaylist = null;
                if (object4 instanceof IFasterByteArrayWriteReference) {
                    smoothStreamingLivePlaylist = (IFasterByteArrayWriteReference)object4;
                }
                int n3 = 0;
                object3 = rTPPacketFragmentList.getFragments();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (RTPPacketFragment)object2.next();
                    if (smoothStreamingLivePlaylist != null) {
                        smoothStreamingLivePlaylist.write(object.getBuffer(), object.getOffset(), object.getLen(), true);
                    } else {
                        ((OutputStream)object4).write(object.getBuffer(), object.getOffset(), object.getLen());
                    }
                    n3 += object.getLen();
                }
                if (iHTTPStreamerSession != null) {
                    object = iHTTPStreamerSession.getStream();
                    if (object != null) {
                        object.getMediaIOPerformance().incrementMessagesOut((long)n3, 1L);
                    }
                    iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n3 + iHTTPResponse.getHeaderSize()), 1L);
                }
                if (doDebug) {
                    System.out.println("sent[" + string + "]: " + n3);
                }
                bl2 = true;
                if (this.debugRequests == null) break block50;
                object = this.debugRequests;
                synchronized (object) {
                    if (debugRequest != null) {
                        debugSession.debugRequests.remove(smoothStreamerFragmentId.getStartTimecode() + "");
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).error("HTTPStreamerAdapterSmoothStreaming.onISMVData: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    class DebugRequest {
        int type = 0;
        String requestId = null;

        DebugRequest() {
        }
    }

    class DebugSession {
        Map<String, DebugRequest> debugRequests = new HashMap<String, DebugRequest>();
        String sessionId = null;

        DebugSession() {
        }
    }

    class DebugThread
    extends Thread {
        DebugThread() {
        }

        public void run() {
            System.out.println("DebugThread.start");
            while (true) {
                try {
                    while (true) {
                        HTTPStreamerAdapterSmoothStreamer.this.dumpDebugRequests();
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    System.out.println("DebugThread: " + exception.toString());
                    continue;
                }
                break;
            }
        }
    }
}

