/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothStreamingFragments {
    private SortedMap<Long, SmoothStreamingFragment> fragments = new TreeMap<Long, SmoothStreamingFragment>();
    private Object lock = new Object();
    private int smoothBufferTargetDuration = 30000;
    private int smoothManifestTargetDuration = 20000;
    private int smoothBufferMinFragmentCount = 3;
    private int smoothManifestMinFragmentCount = 3;
    private int contentType = 0;

    public SmoothStreamingFragments(int n) {
        this.contentType = n;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.fragments.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long l = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.fragments.size() > 0) {
                l = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStopTimecode() - ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getStartTimecode();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothStreamingMediaInfoAudio getMediaInfoAudio() {
        SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.fragments.size() > 0) {
                smoothStreamingMediaInfoAudio = ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getMediaInfoAudio();
            }
        }
        return smoothStreamingMediaInfoAudio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmoothStreamingMediaInfoVideo getMediaInfoVideo() {
        SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.fragments.size() > 0) {
                smoothStreamingMediaInfoVideo = ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getMediaInfoVideo();
            }
        }
        return smoothStreamingMediaInfoVideo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStopTimecode() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                l = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStopTimecode();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStartTimecode() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                l = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStartTimecode();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getStartStopTimecodes() {
        long[] lArray = null;
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                lArray = new long[]{((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getStartTimecode(), ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStopTimecode()};
            }
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(long l) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.fragments.size();
            if (n > 0) {
                long l2;
                long l3 = l2 = ((SmoothStreamingFragment)this.fragments.get(this.fragments.lastKey())).getStartTimecode();
                if (l > 0L && l < l2) {
                    l2 = l2 - l > (long)(this.smoothBufferTargetDuration * 10000) ? (l2 -= (long)(this.smoothBufferTargetDuration * 10000)) : l;
                }
                while (this.fragments.size() > this.smoothBufferMinFragmentCount) {
                    Long l4 = this.fragments.firstKey();
                    SmoothStreamingFragment smoothStreamingFragment = (SmoothStreamingFragment)this.fragments.remove(l4);
                    long l5 = ((SmoothStreamingFragment)this.fragments.get(this.fragments.firstKey())).getStopTimecode();
                    if (l2 - l5 > (long)(this.smoothBufferTargetDuration * 10000)) continue;
                    this.fragments.put(l4, smoothStreamingFragment);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFragment(long l, SmoothStreamingFragment smoothStreamingFragment) {
        Object object = this.lock;
        synchronized (object) {
            this.fragments.put(new Long(l), smoothStreamingFragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.fragments.size();
        }
    }

    public RTPPacketFragmentList getFragmentBytes(long l) {
        return this.getFragmentBytes(l, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPPacketFragmentList getFragmentBytes(long l, int n) {
        RTPPacketFragmentList rTPPacketFragmentList = null;
        SmoothStreamingFragment smoothStreamingFragment = null;
        Object object = this.lock;
        synchronized (object) {
            Long l2 = new Long(l);
            smoothStreamingFragment = (SmoothStreamingFragment)this.fragments.get(l2);
            if (smoothStreamingFragment == null && n > 0) {
                SortedMap<Long, SmoothStreamingFragment> sortedMap = this.fragments.headMap(l2);
                SortedMap<Long, SmoothStreamingFragment> sortedMap2 = this.fragments.tailMap(l2);
                if (sortedMap.size() > 0 || sortedMap2.size() > 0) {
                    long l3;
                    Long l4 = null;
                    if (sortedMap.size() <= 0) {
                        l4 = sortedMap2.firstKey();
                    } else if (sortedMap2.size() <= 0) {
                        l4 = sortedMap.lastKey();
                    } else {
                        long l5;
                        Long l6 = sortedMap2.firstKey();
                        Long l7 = sortedMap.lastKey();
                        long l8 = Math.abs(l - l6);
                        l4 = l8 < (l5 = Math.abs(l - l7)) ? l6 : l7;
                    }
                    if (l4 != null && (l3 = Math.abs(l - l4) / 10000L) <= (long)n) {
                        smoothStreamingFragment = (SmoothStreamingFragment)this.fragments.get(l4);
                    }
                }
            }
        }
        if (smoothStreamingFragment != null) {
            rTPPacketFragmentList = smoothStreamingFragment.getFragmentList();
        }
        return rTPPacketFragmentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<long[]> getTimeInfo(long l, long l2) {
        Object object;
        int n;
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object2 = this.lock;
        synchronized (object2) {
            arrayList2.addAll(this.fragments.values());
        }
        if (l >= 0L) {
            for (n = arrayList2.size(); n > 0; --n) {
                object = (SmoothStreamingFragment)arrayList2.remove(0);
                if (((SmoothStreamingFragment)object).getStopTimecode() <= l) continue;
                arrayList2.add(0, object);
                ++n;
                break;
            }
        }
        if (l2 >= 0L) {
            while (n > 0) {
                object = (SmoothStreamingFragment)arrayList2.remove(n - 1);
                --n;
                if (((SmoothStreamingFragment)object).getStartTimecode() >= l2) continue;
                arrayList2.add(object);
                ++n;
                break;
            }
        }
        for (SmoothStreamingFragment smoothStreamingFragment : arrayList2) {
            long[] lArray = new long[]{smoothStreamingFragment.getStartTimecode(), smoothStreamingFragment.getStopTimecode()};
            arrayList.add(lArray);
        }
        return arrayList;
    }

    public int getSmoothBufferTargetDuration() {
        return this.smoothBufferTargetDuration;
    }

    public void setSmoothBufferTargetDuration(int n) {
        this.smoothBufferTargetDuration = n;
    }

    public int getSmoothBufferMinFragmentCount() {
        return this.smoothBufferMinFragmentCount;
    }

    public void setSmoothBufferMinFragmentCount(int n) {
        this.smoothBufferMinFragmentCount = n;
    }

    public int getSmoothManifestTargetDuration() {
        return this.smoothManifestTargetDuration;
    }

    public void setSmoothManifestTargetDuration(int n) {
        this.smoothManifestTargetDuration = n;
    }

    public int getSmoothManifestMinFragmentCount() {
        return this.smoothManifestMinFragmentCount;
    }

    public void setSmoothManifestMinFragmentCount(int n) {
        this.smoothManifestMinFragmentCount = n;
    }
}

