/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.file;

import com.wowza.util.URLUtils;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamPlay;
import com.wowza.wms.stream.file.Playlist;
import com.wowza.wms.stream.file.PlaylistNode;
import com.wowza.wms.stream.file.PlaylistPlayer;
import java.io.OutputStream;
import java.net.URL;

public class MediaStreamFilePlay
extends MediaStreamPlay {
    private Playlist playlist = null;
    private PlaylistPlayer player = null;
    private boolean isThrottled = true;

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        this.playlist = new Playlist();
        this.player = new PlaylistPlayer(this.playlist, iMediaStream);
    }

    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        if (this.player != null) {
            this.player.switchName(string, string2, string3, string4, d, d2, n);
        }
    }

    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        if (this.playlist == null) {
            return;
        }
        try {
            if (n == 1 || n == 3) {
                this.reset(true);
                this.playlist.clear();
            }
            PlaylistNode playlistNode = new PlaylistNode();
            playlistNode.setName(string);
            playlistNode.setPlayStart(d);
            playlistNode.setPlayLen(d2);
            playlistNode.setPlayReset(n);
            playlistNode.setStreamExt(string3);
            playlistNode.setQueryStr(string4);
            String string5 = this.parent.getStreams().getAppInstance().getStreamStoragePath();
            string5 = URLUtils.pathToFileURL((String)string5);
            String string6 = string5 + "/" + string + "." + playlistNode.getStreamExt();
            URL uRL = new URL(string6);
            playlistNode.setURL(uRL);
            if (this.playlist.size() == 0) {
                this.player.playStart();
            }
            this.playlist.add(playlistNode);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamFilePlay.class).error("setName: " + exception.toString());
        }
    }

    public void seek(int n) {
        if (this.player != null) {
            this.player.seek(n);
        }
    }

    public void pause(int n, long l) {
        if (this.player != null) {
            this.player.pause(n, l);
        }
    }

    public void pauseRaw(int n, long l) {
        if (this.player != null) {
            this.player.pauseRaw(n, l);
        }
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (!this.parent.isOpen()) {
            return 0;
        }
        if (this.player != null) {
            return this.player.play(this.parent, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return 0;
    }

    public boolean play() {
        if (!this.parent.isOpen()) {
            return false;
        }
        return this.player != null;
    }

    public void setBufferTime(int n) {
        super.setBufferTime(n);
        if (this.player != null) {
            this.player.setBufferTime(n);
        }
    }

    public void resetNoLookup() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (this.player != null) {
            this.player.reset(bl);
        }
    }

    public void shutdown() {
        if (this.player != null) {
            this.player.shutdown();
        }
        this.player = null;
        if (this.playlist != null) {
            this.playlist.clear();
        }
        this.playlist = null;
    }

    public void close() {
    }

    public void interruptPlay() {
        if (this.player != null) {
            this.player.interruptPlay();
        }
    }

    public void startPlay() {
        if (this.player != null) {
            this.player.startPlay();
        }
    }

    public boolean isThrottled() {
        return this.isThrottled;
    }

    public void setThrottled(boolean bl) {
        this.isThrottled = bl;
    }

    public void updateLoggingValues() {
        if (this.player != null) {
            this.player.updateLoggingValues();
        }
    }

    public double length() {
        double d = 0.0;
        if (this.player != null) {
            d = this.player.length();
        }
        return d;
    }

    public long size() {
        long l = 0L;
        if (this.player != null) {
            l = this.player.size();
        }
        return l;
    }
}

