/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.file;

import com.wowza.wms.logging.WMSLoggerFactory;

public class MediaStreamIndex {
    private long[] index = null;
    private int length = 0;
    private boolean hitEnd = false;

    public void reset() {
        this.index = null;
        this.length = 0;
        this.hitEnd = false;
    }

    public MediaStreamIndex clone() {
        MediaStreamIndex mediaStreamIndex = new MediaStreamIndex();
        mediaStreamIndex.length = 0;
        mediaStreamIndex.hitEnd = this.hitEnd;
        if (this.index != null) {
            mediaStreamIndex.index = new long[this.index.length];
            System.arraycopy(this.index, 0, mediaStreamIndex.index, 0, mediaStreamIndex.index.length);
            mediaStreamIndex.length = mediaStreamIndex.index.length;
        }
        return mediaStreamIndex;
    }

    public void indexFileDump() {
        WMSLoggerFactory.getLogger(MediaStreamIndex.class).info("this.fileIndexLen: " + this.length);
        for (int i = 0; i < this.length; ++i) {
            WMSLoggerFactory.getLogger(MediaStreamIndex.class).info("  [" + i + "] " + this.index[i]);
        }
    }

    public void indexFileIncSize(int n) {
        if (n > (this.index == null ? 0 : this.index.length)) {
            long[] lArray = new long[n];
            if (this.index != null) {
                System.arraycopy(this.index, 0, lArray, 0, this.index.length);
            }
            this.index = lArray;
        }
    }

    public void indexFileShrink() {
        if (this.index == null) {
            return;
        }
        if (this.length == 0) {
            this.index = null;
            return;
        }
        if (this.length != this.index.length) {
            long[] lArray = new long[this.length];
            System.arraycopy(this.index, 0, lArray, 0, this.length);
            this.index = lArray;
        }
    }

    public void indexFileSet(int n, long l) {
        int n2;
        int n3 = n2 = this.index == null ? 0 : this.index.length;
        if (n >= n2) {
            int n4 = n2 + 3600;
            this.indexFileIncSize(n4);
        }
        if (n < this.index.length) {
            this.index[n] = l;
            this.length = n + 1;
        }
    }

    public long indexFileGet(long l) {
        if (l < 0L) {
            l = 0L;
        }
        int n = (int)(l / 1000L);
        if (this.index != null) {
            int n2 = n < this.length ? n : this.length - 1;
            return this.index[n2];
        }
        return -1L;
    }

    public long indexFileLast() {
        if (this.index != null) {
            return this.index[this.length - 1];
        }
        return -1L;
    }

    public long get(int n) {
        return this.index[n];
    }

    public boolean isHitEnd() {
        return this.hitEnd;
    }

    public void setHitEnd(boolean bl) {
        this.hitEnd = bl;
    }

    public long[] getIndex() {
        return this.index;
    }

    public void setIndex(long[] lArray) {
        this.index = lArray;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }
}

