/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.file;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientResponseTracker;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.MediaStreamFilePlay;
import com.wowza.wms.stream.file.Playlist;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistNode;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistSeeker;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.util.StreamUtils;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class PlaylistPlayer {
    public static final int SEEKTYPE_NONE = 0;
    public static final int SEEKTYPE_SEEK = 1;
    public static final int SEEKTYPE_UNPAUSE = 2;
    private Playlist playlist = null;
    private IMediaReader mediaReader = null;
    private PlaylistCursor flvCursor = new PlaylistCursor();
    private IMediaStream stream = null;
    private int playlistLoc = 0;
    private boolean playlistEnd = false;
    private byte[] chunkWorkBuffer = null;
    private int[] chunkHeaderValues = null;
    private Object bufferTimeObj = null;
    private int bufferTime = 0;
    private boolean isOpen = true;
    private boolean isThrottled = true;
    private boolean isPlayStarted = false;
    private boolean disableLowBandwidthThrottling = false;
    private int behindDropDFrames = 1000;
    private int behindDropPFrames = 2000;
    private int behindDropKFrames = 3000;
    private int behindDropAudio = 3000;
    private int behindSendSeqCount = 2;
    private int minBufferSize = 2000;
    private int tcWindowSend = 2000;
    private int tcWindowUpdate = 1000;
    private int minBufferSizeActive = 0;
    private int tcWindowSendActive = 0;
    private int tcWindowUpdateActive = 0;
    private int tcMaxSend = 8000;
    private long trackerSeqSource = 0L;
    private long trackerStartSeq = -1L;
    private PlaylistTracker lastSentPlaylistTracker = null;
    private int lastTCFilter = 7;
    private long maxTCOffset = 0L;
    private int maxPendingSeekRequests = 4;
    private AtomicReference<PlaylistSwitch> playListSwitch = new AtomicReference<Object>(null);
    private boolean isBurstCapable = false;
    private boolean enableDynamicStreamMarkers = true;
    private boolean checkStreamProperties = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaylistPlayer(Playlist playlist, IMediaStream iMediaStream) {
        this.playlist = playlist;
        this.stream = iMediaStream;
        this.chunkHeaderValues = new int[5];
        this.bufferTimeObj = new Object();
        IMediaStream iMediaStream2 = this.stream;
        synchronized (iMediaStream2) {
            this.playlistLoc = 0;
            this.playlistEnd = false;
            this.flvCursor.setFirstStream(true);
        }
        iMediaStream2 = null;
        if (WMSLoggerFactory.getLogger(PlaylistPlayer.class).isDebugEnabled()) {
            iMediaStream2 = WMSLoggerFactory.getLogger(PlaylistPlayer.class);
        }
        if (this.stream != null) {
            WMSProperties wMSProperties = this.stream.getProperties();
            String string = wMSProperties.getPropertyStr("seekTarget", null);
            String string2 = wMSProperties.getPropertyStr("seekVideoTarget", null);
            this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean("disableLowBandwidthThrottling", this.disableLowBandwidthThrottling);
            this.behindDropDFrames = wMSProperties.getPropertyInt("behindDropDFrames", this.behindDropDFrames);
            this.behindDropPFrames = wMSProperties.getPropertyInt("behindDropPFrames", this.behindDropPFrames);
            this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt("behindDropKFrames", this.behindDropKFrames);
            this.behindDropAudio = wMSProperties.getPropertyInt("behindDropAudio", this.behindDropAudio);
            this.behindSendSeqCount = wMSProperties.getPropertyInt("behindSendSeqCount", this.behindSendSeqCount);
            this.maxPendingSeekRequests = wMSProperties.getPropertyInt("maxPendingSeekRequests", this.maxPendingSeekRequests);
            this.minBufferSize = wMSProperties.getPropertyInt("minBufferSize", this.minBufferSize);
            this.tcWindowSend = wMSProperties.getPropertyInt("tcWindowSend", this.tcWindowSend);
            this.tcWindowUpdate = wMSProperties.getPropertyInt("tcWindowUpdate", this.tcWindowUpdate);
            this.tcMaxSend = wMSProperties.getPropertyInt("tcMaxSend", this.tcMaxSend);
            this.enableDynamicStreamMarkers = wMSProperties.getPropertyBoolean("enableDynamicStreamMarkers", this.enableDynamicStreamMarkers);
            this.minBufferSizeActive = this.minBufferSize;
            this.tcWindowSendActive = this.tcWindowSend;
            this.tcWindowUpdateActive = this.tcWindowUpdate;
            if (iMediaStream2 != null) {
                iMediaStream2.debug("disableLowBandwidthThrottling: " + this.disableLowBandwidthThrottling);
                iMediaStream2.debug("behindDropDFrames: " + this.behindDropDFrames);
                iMediaStream2.debug("behindDropPFrames: " + this.behindDropPFrames);
                iMediaStream2.debug("behindDropKFrames: " + this.behindDropKFrames);
                iMediaStream2.debug("behindDropAudio: " + this.behindDropAudio);
                iMediaStream2.debug("behindSendSeqCount: " + this.behindSendSeqCount);
                iMediaStream2.debug("maxPendingSeekRequests: " + this.maxPendingSeekRequests);
                iMediaStream2.debug("minBufferSize: " + this.minBufferSize);
                iMediaStream2.debug("tcWindowSend: " + this.tcWindowSend);
                iMediaStream2.debug("tcWindowUpdate: " + this.tcWindowUpdate);
                iMediaStream2.debug("tcMaxSend: " + this.tcMaxSend);
            }
            if (string != null) {
                if (string.trim().equalsIgnoreCase("videoKeyFrame")) {
                    this.flvCursor.setSeekTarget(1);
                    this.flvCursor.setSeekVideoTarget(3);
                } else if (string.trim().equalsIgnoreCase("audio")) {
                    this.flvCursor.setSeekTarget(3);
                    this.flvCursor.setSeekVideoTarget(2);
                } else if (string.trim().equalsIgnoreCase("enhanced")) {
                    this.flvCursor.setSeekTarget(4);
                    this.flvCursor.setSeekVideoTarget(1);
                } else {
                    WMSLoggerFactory.getLogger(PlaylistPlayer.class).error("undefined seekTarget: " + string);
                }
                if (iMediaStream2 != null) {
                    iMediaStream2.debug("seekTarget: " + string);
                }
            }
            if (string2 != null) {
                if (string2.equalsIgnoreCase("keyclosest")) {
                    this.flvCursor.setSeekVideoTarget(3);
                } else if (string2.equalsIgnoreCase("keyup")) {
                    this.flvCursor.setSeekVideoTarget(1);
                } else if (string2.equalsIgnoreCase("keydown")) {
                    this.flvCursor.setSeekVideoTarget(2);
                } else {
                    WMSLoggerFactory.getLogger(PlaylistPlayer.class).error("undefined seekVideoTarget: " + string2);
                }
                if (iMediaStream2 != null) {
                    iMediaStream2.debug("seekVideoTarget: " + string2);
                }
            }
        }
    }

    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{10, 0, 0, 0};
            int n = iClient.testFlashVersion(nArray);
            return n >= 0;
        }
        return false;
    }

    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (this.isBurstCapable) {
            byte[] byArray = iMediaStream.getBurstStartStop(true);
            try {
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (this.isBurstCapable) {
            byte[] byArray = iMediaStream.getBurstStartStop(false);
            try {
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playListSwitch.set(new PlaylistSwitch(string, string2, string3, string4, d, d2, n));
    }

    private void setLoggingNode(PlaylistNode playlistNode) {
        WMSLoggerFactory.putGlobalLogValue((String)"CTRL-playlist-node", (Object)playlistNode);
    }

    private PlaylistNode getLoggingNode() {
        PlaylistNode playlistNode = null;
        playlistNode = (PlaylistNode)WMSLoggerFactory.getGlobalLogValue((String)"CTRL-playlist-node");
        if (playlistNode == null) {
            playlistNode = this.playlist.get(this.playlistLoc);
        }
        return playlistNode;
    }

    private void clearLoggingNode() {
        WMSLoggerFactory.removeGlobalLogValue((String)"CTRL-playlist-node");
    }

    private void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.chunkWorkBuffer = new byte[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            this.flvCursor.setInterruptPlay();
            this.isOpen = false;
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean bl) {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            if (bl) {
                this.playlistLoc = 0;
                if (this.mediaReader != null) {
                    this.mediaReader.close();
                }
                this.mediaReader = null;
                this.flvCursor.setFirstStream(true);
                this.flvCursor.setPlaylistReset(true);
                this.flvCursor.setLastTC(0L);
                this.trackerStartSeq = -1L;
                this.lastSentPlaylistTracker = null;
                this.lastTCFilter = 7;
            }
            this.playlistEnd = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playStart() {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            this.flvCursor.setStartPlaying(true);
            this.flvCursor.setFillBuffer(true);
        }
    }

    public int sendMetadata(OutputStream outputStream, long[] lArray, AMFObj aMFObj, long l) {
        int n = 0;
        if (this.mediaReader == null) {
            return 0;
        }
        List list = this.mediaReader.getMetadata();
        if (list != null) {
            int n2 = this.flvCursor.getWriteControl().getChunkSize();
            this.checkWorkBuffer(n2);
            ResponseFunction responseFunction = null;
            AMFDataObj aMFDataObj = null;
            responseFunction = new ResponseFunction(this.stream.getClient(), this.stream.getRespAMFDataObj());
            responseFunction.createSeekMessage("onStatus");
            responseFunction.setSrc(this.stream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
            responseFunction.addBody((AMFData)aMFDataObj);
            n += responseFunction.write(outputStream, true, n2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = ((ByteBuffer)iterator.next()).array();
                this.chunkHeaderValues[0] = 18;
                this.chunkHeaderValues[1] = byArray.length;
                this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                int n3 = StreamUtils.directOutput((byte[])byArray, (int[])this.chunkHeaderValues, (boolean)true, (int)this.stream.getSrc(), (OutputStream)outputStream, (AMFObj)aMFObj, (byte[])this.chunkWorkBuffer, (int)n2);
                n += n3;
                lArray[4] = lArray[4] + (long)n3;
                lArray[5] = lArray[5] + 1L;
            }
        }
        return n;
    }

    private int moveToNextFile(OutputStream outputStream, PlaylistNode playlistNode) {
        return this.moveToNextFile(outputStream, playlistNode, true);
    }

    private int moveToNextFile(OutputStream outputStream, PlaylistNode playlistNode, boolean bl) {
        String string = playlistNode.getName();
        int n = 0;
        if (!this.playlistEnd) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(PlaylistPlayer.class);
            if (!wMSLogger.isDebugEnabled()) {
                wMSLogger = null;
            }
            if (bl) {
                if (this.stream.isSendPlayStopLogEvent()) {
                    this.setLoggingNode(playlistNode);
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "stop", 200, string);
                    this.clearLoggingNode();
                    this.stream.notifyActionStop();
                    this.stream.setSendPlayStopLogEvent(false);
                }
                int n2 = this.flvCursor.getWriteControl().getChunkSize();
                this.checkWorkBuffer(n2);
                ++this.playlistLoc;
                if (this.playlistLoc >= this.playlist.size()) {
                    long l = this.flvCursor.getLastTC() + this.flvCursor.getStartTCOffset();
                    this.isPlayStarted = false;
                    if (wMSLogger != null) {
                        wMSLogger.debug("sendPlayStatus: ltc:" + this.flvCursor.getLastTC() + " atc:" + l);
                    }
                    this.chunkHeaderValues[0] = 8;
                    this.chunkHeaderValues[1] = 0;
                    this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                    n += StreamUtils.directOutput((byte[])null, (int[])this.chunkHeaderValues, (boolean)true, (int)this.stream.getSrc(), (OutputStream)outputStream, (AMFObj)this.stream.getRespAMFAudioObj(), (byte[])this.chunkWorkBuffer, (int)n2);
                    n += this.stream.sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    if (wMSLogger != null) {
                        wMSLogger.debug("sendPlayStop: ltc:" + this.flvCursor.getLastTC() + " atc:" + l);
                    }
                    n += this.stream.sendPlayStop(outputStream, l, string);
                    this.playlistLoc = this.playlist.size() - 1;
                    this.playlistEnd = true;
                } else {
                    long l = this.flvCursor.getLastTC() + this.flvCursor.getStartTCOffset();
                    this.isPlayStarted = false;
                    if (wMSLogger != null) {
                        wMSLogger.debug("sendPlaySwitch: ltc:" + this.flvCursor.getLastTC() + " atc:" + l);
                    }
                    this.chunkHeaderValues[0] = 8;
                    this.chunkHeaderValues[1] = 0;
                    this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                    n += StreamUtils.directOutput((byte[])null, (int[])this.chunkHeaderValues, (boolean)true, (int)this.stream.getSrc(), (OutputStream)outputStream, (AMFObj)this.stream.getRespAMFAudioObj(), (byte[])this.chunkWorkBuffer, (int)n2);
                    n += this.stream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
                    if (this.mediaReader != null) {
                        this.mediaReader.close();
                    }
                    this.mediaReader = null;
                    this.flvCursor.reset();
                    this.flvCursor.setStartPlaying(true);
                    this.flvCursor.setSendAbsAudioTC(true);
                    this.flvCursor.setSendAbsVideoTC(true);
                    this.flvCursor.setSendAbsBroadcastTC(true);
                }
            } else {
                long l = this.flvCursor.getLastTC() + this.flvCursor.getStartTCOffset();
                this.isPlayStarted = false;
                if (wMSLogger != null) {
                    wMSLogger.debug("sendPlayStop: ltc:" + this.flvCursor.getLastTC() + " atc:" + l);
                }
                n += this.stream.sendPlayStop(outputStream, l, string);
                this.flvCursor.reset();
            }
        }
        return n;
    }

    private IMediaReader getMediaReader(PlaylistNode playlistNode) {
        return this.getMediaReader(playlistNode, false);
    }

    private IMediaReader getMediaReader(PlaylistNode playlistNode, boolean bl) {
        String string = playlistNode.getStreamExt().toLowerCase();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)this.stream.getStreams().getAppInstance(), (MediaReaderList)this.stream.getStreams().getVHost().getMediaReaders(), (String)string);
        if (iMediaReader != null) {
            IApplicationInstance iApplicationInstance = this.stream.getStreams().getAppInstance();
            String string2 = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, this.stream, playlistNode.getStreamExt(), string2, playlistNode.getName());
            if (bl) {
                iMediaReader.open(string2, playlistNode.getName());
            }
        }
        return iMediaReader;
    }

    private long getNodeDuration(PlaylistNode playlistNode) {
        String string;
        long l;
        long l2 = 0L;
        IMediaReader iMediaReader = null;
        if (!playlistNode.isStartTCValid()) {
            l = 0L;
            if (playlistNode.getPlayStart() > 0.0) {
                l = Math.round(playlistNode.getPlayStart());
                if (iMediaReader == null) {
                    iMediaReader = this.getMediaReader(playlistNode, true);
                }
                if ((string = iMediaReader.seek(l, 1)) != null) {
                    l = string.getResultTimecode();
                }
                if (iMediaReader != null) {
                    iMediaReader.close();
                }
                iMediaReader = null;
            }
            playlistNode.setStartTC(l);
        }
        if (!playlistNode.isStopTCValid()) {
            l = 0L;
            if (playlistNode.getPlayLen() > 0.0) {
                PlaylistSeekResult playlistSeekResult;
                long l3 = 0L;
                if (playlistNode.getPlayStart() > 0.0) {
                    l3 = Math.round(playlistNode.getPlayStart());
                }
                long l4 = Math.round(playlistNode.getPlayLen());
                l = l3 + l4;
                if (iMediaReader == null) {
                    iMediaReader = this.getMediaReader(playlistNode, true);
                }
                if ((playlistSeekResult = iMediaReader.seek(l, 4)) != null) {
                    l = playlistSeekResult.getResultTimecode();
                }
                if (iMediaReader != null) {
                    iMediaReader.close();
                }
                iMediaReader = null;
            } else {
                string = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                if (iMediaReader == null) {
                    iMediaReader = this.getMediaReader(playlistNode, true);
                }
                l = iMediaReader.getDuration();
                if (iMediaReader != null) {
                    iMediaReader.close();
                }
                iMediaReader = null;
            }
            playlistNode.setStopTC(l);
        }
        if ((l2 = playlistNode.getStopTC() - playlistNode.getStartTC()) < 0L) {
            l2 = 0L;
        }
        return l2;
    }

    public long getNodeOffset(Playlist playlist, int n) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += this.getNodeDuration(this.playlist.get(i));
        }
        PlaylistNode playlistNode = this.playlist.get(n);
        return l -= playlistNode.getStartTC();
    }

    private PlaylistTracker getSendPlaylistTracker(PlaylistTracker playlistTracker, boolean bl) {
        if (playlistTracker == null) {
            playlistTracker = new PlaylistTracker();
            playlistTracker.isStart = bl;
        }
        return playlistTracker;
    }

    private int getTrackerStartCount(IMediaStream iMediaStream) {
        int n = 0;
        try {
            Object object;
            long l = -1L;
            if (iMediaStream != null) {
                PlaylistTracker playlistTracker;
                ClientResponseTracker clientResponseTracker;
                ClientWriteListener clientWriteListener;
                object = "stream" + iMediaStream.getSrc();
                Client client = (Client)iMediaStream.getClient();
                if (client != null && (clientWriteListener = client.getWriteListener()) != null && (clientResponseTracker = clientWriteListener.getLastTracker()) != null && (playlistTracker = (PlaylistTracker)clientResponseTracker.getInfo((String)object)) != null) {
                    l = playlistTracker.trackerSeq;
                }
            }
            if (this.lastSentPlaylistTracker != null) {
                object = this.lastSentPlaylistTracker.prevTracker;
                while (object != null && ((PlaylistTracker)object).trackerSeq >= l) {
                    if (((PlaylistTracker)object).isStart) {
                        ++n;
                    }
                    object = ((PlaylistTracker)object).prevTracker;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlaylistPlayer.class).error("PlaylistPlayer.getTrackerStartCount: " + exception.toString());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        Object object;
        String string;
        ClientWriteListener clientWriteListener;
        PlaylistReaderWriteResults playlistReaderWriteResults;
        PlaylistTracker playlistTracker;
        long l;
        long l2;
        long l3;
        int n;
        WMSLogger wMSLogger;
        int n2;
        block141: {
            int n3;
            long l4;
            boolean bl;
            FastPlaySettings fastPlaySettings;
            Object object2;
            block156: {
                block153: {
                    block155: {
                        boolean bl2;
                        long l5;
                        int n4;
                        long l6;
                        block154: {
                            block152: {
                                int n5;
                                PlaylistTracker playlistTracker2;
                                int n6;
                                long l7;
                                int n7;
                                long l8;
                                boolean bl3;
                                IMediaStream iMediaStream2;
                                block151: {
                                    block150: {
                                        IMediaStream iMediaStream3;
                                        boolean bl4;
                                        block148: {
                                            boolean bl5;
                                            block149: {
                                                IMediaReaderStreamPosition iMediaReaderStreamPosition;
                                                boolean bl6;
                                                long l9;
                                                block145: {
                                                    int n8;
                                                    long l10;
                                                    block147: {
                                                        boolean bl7;
                                                        block146: {
                                                            PlaylistSwitch playlistSwitch;
                                                            boolean bl8;
                                                            block142: {
                                                                block144: {
                                                                    block143: {
                                                                        n2 = 0;
                                                                        if (this.playlist == null) {
                                                                            return 0;
                                                                        }
                                                                        if (this.playlist.size() <= 0) {
                                                                            return 0;
                                                                        }
                                                                        wMSLogger = WMSLoggerFactory.getLogger(PlaylistPlayer.class);
                                                                        if (!wMSLogger.isDebugEnabled()) {
                                                                            wMSLogger = null;
                                                                        }
                                                                        iMediaStream2 = this.stream;
                                                                        // MONITORENTER : iMediaStream2
                                                                        if (this.flvCursor.isBreakLoop() || !this.isOpen) {
                                                                            // MONITOREXIT : iMediaStream2
                                                                            return 0;
                                                                        }
                                                                        this.flvCursor.enterReader();
                                                                        // MONITOREXIT : iMediaStream2
                                                                        iMediaStream2 = (Client)iMediaStream.getClient();
                                                                        this.flvCursor.getWriteControl().setChunkSize(iMediaStream2.getSendChunkSize());
                                                                        bl7 = false;
                                                                        n = -1;
                                                                        l3 = -1L;
                                                                        l2 = -1L;
                                                                        l = -1L;
                                                                        playlistTracker = null;
                                                                        playlistReaderWriteResults = null;
                                                                        clientWriteListener = iMediaStream2.getWriteListener();
                                                                        string = "stream" + iMediaStream.getSrc();
                                                                        object = this.playlist.get(this.playlistLoc);
                                                                        if (object == null) break block141;
                                                                        if (this.mediaReader == null) {
                                                                            this.mediaReader = this.getMediaReader((PlaylistNode)object);
                                                                        }
                                                                        if (this.mediaReader == null) break block141;
                                                                        if (this.mediaReader.isOpen()) break block142;
                                                                        object2 = this.stream;
                                                                        // MONITORENTER : object2
                                                                        if (!this.flvCursor.isBreakLoop() && this.isOpen) break block143;
                                                                        // MONITOREXIT : object2
                                                                        break block141;
                                                                    }
                                                                    this.flvCursor.reset();
                                                                    String string2 = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                                                                    try {
                                                                        this.mediaReader.open(string2, ((PlaylistNode)object).getName());
                                                                        this.flvCursor.setStartPlaying(true);
                                                                        if (!this.mediaReader.isOpen() && !((PlaylistNode)object).isSentStreamNotFound()) {
                                                                            n2 += this.stream.sendStreamNotFound(((PlaylistNode)object).getName());
                                                                            ((PlaylistNode)object).setSentStreamNotFound(true);
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        WMSLoggerFactory.getLogger(PlaylistPlayer.class).error("play: error opening file (" + string2 + "/" + ((PlaylistNode)object).getName() + "): " + exception.toString());
                                                                        exception.printStackTrace();
                                                                    }
                                                                    if (this.mediaReader.isOpen()) break block144;
                                                                    n2 += this.moveToNextFile(outputStream, (PlaylistNode)object);
                                                                    // MONITOREXIT : object2
                                                                    break block141;
                                                                }
                                                                // MONITOREXIT : object2
                                                            }
                                                            object2 = this.flvCursor.getWriteControl();
                                                            ((PlaylistWriteControl)object2).reset();
                                                            playlistReaderWriteResults = this.flvCursor.getWriteResults();
                                                            fastPlaySettings = this.stream.getFastPlaySettings();
                                                            bl3 = fastPlaySettings != null;
                                                            bl = ((PlaylistNode)object).getPlayReset() > 1;
                                                            boolean bl9 = bl8 = this.stream.getClient().getProtocol() == 1;
                                                            if (this.checkStreamProperties) {
                                                                if (this.enableDynamicStreamMarkers) {
                                                                    this.isBurstCapable = this.isBurstCapable(this.stream);
                                                                }
                                                                if (this.isBurstCapable) {
                                                                    WMSLoggerFactory.getLogger(null).info("PlaylistPlayer.play[" + iMediaStream.getContextStr() + "]: Dynamic Stream Markers are on.");
                                                                }
                                                                this.checkStreamProperties = false;
                                                            }
                                                            if ((playlistSwitch = (PlaylistSwitch)this.playListSwitch.getAndSet(null)) != null) {
                                                                System.out.println("PlaylistSwitch: " + playlistSwitch.toString());
                                                                IMediaReader iMediaReader = null;
                                                                PlaylistNode playlistNode = new PlaylistNode();
                                                                playlistNode.setName(playlistSwitch.name);
                                                                playlistNode.setStreamExt(playlistSwitch.ext);
                                                                iMediaReader = this.getMediaReader(playlistNode, true);
                                                                if (iMediaReader != null) {
                                                                    long l11 = this.flvCursor.getLastTC();
                                                                    l9 = this.flvCursor.getLastVideoTC();
                                                                    if (l11 <= 0L) {
                                                                        System.out.println("PlaylistSwitch: at zero");
                                                                        ((PlaylistNode)object).setName(playlistSwitch.name);
                                                                        ((PlaylistNode)object).setStreamExt(playlistSwitch.ext);
                                                                        if (this.mediaReader != null) {
                                                                            this.mediaReader.close();
                                                                        }
                                                                        this.mediaReader = iMediaReader;
                                                                        iMediaReader = null;
                                                                    } else {
                                                                        boolean bl10;
                                                                        boolean bl11 = bl10 = l11 > 0L && l9 <= 0L;
                                                                        if (!bl10) {
                                                                            IMediaReaderStreamPosition iMediaReaderStreamPosition2;
                                                                            PlaylistSeekResult playlistSeekResult;
                                                                            if (wMSLogger != null) {
                                                                                wMSLogger.debug("PlaylistSwitch: seek: " + l9);
                                                                            }
                                                                            if ((playlistSeekResult = iMediaReader.seek(l9, 2)) != null && (iMediaReaderStreamPosition2 = playlistSeekResult.getVideoStreamPos()) != null) {
                                                                                l4 = playlistSeekResult.getResultVideoTimecode();
                                                                                if (wMSLogger != null) {
                                                                                    wMSLogger.debug("PlaylistSwitch: video: " + l9 + ":" + l4);
                                                                                }
                                                                                ((PlaylistWriteControl)object2).setMaxTC(l4);
                                                                                l8 = this.mediaReader.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
                                                                                n2 = (int)((long)n2 + l8);
                                                                                this.flvCursor.incSendSeqCount();
                                                                                if (((PlaylistWriteControl)object2).getVideoFilter() != 7) {
                                                                                    this.flvCursor.setWaitForKeyFrame(true);
                                                                                }
                                                                                if (this.flvCursor.isDelayedFillBuffer()) {
                                                                                    this.flvCursor.setDelayedFillBuffer(false);
                                                                                }
                                                                                if (wMSLogger != null) {
                                                                                    wMSLogger.debug("PlaylistSwitch: do switch");
                                                                                }
                                                                                ((PlaylistNode)object).setName(playlistSwitch.name);
                                                                                ((PlaylistNode)object).setStreamExt(playlistSwitch.ext);
                                                                                if (this.mediaReader != null) {
                                                                                    this.mediaReader.close();
                                                                                }
                                                                                this.mediaReader = iMediaReader;
                                                                                iMediaReader = null;
                                                                                this.mediaReader.setStreamPosition(iMediaReaderStreamPosition2);
                                                                                this.stream.sendVODPlaySwitch(outputStream, playlistSwitch.name, l4);
                                                                                this.flvCursor.resetSampleDesc();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                if (iMediaReader != null) {
                                                                    iMediaReader.close();
                                                                }
                                                            }
                                                            bl4 = false;
                                                            bl6 = false;
                                                            bl5 = false;
                                                            iMediaReaderStreamPosition = null;
                                                            if (!this.flvCursor.isStartPlaying()) break block145;
                                                            IMediaStream iMediaStream4 = this.stream;
                                                            // MONITORENTER : iMediaStream4
                                                            if (!this.flvCursor.isBreakLoop() && this.isOpen) break block146;
                                                            // MONITOREXIT : iMediaStream4
                                                            break block141;
                                                        }
                                                        this.flvCursor.setFastPlaySettings(fastPlaySettings);
                                                        if (this.flvCursor.isPlaylistReset()) {
                                                            n2 += this.stream.sendPlayReset(outputStream, ((PlaylistNode)object).getName());
                                                            this.flvCursor.setPlaylistReset(false);
                                                        }
                                                        l10 = 0L;
                                                        long l12 = -1L;
                                                        n8 = this.flvCursor.getSeekType();
                                                        switch (n8) {
                                                            case 0: {
                                                                long l13;
                                                                if (((PlaylistNode)object).getPlayStart() > 0.0 || ((PlaylistNode)object).getDuration() == 0) {
                                                                    l10 = Math.round(((PlaylistNode)object).getPlayStart());
                                                                    l13 = System.currentTimeMillis();
                                                                    PlaylistSeekResult playlistSeekResult = this.mediaReader.seek(l10, 1);
                                                                    long l14 = System.currentTimeMillis();
                                                                    if (playlistSeekResult == null) {
                                                                        l10 = 0L;
                                                                        this.mediaReader.rewind();
                                                                    } else {
                                                                        iMediaStream3 = null;
                                                                        switch (this.flvCursor.getSeekTarget()) {
                                                                            case 1: {
                                                                                iMediaStream3 = playlistSeekResult.getVideoStreamPos();
                                                                                if (iMediaStream3 != null && iMediaStream3.isValid()) {
                                                                                    l10 = playlistSeekResult.getResultVideoTimecode();
                                                                                    this.mediaReader.setStreamPosition(playlistSeekResult.getVideoStreamPos());
                                                                                } else {
                                                                                    l10 = playlistSeekResult.getResultTimecode();
                                                                                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                                                                }
                                                                                iMediaReaderStreamPosition = null;
                                                                                if (((PlaylistNode)object).getPlayLen() != 0.0) break;
                                                                                iMediaReaderStreamPosition = iMediaStream3;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                l10 = playlistSeekResult.getResultTimecode();
                                                                                iMediaReaderStreamPosition = playlistSeekResult.getVideoStreamPos();
                                                                                this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                                                                break;
                                                                            }
                                                                            case 4: {
                                                                                l10 = playlistSeekResult.getResultTimecode();
                                                                                iMediaReaderStreamPosition = playlistSeekResult.getVideoStreamPos();
                                                                                this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                                                                break;
                                                                            }
                                                                        }
                                                                    }
                                                                    if (wMSLogger != null) {
                                                                        wMSLogger.debug("play seek(" + (l14 - l13) + "): " + l10);
                                                                    }
                                                                    this.flvCursor.setSeekReqLocation(l10);
                                                                    this.flvCursor.setSeekResLocation(l10);
                                                                }
                                                                if (l10 + this.flvCursor.getStartTCOffset() < 0L) {
                                                                    l10 = -this.flvCursor.getStartTCOffset();
                                                                }
                                                                this.flvCursor.setFillBuffer(true);
                                                                ((PlaylistNode)object).setStartTC(l10);
                                                                this.flvCursor.setEndTC(-1L);
                                                                if (((PlaylistNode)object).getPlayLen() > 0.0) {
                                                                    long l15;
                                                                    PlaylistSeekResult playlistSeekResult;
                                                                    l13 = 0L;
                                                                    if (((PlaylistNode)object).getPlayStart() > 0.0) {
                                                                        l13 = Math.round(((PlaylistNode)object).getPlayStart());
                                                                    }
                                                                    if ((playlistSeekResult = this.mediaReader.seek(l12 = l13 + (l15 = Math.round(((PlaylistNode)object).getPlayLen())), 4)) != null) {
                                                                        l12 = playlistSeekResult.getResultTimecode();
                                                                    }
                                                                    this.flvCursor.setEndTC(l12);
                                                                    ((PlaylistNode)object).setStopTC(l12);
                                                                } else if (((PlaylistNode)object).getPlayLen() == 0.0) {
                                                                    bl5 = true;
                                                                }
                                                                this.flvCursor.setSendAbsVideoTC(true);
                                                                this.flvCursor.setSendAbsBroadcastTC(true);
                                                                this.flvCursor.setSendAbsAudioTC(true);
                                                                this.flvCursor.setStartTCOffset(this.getNodeOffset(this.playlist, this.playlistLoc));
                                                                if (fastPlaySettings != null) {
                                                                    fastPlaySettings.setStartTC(l10);
                                                                    fastPlaySettings.setStartTCOffset(this.flvCursor.getStartTCOffset());
                                                                }
                                                                if (this.isPlayStarted) {
                                                                    PlaylistNode playlistNode = this.flvCursor.getNode();
                                                                    if (playlistNode != null) {
                                                                        n2 += this.stream.sendPlayStop(outputStream, -1L, playlistNode.getName());
                                                                        this.setLoggingNode(playlistNode);
                                                                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, playlistNode.getName());
                                                                        this.clearLoggingNode();
                                                                        iMediaStream.notifyActionStop();
                                                                    }
                                                                    this.isPlayStarted = false;
                                                                }
                                                                long l16 = l10;
                                                                n2 += this.stream.sendPlayStart(outputStream, ((PlaylistNode)object).getName(), !this.flvCursor.isFirstStream(), l16 += this.flvCursor.getStartTCOffset(), this.flvCursor.getSeekTypes());
                                                                this.isPlayStarted = true;
                                                                if (bl5) break;
                                                                bl7 = true;
                                                                break;
                                                            }
                                                            case 1: {
                                                                l10 = this.flvCursor.getSeekResLocation();
                                                                iMediaReaderStreamPosition = this.flvCursor.getSeekVideoStreamPos();
                                                                if (l10 < 0L) {
                                                                    l10 = 0L;
                                                                }
                                                                if (l10 + this.flvCursor.getStartTCOffset() < 0L) {
                                                                    l10 = -this.flvCursor.getStartTCOffset();
                                                                }
                                                                long l16 = l10;
                                                                l16 += this.flvCursor.getStartTCOffset();
                                                                if (fastPlaySettings != null) {
                                                                    fastPlaySettings.setStartTC(l10);
                                                                    fastPlaySettings.setStartTCOffset(this.flvCursor.getStartTCOffset());
                                                                }
                                                                n2 += this.stream.sendPlaySeek(outputStream, this.flvCursor.getSeekReqLocation(), l16, ((PlaylistNode)object).getName(), this.flvCursor.getSeekTypes());
                                                                this.isPlayStarted = true;
                                                                break;
                                                            }
                                                            case 2: {
                                                                l10 = this.flvCursor.getSeekResLocation();
                                                                iMediaReaderStreamPosition = this.flvCursor.getSeekVideoStreamPos();
                                                                if (l10 < 0L) {
                                                                    l10 = 0L;
                                                                }
                                                                if (l10 + this.flvCursor.getStartTCOffset() < 0L) {
                                                                    l10 = -this.flvCursor.getStartTCOffset();
                                                                }
                                                                long l16 = l10;
                                                                l16 += this.flvCursor.getStartTCOffset();
                                                                if (fastPlaySettings != null) {
                                                                    fastPlaySettings.setStartTC(l10);
                                                                    fastPlaySettings.setStartTCOffset(this.flvCursor.getStartTCOffset());
                                                                }
                                                                n2 += this.stream.sendUnpauseNotify(outputStream, l16, ((PlaylistNode)object).getName(), this.flvCursor.getSeekTypes());
                                                                this.isPlayStarted = true;
                                                                break;
                                                            }
                                                        }
                                                        List<Integer> list = this.flvCursor.getSeekTypes();
                                                        if (list.size() == 0 || list.contains(new Integer(0))) {
                                                            iMediaStream.notifyActionPlay(((PlaylistNode)object).getName(), ((PlaylistNode)object).getPlayStart(), ((PlaylistNode)object).getPlayLen(), ((PlaylistNode)object).getPlayReset());
                                                            iMediaStream.setSendPlayStopLogEvent(true);
                                                            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(l10));
                                                            this.setLoggingNode((PlaylistNode)object);
                                                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 200, ((PlaylistNode)object).getName());
                                                            this.clearLoggingNode();
                                                        }
                                                        if (iMediaStream2.isConnected()) break block147;
                                                        // MONITOREXIT : iMediaStream4
                                                        break block141;
                                                    }
                                                    this.minBufferSizeActive = this.minBufferSize;
                                                    this.tcWindowSendActive = this.tcWindowSend;
                                                    this.tcWindowUpdateActive = this.tcWindowUpdate;
                                                    if (this.getBufferTime() <= 0) {
                                                        this.minBufferSizeActive = 1000;
                                                        this.tcWindowSendActive = 1000;
                                                        this.tcWindowUpdateActive = 500;
                                                        WMSLoggerFactory.getLogger(ModuleCore.class).debug("Switch to zero buffer settings");
                                                    }
                                                    this.flvCursor.setLastAudioWasZero(false);
                                                    this.flvCursor.resetPacketCounts();
                                                    this.flvCursor.setNode((PlaylistNode)object);
                                                    this.flvCursor.setLastAudioTC(l10);
                                                    this.flvCursor.setLastVideoTC(l10);
                                                    this.flvCursor.setLastBroadcastTC(l10);
                                                    this.flvCursor.setLastVideoFastTC(l10);
                                                    this.flvCursor.setLastTC(l10);
                                                    this.flvCursor.setStartTC(l10);
                                                    this.flvCursor.setFirstStream(false);
                                                    this.flvCursor.setSeekType(0);
                                                    this.flvCursor.clearSeekTypes();
                                                    this.flvCursor.setDelayedFillBuffer(false);
                                                    this.flvCursor.setWaitForKeyFrame(false);
                                                    this.flvCursor.setForceVideoTC(-1L);
                                                    this.flvCursor.setLastSendBufferTime(0);
                                                    this.flvCursor.setSendSeqCount(0);
                                                    this.flvCursor.setAudioSampleDesc(-1L);
                                                    this.flvCursor.setVideoSampleDesc(-1L);
                                                    this.flvCursor.setLastAudioCodecConfig(null);
                                                    this.flvCursor.setLastVideoCodecConfig(null);
                                                    this.playlistEnd = false;
                                                    playlistTracker = this.getSendPlaylistTracker(playlistTracker, true);
                                                    this.trackerStartSeq = playlistTracker.trackerSeq;
                                                    this.mediaReader.startPlayback();
                                                    if (this.flvCursor.isSendAbsAudioTC()) {
                                                        if (!bl3 && this.stream.isReceiveAudio()) {
                                                            int n9 = this.flvCursor.getWriteControl().getChunkSize();
                                                            this.checkWorkBuffer(n9);
                                                            this.chunkHeaderValues[0] = 8;
                                                            this.chunkHeaderValues[1] = 0;
                                                            this.chunkHeaderValues[2] = (int)(l10 & 0xFFFFFFFFL);
                                                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + this.flvCursor.getStartTCOffset());
                                                            if (this.chunkHeaderValues[2] < 0) {
                                                                this.chunkHeaderValues[2] = 0;
                                                            }
                                                            n2 += StreamUtils.directOutput((byte[])null, (int[])this.chunkHeaderValues, (boolean)true, (int)iMediaStream.getSrc(), (OutputStream)outputStream, (AMFObj)aMFObj, (byte[])this.chunkWorkBuffer, (int)n9);
                                                            playlistReaderWriteResults.incAudioPackets();
                                                        }
                                                        this.flvCursor.setLastAudioTC(l10);
                                                        this.flvCursor.setSendAbsAudioTC(false);
                                                    }
                                                    if (!bl3) {
                                                        l8 = l10 + this.flvCursor.getStartTCOffset();
                                                        if (l8 < 0L) {
                                                            l8 = 0L;
                                                        }
                                                        n2 += this.sendMetadata(outputStream, lArray, aMFObj3, l8);
                                                    }
                                                    int n10 = 0;
                                                    Object object3 = this.bufferTimeObj;
                                                    // MONITORENTER : object3
                                                    n10 = this.getBufferTime();
                                                    n7 = iMediaStream2.getMaximumSetBufferTime();
                                                    if (n7 > 0 && n10 > n7) {
                                                        n10 = n7;
                                                    }
                                                    this.flvCursor.setLastSendBufferTime(n10);
                                                    // MONITOREXIT : object3
                                                    if (this.flvCursor.isFillBuffer()) {
                                                        ((PlaylistWriteControl)object2).setVideoFilter(7);
                                                        ((PlaylistWriteControl)object2).setAudioFilter(false);
                                                        if (this.stream.isPlaying() && !bl5) {
                                                            long l17 = l10 + (long)Math.max(n10, this.minBufferSizeActive);
                                                            if (this.flvCursor.getEndTC() >= 0L && l17 > this.flvCursor.getEndTC() && (l17 = this.flvCursor.getEndTC()) > 0L) {
                                                                --l17;
                                                            }
                                                            if (l17 > (long)this.tcMaxSend) {
                                                                l17 = this.tcMaxSend;
                                                            }
                                                            ((PlaylistWriteControl)object2).setMaxTC(l17);
                                                        } else {
                                                            ((PlaylistWriteControl)object2).setMaxTC(0L);
                                                            ((PlaylistWriteControl)object2).setSkipAudio(true);
                                                        }
                                                        if (n8 == 1 && this.stream.isPlaying()) {
                                                            ((PlaylistWriteControl)object2).setMaxTC(0L);
                                                            ((PlaylistWriteControl)object2).setSkipAudio(true);
                                                            this.flvCursor.setDelayedFillBuffer(true);
                                                            ((Client)this.stream.getClient()).setImmediateIdle(true);
                                                        }
                                                    }
                                                    bl6 = this.flvCursor.isFillBuffer();
                                                    // MONITOREXIT : iMediaStream4
                                                }
                                                if (bl6) {
                                                    boolean bl12;
                                                    this.flvCursor.setRealStartTC(this.flvCursor.getStartTC());
                                                    this.flvCursor.setRealStartTime(System.currentTimeMillis());
                                                    n = ((PlaylistWriteControl)object2).getVideoFilter();
                                                    l3 = 0L;
                                                    l = this.flvCursor.getSendSeqCount();
                                                    l9 = ((PlaylistWriteControl)object2).getMaxTC();
                                                    IMediaReaderStreamPosition iMediaReaderStreamPosition3 = this.mediaReader.getStreamPosition();
                                                    boolean bl13 = false;
                                                    boolean bl14 = bl12 = iMediaReaderStreamPosition == null ? false : iMediaReaderStreamPosition.isValid();
                                                    if (bl12) {
                                                        this.mediaReader.setStreamPosition(iMediaReaderStreamPosition);
                                                        ((PlaylistWriteControl)object2).setMaxTC(0L);
                                                        this.flvCursor.setForceVideoTC(this.flvCursor.getStartTC());
                                                        this.flvCursor.setSeekStartStreamPos(iMediaReaderStreamPosition3);
                                                        n2 += this.mediaReader.writeGeneratedKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
                                                        ((PlaylistWriteControl)object2).setSkipAudio(false);
                                                        this.flvCursor.setSeekStartStreamPos(null);
                                                        this.mediaReader.setStreamPosition(iMediaReaderStreamPosition3);
                                                        ((PlaylistWriteControl)object2).setMaxTC(l9);
                                                        this.flvCursor.setWaitForKeyFrame(this.flvCursor.getSeekTarget() != 4);
                                                        bl13 = true;
                                                    }
                                                    if (!bl13 || bl13 && l9 > 0L) {
                                                        n2 += this.mediaReader.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
                                                        ((PlaylistWriteControl)object2).setSkipAudio(false);
                                                    } else if (bl13 && l9 == 0L) {
                                                        n2 += this.mediaReader.sendZeroLengthPacket(9, 0, false, iMediaStream, outputStream, aMFObj2, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, false);
                                                    }
                                                    if (!this.flvCursor.isDelayedFillBuffer()) {
                                                        this.flvCursor.incSendSeqCount();
                                                    }
                                                    bl4 = true;
                                                }
                                                if (!this.flvCursor.isStartPlaying()) break block148;
                                                IMediaStream iMediaStream5 = this.stream;
                                                // MONITORENTER : iMediaStream5
                                                if (!this.flvCursor.isBreakLoop() && this.isOpen) break block149;
                                                // MONITOREXIT : iMediaStream5
                                                break block141;
                                            }
                                            if (bl4 && playlistReaderWriteResults.getAudioPackets() == 1 && (!this.stream.isPlaying() || bl5)) {
                                                int n11 = this.flvCursor.getWriteControl().getChunkSize();
                                                this.checkWorkBuffer(n11);
                                                if (!bl3 && this.stream.isReceiveAudio()) {
                                                    this.chunkHeaderValues[0] = 8;
                                                    this.chunkHeaderValues[1] = 0;
                                                    this.chunkHeaderValues[2] = 0;
                                                    n2 += StreamUtils.directOutput((byte[])null, (int[])this.chunkHeaderValues, (boolean)false, (int)iMediaStream.getSrc(), (OutputStream)outputStream, (AMFObj)aMFObj, (byte[])this.chunkWorkBuffer, (int)n11);
                                                }
                                                if (playlistReaderWriteResults.getVideoPackets() > 0 && this.stream.isReceiveVideo()) {
                                                    n2 += this.mediaReader.sendZeroLengthPacket(9, 0, false, iMediaStream, outputStream, aMFObj2, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, false);
                                                }
                                                if (!this.stream.isPlaying()) {
                                                    n2 += iMediaStream.sendControlBytes(1, outputStream);
                                                }
                                            }
                                            this.flvCursor.setFillBuffer(false);
                                            this.flvCursor.setStartPlaying(false);
                                            if (bl5) {
                                                this.isPlayStarted = false;
                                                long l18 = this.flvCursor.getLastTC();
                                                l18 += this.flvCursor.getStartTCOffset();
                                                if (iMediaStream.isSendPlayStopLogEvent()) {
                                                    this.setLoggingNode((PlaylistNode)object);
                                                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, ((PlaylistNode)object).getName());
                                                    this.clearLoggingNode();
                                                    iMediaStream.setSendPlayStopLogEvent(false);
                                                    iMediaStream.notifyActionStop();
                                                }
                                                n2 += this.stream.sendPlayStatus(outputStream, l18, 2, 0.0, 0.0);
                                                n2 += this.stream.sendPlayStop(outputStream, l18, ((PlaylistNode)object).getName());
                                                this.flvCursor.reset();
                                                this.playlistEnd = true;
                                            } else if (playlistReaderWriteResults.isHitEnd()) {
                                                n2 += this.moveToNextFile(outputStream, (PlaylistNode)object);
                                            }
                                            // MONITOREXIT : iMediaStream5
                                        }
                                        if (bl4 || this.playlistEnd) break block141;
                                        l7 = 0L;
                                        l6 = 0L;
                                        n4 = 0;
                                        l4 = 0L;
                                        l8 = 0L;
                                        n7 = 0;
                                        n6 = 0;
                                        iMediaStream3 = this.stream;
                                        // MONITORENTER : iMediaStream3
                                        if (!this.flvCursor.isBreakLoop() && this.isOpen) break block150;
                                        // MONITOREXIT : iMediaStream3
                                        break block141;
                                    }
                                    if (this.stream.isPlaying()) break block151;
                                    // MONITOREXIT : iMediaStream3
                                    break block141;
                                }
                                Object object4 = this.bufferTimeObj;
                                // MONITORENTER : object4
                                n7 = this.getBufferTime();
                                n3 = iMediaStream2.getMaximumSetBufferTime();
                                if (n3 > 0 && n7 > n3) {
                                    n7 = n3;
                                }
                                n6 = this.flvCursor.getLastSendBufferTime();
                                this.flvCursor.setLastSendBufferTime(n7);
                                // MONITOREXIT : object4
                                l5 = System.currentTimeMillis();
                                n4 = Math.max(this.minBufferSizeActive, n7);
                                boolean bl15 = false;
                                if (this.flvCursor.isDelayedFillBuffer() || n7 > n6) {
                                    this.flvCursor.setSendSeqCount(0);
                                    if (n7 > n6) {
                                        bl15 = true;
                                    }
                                }
                                l7 = l5 - this.flvCursor.getRealStartTime();
                                l6 = this.flvCursor.getLastTCAdj() - this.flvCursor.getStartTC();
                                l4 = l7 - l6 + (long)n4;
                                l8 = 0L;
                                long l19 = 0L;
                                int n12 = 0;
                                int n13 = 7;
                                boolean bl16 = false;
                                bl2 = false;
                                l8 = l4 - (long)n4;
                                ClientResponseTracker clientResponseTracker = clientWriteListener.getLastTracker();
                                if (clientResponseTracker != null && (playlistTracker2 = (PlaylistTracker)clientResponseTracker.getInfo(string)) != null) {
                                    boolean bl17;
                                    n12 = this.lastSentPlaylistTracker.bufferTime;
                                    PlaylistTracker playlistTracker3 = this.lastSentPlaylistTracker.prevTracker;
                                    PlaylistTracker playlistTracker4 = null;
                                    int n14 = 0;
                                    boolean bl18 = bl17 = playlistTracker2.trackerSeq < this.trackerStartSeq;
                                    while (playlistTracker3 != null) {
                                        if (playlistTracker3.bufferTime > n12) {
                                            n12 = playlistTracker3.bufferTime;
                                        }
                                        if (playlistTracker3.trackerSeq < playlistTracker2.trackerSeq) {
                                            playlistTracker3.prevTracker = null;
                                            break;
                                        }
                                        if (bl17 && playlistTracker3.trackerSeq == this.trackerStartSeq) {
                                            playlistTracker4 = playlistTracker3;
                                        }
                                        if (playlistTracker3.isStart) {
                                            ++n14;
                                        }
                                        playlistTracker3 = playlistTracker3.prevTracker;
                                    }
                                    if (playlistTracker4 != null) {
                                        playlistTracker2 = playlistTracker4;
                                    }
                                    if (playlistTracker2.trackerSeq >= this.trackerStartSeq) {
                                        long l20 = clientResponseTracker.getSent();
                                        long l21 = clientResponseTracker.getSize();
                                        long l22 = playlistTracker2.firstTC + (playlistTracker2.lastTC - playlistTracker2.firstTC) * l20 / l21;
                                        l19 = this.lastSentPlaylistTracker.lastTC - l22 - (long)n12 - (long)this.tcWindowSendActive;
                                        if (n14 >= 2 || l19 > (long)Math.max(this.behindDropAudio, this.behindDropKFrames)) {
                                            bl2 = true;
                                        }
                                        if (this.flvCursor.getSendSeqCount() > 1) {
                                            if (l19 > (long)this.behindDropAudio) {
                                                bl16 = true;
                                            }
                                            if (l19 > (long)this.behindDropKFrames) {
                                                n13 = 0;
                                            } else if (l19 > (long)this.behindDropPFrames) {
                                                n13 = 1;
                                            } else if (l19 > (long)this.behindDropDFrames) {
                                                n13 = 3;
                                            }
                                        }
                                    }
                                }
                                if (this.lastTCFilter != n13) {
                                    WMSLoggerFactory.getLogger(PlaylistPlayer.class).debug("Filter[" + string + "]: filter:(" + this.lastTCFilter + "-" + n13 + ") offset:" + l19 + " bufferTime:" + n12);
                                }
                                if (bl3 || this.disableLowBandwidthThrottling || this.flvCursor.getSendSeqCount() < this.behindSendSeqCount) {
                                    n13 = 7;
                                    bl16 = false;
                                }
                                if ((n5 = this.stream.getReceiveVideoFPS()) < -1) {
                                    if (n5 == -2 && n13 == 7) {
                                        n13 = 3;
                                    } else if (n5 == -3 && (n13 == 7 || n13 == 3)) {
                                        n13 = 1;
                                        this.flvCursor.setWaitForKeyFrame(true);
                                    }
                                }
                                ((PlaylistWriteControl)object2).setVideoFilter(n13);
                                ((PlaylistWriteControl)object2).setAudioFilter(bl16);
                                this.lastTCFilter = n13;
                                n = ((PlaylistWriteControl)object2).getVideoFilter();
                                l3 = l8;
                                l = this.flvCursor.getSendSeqCount();
                                l2 = l4;
                                if (!this.flvCursor.isBreakLoop() && this.isOpen) break block152;
                                // MONITOREXIT : iMediaStream3
                                break block141;
                            }
                            if (!this.isThrottled) break block153;
                            if (l4 >= (long)(-this.tcWindowUpdateActive)) break block154;
                            // MONITOREXIT : iMediaStream3
                            break block141;
                        }
                        if (l4 < (long)this.tcWindowSendActive) {
                            l4 = this.tcWindowSendActive;
                        }
                        if (!bl2) break block155;
                        long l23 = l5 - l6 + (long)n4;
                        this.flvCursor.setRealStartTime(l23);
                        // MONITOREXIT : iMediaStream3
                        break block141;
                    }
                    if (l4 > (long)this.tcMaxSend) {
                        l4 = this.tcMaxSend;
                    }
                    break block156;
                }
                l4 = this.tcWindowSendActive;
            }
            // MONITOREXIT : iMediaStream3
            long l24 = this.flvCursor.getLastTCAdj() + l4;
            n3 = 0;
            if (this.flvCursor.getEndTC() >= 0L && l24 > this.flvCursor.getEndTC()) {
                n3 = 1;
                l24 = this.flvCursor.getEndTC();
                if (l24 > 0L) {
                    --l24;
                }
            }
            ((PlaylistWriteControl)object2).setMaxTC(l24);
            this.sendBurstStart(outputStream, iMediaStream);
            long l25 = this.mediaReader.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, this.flvCursor, (PlaylistWriteControl)object2, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
            this.sendBurstEnd(outputStream, iMediaStream);
            n2 = (int)((long)n2 + l25);
            this.flvCursor.incSendSeqCount();
            if (((PlaylistWriteControl)object2).getVideoFilter() != 7) {
                this.flvCursor.setWaitForKeyFrame(true);
            }
            if (this.flvCursor.isDelayedFillBuffer()) {
                this.flvCursor.setDelayedFillBuffer(false);
            }
            IMediaStream iMediaStream6 = this.stream;
            // MONITORENTER : iMediaStream6
            if (this.flvCursor.isBreakLoop() || !this.isOpen) {
                // MONITOREXIT : iMediaStream6
            } else {
                if (n3 != 0) {
                    playlistReaderWriteResults.setHitEnd(true);
                }
                if (playlistReaderWriteResults.isHitEnd()) {
                    if (((PlaylistWriteControl)object2).getMaxTC() != 0L && !((PlaylistNode)object).isStopTCValid()) {
                        ((PlaylistNode)object).setStopTC(this.flvCursor.getLastTC());
                    }
                    n2 += this.moveToNextFile(outputStream, (PlaylistNode)object);
                    // MONITOREXIT : iMediaStream6
                }
            }
        }
        object = this.stream;
        // MONITORENTER : object
        this.flvCursor.leaveReader();
        // MONITOREXIT : object
        if (n2 > 0 && wMSLogger != null) {
            object = "";
            object = (String)object + "filter:" + n;
            object = (String)object + " throttleWindow:" + l2;
            object = (String)object + " frontWindow:" + l3 + "[" + this.behindDropDFrames + ":" + this.behindDropPFrames + ":" + this.behindDropKFrames + ":" + this.behindDropAudio + "]";
            object = (String)object + " seq:" + l + "[" + this.behindSendSeqCount + "]";
            wMSLogger.debug("send: size:" + n2 + " ltc:" + this.flvCursor.getLastTC() + " atc:" + (this.flvCursor.getLastTC() + this.flvCursor.getStartTCOffset()));
            wMSLogger.debug((String)object);
        }
        if (playlistReaderWriteResults == null) return n2;
        if (n2 <= 0) return n2;
        playlistTracker = this.getSendPlaylistTracker(playlistTracker, false);
        playlistTracker.totalLen = n2;
        playlistTracker.firstTC = playlistReaderWriteResults.getFirstTC();
        playlistTracker.lastTC = playlistReaderWriteResults.getLastTC();
        playlistTracker.bufferTime = this.flvCursor.getLastSendBufferTime();
        playlistTracker.prevTracker = this.lastSentPlaylistTracker;
        this.lastSentPlaylistTracker = playlistTracker;
        clientWriteListener.getPendingTracker().putInfo(string, (Object)playlistTracker);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSeek(long l, int n) {
        block35: {
            if (this.playlist == null) {
                return;
            }
            if (this.playlist.size() <= 0) {
                return;
            }
            PlaylistNode playlistNode = this.playlist.get(this.playlistLoc);
            if (playlistNode != null) {
                IMediaStream iMediaStream = this.stream;
                synchronized (iMediaStream) {
                    long l2;
                    int n2;
                    if ((n == 1 || n == 2) && this.maxPendingSeekRequests > 0 && (n2 = this.getTrackerStartCount(this.stream)) > this.maxPendingSeekRequests) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("Insufficient Bandwidth [" + n2 + "," + this.maxPendingSeekRequests + "]", this.stream, "stream", "seek", 500, playlistNode.getName());
                        break block35;
                    }
                    long l3 = l;
                    int n3 = this.playlist.size();
                    if (n3 > 1) {
                        l2 = 0L;
                        int n4 = -1;
                        for (int i = 0; i < n3; ++i) {
                            PlaylistNode playlistNode2 = this.playlist.get(i);
                            long l4 = this.getNodeDuration(playlistNode2);
                            if (l <= l2 + l4 || i == n3 - 1) {
                                l3 -= l2;
                                n4 = i;
                                break;
                            }
                            l2 += l4;
                        }
                        if (this.playlistLoc != n4) {
                            if (this.mediaReader != null) {
                                this.mediaReader.close();
                            }
                            this.mediaReader = null;
                            this.playlistLoc = n4;
                            playlistNode = this.playlist.get(this.playlistLoc);
                        }
                    }
                    if (this.mediaReader == null) {
                        this.mediaReader = this.getMediaReader(playlistNode);
                    }
                    if (this.mediaReader == null) {
                        break block35;
                    }
                    if (!this.mediaReader.isOpen()) {
                        String string = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                        try {
                            this.mediaReader.open(string, playlistNode.getName());
                            this.flvCursor.setStartPlaying(true);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(PlaylistPlayer.class).error("seek: error opening file (" + string + "/" + playlistNode.getName() + "): " + exception.toString());
                        }
                    }
                    if (this.mediaReader.isOpen()) {
                        this.flvCursor.setSeeking(true);
                        this.flvCursor.setInterruptPlay();
                        if (!playlistNode.isStartTCValid()) {
                            this.getNodeDuration(playlistNode);
                        }
                        l2 = l3 += playlistNode.getStartTC();
                        IMediaReaderStreamPosition iMediaReaderStreamPosition = null;
                        long l5 = System.currentTimeMillis();
                        int n5 = this.flvCursor.getSeekVideoTarget();
                        if (this.flvCursor.getSeekTarget() == 1 && n == 2) {
                            n5 = 1;
                        }
                        PlaylistSeekResult playlistSeekResult = this.mediaReader.seek(l3, n5);
                        long l6 = System.currentTimeMillis();
                        if (playlistSeekResult == null) {
                            l2 = 0L;
                            this.mediaReader.rewind();
                        } else {
                            switch (this.flvCursor.getSeekTarget()) {
                                case 1: {
                                    boolean bl = playlistSeekResult.getVideoStreamPos() == null ? false : playlistSeekResult.getVideoStreamPos().isValid();
                                    iMediaReaderStreamPosition = null;
                                    if (bl) {
                                        l2 = playlistSeekResult.getResultVideoTimecode();
                                        this.mediaReader.setStreamPosition(playlistSeekResult.getVideoStreamPos());
                                        iMediaReaderStreamPosition = playlistSeekResult.getVideoStreamPos();
                                        break;
                                    }
                                    l2 = playlistSeekResult.getResultTimecode();
                                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                    break;
                                }
                                case 3: {
                                    l2 = playlistSeekResult.getResultTimecode();
                                    iMediaReaderStreamPosition = playlistSeekResult.getVideoStreamPos();
                                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                    break;
                                }
                                case 4: {
                                    l2 = playlistSeekResult.getResultTimecode();
                                    iMediaReaderStreamPosition = playlistSeekResult.getVideoStreamPos();
                                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                }
                            }
                        }
                        WMSLoggerFactory.getLogger(PlaylistSeeker.class).debug("seek seek(" + (l6 - l5) + "): searchFor:" + l + " result:" + l2);
                        this.flvCursor.setSeekType(n);
                        this.flvCursor.addSeekType(n);
                        this.flvCursor.setSeekReqLocation(l3);
                        this.flvCursor.setSeekResLocation(l2);
                        this.flvCursor.setSeekVideoStreamPos(iMediaReaderStreamPosition);
                        this.flvCursor.setSendAbsVideoTC(true);
                        this.flvCursor.setSendAbsBroadcastTC(true);
                        this.flvCursor.setSendAbsAudioTC(true);
                        this.flvCursor.setStartPlaying(true);
                        this.flvCursor.setFillBuffer(true);
                        long l7 = -1L;
                        if (playlistNode.getPlayLen() > 0.0) {
                            if (playlistNode.getStopTC() == -1L) {
                                long l8;
                                long l9 = 0L;
                                if (playlistNode.getPlayStart() > 0.0) {
                                    l9 = Math.round(playlistNode.getPlayStart());
                                }
                                if ((playlistSeekResult = this.mediaReader.seek(l7 = l9 + (l8 = Math.round(playlistNode.getPlayLen())), 4)) != null) {
                                    l7 = playlistSeekResult.getResultTimecode();
                                }
                                playlistNode.setStopTC(l7);
                            } else {
                                l7 = playlistNode.getStopTC();
                            }
                        }
                        this.flvCursor.setEndTC(l7);
                        this.flvCursor.setStartTCOffset(this.getNodeOffset(this.playlist, this.playlistLoc));
                        this.flvCursor.setSeeking(false);
                        WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(l2));
                        if (n == 2) {
                            this.stream.setSendPlayStopLogEvent(true);
                            this.setLoggingNode(playlistNode);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "unpause", 200, playlistNode.getName());
                            this.clearLoggingNode();
                        } else {
                            this.setLoggingNode(playlistNode);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "seek", 200, playlistNode.getName());
                            this.clearLoggingNode();
                        }
                    }
                }
            }
        }
    }

    public void seek(long l) {
        this.internalSeek(l, 1);
    }

    public void pauseRaw(int n, long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(int n, long l) {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            boolean bl = n == -1 ? this.stream.isPlaying() : n == 1;
            this.stream.setIsPlaying(!bl);
            if (bl) {
                PlaylistNode playlistNode = this.playlist.get(this.playlistLoc);
                this.stream.sendPauseNotify(l, playlistNode == null ? this.stream.getName() : playlistNode.getName());
                if (playlistNode != null) {
                    this.setLoggingNode(playlistNode);
                }
                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "pause", 200, playlistNode == null ? this.stream.getName() : playlistNode.getName());
                if (playlistNode != null) {
                    this.clearLoggingNode();
                }
            } else {
                this.internalSeek(l, 2);
            }
        }
    }

    public boolean play() {
        return this.playlist.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferTime(int n) {
        Object object = this.bufferTimeObj;
        synchronized (object) {
            this.bufferTime = n;
        }
    }

    public int getBufferTime() {
        return this.getBufferTime(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferTime(boolean bl) {
        int n = 0;
        Object object = this.bufferTimeObj;
        synchronized (object) {
            n = this.bufferTime;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptPlay() {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            this.flvCursor.setInterruptPlay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlay() {
        IMediaStream iMediaStream = this.stream;
        synchronized (iMediaStream) {
            this.flvCursor.setSeekType(0);
            this.flvCursor.addSeekType(0);
            this.flvCursor.setStartPlaying(true);
            this.flvCursor.setFillBuffer(true);
            MediaStreamFilePlay mediaStreamFilePlay = (MediaStreamFilePlay)this.stream.getPlayer();
            this.isThrottled = mediaStreamFilePlay.isThrottled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double length() {
        double d;
        block10: {
            d = 0.0;
            PlaylistNode playlistNode = this.playlist.get(this.playlistLoc);
            if (playlistNode == null) break block10;
            if (this.mediaReader == null) {
                this.mediaReader = this.getMediaReader(playlistNode);
            }
            if (this.mediaReader != null) {
                Object object;
                if (!this.mediaReader.isOpen()) {
                    object = this.stream;
                    synchronized (object) {
                        if (this.flvCursor.isBreakLoop() || !this.isOpen) {
                            break block10;
                        }
                        String string = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                        try {
                            this.mediaReader.open(string, playlistNode.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.mediaReader.isOpen()) {
                    object = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                    d = (double)this.mediaReader.getDuration() / 1000.0;
                }
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        long l;
        block10: {
            l = 0L;
            PlaylistNode playlistNode = this.playlist.get(this.playlistLoc);
            if (playlistNode == null) break block10;
            if (this.mediaReader == null) {
                this.mediaReader = this.getMediaReader(playlistNode);
            }
            if (this.mediaReader != null) {
                Object object;
                if (!this.mediaReader.isOpen()) {
                    object = this.stream;
                    synchronized (object) {
                        if (this.flvCursor.isBreakLoop() || !this.isOpen) {
                            break block10;
                        }
                        String string = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                        try {
                            this.mediaReader.open(string, playlistNode.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.mediaReader.isOpen()) {
                    object = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                    l = this.mediaReader.getLength();
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoggingValues() {
        block15: {
            PlaylistNode playlistNode = this.getLoggingNode();
            if (playlistNode == null) break block15;
            if (this.mediaReader == null) {
                this.mediaReader = this.getMediaReader(playlistNode);
            }
            if (this.mediaReader != null) {
                String string;
                Object object;
                if (!this.mediaReader.isOpen()) {
                    object = this.stream;
                    synchronized (object) {
                        if (this.flvCursor.isBreakLoop() || !this.isOpen) {
                            break block15;
                        }
                        string = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                        try {
                            this.mediaReader.open(string, playlistNode.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.mediaReader.isOpen()) {
                    object = this.stream.getStreams().getAppInstance().getStreamStoragePath();
                    WMSLoggerFactory.putGlobalLogValue((String)"x-file-name", (Object)this.mediaReader.getPath());
                    WMSLoggerFactory.putGlobalLogValue((String)"x-file-ext", (Object)this.mediaReader.getMediaExtension());
                    WMSLoggerFactory.putGlobalLogValue((String)"x-file-size", (Object)new Long(this.mediaReader.getLength()));
                    WMSLoggerFactory.putGlobalLogValue((String)"x-file-length", (Object)new Double((double)this.mediaReader.getDuration() / 1000.0));
                    WMSLoggerFactory.putGlobalLogValue((String)"x-sname", (Object)playlistNode.getName());
                    if (WMSLoggerFactory.getGlobalLogValue((String)"x-ctx-override") != null) {
                        WMSLoggerFactory.putGlobalLogValue((String)"x-ctx", (Object)WMSLoggerFactory.getGlobalLogValue((String)"x-ctx-override"));
                    } else {
                        WMSLoggerFactory.putGlobalLogValue((String)"x-ctx", (Object)playlistNode.getName());
                    }
                    if (!WMSLoggerFactory.isGlobalLogValueSet((String)"x-spos")) {
                        WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(this.flvCursor.getLastTC()));
                    }
                    string = this.stream.getClient().getUri() + "/" + playlistNode.getName() + "." + this.mediaReader.getMediaExtension();
                    WMSLoggerFactory.putGlobalLogValue((String)"x-suri-stem", (Object)string);
                    String string2 = playlistNode.getQueryStr();
                    if (string2.length() > 0) {
                        WMSLoggerFactory.putGlobalLogValue((String)"x-suri-query", (Object)string2);
                        WMSLoggerFactory.putGlobalLogValue((String)"x-sname-query", (Object)string2);
                        string = string + "?" + string2;
                    } else {
                        WMSLoggerFactory.removeGlobalLogValue((String)"x-suri-query");
                        WMSLoggerFactory.removeGlobalLogValue((String)"x-sname-query");
                    }
                    WMSLoggerFactory.putGlobalLogValue((String)"x-suri", (Object)string);
                }
            }
        }
    }

    public int getSeekTarget() {
        return this.flvCursor.getSeekTarget();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    class PlaylistSwitch {
        String name = null;
        String oldName = null;
        String ext = null;
        String queryStr = null;
        double playStart = 0.0;
        double playLen = 0.0;
        int playTransition = 0;

        public PlaylistSwitch(String string, String string2, String string3, String string4, double d, double d2, int n) {
            this.name = string;
            this.oldName = string2;
            this.ext = string3;
            this.queryStr = string4;
            this.playStart = d;
            this.playLen = d2;
            this.playTransition = n;
        }

        public String toString() {
            return "{PlaylistSwitch: name:\"" + this.name + "\"}";
        }
    }

    class PlaylistTracker {
        long totalLen = 0L;
        long firstTC = -1L;
        long lastTC = -1L;
        long trackerSeq = 0L;
        boolean isStart = false;
        int bufferTime = 0;
        PlaylistTracker prevTracker = null;

        public PlaylistTracker() {
            this.trackerSeq = ++PlaylistPlayer.this.trackerSeqSource;
        }
    }
}

