/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.HTTPStreamerMediaCasterStreamLock;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerSessionBase
implements IHTTPStreamerSession {
    private boolean isValidated = false;
    protected String sessionId = null;
    protected int sessionType = 0;
    protected int sessionProtocol = -1;
    protected IVHost vhost = null;
    protected IApplicationInstance appInstance = null;
    protected boolean timeoutSession = false;
    protected int sessionTimeout = 20000;
    protected long lastRequest = -1L;
    protected long firstCheck = -1L;
    protected Object lock = new Object();
    protected boolean isActive = true;
    protected boolean acceptSession = true;
    protected IMediaStream stream = null;
    protected boolean isPlayLogged = false;
    protected IOPerformanceCounter totalIOPerformanceLast = new IOPerformanceCounter();
    protected IOPerformanceCounter totalIOPerformance2Last = new IOPerformanceCounter();
    protected ConnectionHolder connectionHolder = new ConnectionHolder(null);
    protected IHTTPStreamerAdapter httpStreamerAdapter = null;
    protected String liveStreamingPacketizer = null;
    protected String ipAddress = null;
    protected Map<String, HTTPStreamerStreamNameParts> streamNamePartMap = new HashMap<String, HTTPStreamerStreamNameParts>();
    protected String streamName = null;
    protected String streamExt = null;
    protected String serverIp = null;
    protected int serverPort = 80;
    protected String userAgent = null;
    protected String uri = null;
    protected String referrer = null;
    protected String queryStr = null;
    protected String cookieStr = null;
    protected HTTPStreamerMediaCasterStreamLock mediaCasterStreamLock = new HTTPStreamerMediaCasterStreamLock();
    protected long streamPosition = 0L;
    protected IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    protected Set<String> streamDomainStrSet = new HashSet<String>();
    protected ElapsedTimer elapsedTime = new ElapsedTimer();
    protected Map<String, HTTPStreamerFileInfo> fileInfoMap = new HashMap<String, HTTPStreamerFileInfo>();

    public String getStreamDomainStr(IApplicationInstance iApplicationInstance, String string) {
        return iApplicationInstance.getVHost().getName() + ":" + iApplicationInstance.getContextStr() + "/" + string;
    }

    @Override
    public void lockRepeaterStreams(List<String> list, String string, String string2, String string3) {
        this.mediaCasterStreamLock.lockRepeaterStreams(list, this.appInstance, string, string2, string3);
    }

    private void unlockRepeaterStreams() {
        this.mediaCasterStreamLock.unlockRepeaterStreams(this.appInstance);
    }

    @Override
    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String string) {
        this.sessionId = string;
    }

    @Override
    public IVHost getVHost() {
        return this.vhost;
    }

    @Override
    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.lastRequest = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimeout(long l) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.firstCheck == -1L) {
                this.firstCheck = l;
            }
            if (this.timeoutSession) {
                if (this.lastRequest >= 0L) {
                    if (l - this.lastRequest > (long)this.sessionTimeout) {
                        bl = true;
                    }
                } else if (l - this.firstCheck > (long)this.sessionTimeout) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isActive = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.isActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.httpStreamerAdapter != null) {
            this.httpStreamerAdapter.shutdownSession(this);
        }
        this.unlockRepeaterStreams();
        IMediaStream iMediaStream = null;
        Object object = this.lock;
        synchronized (object) {
            iMediaStream = this.stream;
        }
        if (iMediaStream != null && this.isPlayLogged()) {
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, iMediaStream.getName());
            this.setPlayLogged(false);
        }
        object = this.lock;
        synchronized (object) {
            this.isActive = false;
            this.stream = null;
        }
        object = null;
        if (iMediaStream != null) {
            iMediaStream.close();
            MediaStreamMap mediaStreamMap = iMediaStream.getStreams();
            object = mediaStreamMap.getAppInstance();
            object.removeHTTPStreamerSession(this);
            mediaStreamMap.removeStream(iMediaStream.getSrc());
            iMediaStream.setHTTPStreamerSession(null);
        }
    }

    @Override
    public IMediaStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimeoutSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.timeoutSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeoutSession(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.timeoutSession = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.sessionTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.sessionTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidated() {
        Object object = this.lock;
        synchronized (object) {
            return this.isValidated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidated(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isValidated = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndSetPlayLogged() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            bl = this.isPlayLogged;
            if (!bl) {
                this.isPlayLogged = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlayLogged() {
        Object object = this.lock;
        synchronized (object) {
            return this.isPlayLogged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlayLogged(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isPlayLogged = bl;
        }
    }

    @Override
    public void addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        if (this.stream != null) {
            IOPerformanceCounter iOPerformanceCounter2 = this.stream.getMediaIOPerformance().clone();
            iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformanceLast);
            this.totalIOPerformanceLast = iOPerformanceCounter2;
        }
    }

    @Override
    public void addIOPerformance2(IOPerformanceCounter iOPerformanceCounter) {
        if (this.stream != null) {
            IOPerformanceCounter iOPerformanceCounter2 = this.stream.getMediaIOPerformance().clone();
            iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformance2Last);
            this.totalIOPerformance2Last = iOPerformanceCounter2;
        }
    }

    @Override
    public IHTTPStreamerAdapter getHTTPStreamerAdapter() {
        return this.httpStreamerAdapter;
    }

    @Override
    public void setHTTPStreamerAdapter(IHTTPStreamerAdapter iHTTPStreamerAdapter) {
        this.httpStreamerAdapter = iHTTPStreamerAdapter;
    }

    @Override
    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    @Override
    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    @Override
    public int getSessionType() {
        return this.sessionType;
    }

    @Override
    public void setSessionType(int n) {
        this.sessionType = n;
    }

    @Override
    public String getLiveStreamingPacketizer() {
        return this.liveStreamingPacketizer;
    }

    @Override
    public void setLiveStreamingPacketizer(String string) {
        this.liveStreamingPacketizer = string;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    @Override
    public void updateLoggingValues() {
        String string;
        WMSLoggerFactory.putGlobalLogValue("c-client-id", new Integer(Integer.parseInt(this.getSessionId())));
        WMSLoggerFactory.putGlobalLogValue("c-ip", this.getIpAddress());
        WMSLoggerFactory.putGlobalLogValue("c-proto", "http (streamer)");
        WMSLoggerFactory.putGlobalLogValue("x-app", this.appInstance.getApplication().getName());
        WMSLoggerFactory.putGlobalLogValue("x-appinst", this.appInstance.getName());
        WMSLoggerFactory.putGlobalLogValue("x-vhost", this.getVHost().getName());
        String string2 = this.getUri();
        String string3 = this.getQueryStr();
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        if ((string = this.getReferrer()) == null) {
            string = "";
        }
        string.replace("|", "%7c");
        String string4 = "http://" + this.serverIp + ":" + this.serverPort + "/";
        WMSLoggerFactory.putGlobalLogValue("s-uri", string4 + string2);
        WMSLoggerFactory.putGlobalLogValue("cs-uri-stem", string4 + this.getUri());
        WMSLoggerFactory.putGlobalLogValue("x-suri", string4 + string2);
        WMSLoggerFactory.putGlobalLogValue("x-suri-stem", string4 + this.getUri());
        WMSLoggerFactory.putGlobalLogValue("x-sname", this.streamName);
        if (string3 != null) {
            WMSLoggerFactory.putGlobalLogValue("x-suri-query", string3);
            WMSLoggerFactory.putGlobalLogValue("x-sname-query", string3);
            WMSLoggerFactory.putGlobalLogValue("cs-uri-query", string3);
        } else {
            WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
            WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
            WMSLoggerFactory.removeGlobalLogValue("cs-uri-query");
        }
        WMSLoggerFactory.putGlobalLogValue("c-referrer", this.referrer);
        WMSLoggerFactory.putGlobalLogValue("c-user-agent", this.userAgent);
        WMSLoggerFactory.putGlobalLogValue("s-ip", this.serverIp);
        WMSLoggerFactory.putGlobalLogValue("s-port", this.serverPort);
        HTTPStreamerFileInfo hTTPStreamerFileInfo = this.getFileInfo(this.streamName);
        if (hTTPStreamerFileInfo != null) {
            WMSLoggerFactory.putGlobalLogValue("x-file-name", hTTPStreamerFileInfo.getFileName());
            WMSLoggerFactory.putGlobalLogValue("x-file-ext", hTTPStreamerFileInfo.getFileExt());
            WMSLoggerFactory.putGlobalLogValue("x-file-size", new Long(hTTPStreamerFileInfo.getFileSize()));
            WMSLoggerFactory.putGlobalLogValue("x-file-length", new Double(hTTPStreamerFileInfo.getFileLength()));
        }
        WMSLoggerFactory.putGlobalLogValue("sc-bytes", new Long(this.ioPerformanceCounter.getMessagesOutBytes()));
        WMSLoggerFactory.putGlobalLogValue("cs-bytes", new Long(this.ioPerformanceCounter.getMessagesInBytes()));
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
        WMSLoggerFactory.putGlobalLogValue("x-spos", new Long(this.streamPosition));
    }

    @Override
    public void clearLoggingValues() {
        WMSLoggerFactory.removeGlobalLogValue("c-client-id");
        WMSLoggerFactory.removeGlobalLogValue("c-ip");
        WMSLoggerFactory.removeGlobalLogValue("c-proto");
        WMSLoggerFactory.removeGlobalLogValue("x-app");
        WMSLoggerFactory.removeGlobalLogValue("x-appinst");
        WMSLoggerFactory.removeGlobalLogValue("x-vhost");
        WMSLoggerFactory.removeGlobalLogValue("s-uri");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-stem");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-query");
        WMSLoggerFactory.removeGlobalLogValue("c-referrer");
        WMSLoggerFactory.removeGlobalLogValue("c-user-agent");
        WMSLoggerFactory.removeGlobalLogValue("s-ip");
        WMSLoggerFactory.removeGlobalLogValue("s-port");
        WMSLoggerFactory.removeGlobalLogValue("x-file-name");
        WMSLoggerFactory.removeGlobalLogValue("x-file-ext");
        WMSLoggerFactory.removeGlobalLogValue("x-file-size");
        WMSLoggerFactory.removeGlobalLogValue("x-file-length");
        WMSLoggerFactory.removeGlobalLogValue("sc-bytes");
        WMSLoggerFactory.removeGlobalLogValue("cs-bytes");
        WMSLoggerFactory.removeGlobalLogValue("x-spos");
        WMSLoggerFactory.removeGlobalLogValue("x-suri");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-stem");
        WMSLoggerFactory.removeGlobalLogValue("x-sname");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
        WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
    }

    @Override
    public int getSessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void setSessionProtocol(int n) {
        this.sessionProtocol = n;
    }

    @Override
    public String getServerIp() {
        return this.serverIp;
    }

    @Override
    public void setServerIp(String string) {
        this.serverIp = string;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(int n) {
        this.serverPort = n;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String string) {
        this.uri = string;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public void setReferrer(String string) {
        this.referrer = string;
    }

    @Override
    public String getQueryStr() {
        return this.queryStr;
    }

    @Override
    public void setQueryStr(String string) {
        this.queryStr = string;
    }

    @Override
    public void rejectSession() {
        this.acceptSession = false;
    }

    @Override
    public void acceptSession() {
        this.acceptSession = true;
    }

    @Override
    public boolean isAcceptSession() {
        return this.acceptSession;
    }

    @Override
    public void setAcceptSession(boolean bl) {
        this.acceptSession = bl;
    }

    @Override
    public String getCookieStr() {
        return this.cookieStr;
    }

    @Override
    public void setCookieStr(String string) {
        this.cookieStr = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPStreamerStreamNameParts getStreamNameParts(String string) {
        Map<String, HTTPStreamerStreamNameParts> map = this.streamNamePartMap;
        synchronized (map) {
            return this.streamNamePartMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsStreamNameParts(String string) {
        Map<String, HTTPStreamerStreamNameParts> map = this.streamNamePartMap;
        synchronized (map) {
            return this.streamNamePartMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putStreamNameParts(String string, HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts) {
        Map<String, HTTPStreamerStreamNameParts> map = this.streamNamePartMap;
        synchronized (map) {
            this.streamNamePartMap.put(string, hTTPStreamerStreamNameParts);
        }
    }

    @Override
    public long getStreamPosition() {
        return this.streamPosition;
    }

    @Override
    public void setStreamPosition(long l) {
        this.streamPosition = l;
    }

    @Override
    public IOPerformanceCounter getIOPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPStreamerFileInfo getFileInfo(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.fileInfoMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFileInfo(String string, HTTPStreamerFileInfo hTTPStreamerFileInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.fileInfoMap.put(string, hTTPStreamerFileInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileInfo(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.fileInfoMap.containsKey(string);
        }
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public void setStreamName(String string) {
        this.streamName = string;
    }

    @Override
    public String getStreamExt() {
        return this.streamExt;
    }

    @Override
    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidStreamDomainStr(String string) {
        Set<String> set = this.streamDomainStrSet;
        synchronized (set) {
            return this.streamDomainStrSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsStreamDomainStr(String string) {
        Set<String> set = this.streamDomainStrSet;
        synchronized (set) {
            return this.streamDomainStrSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStreamDomainStr(String string) {
        String string2 = string;
        synchronized (string2) {
            this.streamDomainStrSet.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStreamDomainStrs(List<String> list) {
        Set<String> set = this.streamDomainStrSet;
        synchronized (set) {
            for (String string : list) {
                String string2 = this.getStreamDomainStr(this.appInstance, string);
                this.streamDomainStrSet.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStreamDomainStr(String string) {
        String string2 = string;
        synchronized (string2) {
            this.streamDomainStrSet.add(string);
        }
    }

    @Override
    public ElapsedTimer getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }
}

