/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FrameRecommendedBufferSize
extends ID3V2FrameBase {
    private int bufferSize = 10000;
    private byte embeddedFlag = 0;
    private long offsetToNextTag = 0L;

    public ID3V2FrameRecommendedBufferSize(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameRecommendedBufferSize() {
        super("RBUF", 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            BufferUtils.intToByteArray(this.bufferSize, byArray, n + n2, 3);
            byArray[n + (n2 += 3)] = (byte)(this.embeddedFlag & 0xFF);
            BufferUtils.longToByteArray(this.offsetToNextTag, byArray, n + ++n2, 4);
            n2 += 4;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 3 < n2) {
                this.bufferSize = BufferUtils.byteArrayToInt(byArray, n, 3);
                if ((n += 3) + 1 < n2) {
                    this.embeddedFlag = (byte)(byArray[n] & 0xFF);
                    if (++n + 4 < n2) {
                        this.offsetToNextTag = BufferUtils.byteArrayToLong(byArray, n, 4);
                        n += 4;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return 8;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public byte getEmbeddedFlag() {
        return this.embeddedFlag;
    }

    public void setEmbeddedFlag(byte by) {
        this.embeddedFlag = by;
    }

    public long getOffsetToNextTag() {
        return this.offsetToNextTag;
    }

    public void setOffsetToNextTag(long l) {
        this.offsetToNextTag = l;
    }
}

