/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.MD5DigestUtils;
import com.wowza.util.NetworkUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterConnection;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasic;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPConnection;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPHandler;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPRequest;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPResponse;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPSingleton;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.server.RtmpLeftover;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.util.RTCPUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class RTPSessionDescriptionDataProviderBasicRTSPWorker {
    public static final int MSGBUFFER_SIZE = 2048;
    public static final String[] RTSP_COMMANDS = new String[]{"DESCRIBE", "SETUP", "TEARDOWN", "PLAY", "PAUSE", "OPTIONS", "ANNOUNCE", "RECORD", "REDIRECT", "GET_PARAMETER", "SET_PARAMETER"};
    private IApplicationInstance appInstance = null;
    private String sdpData = null;
    private String sdpDataTmp = null;
    private String rtspURL = null;
    private RTPSessionDescriptionDataProviderBasicRTSPConnection rtspConnection;
    private IoSession session = null;
    private RTPSessionDescriptionDataProviderBasicRTSPHandler handler;
    private int cseq = 1;
    private byte[] msgBuffer = null;
    private int msgExtent = 0;
    private int msgPosition = 0;
    private TreeMap<Integer, RTPSessionDescriptionDataProviderBasicRTSPRequest> requests = new TreeMap();
    private List<String> tracks = new ArrayList<String>();
    private Map<String, RTSPTrack> trackMap = new HashMap<String, RTSPTrack>();
    private int trackPosition = 0;
    private String sessionId = null;
    private int sessionTimeout = 0;
    private int rtspValidationFrequency = 15000;
    private boolean rtspFilterUnknownTracks = false;
    private String rtspBindIpAddress = null;
    private int rtspBlockSize = 0;
    private List<Integer> portPairs = new ArrayList<Integer>();
    private Set<String> rtspCommands = new HashSet<String>();
    private RTPSessionDescriptionDataProviderBasic rtpBasicDataProvider = null;
    private long lastPingTime = -1L;
    private int pingFrequency = 30000;
    private String userInfo = null;
    private boolean forceInterleaved = false;
    private boolean rtspUseContentBase = true;
    private RtmpLeftover leftover = null;
    private int interleaveIndex = 0;
    private RTPSession rtpSession = null;
    private Map<Integer, TrackHolder> interleavePortMap = new HashMap<Integer, TrackHolder>();
    private List<PenndingInterleaveMessage> pendingInterleaveMessages = new ArrayList<PenndingInterleaveMessage>();
    private String contentBase = null;
    private boolean msgRunning = false;
    private Object msgLock = new Object();
    private List<ByteBuffer> msgList = new ArrayList<ByteBuffer>();

    public RTPSessionDescriptionDataProviderBasicRTSPWorker(RTPSessionDescriptionDataProviderBasic rTPSessionDescriptionDataProviderBasic, IApplicationInstance iApplicationInstance) {
        this.rtpBasicDataProvider = rTPSessionDescriptionDataProviderBasic;
        this.appInstance = iApplicationInstance;
        this.rtspConnection = RTPSessionDescriptionDataProviderBasicRTSPConnection.getInstance();
        this.handler = new RTPSessionDescriptionDataProviderBasicRTSPHandler(this);
        WMSProperties wMSProperties = iApplicationInstance.getMediaCasterProperties();
        if (wMSProperties != null) {
            this.rtspValidationFrequency = wMSProperties.getPropertyInt("rtspValidationFrequency", this.rtspValidationFrequency);
            this.rtspBindIpAddress = wMSProperties.getPropertyStr("rtspBindIpAddress", this.rtspBindIpAddress);
            this.rtspBlockSize = wMSProperties.getPropertyInt("rtspBlockSize", this.rtspBlockSize);
            this.forceInterleaved = wMSProperties.getPropertyBoolean("forceInterleaved", this.forceInterleaved);
            this.rtspUseContentBase = wMSProperties.getPropertyBoolean("rtspUseContentBase", this.rtspUseContentBase);
            this.rtspFilterUnknownTracks = wMSProperties.getPropertyBoolean("rtspFilterUnknownTracks", this.rtspFilterUnknownTracks);
        }
        for (int i = 0; i < RTSP_COMMANDS.length; ++i) {
            this.rtspCommands.add(RTSP_COMMANDS[i].toLowerCase());
        }
    }

    public synchronized void sendPing() {
        try {
            RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setCommand("OPTIONS");
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setTarget(this.rtspURL);
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setCSeq(this.cseq);
            if (this.sessionId != null) {
                rTPSessionDescriptionDataProviderBasicRTSPRequest.addHeader("Session", this.sessionId);
            }
            this.requests.put(new Integer(this.cseq), rTPSessionDescriptionDataProviderBasicRTSPRequest);
            ++this.cseq;
            this.rtpBasicDataProvider.rtspMessageHook(rTPSessionDescriptionDataProviderBasicRTSPRequest);
            byte[] byArray = rTPSessionDescriptionDataProviderBasicRTSPRequest.getMessage();
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send(open): command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand());
            this.session.write((Object)ByteBuffer.wrap((byte[])byArray));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.sendPing: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(IoSession ioSession) {
        try {
            RTPSessionDescriptionDataProviderBasicRTSPWorker rTPSessionDescriptionDataProviderBasicRTSPWorker = this;
            synchronized (rTPSessionDescriptionDataProviderBasicRTSPWorker) {
                RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setCommand("DESCRIBE");
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setTarget(this.rtspURL);
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setCSeq(this.cseq);
                rTPSessionDescriptionDataProviderBasicRTSPRequest.addHeader("Accept", "application/sdp");
                this.requests.put(new Integer(this.cseq), rTPSessionDescriptionDataProviderBasicRTSPRequest);
                ++this.cseq;
                this.rtpBasicDataProvider.rtspMessageHook(rTPSessionDescriptionDataProviderBasicRTSPRequest);
                byte[] byArray = rTPSessionDescriptionDataProviderBasicRTSPRequest.getMessage();
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send(open): command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand());
                ioSession.write((Object)ByteBuffer.wrap((byte[])byArray));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.onOpen: " + exception.toString());
            exception.printStackTrace();
        }
        RTPSessionDescriptionDataProviderBasicRTSPSingleton.addSession(this.rtspURL, ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(IoSession ioSession) {
        RTPSessionDescriptionDataProviderBasicRTSPWorker rTPSessionDescriptionDataProviderBasicRTSPWorker = this;
        synchronized (rTPSessionDescriptionDataProviderBasicRTSPWorker) {
            this.session = null;
        }
        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.onClose");
        RTPSessionDescriptionDataProviderBasicRTSPSingleton.removeSession(this.rtspURL, ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(IoSession ioSession, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = null;
        Object object = this.msgLock;
        synchronized (object) {
            this.msgList.add(byteBuffer);
            if (!this.msgRunning) {
                byteBuffer2 = this.msgList.remove(0);
                this.msgRunning = true;
            }
        }
        while (true) {
            if (this.forceInterleaved) {
                object = this;
                synchronized (object) {
                    this.decodeMessageInterleaved(ioSession, byteBuffer2);
                }
                for (PenndingInterleaveMessage penndingInterleaveMessage : this.pendingInterleaveMessages) {
                    penndingInterleaveMessage.handler.handleMessage(null, penndingInterleaveMessage.buffer, penndingInterleaveMessage.offset, penndingInterleaveMessage.len);
                }
                this.pendingInterleaveMessages.clear();
            } else {
                object = this;
                synchronized (object) {
                    this.decodeMessage(ioSession, byteBuffer2);
                }
            }
            object = this.msgLock;
            synchronized (object) {
                if (this.msgList.size() <= 0) {
                    this.msgRunning = false;
                    break;
                }
                byteBuffer2 = this.msgList.remove(0);
            }
        }
    }

    public void decodeMessageInterleaved(IoSession ioSession, ByteBuffer byteBuffer) {
        Object object;
        Object object2;
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.limit();
        int n2 = 0;
        if (this.leftover != null) {
            object2 = this.leftover;
            this.leftover = null;
            object = new byte[n + ((RtmpLeftover)object2).len];
            System.arraycopy(((RtmpLeftover)object2).buffer, ((RtmpLeftover)object2).offset, object, 0, ((RtmpLeftover)object2).len);
            System.arraycopy(byArray, 0, object, ((RtmpLeftover)object2).len, n);
            byArray = object;
            n = byArray.length;
        }
        do {
            if (byArray[n2] == 36) {
                if (n - n2 < 4) break;
                int n3 = byArray[n2 + 2] & 0xFF;
                n3 <<= 8;
                if (n - n2 < (n3 += byArray[n2 + 3] & 0xFF) + 4) break;
                int n4 = byArray[n2 + 1] & 0xFF;
                TrackHolder trackHolder = this.interleavePortMap.get(new Integer(n4));
                if (trackHolder != null) {
                    PenndingInterleaveMessage penndingInterleaveMessage = new PenndingInterleaveMessage();
                    penndingInterleaveMessage.buffer = byArray;
                    penndingInterleaveMessage.offset = n2 + 4;
                    penndingInterleaveMessage.len = n3;
                    penndingInterleaveMessage.handler = trackHolder.handler;
                    this.pendingInterleaveMessages.add(penndingInterleaveMessage);
                    if (trackHolder.firstMessage) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("firstPacket: TCP:$" + n4);
                        trackHolder.firstMessage = false;
                    }
                }
                n2 += n3 + 4;
                continue;
            }
            object2 = RTSPRequestMessage.quickParseHeader(byArray, n2, n - n2);
            if (object2 == null || n - n2 < object2[0] + object2[1]) break;
            this.processMessage(ioSession, byArray, n2, (int)(object2[0] + object2[1]));
            n2 += object2[0] + object2[1];
        } while (n2 < n);
        if (n2 < n) {
            byte[] byArray2 = new byte[n - n2];
            System.arraycopy(byArray, n2, byArray2, 0, n - n2);
            object = new RtmpLeftover();
            object.buffer = byArray2;
            object.offset = 0;
            object.len = byArray2.length;
            this.leftover = object;
        }
    }

    public synchronized void decodeMessage(IoSession ioSession, ByteBuffer byteBuffer) {
        try {
            if (byteBuffer != null) {
                int n = byteBuffer.remaining();
                if (this.msgBuffer == null) {
                    this.msgPosition = 0;
                    this.msgExtent = 0;
                    this.msgBuffer = new byte[Math.max(2048, n)];
                }
                if (this.msgExtent + n > this.msgBuffer.length) {
                    byte[] byArray = new byte[this.msgExtent + n];
                    System.arraycopy(this.msgBuffer, 0, byArray, 0, this.msgExtent);
                    this.msgBuffer = byArray;
                }
                byteBuffer.get(this.msgBuffer, this.msgExtent, n);
                this.msgExtent += n;
                int n2 = this.processMessage(ioSession, this.msgBuffer, this.msgPosition, this.msgExtent - this.msgPosition);
                this.msgPosition += n2;
                if (this.msgPosition == this.msgExtent) {
                    this.msgPosition = 0;
                    this.msgExtent = 0;
                    this.msgBuffer = null;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.onMessage: " + exception.toString());
        }
    }

    private int processMessage(IoSession ioSession, byte[] byArray, int n, int n2) {
        int n3 = 0;
        ArrayList<RTPSessionDescriptionDataProviderBasicRTSPResponse> arrayList = new ArrayList<RTPSessionDescriptionDataProviderBasicRTSPResponse>();
        try {
            int n4;
            while ((n4 = RTPSessionDescriptionDataProviderBasicRTSPResponse.getResponseLength(byArray, n, n2)) != 0 && n4 <= n2) {
                RTPSessionDescriptionDataProviderBasicRTSPResponse rTPSessionDescriptionDataProviderBasicRTSPResponse = new RTPSessionDescriptionDataProviderBasicRTSPResponse();
                rTPSessionDescriptionDataProviderBasicRTSPResponse.parseMessage(byArray, n, n4);
                arrayList.add(rTPSessionDescriptionDataProviderBasicRTSPResponse);
                n += n4;
                n3 += n4;
                if ((n2 -= n4) != 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processMessage: " + exception.toString());
        }
        try {
            for (RTPSessionDescriptionDataProviderBasicRTSPResponse rTPSessionDescriptionDataProviderBasicRTSPResponse : arrayList) {
                this.processResponse(ioSession, rTPSessionDescriptionDataProviderBasicRTSPResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processMessage: " + exception.toString());
        }
        return n3;
    }

    private void processResponse(IoSession ioSession, RTPSessionDescriptionDataProviderBasicRTSPResponse rTPSessionDescriptionDataProviderBasicRTSPResponse) {
        try {
            int n = rTPSessionDescriptionDataProviderBasicRTSPResponse.getCSeq();
            if (n < 0) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: CSeq less than zero");
            } else {
                String string = rTPSessionDescriptionDataProviderBasicRTSPResponse.getProtocol();
                WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class);
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("*** RTSPMessageReceive ***\n" + rTPSessionDescriptionDataProviderBasicRTSPResponse.toString());
                }
                if (string.equalsIgnoreCase("GET_PARAMETER")) {
                    Object object;
                    if (this.sessionId == null && (object = rTPSessionDescriptionDataProviderBasicRTSPResponse.getSessionId()) != null) {
                        this.sessionId = object;
                        this.sessionTimeout = rTPSessionDescriptionDataProviderBasicRTSPResponse.getSessionTimeout();
                    }
                    object = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).setCommand(rTPSessionDescriptionDataProviderBasicRTSPResponse.getResponse());
                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).setTarget("200");
                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).setProtocol("OK");
                    if (this.sessionId != null) {
                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).addHeader("Session", this.sessionId);
                    }
                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).setCSeq(rTPSessionDescriptionDataProviderBasicRTSPResponse.getCSeq());
                    this.rtpBasicDataProvider.rtspMessageHook((RTPSessionDescriptionDataProviderBasicRTSPRequest)object);
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: pingResponse:" + ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).getCommand() + " " + ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).getTarget() + " " + ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).getProtocol() + " CSeq:" + rTPSessionDescriptionDataProviderBasicRTSPResponse.getCSeq() + " Session:" + this.sessionId);
                    ioSession.write((Object)ByteBuffer.wrap((byte[])((RTPSessionDescriptionDataProviderBasicRTSPRequest)object).getMessage()));
                } else {
                    RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = this.requests.get(new Integer(n));
                    if (rTPSessionDescriptionDataProviderBasicRTSPRequest == null) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: request missing: CSeq: " + n);
                    } else {
                        this.processResponse(ioSession, rTPSessionDescriptionDataProviderBasicRTSPRequest, rTPSessionDescriptionDataProviderBasicRTSPResponse);
                        --n;
                        while (this.requests.remove(new Integer(n)) != null) {
                            --n;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: " + exception.toString());
        }
    }

    private void processResponse(IoSession ioSession, RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest, RTPSessionDescriptionDataProviderBasicRTSPResponse rTPSessionDescriptionDataProviderBasicRTSPResponse) {
        block98: {
            try {
                Object object;
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand() + " response:" + rTPSessionDescriptionDataProviderBasicRTSPResponse.getHeader("uri") + " status:" + rTPSessionDescriptionDataProviderBasicRTSPResponse.getStatus() + " handled:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.isHandled());
                if (rTPSessionDescriptionDataProviderBasicRTSPRequest.isHandled()) break block98;
                int n = rTPSessionDescriptionDataProviderBasicRTSPResponse.getStatus();
                if (this.sessionId == null && (object = rTPSessionDescriptionDataProviderBasicRTSPResponse.getSessionId()) != null) {
                    this.sessionId = object;
                    this.sessionTimeout = rTPSessionDescriptionDataProviderBasicRTSPResponse.getSessionTimeout();
                }
                object = this.appInstance.getVHost();
                RTPContext rTPContext = object.getRTPContext();
                if (n == 401) {
                    if (rTPSessionDescriptionDataProviderBasicRTSPRequest.isAuthResponse()) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).warn("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: Authentication required[" + n + "]: Authorization failed.");
                    } else if (this.userInfo != null) {
                        String string162;
                        int n2 = this.userInfo.indexOf(":");
                        String string2 = this.userInfo;
                        String string3 = "";
                        if (n2 >= 0) {
                            string3 = this.userInfo.substring(n2 + 1);
                            string2 = this.userInfo.substring(0, n2);
                        }
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        List<String> list = rTPSessionDescriptionDataProviderBasicRTSPResponse.getHeaderList("www-authenticate");
                        for (String string162 : list) {
                            if (string162.toLowerCase().startsWith("digest ")) {
                                string4 = string162;
                            } else if (string162.toLowerCase().startsWith("basic ")) {
                                string5 = string162;
                            }
                            string6 = string162;
                        }
                        if (string4 != null) {
                            Object object2;
                            string162 = string4.substring("digest ".length());
                            Map<String, String> map = AuthenticationUtils.parseAuthenticationValues(string162);
                            String string15 = null;
                            String rTPSessionDescriptionDataProviderBasicRTSPRequest3 = null;
                            String object6 = null;
                            String object5 = null;
                            String n4 = null;
                            String string18 = null;
                            try {
                                URI exception = new URI(this.rtspURL);
                                object2 = new URI(exception.getScheme(), null, exception.getHost(), exception.getPort(), exception.getPath(), exception.getQuery(), exception.getFragment());
                                string18 = ((URI)object2).toString();
                            }
                            catch (Exception bl4) {
                                // empty catch block
                            }
                            String n9 = rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand();
                            string15 = map.get("realm");
                            rTPSessionDescriptionDataProviderBasicRTSPRequest3 = map.get("nonce");
                            object6 = map.get("nc");
                            object5 = map.get("cnonce");
                            n4 = map.get("qop");
                            if (map.containsKey("uri")) {
                                string18 = map.get("uri");
                            }
                            object2 = MD5DigestUtils.generateAuth(n9, string18, string2, string3, string15, rTPSessionDescriptionDataProviderBasicRTSPRequest3, n4, object6, object5);
                            String string = "";
                            string = string + " username=\"" + string2 + "\"";
                            string = string + " realm=\"" + string15 + "\"";
                            string = string + " nonce=\"" + rTPSessionDescriptionDataProviderBasicRTSPRequest3 + "\"";
                            string = string + " uri=\"" + string18 + "\"";
                            string = string + " response=\"" + (String)object2 + "\"";
                            if (object6 != null) {
                                string = string + " nc=\"" + object6 + "\"";
                            }
                            if (n4 != null) {
                                string = string + " qop=\"" + n4 + "\"";
                            }
                            RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest2 = rTPSessionDescriptionDataProviderBasicRTSPRequest.clone();
                            rTPSessionDescriptionDataProviderBasicRTSPRequest2.setCSeq(this.cseq);
                            rTPSessionDescriptionDataProviderBasicRTSPRequest2.addHeader("Authorization", "Digest" + string);
                            rTPSessionDescriptionDataProviderBasicRTSPRequest2.setAuthResponse(true);
                            this.requests.put(new Integer(this.cseq), rTPSessionDescriptionDataProviderBasicRTSPRequest2);
                            ++this.cseq;
                            this.rtpBasicDataProvider.rtspMessageHook(rTPSessionDescriptionDataProviderBasicRTSPRequest2);
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest2.getCommand());
                            ioSession.write((Object)ByteBuffer.wrap((byte[])rTPSessionDescriptionDataProviderBasicRTSPRequest2.getMessage()));
                        } else if (string5 != null) {
                            string162 = string5.substring("basic ".length());
                            Map<String, String> i = AuthenticationUtils.parseAuthenticationValues(string162);
                            String object4 = "";
                            object4 = object4 + " " + Base64.encodeBytes(this.userInfo.getBytes());
                            RTPSessionDescriptionDataProviderBasicRTSPRequest stringArray3 = rTPSessionDescriptionDataProviderBasicRTSPRequest.clone();
                            stringArray3.setCSeq(this.cseq);
                            stringArray3.addHeader("Authorization", "Basic" + object4);
                            stringArray3.setAuthResponse(true);
                            this.requests.put(new Integer(this.cseq), stringArray3);
                            ++this.cseq;
                            this.rtpBasicDataProvider.rtspMessageHook(stringArray3);
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + stringArray3.getCommand());
                            ioSession.write((Object)ByteBuffer.wrap((byte[])stringArray3.getMessage()));
                        } else {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).warn("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: Authentication required[" + n + "]: Unknown authentication model: " + string6);
                        }
                    } else {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).warn("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: Authentication required[" + n + "]: Username password not available");
                    }
                } else if (rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand().equals("DESCRIBE")) {
                    if (n != 200) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).warn("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: DESCRIBE: Status: " + n);
                    } else {
                        String string = rTPSessionDescriptionDataProviderBasicRTSPResponse.getHeader("content-base");
                        if (string != null) {
                            this.contentBase = string;
                        }
                        this.sdpDataTmp = rTPSessionDescriptionDataProviderBasicRTSPResponse.getBodyAsString();
                        if (this.sdpDataTmp != null) {
                            Object l3;
                            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(null);
                            if (wMSLogger.isDebugEnabled()) {
                                wMSLogger.debug(this.sdpDataTmp);
                            }
                            this.tracks.clear();
                            this.trackMap.clear();
                            RTSPTrack rTSPTrack = new RTSPTrack();
                            rTSPTrack.trackId = "header";
                            this.trackMap.put(rTSPTrack.trackId, rTSPTrack);
                            this.sdpDataTmp = this.sdpDataTmp.replace("\r\n", "\n").replace("\r", "\n");
                            String[] stringArray = this.sdpDataTmp.split("\n");
                            boolean bl = false;
                            String[] stringArray2 = null;
                            int bl2 = -1;
                            int i = 0;
                            String string20 = "";
                            for (int string19 = 0; string19 < stringArray.length; ++string19) {
                                int n5;
                                int stringArray4;
                                Object object3;
                                Object exception;
                                l3 = stringArray[string19].trim();
                                if (((String)l3).startsWith("m=")) {
                                    String[] string17;
                                    rTSPTrack = new RTSPTrack();
                                    if (stringArray2 != null) {
                                        rTSPTrack.destination = stringArray2;
                                        rTSPTrack.isMulticast = i != 0;
                                    }
                                    if (stringArray3 > 0) {
                                        rTSPTrack.ttl = stringArray3;
                                    }
                                    if ((string17 = ((String)l3).substring(2).split("[ ]")).length > 1) {
                                        try {
                                            string20 = string17[0];
                                            exception = string17[1];
                                            object3 = ((String)exception).split("/");
                                            stringArray4 = Integer.parseInt(object3[0]);
                                            if (stringArray4 > 0) {
                                                rTSPTrack.clientPort = stringArray4;
                                                rTSPTrack.clientCPort = stringArray4 + 1;
                                            }
                                        }
                                        catch (Exception l4) {
                                            // empty catch block
                                        }
                                    }
                                    bl = true;
                                } else if (((String)l3).startsWith("c=")) {
                                    String n3 = ((String)l3).substring(2).trim();
                                    if (n3.length() > 0 && ((String[])(exception = n3.split("[ ]"))).length >= 3) {
                                        int n2;
                                        object3 = exception[2].trim();
                                        stringArray4 = object3.indexOf("/");
                                        String j = null;
                                        if (stringArray4 >= 0) {
                                            j = object3.substring(stringArray4 + 1);
                                            object3 = object3.substring(0, stringArray4);
                                        }
                                        if (j != null) {
                                            n2 = -1;
                                            try {
                                                n2 = Integer.parseInt(j);
                                            }
                                            catch (Exception exception2) {
                                                // empty catch block
                                            }
                                            if (n2 > 0) {
                                                if (!bl) {
                                                    int stringArray3 = n2;
                                                } else {
                                                    rTSPTrack.ttl = n2;
                                                }
                                            }
                                        }
                                        n2 = NetworkUtils.isAddressMulticast((String)object3) ? 1 : 0;
                                        if (!bl) {
                                            stringArray2 = object3;
                                            i = n2;
                                        } else {
                                            rTSPTrack.destination = (String)object3;
                                            rTSPTrack.isMulticast = n2 != 0;
                                        }
                                    }
                                } else if (((String)l3).startsWith("a=control") && (n5 = ((String)l3).indexOf(":")) >= 0) {
                                    exception = ((String)l3).substring(n5 + 1);
                                    if (bl && (!this.rtspFilterUnknownTracks || string20.toLowerCase().indexOf("audio") >= 0 || string20.toLowerCase().indexOf("video") >= 0)) {
                                        this.tracks.add((String)exception);
                                        rTSPTrack.trackId = exception;
                                        this.trackMap.put(rTSPTrack.trackId, rTSPTrack);
                                    }
                                }
                                rTSPTrack.lines.add((String)l3);
                            }
                            if (this.tracks.size() > this.trackPosition) {
                                String string21 = this.tracks.get(this.trackPosition);
                                rTSPTrack = this.trackMap.get(string21);
                                ++this.trackPosition;
                                l3 = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
                                ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setCommand("SETUP");
                                if (string21.indexOf("://") >= 0) {
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setTarget(string21);
                                } else if (this.rtspUseContentBase && this.contentBase != null) {
                                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: SETUP: " + this.contentBase + string21);
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setTarget(this.contentBase + string21);
                                } else {
                                    int n6 = this.rtspURL.indexOf("?");
                                    if (n6 >= 0) {
                                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setTarget(this.rtspURL.substring(0, n6) + "/" + string21 + this.rtspURL.substring(n6));
                                    } else {
                                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setTarget(this.rtspURL + "/" + string21);
                                    }
                                }
                                if (this.sessionId != null) {
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).addHeader("Session", this.sessionId);
                                }
                                if (this.forceInterleaved) {
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).addHeader("Transport", "RTP/AVP/TCP;unicast;interleaved=" + (this.interleaveIndex * 2 + 0) + "-" + (this.interleaveIndex * 2 + 1));
                                    ++this.interleaveIndex;
                                } else if (rTSPTrack.isMulticast) {
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).addHeader("Transport", "RTP/AVP/UDP;multicast;destination=" + rTSPTrack.destination + ";client_port=" + rTSPTrack.clientPort + "-" + rTSPTrack.clientCPort + (rTSPTrack.ttl > 0 ? ";ttl=" + rTSPTrack.ttl : ""));
                                } else {
                                    int n3 = rTPContext.acquireUDPPortPair();
                                    this.portPairs.add(new Integer(n3));
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).addHeader("Transport", "RTP/AVP/UDP;unicast;client_port=" + n3 + "-" + (n3 + 1));
                                }
                                if (this.rtspBlockSize > 0) {
                                    ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).addHeader("Blocksize", this.rtspBlockSize + "");
                                }
                                ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setCSeq(this.cseq);
                                ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).setTrackId(string21);
                                this.requests.put(new Integer(this.cseq), (RTPSessionDescriptionDataProviderBasicRTSPRequest)l3);
                                ++this.cseq;
                                this.rtpBasicDataProvider.rtspMessageHook((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3);
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + ((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).getCommand());
                                ioSession.write((Object)ByteBuffer.wrap((byte[])((RTPSessionDescriptionDataProviderBasicRTSPRequest)l3).getMessage()));
                            }
                        }
                    }
                } else if (rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand().equals("SETUP")) {
                    Object object7;
                    String string = rTPSessionDescriptionDataProviderBasicRTSPRequest.getTrackId();
                    RTSPTrack rTSPTrack = this.trackMap.get(string);
                    if (rTSPTrack != null) {
                        object7 = rTPSessionDescriptionDataProviderBasicRTSPResponse.getHeader("transport");
                        rTSPTrack.transport = object7;
                    } else {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).warn("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: SETUP: TrackId not found: " + string);
                    }
                    if (this.tracks.size() > this.trackPosition) {
                        int n7;
                        string = this.tracks.get(this.trackPosition);
                        ++this.trackPosition;
                        object7 = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setCommand("SETUP");
                        if (string.indexOf("://") >= 0) {
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setTarget(string);
                        } else if (this.rtspUseContentBase && this.contentBase != null) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: SETUP: " + this.contentBase + string);
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setTarget(this.contentBase + string);
                        } else {
                            n7 = this.rtspURL.indexOf("?");
                            if (n7 >= 0) {
                                ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setTarget(this.rtspURL.substring(0, n7) + "/" + string + this.rtspURL.substring(n7));
                            } else {
                                ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setTarget(this.rtspURL + "/" + string);
                            }
                        }
                        if (this.sessionId != null) {
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).addHeader("Session", this.sessionId);
                        }
                        if (this.forceInterleaved) {
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).addHeader("Transport", "RTP/AVP/TCP;unicast;interleaved=" + (this.interleaveIndex * 2 + 0) + "-" + (this.interleaveIndex * 2 + 1));
                            ++this.interleaveIndex;
                        } else if (rTSPTrack.isMulticast) {
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).addHeader("Transport", "RTP/AVP/UDP;multicast;destination=" + rTSPTrack.destination + ";client_port=" + rTSPTrack.clientPort + "-" + rTSPTrack.clientCPort + (rTSPTrack.ttl > 0 ? ";ttl=" + rTSPTrack.ttl : ""));
                        } else {
                            n7 = rTPContext.acquireUDPPortPair();
                            this.portPairs.add(new Integer(n7));
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).addHeader("Transport", "RTP/AVP/UDP;unicast;client_port=" + n7 + "-" + (n7 + 1));
                        }
                        if (this.rtspBlockSize > 0) {
                            ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).addHeader("Blocksize", this.rtspBlockSize + "");
                        }
                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setCSeq(this.cseq);
                        ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).setTrackId(string);
                        this.requests.put(new Integer(this.cseq), (RTPSessionDescriptionDataProviderBasicRTSPRequest)object7);
                        ++this.cseq;
                        ioSession.write((Object)ByteBuffer.wrap((byte[])((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).getMessage()));
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + ((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7).getCommand());
                        this.rtpBasicDataProvider.rtspMessageHook((RTPSessionDescriptionDataProviderBasicRTSPRequest)object7);
                    } else {
                        this.buildSDPData();
                    }
                } else if (rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand().equals("PLAY")) {
                    String string;
                    RTPStream rTPStream;
                    if (this.forceInterleaved && this.rtpSession != null && (rTPStream = this.rtpSession.getRTSPStream()) != null && (string = rTPSessionDescriptionDataProviderBasicRTSPResponse.getHeader("rtp-info")) != null && (string = string.trim()).length() > 0) {
                        long l = System.currentTimeMillis();
                        long l2 = RTCPUtils.toNtpTime(l);
                        String[] stringArray = string.split("[,]");
                        for (int i = 0; i < stringArray.length; ++i) {
                            Object object4;
                            Object object5;
                            String string2 = stringArray[i].trim();
                            if (string2.length() <= 0) continue;
                            String string3 = null;
                            long l3 = -1L;
                            long l4 = -1L;
                            String[] stringArray4 = string2.split("[;]");
                            for (int string23 = 0; string23 < stringArray4.length; ++string23) {
                                String string4 = stringArray4[string23].trim();
                                if (string4.length() <= 0) continue;
                                object5 = string4;
                                object4 = null;
                                int n4 = string4.indexOf("=");
                                if (n4 >= 0) {
                                    object5 = string4.substring(0, n4).trim();
                                    object4 = string4.substring(n4 + 1).trim();
                                }
                                if (((String)object5).equalsIgnoreCase("url")) {
                                    string3 = object4;
                                    continue;
                                }
                                if (((String)object5).equalsIgnoreCase("rtptime")) {
                                    try {
                                        l4 = Long.parseLong((String)object4);
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                                if (!((String)object5).equalsIgnoreCase("seq")) continue;
                                try {
                                    l3 = Long.parseLong((String)object4);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (string3 == null || l4 < 0L) continue;
                            String string5 = string3;
                            int n5 = string3.lastIndexOf("/");
                            if (n5 >= 0) {
                                string5 = string3.substring(n5 + 1);
                            }
                            if ((object5 = rTPStream.getTrack(string5)) == null || (object4 = RTCPUtils.createSenderReport((RTPTrack)object5, l2, l4, 0L, 0L)) == null) continue;
                            PenndingInterleaveMessage penndingInterleaveMessage = new PenndingInterleaveMessage();
                            penndingInterleaveMessage.buffer = object4;
                            penndingInterleaveMessage.offset = 0;
                            penndingInterleaveMessage.len = ((byte[])object4).length;
                            penndingInterleaveMessage.handler = ((RTPTrack)object5).getRTCPMessageHandler();
                            this.pendingInterleaveMessages.add(penndingInterleaveMessage);
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("senderReport[RTP-Info]: " + string5);
                            rTPStream.setResyncAudioVideoOnSR(false);
                        }
                    }
                } else if (rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand().equals("TEARDOWN")) {
                    ioSession.close();
                }
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setHandled(true);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void buildSDPData() {
        try {
            String string = "";
            RTSPTrack rTSPTrack = this.trackMap.get("header");
            if (rTSPTrack != null) {
                for (String object3 : rTSPTrack.lines) {
                    if (object3.startsWith("c=")) continue;
                    string = string + object3 + "\r\n";
                }
            }
            if (this.rtspBindIpAddress != null) {
                string = string + "c=IN IP4 " + this.rtspBindIpAddress + "\r\n";
            }
            for (String string2 : this.tracks) {
                rTSPTrack = this.trackMap.get(string2);
                if (rTSPTrack == null) continue;
                for (String string3 : rTSPTrack.lines) {
                    void var6_9;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    if (string3.startsWith("m=")) {
                        String[] stringArray = string3.substring(2).split("[ ]");
                        int n = rTSPTrack.getClientPort();
                        if (this.forceInterleaved) {
                            n = 0;
                        }
                        if (stringArray.length > 1) {
                            stringArray[1] = n + "";
                        }
                        String string7 = "m=";
                        for (int i = 0; i < stringArray.length; ++i) {
                            void var6_14;
                            if (i > 0) {
                                void var6_12;
                                String string8 = (String)var6_12 + " ";
                            }
                            String string9 = (String)var6_14 + stringArray[i];
                        }
                        long l = rTSPTrack.getSSRC();
                        if (l > 0L) {
                            string4 = "a=ssrc:" + l + " stream";
                        }
                        if (this.forceInterleaved) {
                            string5 = "a=proto:RTP/AVP/TCP;interleaved=" + rTSPTrack.getClientPort() + "-" + rTSPTrack.getClientCPort();
                        }
                        if (rTSPTrack.isMulticast) {
                            string6 = "c=IN IP4 " + rTSPTrack.getDestination() + (rTSPTrack.getTTL() > 0 ? "/" + rTSPTrack.getTTL() : "");
                        }
                    }
                    if (!var6_9.startsWith("c=")) {
                        string = string + (String)var6_9 + "\r\n";
                    }
                    if (string6 != null) {
                        string = string + string6 + "\r\n";
                    }
                    if (string4 != null) {
                        string = string + string4 + "\r\n";
                    }
                    if (string5 == null) continue;
                    string = string + string5 + "\r\n";
                }
            }
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(null);
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug(string);
            }
            RTPSessionDescriptionDataProviderBasicRTSPWorker rTPSessionDescriptionDataProviderBasicRTSPWorker = this;
            synchronized (rTPSessionDescriptionDataProviderBasicRTSPWorker) {
                this.sdpData = string;
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.buildSDPData: sessionId:" + this.sessionId + " sessionTimeout:" + this.sessionTimeout);
                if (this.sessionTimeout > 0 || this.rtspValidationFrequency > 0) {
                    if (this.sessionTimeout > 0) {
                        this.pingFrequency = this.sessionTimeout / 2;
                    } else if (this.rtspValidationFrequency > 0) {
                        this.pingFrequency = this.rtspValidationFrequency;
                    }
                    this.lastPingTime = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.buildSDPData: " + exception.toString());
        }
    }

    public synchronized void onIdle(IoSession ioSession) {
    }

    public synchronized void doIdle() {
        try {
            long l;
            if (this.session != null && this.lastPingTime > 0L && (l = System.currentTimeMillis()) - this.lastPingTime >= (long)this.pingFrequency) {
                this.lastPingTime = l;
                this.sendPing();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.buildSDPData: " + exception.toString());
        }
    }

    public synchronized String getSDPData() {
        return this.sdpData;
    }

    public synchronized void close() {
        this.rtpSession = null;
        this.interleavePortMap.clear();
        IVHost iVHost = this.appInstance.getVHost();
        RTPContext rTPContext = iVHost.getRTPContext();
        for (int n : this.portPairs) {
            rTPContext.releaseUDPPortPair(n);
        }
        this.portPairs.clear();
        if (this.session != null) {
            RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setCommand("TEARDOWN");
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setTarget(this.rtspURL);
            if (this.sessionId != null) {
                rTPSessionDescriptionDataProviderBasicRTSPRequest.addHeader("Session", this.sessionId);
            }
            rTPSessionDescriptionDataProviderBasicRTSPRequest.setCSeq(this.cseq);
            this.requests.put(new Integer(this.cseq), rTPSessionDescriptionDataProviderBasicRTSPRequest);
            ++this.cseq;
            this.rtpBasicDataProvider.rtspMessageHook(rTPSessionDescriptionDataProviderBasicRTSPRequest);
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand());
            WriteFuture writeFuture = this.session.write((Object)ByteBuffer.wrap((byte[])rTPSessionDescriptionDataProviderBasicRTSPRequest.getMessage()));
            if (writeFuture != null) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.close closeSession");
                try {
                    writeFuture.join();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.close session.join:" + exception.toString());
                }
                try {
                    this.session.close();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.close session.close:" + exception.toString());
                }
            }
        }
    }

    public synchronized boolean doConnect(String string, int n) {
        boolean bl;
        block8: {
            bl = false;
            this.rtspURL = string;
            this.userInfo = null;
            String string2 = "/";
            int n2 = 554;
            String string3 = null;
            try {
                URI uRI = new URI(string);
                string3 = uRI.getHost();
                if (uRI.getPort() > 0) {
                    n2 = uRI.getPort();
                }
                if (uRI.getPath() != null) {
                    string2 = uRI.getPath();
                }
                if (uRI.getQuery() != null) {
                    string2 = string2 + "?" + uRI.getQuery();
                }
                if (uRI.getUserInfo() != null) {
                    this.userInfo = uRI.getUserInfo();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.doConnect: convert: " + exception.toString());
            }
            if (string3 == null) break block8;
            int n3 = (int)Math.round((double)n / 1000.0);
            if (n3 <= 0) {
                n3 = 1;
            }
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.doConnect: hostname:" + string3 + " port:" + n2 + " timeout:" + n3 + " rtspBindIpAddress:" + this.rtspBindIpAddress + " path:" + string2);
            IVHost iVHost = this.appInstance.getVHost();
            MediaCasterConnection mediaCasterConnection = ((VHost)iVHost).getMediaCasterConnection();
            this.session = mediaCasterConnection.connect(this.handler, string3, n2, n3, this.rtspBindIpAddress);
            if (this.session != null) {
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void sessionStart(RTPSession rTPSession) {
        try {
            if (this.session != null && this.session.isConnected() && this.sdpData != null) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.sessionStart: PLAY: " + this.rtspURL);
                RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest = new RTPSessionDescriptionDataProviderBasicRTSPRequest();
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setCommand("PLAY");
                if (this.sessionId != null) {
                    rTPSessionDescriptionDataProviderBasicRTSPRequest.addHeader("Session", this.sessionId);
                }
                if (this.rtspUseContentBase && this.contentBase != null) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).info("RTPSessionDescriptionDataProviderBasicRTSPWorker.processResponse: PLAY: " + this.contentBase);
                    rTPSessionDescriptionDataProviderBasicRTSPRequest.setTarget(this.contentBase);
                } else {
                    rTPSessionDescriptionDataProviderBasicRTSPRequest.setTarget(this.rtspURL);
                }
                rTPSessionDescriptionDataProviderBasicRTSPRequest.setCSeq(this.cseq);
                rTPSessionDescriptionDataProviderBasicRTSPRequest.addHeader("Range", "npt=0.000-");
                this.requests.put(new Integer(this.cseq), rTPSessionDescriptionDataProviderBasicRTSPRequest);
                ++this.cseq;
                this.rtpBasicDataProvider.rtspMessageHook(rTPSessionDescriptionDataProviderBasicRTSPRequest);
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).debug("RTPSessionDescriptionDataProviderBasicRTSPWorker.send: command:" + rTPSessionDescriptionDataProviderBasicRTSPRequest.getCommand());
                this.session.write((Object)ByteBuffer.wrap((byte[])rTPSessionDescriptionDataProviderBasicRTSPRequest.getMessage()));
                this.rtpSession = rTPSession;
                if (this.forceInterleaved) {
                    RTPStream rTPStream;
                    this.interleavePortMap.clear();
                    if (rTPSession != null && (rTPStream = rTPSession.getRTSPStream()) != null) {
                        List<String> list = rTPStream.getTrackNames();
                        for (String string : list) {
                            RTPTrack rTPTrack = rTPStream.getTrack(string);
                            if (rTPTrack == null) continue;
                            if (rTPTrack.getRTPInPortNum() >= 0) {
                                this.interleavePortMap.put(new Integer(rTPTrack.getRTPInPortNum()), new TrackHolder(rTPTrack.getRTPMessageHandler()));
                            }
                            if (rTPTrack.getRTCPInPortNum() < 0) continue;
                            this.interleavePortMap.put(new Integer(rTPTrack.getRTCPInPortNum()), new TrackHolder(rTPTrack.getRTCPMessageHandler()));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTPSessionDescriptionDataProviderBasicRTSPWorker.sessionStart: " + exception.toString());
        }
    }

    class PenndingInterleaveMessage {
        byte[] buffer = null;
        int offset = 0;
        int len = 0;
        IRTPMessageHandler handler = null;

        PenndingInterleaveMessage() {
        }
    }

    class RTSPTrack {
        public String trackId = null;
        public List<String> lines = new ArrayList<String>();
        public String transport = null;
        private boolean isParsed = false;
        private int clientPort = 0;
        private int clientCPort = 0;
        private long ssrc = 0L;
        private String ssrcStr = null;
        private String destination = null;
        private String mode = null;
        private boolean isMulticast = false;
        private int ttl = -1;

        RTSPTrack() {
        }

        private void parseTransport() {
            try {
                if (this.transport != null) {
                    String[] stringArray = this.transport.split("[;]");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string;
                        String string2;
                        Object object;
                        int n;
                        String string3 = stringArray[i].trim();
                        if (string3.equalsIgnoreCase("multicast")) {
                            this.isMulticast = true;
                            continue;
                        }
                        if (string3.startsWith("ssrc")) {
                            n = string3.indexOf("=");
                            if (n < 0) {
                                n = string3.indexOf(":");
                            }
                            if (n < 0) continue;
                            this.ssrcStr = string3.substring(n + 1);
                            object = BufferUtils.decodeHexString(this.ssrcStr);
                            if (object == null) continue;
                            this.ssrc = BufferUtils.byteArrayToLong(object, 0, ((byte[])object).length);
                            continue;
                        }
                        if (string3.startsWith("destination")) {
                            n = string3.indexOf("=");
                            if (n < 0) {
                                n = string3.indexOf(":");
                            }
                            if (n < 0) continue;
                            this.destination = string3.substring(n + 1);
                            continue;
                        }
                        if (string3.startsWith("mode")) {
                            n = string3.indexOf("=");
                            if (n < 0) {
                                n = string3.indexOf(":");
                            }
                            if (n < 0) continue;
                            this.mode = string3.substring(n + 1);
                            continue;
                        }
                        if (string3.startsWith("client_port")) {
                            n = string3.indexOf("=");
                            if (n < 0) {
                                n = string3.indexOf(":");
                            }
                            if (n < 0 || (n = (object = (Object)string3.substring(n + 1)).indexOf("-")) < 0) continue;
                            string2 = object.substring(0, n);
                            string = object.substring(n + 1);
                            try {
                                this.clientPort = Integer.parseInt(string2);
                                this.clientCPort = Integer.parseInt(string);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (!string3.startsWith("interleaved")) continue;
                        n = string3.indexOf("=");
                        if (n < 0) {
                            n = string3.indexOf(":");
                        }
                        if (n < 0 || (n = (object = string3.substring(n + 1)).indexOf("-")) < 0) continue;
                        string2 = object.substring(0, n);
                        string = object.substring(n + 1);
                        try {
                            this.clientPort = Integer.parseInt(string2);
                            this.clientCPort = Integer.parseInt(string);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPWorker.class).error("RTSPTrack.parseTransport: " + exception.toString());
            }
            this.isParsed = true;
        }

        public String getSSRCStr() {
            return this.ssrcStr;
        }

        public long getSSRC() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.ssrc;
        }

        public int getClientPort() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.clientPort;
        }

        public int getClientCPort() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.clientCPort;
        }

        public String getDestination() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.destination;
        }

        public String getMode() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.mode;
        }

        public boolean isMulticast() {
            if (!this.isParsed) {
                this.parseTransport();
            }
            return this.isMulticast;
        }

        public int getTTL() {
            return this.ttl;
        }
    }

    class TrackHolder {
        boolean firstMessage = true;
        IRTPMessageHandler handler = null;

        public TrackHolder(IRTPMessageHandler iRTPMessageHandler) {
            this.handler = iRTPMessageHandler;
        }
    }
}

