/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;

public class ModuleCore
extends ModuleBase {
    public static void createStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n = mediaStreamMap.getNextStreamIndex(iClient), true);
        if (iMediaStream != null && iClient.isConnected()) {
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "create", 200, "streamType:" + iClient.getStreamType() + " streamIndex:" + n);
        }
        ((Client)iClient).setLastStreamId(n);
        ModuleCore.sendResult(iClient, aMFDataList, n);
    }

    public static void initStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0) {
            object = mediaStreamMap.getStream(iClient, n);
            if (object != null) {
                ((Client)iClient).closeOpenStream((IMediaStream)object);
                mediaStreamMap.removeStream(iClient, n);
            }
            if ((object = mediaStreamMap.getStream(iClient, n, true)) != null) {
                if (iClient.isConnected()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)object, "stream", "create", 200, "streamType:" + iClient.getStreamType() + " streamIndex:" + n);
                }
                ((Client)iClient).setLastStreamId(n);
            }
        }
    }

    public static void releaseStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = "[unknown]";
        if (aMFDataList.size() >= 4) {
            string = ModuleCore.getParamString(aMFDataList, 3);
            MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
            mediaStreamMap.clearStreamName(string);
            mediaStreamMap.notifyPlayUnpublish(string);
        }
    }

    public static void getLastStreamId(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.sendResult(iClient, aMFDataList, ((Client)iClient).getLastStreamId());
    }

    public static void deleteStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0) {
            object = mediaStreamMap.getStream(iClient, n);
            ((Client)iClient).closeOpenStream((IMediaStream)object);
            mediaStreamMap.removeStream(iClient, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        double d = iClient.getClientId();
        String string = null;
        String string2 = "";
        Object object2 = "flv";
        int n = requestFunction.getSrc();
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 2 && (string = (String)((AMFData)object).getValue()) != null && ((string = string.trim()).equalsIgnoreCase("false") || string.equalsIgnoreCase("null"))) {
            string = null;
        }
        if (string != null) {
            Object object3;
            Object object4;
            Object object5;
            boolean bl;
            object = ModuleUtils.decodeStreamExtension(string, (String)object2);
            string = object[0];
            object2 = object[1];
            boolean bl2 = string.indexOf("://") >= 0;
            int n2 = string.indexOf("?");
            if (!bl2 && n2 >= 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            AMFDataObj aMFDataObj = null;
            IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
            boolean bl3 = false;
            boolean bl4 = bl = iMediaStream == null ? false : iMediaStream.isAppend();
            if (aMFDataList.size() >= 5 && ((AMFData)(object5 = aMFDataList.get(4))).getType() == 2 && ((String[])(object4 = ((String)(object3 = (String)((AMFData)object5).getValue())).split("[:]"))).length > 0) {
                if (object4[0].compareToIgnoreCase("record") == 0 || ((String)object4[0]).compareToIgnoreCase("append") == 0) {
                    bl3 = true;
                }
                if (((String)object4[0]).compareToIgnoreCase("append") == 0) {
                    bl = true;
                }
            }
            if (iMediaStream != null) {
                object5 = iMediaStream;
                synchronized (object5) {
                    Object object6;
                    object3 = iMediaStream.getAccess(iClient, string);
                    object4 = null;
                    object4 = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                    ((ResponseFunction)object4).createDefaultMessage("onStatus", 0.0);
                    ((ResponseFunction)object4).setSrc(n);
                    if (object3[1] != false) {
                        aMFDataObj = new AMFDataObj();
                        aMFDataObj.put("level", new AMFDataItem("status"));
                        aMFDataObj.put("code", new AMFDataItem("NetStream.Publish.Start"));
                        aMFDataObj.put("description", new AMFDataItem("Publishing " + string + "."));
                        aMFDataObj.put("clientid", new AMFDataItem(d));
                        ((ResponseFunction)object4).addBody(aMFDataObj);
                        object6 = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
                        ResponseFunction responseFunction = new ResponseFunction(iClient);
                        responseFunction.addBytes((byte[])object6);
                        responseFunction.doBreak = true;
                        responseFunctions.add(responseFunction);
                        iMediaStream.setSendPublishStopLogEvent(true);
                    } else {
                        aMFDataObj = new AMFDataObj();
                        aMFDataObj.put("level", new AMFDataItem("error"));
                        aMFDataObj.put("code", new AMFDataItem("NetStream.Record.NoAccess"));
                        aMFDataObj.put("description", new AMFDataItem("Write access denied for stream " + string + "."));
                        aMFDataObj.put("clientid", new AMFDataItem(d));
                        ((ResponseFunction)object4).addBody(aMFDataObj);
                    }
                    responseFunctions.add((ResponseFunction)object4);
                    if (object3[1] != false) {
                        iMediaStream.setOpen(true);
                        iMediaStream.setRecord(bl3);
                        iMediaStream.setAppend(bl);
                        iMediaStream.setName(string);
                        iMediaStream.setExt((String)object2);
                        iMediaStream.setQueryStr(string2);
                        ((Client)iClient).addPublishStreams(iMediaStream);
                        if (object3[1] != false) {
                            if (bl3) {
                                object6 = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                                ((ResponseFunction)object6).createDefaultMessage("onStatus", 0.0);
                                ((ResponseFunction)object6).setSrc(n);
                                aMFDataObj = new AMFDataObj();
                                aMFDataObj.put("level", new AMFDataItem("status"));
                                aMFDataObj.put("code", new AMFDataItem("NetStream.Record.Start"));
                                aMFDataObj.put("description", new AMFDataItem("Recording " + string + "."));
                                aMFDataObj.put("clientid", new AMFDataItem(d));
                                ((ResponseFunction)object6).addBody(aMFDataObj);
                                responseFunctions.add((ResponseFunction)object6);
                                iMediaStream.setSendRecordStopLogEvent(true);
                            } else {
                                mediaStreamMap.notifyPlayPublish(iMediaStream);
                            }
                        }
                        iMediaStream.startPublishing();
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "publish", 200, string);
                        if (bl3) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "record", 200, string);
                        }
                        iMediaStream.notifyActionPublish(string, bl3, bl);
                    } else {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "publish", 401, string);
                    }
                }
            }
        } else {
            object = mediaStreamMap.getStream(iClient, n);
            if (object != null) {
                ((Client)iClient).closeOpenStream((IMediaStream)object);
            }
        }
    }

    public static void setBandwidthLimit(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalSwitch(IClient iClient, IMediaStream iMediaStream, String string, String string2, String string3, String string4, double d, double d2, int n) {
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d3 = iClient.getClientId();
        IApplicationInstance iApplicationInstance = ModuleCore.getAppInstance(iClient);
        if (iMediaStream != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                boolean[] blArray = iMediaStream.getAccess(iClient, string);
                if (blArray[0]) {
                    iMediaStream.switchName(string, string2, string3, string4, d, d2, n);
                } else {
                    ResponseFunction responseFunction = null;
                    responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(iMediaStream.getSrc());
                    AMFDataObj aMFDataObj = null;
                    aMFDataObj = new AMFDataObj();
                    aMFDataObj.put("level", new AMFDataItem("error"));
                    aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Transition"));
                    aMFDataObj.put("description", new AMFDataItem("Read access denied for stream " + string + "."));
                    aMFDataObj.put("clientid", new AMFDataItem(d3));
                    responseFunction.addBody(aMFDataObj);
                    responseFunctions.add(responseFunction);
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 401, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalStop(IClient iClient, IMediaStream iMediaStream, String string, String string2, String string3, String string4, double d, double d2, int n) {
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d3 = iClient.getClientId();
        IApplicationInstance iApplicationInstance = ModuleCore.getAppInstance(iClient);
        if (iMediaStream != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                boolean[] blArray = iMediaStream.getAccess(iClient, string);
                if (blArray[0]) {
                    iMediaStream.stopName(string, string2, string3, string4, d, d2, n);
                } else {
                    ResponseFunction responseFunction = null;
                    responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(iMediaStream.getSrc());
                    AMFDataObj aMFDataObj = null;
                    aMFDataObj = new AMFDataObj();
                    aMFDataObj.put("level", new AMFDataItem("error"));
                    aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Stop"));
                    aMFDataObj.put("description", new AMFDataItem("Read access denied for stream " + string + "."));
                    aMFDataObj.put("clientid", new AMFDataItem(d3));
                    responseFunction.addBody(aMFDataObj);
                    responseFunctions.add(responseFunction);
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 401, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalPlay(IClient iClient, IMediaStream iMediaStream, String string, String string2, String string3, String string4, double d, double d2, int n) {
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d3 = iClient.getClientId();
        IApplicationInstance iApplicationInstance = ModuleCore.getAppInstance(iClient);
        if (iMediaStream != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                boolean[] blArray = iMediaStream.getAccess(iClient, string);
                if (blArray[0]) {
                    iMediaStream.setOpen(true);
                    iMediaStream.setPlay(true);
                    iMediaStream.setName(string, string2, string3, string4, d, d2, n);
                    string = iMediaStream.getName();
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    if (n == 1 || n == 3) {
                        iMediaStream.setFastPlaySettings(iClient.getFastPlaySettings());
                        iClient.clearFastPlaySettings();
                        ((Client)iClient).addPlayStreams(iMediaStream);
                        if (iMediaStreamPlay != null) {
                            iMediaStreamPlay.reset(true);
                            iMediaStreamPlay.interruptPlay();
                            iMediaStreamPlay.startPlay();
                        }
                        iApplicationInstance.addPlayStreamByName(iMediaStream, string);
                    } else if ((n == 0 || n == 2) && iMediaStreamPlay != null) {
                        iMediaStreamPlay.reset(false);
                    }
                } else {
                    ResponseFunction responseFunction = null;
                    responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(iMediaStream.getSrc());
                    AMFDataObj aMFDataObj = null;
                    aMFDataObj = new AMFDataObj();
                    aMFDataObj.put("level", new AMFDataItem("error"));
                    aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Failed"));
                    aMFDataObj.put("description", new AMFDataItem("Read access denied for stream " + string + "."));
                    aMFDataObj.put("clientid", new AMFDataItem(d3));
                    responseFunction.addBody(aMFDataObj);
                    responseFunctions.add(responseFunction);
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 401, string);
                }
            }
        }
    }

    public static void play2(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        try {
            AMFData aMFData;
            if (aMFDataList.size() > 3 && (aMFData = aMFDataList.get(3)).getType() == 3) {
                Object object;
                AMFDataObj aMFDataObj = aMFDataList.getObject(3);
                Object object2 = "unknown";
                String string = null;
                String string2 = "flv";
                String string3 = "";
                double d = -2.0;
                double d2 = -1.0;
                int n = 1;
                boolean bl = true;
                int n2 = requestFunction.getSrc();
                IApplicationInstance iApplicationInstance = iClient.getAppInstance();
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n2);
                ResponseFunctions responseFunctions = iClient.getRespFunctions();
                double d3 = iClient.getClientId();
                if (aMFDataObj.containsKey("streamName")) {
                    object2 = aMFDataObj.getString("streamName");
                    if (object2 != null) {
                        object = object2;
                        if ((object2 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias((String)object2, iClient)) == null) {
                            ResponseFunction responseFunction = null;
                            responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                            responseFunction.createDefaultMessage("onStatus", 0.0);
                            responseFunction.setSrc(iMediaStream.getSrc());
                            AMFDataObj aMFDataObj2 = null;
                            aMFDataObj2 = new AMFDataObj();
                            aMFDataObj2.put("level", new AMFDataItem("error"));
                            aMFDataObj2.put("code", new AMFDataItem("NetStream.Play.Failed"));
                            aMFDataObj2.put("description", new AMFDataItem("Stream alias access denied " + (String)object + "."));
                            aMFDataObj2.put("clientid", new AMFDataItem(d3));
                            responseFunction.addBody(aMFDataObj2);
                            responseFunctions.add(responseFunction);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 401, (String)object2);
                            bl = false;
                        }
                    }
                    if (object2 != null) {
                        object = ModuleUtils.decodeStreamExtension((String)object2, string2);
                        object2 = object[0];
                        string2 = object[1];
                        boolean bl2 = ((String)object2).indexOf("://") >= 0;
                        int n3 = ((String)object2).indexOf("?");
                        if (!bl2 && n3 >= 0) {
                            string3 = ((String)object2).substring(n3 + 1);
                            object2 = ((String)object2).substring(0, n3);
                        }
                    }
                }
                if (aMFDataObj.containsKey("oldStreamName") && (string = aMFDataObj.getString("oldStreamName")) != null) {
                    object = ModuleUtils.decodeStreamExtension(string, string2);
                    boolean bl3 = (string = object[0]).indexOf("://") >= 0;
                    int n4 = string.indexOf("?");
                    if (!bl3 && n4 >= 0) {
                        string = string.substring(0, n4);
                    }
                }
                if (aMFDataObj.containsKey("len")) {
                    d2 = aMFDataObj.getInt("len");
                }
                if (aMFDataObj.containsKey("start")) {
                    d = aMFDataObj.getInt("start");
                }
                if (aMFDataObj.containsKey("transition") && (object = aMFDataObj.getString("transition")) != null) {
                    if (((String)object).equalsIgnoreCase("append")) {
                        n = 0;
                    } else if (((String)object).equalsIgnoreCase("reset")) {
                        n = 1;
                    } else if (((String)object).equalsIgnoreCase("stop")) {
                        n = 10;
                    } else if (((String)object).equalsIgnoreCase("swap")) {
                        n = 12;
                    } else if (((String)object).equalsIgnoreCase("switch")) {
                        n = 13;
                    }
                }
                if (bl) {
                    if (n == 12 || n == 13) {
                        ModuleCore.internalSwitch(iClient, iMediaStream, (String)object2, string, string2, string3, d, d2, n);
                    } else if (n == 10) {
                        ModuleCore.internalStop(iClient, iMediaStream, (String)object2, string, string2, string3, d, d2, n);
                    } else {
                        ModuleCore.internalPlay(iClient, iMediaStream, (String)object2, string, string2, string3, d, d2, n);
                    }
                }
            }
        }
        catch (Exception exception) {
            ModuleCore.getLogger().error("play2: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object = "unknown";
        String string = null;
        String string2 = "flv";
        String string3 = "";
        double d = -2.0;
        double d2 = -1.0;
        int n = 1;
        int n2 = requestFunction.getSrc();
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n2);
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d3 = iClient.getClientId();
        try {
            AMFData aMFData;
            if (aMFDataList.size() > 3 && (aMFData = aMFDataList.get(3)).getType() == 2) {
                AMFData aMFData2;
                String[] stringArray;
                boolean bl = true;
                object = (String)aMFData.getValue();
                if (object != null) {
                    stringArray = object;
                    if ((object = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias((String)object, iClient)) == null) {
                        ResponseFunction responseFunction = null;
                        responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                        responseFunction.createDefaultMessage("onStatus", 0.0);
                        responseFunction.setSrc(iMediaStream.getSrc());
                        aMFData2 = null;
                        aMFData2 = new AMFDataObj();
                        ((AMFDataObj)aMFData2).put("level", new AMFDataItem("error"));
                        ((AMFDataObj)aMFData2).put("code", new AMFDataItem("NetStream.Play.Failed"));
                        ((AMFDataObj)aMFData2).put("description", new AMFDataItem("Stream alias access denied " + (String)stringArray + "."));
                        ((AMFDataObj)aMFData2).put("clientid", new AMFDataItem(d3));
                        responseFunction.addBody(aMFData2);
                        responseFunctions.add(responseFunction);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "play", 401, (String)object);
                        bl = false;
                    }
                }
                if (object != null) {
                    stringArray = ModuleUtils.decodeStreamExtension((String)object, string2);
                    object = stringArray[0];
                    string2 = stringArray[1];
                }
                if (bl) {
                    boolean bl2 = ((String)object).indexOf("://") >= 0;
                    int n3 = ((String)object).indexOf("?");
                    if (!bl2 && n3 >= 0) {
                        string3 = ((String)object).substring(n3 + 1);
                        object = ((String)object).substring(0, n3);
                    }
                    if (object == null) {
                        object = "unknown";
                    }
                    if (aMFDataList.size() > 4 && (aMFData2 = aMFDataList.get(4)).getType() == 0) {
                        d = (Double)aMFData2.getValue();
                    }
                    if (aMFDataList.size() > 5 && (aMFData2 = aMFDataList.get(5)).getType() == 0) {
                        d2 = (Double)aMFData2.getValue();
                    }
                    if (aMFDataList.size() > 6) {
                        aMFData2 = aMFDataList.get(6);
                        if (aMFData2.getType() == 1) {
                            n = (Boolean)aMFData2.getValue() != false ? 1 : 0;
                        } else if (aMFData2.getType() == 0) {
                            n = ((Double)aMFData2.getValue()).intValue();
                        }
                    }
                    if (n == 12 || n == 13) {
                        ModuleCore.internalSwitch(iClient, iMediaStream, (String)object, string, string2, string3, d, d2, n);
                    } else if (n == 10) {
                        ModuleCore.internalStop(iClient, iMediaStream, (String)object, string, string2, string3, d, d2, n);
                    } else {
                        ModuleCore.internalPlay(iClient, iMediaStream, (String)object, string, string2, string3, d, d2, n);
                    }
                }
            }
        }
        catch (Exception exception) {
            ModuleCore.getLogger().error("play: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void closeStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n = requestFunction.getSrc());
        if (iMediaStream != null) {
            if (iMediaStream.isPlay()) {
                ((Client)iClient).removePlayStreams(iMediaStream);
            } else {
                ((Client)iClient).removePublishStreams(iMediaStream);
            }
            ((Client)iClient).closeOpenStream(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void seek(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
        int n2 = 0;
        double d = 0.0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n2 = ((Double)((AMFData)object).getValue()).intValue();
            d = (Double)((AMFData)object).getValue();
        }
        if (iMediaStream != null) {
            object = iMediaStream;
            synchronized (object) {
                iMediaStream.setFastPlaySettings(iClient.getFastPlaySettings());
                iClient.clearFastPlaySettings();
                IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                if (iMediaStreamPlay != null) {
                    iMediaStreamPlay.seek(n2);
                }
                iMediaStream.notifyActionSeek(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block8: {
            try {
                AMFData aMFData;
                AMFData aMFData2;
                MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
                int n = requestFunction.getSrc();
                IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
                int n2 = -1;
                if (aMFDataList.size() >= 4 && (aMFData2 = aMFDataList.get(3)).getType() == 1) {
                    n2 = (Boolean)aMFData2.getValue() != false ? 1 : 0;
                }
                long l = 0L;
                if (aMFDataList.size() >= 5 && (aMFData = aMFDataList.get(4)).getType() == 0) {
                    l = ((Double)aMFData.getValue()).longValue();
                }
                if (iMediaStream == null) break block8;
                boolean bl = n2 == -1 ? iMediaStream.isPlaying() : n2 == 1;
                IMediaStream iMediaStream2 = iMediaStream;
                synchronized (iMediaStream2) {
                    iMediaStream.setFastPlaySettings(iClient.getFastPlaySettings());
                    iClient.clearFastPlaySettings();
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    if (iMediaStreamPlay != null) {
                        iMediaStreamPlay.pause(n2, l);
                    }
                    iMediaStream.notifyActionPause(bl, l);
                }
            }
            catch (Exception exception) {
                ModuleCore.getLogger().error("pause: error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBufferTime(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        int n2 = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n2 = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0 && (object = mediaStreamMap.getStream(iClient, n)) != null) {
            Object object2 = object;
            synchronized (object2) {
                object.setBufferTime(n2);
                WMSLoggerFactory.getLogger(ModuleCore.class).debug(n2 + "", null, "session", "setbuffertime", 200, "[" + iClient.getClientId() + "," + object.getSrc() + "]: " + n2 + "");
            }
        }
    }

    public static void getClientID(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        double d = iClient.getClientId();
        ModuleCore.sendResult(iClient, aMFDataList, d);
    }

    public static void getVersion(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber();
        ModuleCore.sendResult(iClient, aMFDataList, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLiveStreamPacketizer(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        IMediaStream iMediaStream;
        String string = ModuleCore.getParamString(aMFDataList, 3);
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        if (n > 0 && (iMediaStream = mediaStreamMap.getStream(iClient, n)) != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                iMediaStream.setLiveStreamPacketizer(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLiveStreamRepeating(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        IMediaStream iMediaStream;
        String string = ModuleCore.getParamString(aMFDataList, 3);
        String string2 = ModuleCore.getParamString(aMFDataList, 4);
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        if (n > 0 && (iMediaStream = mediaStreamMap.getStream(iClient, n)) != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                iMediaStream.initLiveStreamRepeating(string, string2);
            }
        }
    }

    public static void getLiveStreamPacketizer(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.sendResult(iClient, aMFDataList, iClient.getLiveStreamPacketizerList());
    }

    public static void setStreamType(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = ModuleCore.getParamString(aMFDataList, 3);
        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "application", "setstreamtype", 200, string);
        iClient.setStreamType(string);
    }

    public static void getStreamType(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.sendResult(iClient, aMFDataList, iClient.getStreamType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveAudio(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        IMediaStream iMediaStream;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        boolean bl = ModuleCore.getParamBoolean(aMFDataList, 3, true);
        if (n > 0 && (iMediaStream = mediaStreamMap.getStream(iClient, n)) != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                iMediaStream.setReceiveAudio(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveVideo(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        boolean bl = true;
        int n2 = -1;
        if (aMFDataList.size() > 3) {
            object = aMFDataList.get(3);
            if (((AMFData)object).getType() == 0) {
                int n3 = ((Double)((AMFData)object).getValue()).intValue();
                if (n3 > 0) {
                    bl = true;
                    n2 = n3;
                } else if (n3 == -1) {
                    bl = true;
                    n2 = -1;
                } else if (n3 == -2) {
                    bl = true;
                    n2 = -2;
                } else if (n3 == -3) {
                    bl = true;
                    n2 = -3;
                } else {
                    bl = false;
                    n2 = -1;
                }
            } else if (((AMFData)object).getType() == 1) {
                bl = (Boolean)((AMFData)object).getValue();
                n2 = -1;
            }
        }
        if (n > 0 && (object = mediaStreamMap.getStream(iClient, n)) != null) {
            Object object2 = object;
            synchronized (object2) {
                object.setReceiveVideo(bl);
                object.setReceiveVideoFPS(n2);
            }
        }
    }

    public void getStreamBitrate(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        double d = 0.0;
        String string = "default";
        String string2 = iClient.getStreamType();
        if (string2 != null) {
            string = string2;
        }
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        boolean bl = false;
        Object object = iApplicationInstance.getVHost().getStreamTypes();
        Object object2 = ((StreamList)object).getStreamDef(string);
        if (object2 != null) {
            bl = ((StreamItem)object2).getProperties().getPropertyBoolean("isLive", bl);
        }
        object = ModuleCore.getParamString(aMFDataList, 3);
        if (!bl && object != null) {
            object2 = "flv";
            String string3 = "";
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)object, (String)object2);
            object = stringArray[0];
            object2 = stringArray[1];
            boolean bl2 = ((String)object).indexOf("://") >= 0;
            int n = ((String)object).indexOf("?");
            if (!bl2 && n >= 0) {
                string3 = ((String)object).substring(n + 1);
                object = ((String)object).substring(0, n);
            }
            String string4 = null;
            IMediaReader iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iClient.getVHost().getMediaReaders(), (String)object2);
            if (iMediaReader != null) {
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                mediaStreamDisconnected.setName((String)object, string4, (String)object2, string3, 0.0, -1.0, 1);
                mediaStreamDisconnected.setClient(iClient);
                String string5 = iClient.getAppInstance().getStreamStoragePath();
                iMediaReader.init(iClient.getAppInstance(), mediaStreamDisconnected, (String)object2, string5, (String)object);
                long l = iMediaReader.getDuration();
                double d2 = (double)l / 1000.0;
                long l2 = iMediaReader.getLength();
                if (d2 != 0.0) {
                    d = (double)l2 * 8.0 / d2;
                }
                iMediaReader.close();
                ModuleCore.getLogger().debug("ModuleCore.getStreamBitrate duration:" + d2 + " length:" + l2 + " ret:" + d);
            } else {
                ModuleCore.getLogger().warn("ModuleCore.getStreamBitrate: Could not create MediaReader for stream: " + (String)object);
            }
        }
        ModuleCore.getLogger().info("ModuleCore.getStreamBitrate [" + (String)object + "] bitrate:" + d);
        ModuleCore.sendResult(iClient, aMFDataList, d);
    }

    public static void getStreamLength(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        AMFData aMFData = aMFDataList.get(3);
        if (aMFData != null) {
            String string = "default";
            String string2 = iClient.getStreamType();
            if (string2 != null) {
                string = string2;
            }
            IApplicationInstance iApplicationInstance = iClient.getAppInstance();
            boolean bl = false;
            Object object = iApplicationInstance.getVHost().getStreamTypes();
            Object object2 = ((StreamList)object).getStreamDef(string);
            if (object2 != null) {
                bl = ((StreamItem)object2).getProperties().getPropertyBoolean("isLive", bl);
            }
            if (aMFData.getType() == 2) {
                String[] stringArray;
                double d = 0.0;
                Object object3 = ModuleCore.getParamString(aMFDataList, 3);
                String string3 = "flv";
                String string4 = "";
                if (object3 != null) {
                    stringArray = object3;
                    if ((object3 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias((String)object3, iClient)) == null) {
                        ModuleCore.getLogger().warn("ModuleCore.getStreamLength[" + (String)stringArray + "]: Stream alias access denied.");
                    }
                }
                if (!bl && object3 != null) {
                    stringArray = ModuleUtils.decodeStreamExtension((String)object3, string3);
                    object3 = stringArray[0];
                    string3 = stringArray[1];
                    boolean bl2 = ((String)object3).indexOf("://") >= 0;
                    int n = ((String)object3).indexOf("?");
                    if (!bl2 && n >= 0) {
                        string4 = ((String)object3).substring(n + 1);
                        object3 = ((String)object3).substring(0, n);
                    }
                    String string5 = null;
                    IMediaReader iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iClient.getVHost().getMediaReaders(), string3);
                    if (iMediaReader != null) {
                        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                        MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                        mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                        mediaStreamDisconnected.setName((String)object3, string5, string3, string4, 0.0, -1.0, 1);
                        mediaStreamDisconnected.setClient(iClient);
                        String string6 = iClient.getAppInstance().getStreamStoragePath();
                        iMediaReader.init(iClient.getAppInstance(), mediaStreamDisconnected, string3, string6, (String)object3);
                        long l = iMediaReader.getDuration();
                        d = (double)l / 1000.0;
                        iMediaReader.close();
                    }
                    ModuleCore.getLogger().debug("stream getStreamLength [" + (String)object3 + "] streamLength:" + d);
                }
                ModuleCore.sendResult(iClient, aMFDataList, d);
            } else if (aMFData.getType() == 8) {
                object = new AMFDataArray();
                object2 = (AMFDataMixedArray)aMFDataList.get(3);
                for (int i = 0; i < ((AMFDataObj)object2).size(); ++i) {
                    String string7 = ModuleCore.getParamString(aMFDataList, 3);
                    String string8 = null;
                    String string9 = "flv";
                    String string10 = "";
                    if (string7 != null) {
                        String string11 = string7;
                        if ((string7 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string7, iClient)) == null) {
                            ModuleCore.getLogger().warn("ModuleCore.getStreamLength[" + string11 + "]: Stream alias access denied.");
                        }
                    }
                    if (string7 != null) {
                        String[] stringArray = ModuleUtils.decodeStreamExtension(string7, string9);
                        string7 = stringArray[0];
                        string9 = stringArray[1];
                    }
                    double d = 0.0;
                    if (!bl && string7 != null) {
                        IMediaReader iMediaReader;
                        boolean bl3 = string7.indexOf("://") >= 0;
                        int n = string7.indexOf("?");
                        if (!bl3 && n >= 0) {
                            string10 = string7.substring(n + 1);
                            string7 = string7.substring(0, n);
                        }
                        if ((iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iClient.getVHost().getMediaReaders(), string9)) != null) {
                            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                            MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                            mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                            mediaStreamDisconnected.setName(string7, string8, string9, string10, 0.0, -1.0, 1);
                            mediaStreamDisconnected.setClient(iClient);
                            String string12 = iClient.getAppInstance().getStreamStoragePath();
                            iMediaReader.init(iClient.getAppInstance(), null, string9, string12, string7);
                            long l = iMediaReader.getDuration();
                            d = (double)l / 1000.0;
                            iMediaReader.close();
                        }
                    }
                    ModuleCore.getLogger().debug("stream getStreamLength [" + string7 + "] streamLength:" + d);
                    ((AMFDataArray)object).add(new AMFDataItem(d));
                }
                ModuleCore.sendResult(iClient, aMFDataList, (AMFData)object);
            }
        }
    }

    public static void getRepeaterOriginUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getRepeaterOriginUrl();
        ModuleCore.sendResult(iClient, aMFDataList, string);
    }

    public static void setRepeaterOriginUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = ModuleCore.getParamString(aMFDataList, 3);
        iClient.setRepeaterOriginUrl(string);
    }

    public static void FCPublish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = null;
        if (aMFDataList.size() > 3) {
            string = aMFDataList.getString(3);
        }
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d = iClient.getClientId();
        String string2 = "flv";
        String string3 = "";
        if (string != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
            string = stringArray[0];
            string2 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("onFCPublish", 0.0);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Publish.Start"));
            aMFDataObj.put("description", new AMFDataItem("FCPublish to stream " + string + "."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
        }
        if (responseFunction != null) {
            responseFunctions.add(responseFunction);
        }
    }

    public static void FCUnPublish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.FCUnpublish(iClient, requestFunction, aMFDataList);
    }

    public static void FCUnpublish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = null;
        if (aMFDataList.size() > 3) {
            string = aMFDataList.getString(3);
        }
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d = iClient.getClientId();
        String string2 = "flv";
        String string3 = "";
        if (string != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
            string = stringArray[0];
            string2 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("onFCUnpublish", 0.0);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Publish.Stop"));
            aMFDataObj.put("description", new AMFDataItem("FCUnpublish to stream " + string + "."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
        }
        if (responseFunction != null) {
            responseFunctions.add(responseFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseRaw(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block8: {
            try {
                AMFData aMFData;
                AMFData aMFData2;
                MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
                int n = requestFunction.getSrc();
                IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
                int n2 = -1;
                if (aMFDataList.size() >= 4 && (aMFData2 = aMFDataList.get(3)).getType() == 1) {
                    n2 = (Boolean)aMFData2.getValue() != false ? 1 : 0;
                }
                long l = 0L;
                if (aMFDataList.size() >= 5 && (aMFData = aMFDataList.get(4)).getType() == 0) {
                    l = ((Double)aMFData.getValue()).longValue();
                }
                if (iMediaStream == null) break block8;
                boolean bl = n2 == -1 ? iMediaStream.isPlaying() : n2 == 1;
                IMediaStream iMediaStream2 = iMediaStream;
                synchronized (iMediaStream2) {
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    if (iMediaStreamPlay != null) {
                        iMediaStreamPlay.pauseRaw(n2, l);
                    }
                    iMediaStream.notifyActionPauseRaw(bl, l);
                }
            }
            catch (Exception exception) {
                ModuleCore.getLogger().error("pause: error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void getReferrer(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getReferrer();
        if (string == null) {
            string = "";
        }
        ModuleCore.sendResult(iClient, aMFDataList, new AMFDataItem(string));
    }

    public static void getPageUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getPageUrl();
        if (string == null) {
            string = "";
        }
        ModuleCore.sendResult(iClient, aMFDataList, new AMFDataItem(string));
    }

    public static void FCSubscribe(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String[] stringArray;
        Object object = null;
        if (aMFDataList.size() > 3) {
            object = aMFDataList.getString(3);
        }
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d = iClient.getClientId();
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        String string = "flv";
        String string2 = "";
        if (object != null) {
            stringArray = object;
            if ((object = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias((String)object, iClient)) == null) {
                responseFunction = new ResponseFunction(iClient);
                responseFunction.createDefaultMessage("onFCSubscribe", 0.0);
                aMFDataObj = new AMFDataObj();
                aMFDataObj.put("level", new AMFDataItem("error"));
                aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Failed"));
                aMFDataObj.put("description", new AMFDataItem("Stream alias access denied " + (String)stringArray + "."));
                aMFDataObj.put("clientid", new AMFDataItem(d));
                responseFunction.addBody(aMFDataObj);
                ModuleCore.getLogger().warn("ModuleCore.FCSubscribe[" + (String)stringArray + "]: Stream alias access denied.");
            }
        }
        if (object != null) {
            stringArray = ModuleUtils.decodeStreamExtension((String)object, string);
            object = stringArray[0];
            string = stringArray[1];
            boolean bl = ((String)object).indexOf("://") >= 0;
            int n = ((String)object).indexOf("?");
            if (!bl && n >= 0) {
                string2 = ((String)object).substring(n + 1);
                object = ((String)object).substring(0, n);
            }
            String string3 = null;
            if (aMFDataList.size() > 4) {
                string3 = aMFDataList.getString(4);
            }
            if (object != null && string3 != null) {
                iClient.fcSubscribe((String)object, string3);
            } else if (object != null) {
                iClient.fcSubscribe((String)object);
            }
            responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("onFCSubscribe", 0.0);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Start"));
            aMFDataObj.put("description", new AMFDataItem("FCSubscribe to stream " + (String)object + "."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
        }
        if (responseFunction != null) {
            responseFunctions.add(responseFunction);
        }
    }

    public static void FCUnsubscribe(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.FCUnSubscribe(iClient, requestFunction, aMFDataList);
    }

    public static void FCUnSubscribe(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String[] stringArray;
        Object object = null;
        if (aMFDataList.size() > 3) {
            object = aMFDataList.getString(3);
        }
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        double d = iClient.getClientId();
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        String string = "flv";
        String string2 = "";
        if (object != null) {
            stringArray = object;
            if ((object = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias((String)object, iClient)) == null) {
                ModuleCore.getLogger().warn("ModuleCore.FCUnSubscribe[" + (String)stringArray + "]: Stream alias access denied.");
            }
        }
        if (object != null) {
            stringArray = ModuleUtils.decodeStreamExtension((String)object, string);
            object = stringArray[0];
            string = stringArray[1];
            boolean bl = ((String)object).indexOf("://") >= 0;
            int n = ((String)object).indexOf("?");
            if (!bl && n >= 0) {
                string2 = ((String)object).substring(n + 1);
                object = ((String)object).substring(0, n);
            }
            iClient.fcUnSubscribe((String)object);
            responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("onFCUnSubscribe", 0.0);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Stop"));
            aMFDataObj.put("description", new AMFDataItem("FCUnsubscribe to stream " + (String)object + "."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
        }
        if (responseFunction != null) {
            responseFunctions.add(responseFunction);
        }
    }
}

