/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.NetConnection;
import com.wowza.wms.netconnection.NetConnectionProcessFunctions;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.request.RequestProcessData;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class NetConnectionProcessData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processNextRequest(INetConnection iNetConnection, ByteBuffer byteBuffer, int n, int n2, List list) {
        try {
            int n3;
            Object object2;
            int n4 = 0;
            byte[] byArray = null;
            int n5 = 0;
            byte[] byArray2 = iNetConnection.getLeftOverData();
            iNetConnection.clearLeftOverData();
            if (byArray2 != null) {
                n5 = byArray2.length + n2;
                byArray = new byte[n5];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byteBuffer.position(byteBuffer.limit() - n2);
                byteBuffer.get(byArray, byArray2.length, n2);
            } else {
                n5 = n2;
                try {
                    byArray = byteBuffer.array();
                    n4 = byteBuffer.limit() - n2;
                    n5 += n4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (byArray == null) {
                    byArray = new byte[n2];
                    byteBuffer.position(byteBuffer.limit() - n2);
                    byteBuffer.get(byArray);
                }
            }
            int n6 = n4;
            int n7 = n5 - n4;
            HashMap hashMap = new HashMap();
            Map map = iNetConnection.getPartialFunctions();
            for (Object object2 : map.keySet()) {
                hashMap.put(object2, map.get(object2));
                list.add(map.get(object2));
            }
            iNetConnection.clearPartialFunctions();
            object2 = iNetConnection.getReqAMFObjs();
            MediaStreamMap mediaStreamMap = iNetConnection.getStreams();
            int n8 = iNetConnection.getReceiveChunkSize();
            IMediaStream iMediaStream = null;
            int n9 = -1;
            AMFObj aMFObj = null;
            int n10 = -1;
            int n11 = -1;
            boolean bl = false;
            do {
                boolean bl2;
                int n12;
                int n13;
                int n14;
                n11 = n4;
                int n15 = 1;
                switch (byArray[n4] & 0xC0) {
                    case 0: {
                        n15 = 12;
                        break;
                    }
                    case 64: {
                        n15 = 8;
                        break;
                    }
                    case 128: {
                        n15 = 4;
                        break;
                    }
                    case 192: {
                        n15 = 1;
                        break;
                    }
                    default: {
                        n14 = 0xFF & byArray[n4];
                        String string = Integer.toHexString(n14);
                        WMSLoggerFactory.getLogger(NetConnectionProcessData.class).error("Bad header:" + string + " offset:" + n4);
                        if (bl) break;
                        iNetConnection.close();
                        bl = true;
                    }
                }
                n14 = 0;
                int n16 = byArray[n4] & 0x3F;
                if (n16 <= 1) {
                    if (++n4 + (n14 += n16 + 1) > n5) {
                        n4 = n11;
                        break;
                    }
                    int n17 = BufferUtils.byteArrayToInt(byArray, n4, n14, true);
                    n16 = 64 + n17;
                    n4 += n14 - 1;
                }
                if (n10 != n16) {
                    AMFObj aMFObj2 = aMFObj = n16 < object2.size() ? (AMFObj)object2.get(n16) : null;
                    if (aMFObj == null) {
                        aMFObj = new AMFObj(n16, iNetConnection.getObjectEncoding());
                        while (object2.size() <= n16) {
                            object2.add(null);
                        }
                        object2.set(n16, aMFObj);
                    }
                    n10 = n16;
                }
                if (n4 + n15 + n14 > n5) {
                    n4 = n11;
                    break;
                }
                ++n4;
                long l = -1L;
                if (n15 >= 4) {
                    l = BufferUtils.byteArrayToInt(byArray, n4, 3, false);
                    aMFObj.setLongTimecode(l == 0xFFFFFFL);
                    n4 += 3;
                }
                if (n15 >= 8) {
                    n13 = BufferUtils.byteArrayToInt(byArray, n4, 3, false);
                    aMFObj.setSize(n13);
                    aMFObj.setType(0xFF & byArray[n4 += 3]);
                    ++n4;
                }
                if (n15 == 12) {
                    aMFObj.setSrc(BufferUtils.byteArrayToInt(byArray, n4, 4, true));
                    n4 += 4;
                }
                if (aMFObj.isLongTimecode()) {
                    if (n4 + 4 > n5) {
                        n4 = n11;
                        break;
                    }
                    l = BufferUtils.byteArrayToLong(byArray, n4, 4, false);
                    aMFObj.setTimecode(l);
                    n4 += 4;
                }
                n13 = aMFObj.getSrc();
                int n18 = aMFObj.getType();
                n3 = n8;
                if (n15 >= 4) {
                    if (!aMFObj.isByteContainerEmpty()) {
                        WMSLoggerFactory.getLogger(RequestProcessData.class).error("packetSizeReset: " + n15 + ":" + aMFObj.getByteContainerLevel());
                        if (!bl) {
                            iNetConnection.close();
                            bl = true;
                            break;
                        }
                    }
                    aMFObj.setByteContainerLevel(0);
                }
                if ((n12 = aMFObj.getSize() - aMFObj.getByteContainerLevel()) < 0) {
                    WMSLoggerFactory.getLogger(RequestProcessData.class).error("Bad block size: " + n12);
                    if (!bl) {
                        iNetConnection.close();
                        bl = true;
                        break;
                    }
                    n12 = 0;
                }
                if (n3 > n12) {
                    n3 = n12;
                }
                if (n4 + n3 > n5) {
                    n4 = n11;
                    break;
                }
                if (l == -1L) {
                    l = aMFObj.getTimecode();
                } else if (n15 < 12 && !aMFObj.isLongTimecode()) {
                    aMFObj.setTimecode(l);
                }
                boolean bl3 = aMFObj.isByteContainerEmpty();
                if (bl3) {
                    long l2 = aMFObj.getAbsTimecode();
                    String string = "";
                    if (aMFObj.isLongTimecode()) {
                        aMFObj.setAbsTimecodeLong(l);
                        string = "long";
                    } else if (n15 == 12) {
                        long l3 = aMFObj.getAbsTimecode();
                        long l4 = l3 & 0xFFFFFFFFFF000000L;
                        long l5 = l3 & 0xFFFFFFL;
                        if (l4 > 0L && l5 <= 250L && l >= 0xFFFF06L) {
                            long l6 = l4 - 0x1000000L + l;
                            aMFObj.setAbsTimecodeLong(l6);
                            string = "weird";
                            WMSLoggerFactory.getLogger(RequestProcessData.class).warn("RequestProcessData: timecode backtrack: ovfl:" + l4 + " short:" + l5 + " new:" + l + " adj:" + l6);
                        } else {
                            aMFObj.setAbsTimecodeShort(l);
                            if (l2 == 0L) {
                                aMFObj.setTimecode(l);
                            }
                            string = "short";
                        }
                    } else {
                        aMFObj.incAbsTimecode(l);
                        string = "inc";
                    }
                }
                aMFObj.incByteContainerLevel(n3);
                boolean bl4 = aMFObj.isByteContainerFull();
                if (bl4) {
                    aMFObj.setByteContainerLevel(0);
                    aMFObj.setLongTimecode(false);
                }
                if ((n18 == 8 || n18 == 9 || n18 == 18 || n18 == 15) && n13 > 0) {
                    if (n13 != n9) {
                        IMediaStream iMediaStream2 = ((NetConnection)iNetConnection).getTargetStream();
                        IMediaStream iMediaStream3 = iMediaStream = iMediaStream2 != null ? iMediaStream2 : mediaStreamMap.getStream(iNetConnection, n13);
                    }
                    if (iMediaStream != null) {
                        n9 = n13;
                        int n19 = aMFObj.getSize();
                        if (n18 == 8) {
                            if (bl3) {
                                iMediaStream.setAudioSize(n19);
                                iMediaStream.setAudioTC(aMFObj.getAbsTimecode());
                                iMediaStream.startAudioPacket();
                            }
                            iMediaStream.addAudioData(byArray, n4, n3);
                        } else if (n18 == 9) {
                            if (bl3) {
                                iMediaStream.setVideoSize(n19);
                                iMediaStream.setVideoTC(aMFObj.getAbsTimecode());
                                iMediaStream.startVideoPacket();
                            }
                            iMediaStream.addVideoData(byArray, n4, n3);
                        } else if (n18 == 18 || n18 == 15) {
                            if (bl3) {
                                iMediaStream.setDataType(n18);
                                iMediaStream.setDataSize(n19);
                                iMediaStream.setDataTC(aMFObj.getAbsTimecode());
                                iMediaStream.startDataPacket();
                            }
                            iMediaStream.addDataData(byArray, n4, n3);
                        }
                        ((NetConnection)iNetConnection).incrementMediaInBytes(n3);
                    } else {
                        n9 = -1;
                    }
                }
                if (n18 == 8 || n18 == 9) continue;
                if (n18 == 1) {
                    n8 = BufferUtils.byteArrayToInt(byArray, n4);
                    iNetConnection.setReceiveChunkSize(n8);
                    WMSLoggerFactory.getLogger(RequestProcessData.class).debug("setReceiveChunkSize: " + n8);
                    continue;
                }
                if (n18 == 3) {
                    int n20 = BufferUtils.byteArrayToInt(byArray, n4);
                    continue;
                }
                if (n18 == 4) {
                    Object object3;
                    int n21 = BufferUtils.byteArrayToInt(byArray, n4, 2);
                    if (n21 == 3) {
                        int n22 = BufferUtils.byteArrayToInt(byArray, n4 + 2, 4);
                        int n23 = BufferUtils.byteArrayToInt(byArray, n4 + 6, 4);
                        object3 = new AMFDataList();
                        ((AMFDataList)object3).add(new AMFDataItem("setBufferTime"));
                        ((AMFDataList)object3).add(new AMFDataItem(0.0));
                        ((AMFDataList)object3).add(new AMFDataItem());
                        ((AMFDataList)object3).add(new AMFDataItem((double)n23));
                        byte[] byArray3 = ((AMFDataList)object3).serialize();
                        RequestFunction requestFunction = new RequestFunction();
                        requestFunction.setSize(byArray3.length);
                        requestFunction.setSrc(n22);
                        requestFunction.setType(20);
                        requestFunction.setTimecode(aMFObj.getAbsTimecode());
                        requestFunction.setWmsNumber(n16);
                        requestFunction.addData(byArray3, 0, byArray3.length);
                        ArrayList<RequestFunction> arrayList = new ArrayList<RequestFunction>();
                        arrayList.add(requestFunction);
                        NetConnectionProcessFunctions.processFunctions(iNetConnection, arrayList);
                        continue;
                    }
                    if (n21 == 6) {
                        int n24 = BufferUtils.byteArrayToInt(byArray, n4 + 2, 4);
                        byte[] byArray4 = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 7, (byte)(0xFF & n24 >> 24), (byte)(0xFF & n24 >> 16), (byte)(0xFF & n24 >> 8), (byte)(0xFF & n24)};
                        object3 = new ResponseFunction(iNetConnection);
                        ((ResponseFunction)object3).addBytes(byArray4);
                        iNetConnection.getRespFunctions().add((ResponseFunction)object3);
                        continue;
                    }
                    if (n21 != 7) continue;
                    int n25 = BufferUtils.byteArrayToInt(byArray, n4 + 2, 4);
                    iNetConnection.handlePingResult(n25, true);
                    continue;
                }
                if (n18 != 20 && n18 != 17 && n18 != 18 && n18 != 15 && n18 != 19 && n18 != 16) continue;
                RequestFunction requestFunction = (RequestFunction)hashMap.get(new Integer(n16));
                if (aMFObj.getSize() <= 0) {
                    WMSLoggerFactory.getLogger(NetConnectionProcessData.class).error("Zero sized function (netConnection): type:" + n18 + " size:" + aMFObj.getSize() + " index:" + n4);
                    if (!bl) {
                        iNetConnection.close();
                        bl = true;
                        break;
                    }
                }
                boolean bl5 = bl2 = requestFunction == null;
                if (!bl2) {
                    bl2 = bl3;
                }
                if (bl2) {
                    requestFunction = new RequestFunction();
                    requestFunction.setSize(aMFObj.getSize());
                    requestFunction.setSrc(aMFObj.getSrc());
                    requestFunction.setType(n18);
                    requestFunction.setTimecode(aMFObj.getAbsTimecode());
                    requestFunction.setWmsNumber(n16);
                    hashMap.put(new Integer(n16), requestFunction);
                    if (aMFObj.getSize() > 0) {
                        list.add(requestFunction);
                    }
                }
                if (requestFunction != null) {
                    requestFunction.addData(byArray, n4, n3);
                    if (!bl4) continue;
                    ArrayList<RequestFunction> arrayList = new ArrayList<RequestFunction>();
                    arrayList.add(requestFunction);
                    NetConnectionProcessFunctions.processFunctions(iNetConnection, arrayList);
                    list.remove(requestFunction);
                    hashMap.remove(new Integer(n16));
                    continue;
                }
                WMSLoggerFactory.getLogger(NetConnectionProcessData.class).error("Function missing");
            } while ((n4 += n3) < n5);
            if (n4 < n5) {
                iNetConnection.setLeftOverData(byArray, n4, n5 - n4);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RequestFunction requestFunction = (RequestFunction)iterator.next();
                if (!requestFunction.isPartial()) continue;
                iNetConnection.addPartialFunction(new Integer(requestFunction.getWmsNumber()), requestFunction);
                iterator.remove();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnectionProcessData.class).error("processNextRequest: error: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            byteBuffer.release();
        }
    }
}

