/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPMulticastListener;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.RTPUDPTransportSession;
import com.wowza.wms.rtp.transport.UDPRunner;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.ByteBuffer;

public class RTPUDPListener
extends Thread {
    private boolean running = true;
    private boolean quit = false;
    private DatagramSocket udpSocket = null;
    private RTPUDPDatagramConfig datagramConfig = null;
    private InetSocketAddress socketAddress = null;
    private InetSocketAddress boundAddress = null;
    private AtomicLong packetCounter = new AtomicLong();
    private UDPRunner runner = null;
    private IUDPMessageHandler handler = null;
    private List<SendMessage> messages = new ArrayList<SendMessage>();
    private SocketAddress lastReceivedFrom = null;

    public RTPUDPListener(RTPUDPDatagramConfig rTPUDPDatagramConfig, InetSocketAddress inetSocketAddress, IUDPMessageHandler iUDPMessageHandler, UDPRunner uDPRunner) {
        this.datagramConfig = rTPUDPDatagramConfig;
        this.socketAddress = inetSocketAddress;
        this.boundAddress = inetSocketAddress;
        this.handler = iUDPMessageHandler;
        this.runner = uDPRunner;
    }

    private void init() {
        try {
            String string = "Cause unknown";
            try {
                this.udpSocket = new DatagramSocket(this.boundAddress);
            }
            catch (Exception exception) {
                string = exception.toString();
            }
            if (this.udpSocket == null && this.boundAddress.getAddress() != null) {
                this.boundAddress = new InetSocketAddress(this.boundAddress.getPort());
                try {
                    this.udpSocket = new DatagramSocket(this.boundAddress);
                }
                catch (Exception exception) {
                    string = exception.toString();
                }
            }
            if (this.udpSocket != null) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("UDPTransport.bind: " + this.boundAddress.toString());
            } else {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("UDPTransport.bind: Failure to bind to address[" + this.socketAddress.toString() + "," + this.boundAddress.toString() + "]: " + string);
            }
            if (this.udpSocket != null) {
                this.udpSocket.setTrafficClass(this.datagramConfig.getTrafficClass());
                this.udpSocket.setReceiveBufferSize(this.datagramConfig.getReceiveBufferSize());
                this.udpSocket.setSendBufferSize(this.datagramConfig.getSendBufferSize());
                this.udpSocket.setReuseAddress(this.datagramConfig.isReuseAddress());
                this.udpSocket.setSoTimeout(this.datagramConfig.getMulticastTimeout());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPUDPListener.init: " + exception.toString());
        }
    }

    public synchronized void quit() {
        this.quit = true;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int unbind() {
        int n = -1;
        try {
            if (this.udpSocket != null) {
                this.udpSocket.close();
            }
            this.udpSocket = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPUDPListener.unbind: " + exception.toString());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2, SocketAddress socketAddress) {
        SendMessage sendMessage = new SendMessage();
        sendMessage.buffer = byArray;
        sendMessage.offset = n;
        sendMessage.len = n2;
        sendMessage.destination = socketAddress;
        List<SendMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(sendMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages() {
        ArrayList<SendMessage> arrayList = null;
        List<SendMessage> list = this.messages;
        synchronized (list) {
            if (this.messages.size() > 0) {
                arrayList = new ArrayList<SendMessage>();
                arrayList.addAll(this.messages);
                this.messages.clear();
            }
        }
        if (arrayList == null) {
            return;
        }
        for (SendMessage sendMessage : arrayList) {
            if (sendMessage.destination == null) {
                sendMessage.destination = this.lastReceivedFrom;
            }
            if (sendMessage.destination == null) continue;
            try {
                DatagramPacket datagramPacket = new DatagramPacket(sendMessage.buffer, sendMessage.offset, sendMessage.len, sendMessage.destination);
                this.udpSocket.send(datagramPacket);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        this.init();
        int n = this.datagramConfig.getDatagramMaximumPacketSize();
        RTPUDPTransportSession rTPUDPTransportSession = null;
        rTPUDPTransportSession = new RTPUDPTransportSession();
        rTPUDPTransportSession.init(this);
        this.handler.sessionOpened(rTPUDPTransportSession);
        while (true) {
            Object object2;
            if (this.udpSocket == null) {
                object = this;
                synchronized (object) {
                    this.running = false;
                    break;
                }
            }
            try {
                Object object3;
                object = new byte[n];
                object2 = new DatagramPacket((byte[])object, n);
                this.udpSocket.receive((DatagramPacket)object2);
                int n2 = ((DatagramPacket)object2).getLength();
                if (n2 > 0) {
                    object3 = ByteBuffer.wrap((byte[])object, (int)0, (int)n2);
                    this.lastReceivedFrom = ((DatagramPacket)object2).getSocketAddress();
                    this.runner.handleMessage(this.lastReceivedFrom, this.handler, object3);
                    long l = this.packetCounter.incrementAndGet();
                    if (l == 1L) {
                        WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("UDPTransport.firstPacket: " + this.boundAddress.toString());
                    }
                }
                this.sendMessages();
                object3 = this;
                synchronized (object3) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.sendMessages();
                object2 = this;
                synchronized (object2) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                object2 = this;
                synchronized (object2) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
        try {
            if (rTPUDPTransportSession != null) {
                this.handler.sessionClosed(rTPUDPTransportSession);
            }
            rTPUDPTransportSession = null;
            object = this;
            synchronized (object) {
                if (this.udpSocket != null) {
                    this.udpSocket.close();
                }
                this.udpSocket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WMSLoggerFactory.getLogger(RTPMulticastListener.class).info("UDPTransport.unbind: " + (this.socketAddress == null ? "" : this.socketAddress.toString()));
    }

    class SendMessage {
        public byte[] buffer = null;
        public int offset = 0;
        public int len = 0;
        public SocketAddress destination = null;

        SendMessage() {
        }
    }
}

