/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.transport.udp.IUDPSender;
import com.wowza.wms.transport.udp.IUDPTransportOutgoing;
import com.wowza.wms.transport.udp.UDPSender;
import com.wowza.wms.transport.udp.UDPTransportOutgoingConnectionBase;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class MulticastOutgoingConnection
extends UDPTransportOutgoingConnectionBase
implements IUDPSender {
    public int connectorIndex = -1;
    public MulticastSocket socket = null;
    public UDPSender sender = null;

    public MulticastOutgoingConnection(IUDPTransportOutgoing iUDPTransportOutgoing, MulticastSocket multicastSocket, UDPSender uDPSender, int n) {
        this.parent = iUDPTransportOutgoing;
        this.socket = multicastSocket;
        this.sender = uDPSender;
        this.connectorIndex = n;
        this.isMulticast = true;
    }

    public synchronized void handleSendMessage(byte[] byArray, int n, int n2) {
        try {
            if (this.isOpen) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n, n2);
                this.socket.send(datagramPacket);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MulticastOutgoingConnection.class).error("MulticastOutgoingConnection.handleSendMessage: " + exception.toString());
        }
    }

    public synchronized void sendMessage(byte[] byArray, int n, int n2) {
        try {
            if (this.isOpen) {
                this.sender.handleMessage(this, byArray, n, n2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MulticastOutgoingConnection.class).error("MulticastOutgoingConnection.sendMessage: " + exception.toString());
        }
    }
}

