/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.atom;

import com.wowza.io.IRandomAccessReader;
import com.wowza.util.BufferUtils;
import com.wowza.wms.drm.playready.PlayReadySampleIndex;
import com.wowza.wms.drm.playready.PlayReadySampleInfo;
import com.wowza.wms.drm.playready.PlayReadySubSampleInfo;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomtkhd;
import com.wowza.wms.mediareader.h264.atom.QTAtomudta;
import com.wowza.wms.mediareader.h264.atom.QTFragmentTrakData;
import java.util.SortedMap;
import java.util.TreeMap;

public class QTAtomtrak
extends QTAtom {
    private QTAtommdia mdiaAtom = null;
    private QTAtomudta udtaAtom = null;
    private QTAtomtkhd tkhdAtom = null;
    private TreeMap<Long, PlayReadySampleIndex> playReadySampleData = new TreeMap();
    private int trackId = 0;
    private long prCacheSample = -1L;
    private long prCacheFilePos = -1L;
    private PlayReadySampleIndex prCacheIndex = null;

    public QTAtomtrak(String string, long l, long l2, long l3) {
        super(string, l, l2, l3);
    }

    public QTAtomtrak(QTAtom qTAtom) {
        super(qTAtom.type, qTAtom.offset, qTAtom.size, qTAtom.headerSize);
    }

    public QTAtommdia getMdiaAtom() {
        return this.mdiaAtom;
    }

    public void setMdiaAtom(QTAtommdia qTAtommdia) {
        this.mdiaAtom = qTAtommdia;
    }

    public String getMinfType() {
        if (this.mdiaAtom != null) {
            return this.mdiaAtom.getMinfType();
        }
        return "unkn";
    }

    public QTAtomudta getUdtaAtom() {
        return this.udtaAtom;
    }

    public void setUdtaAtom(QTAtomudta qTAtomudta) {
        this.udtaAtom = qTAtomudta;
    }

    public boolean isVideo() {
        return this.getMinfType().equals("vmhd");
    }

    public boolean isAudio() {
        return this.getMinfType().equals("smhd");
    }

    public QTAtomtkhd getTkhdAtom() {
        return this.tkhdAtom;
    }

    public void setTkhdAtom(QTAtomtkhd qTAtomtkhd) {
        this.tkhdAtom = qTAtomtkhd;
    }

    public long getTrackId() {
        if (this.tkhdAtom != null) {
            return this.tkhdAtom.getTrackId();
        }
        return -1L;
    }

    public void setTrackId(int n) {
        this.trackId = n;
    }

    public void addPlayReadyIndex(long l, PlayReadySampleIndex playReadySampleIndex) {
        if (this.playReadySampleData == null) {
            this.playReadySampleData = new TreeMap();
        }
        this.playReadySampleData.put(new Long(l), playReadySampleIndex);
    }

    private void resetPlayReadyInfoCache() {
        this.prCacheSample = -1L;
        this.prCacheFilePos = -1L;
        this.prCacheIndex = null;
    }

    public boolean isPlayReadySampleInfo() {
        if (this.playReadySampleData == null) {
            return false;
        }
        return this.playReadySampleData.size() > 0;
    }

    public PlayReadySampleInfo getPlayReadySampleInfo(IRandomAccessReader iRandomAccessReader, long l) {
        if (this.playReadySampleData == null) {
            return null;
        }
        if (this.playReadySampleData.size() <= 0) {
            return null;
        }
        PlayReadySampleInfo playReadySampleInfo = null;
        try {
            byte[] byArray = new byte[4];
            if (l != this.prCacheSample) {
                long l2 = -1L;
                PlayReadySampleIndex playReadySampleIndex = null;
                SortedMap<Long, PlayReadySampleIndex> sortedMap = this.playReadySampleData.tailMap(l);
                if (sortedMap.size() > 0 && sortedMap.firstKey() == l) {
                    l2 = sortedMap.firstKey();
                    playReadySampleIndex = (PlayReadySampleIndex)sortedMap.get(sortedMap.firstKey());
                } else {
                    SortedMap<Long, PlayReadySampleIndex> sortedMap2 = this.playReadySampleData.headMap(l);
                    if (sortedMap2.size() > 0) {
                        l2 = sortedMap2.lastKey();
                        playReadySampleIndex = (PlayReadySampleIndex)sortedMap2.get(sortedMap2.lastKey());
                    } else {
                        l2 = this.playReadySampleData.firstKey();
                        playReadySampleIndex = this.playReadySampleData.get(this.playReadySampleData.firstKey());
                    }
                }
                if (playReadySampleIndex != null) {
                    this.prCacheSample = l2;
                    this.prCacheIndex = playReadySampleIndex;
                    this.prCacheFilePos = this.prCacheIndex.getFilePos();
                    int n = this.prCacheIndex.getFlags();
                    int n2 = this.prCacheIndex.getIvSize();
                    iRandomAccessReader.seek(this.prCacheFilePos);
                    long l3 = 0L;
                    while (this.prCacheSample != l) {
                        iRandomAccessReader.seek(this.prCacheFilePos + (l3 += (long)n2));
                        if ((n & 2) == 2) {
                            iRandomAccessReader.read(byArray, 0, 2);
                            l3 += 2L;
                            int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                            l3 += (long)(n3 * 6);
                        }
                        iRandomAccessReader.seek(this.prCacheFilePos + l3);
                        if (iRandomAccessReader.getFilePointer() >= this.prCacheIndex.getFilePos() + (long)this.prCacheIndex.getSize()) break;
                        ++this.prCacheSample;
                    }
                    this.prCacheFilePos += l3;
                }
            }
            if (l == this.prCacheSample) {
                playReadySampleInfo = new PlayReadySampleInfo();
                playReadySampleInfo.algorithmID = this.prCacheIndex.getAlgorithmID();
                playReadySampleInfo.isLocalKeyId = this.prCacheIndex.isLocalKeyId();
                playReadySampleInfo.ivSize = this.prCacheIndex.getIvSize();
                playReadySampleInfo.keyID = this.prCacheIndex.getKeyID();
                playReadySampleInfo.iv = new byte[playReadySampleInfo.ivSize];
                iRandomAccessReader.seek(this.prCacheFilePos);
                iRandomAccessReader.read(playReadySampleInfo.iv, 0, playReadySampleInfo.iv.length);
                int n = this.prCacheIndex.getFlags();
                if ((n & 2) == 2) {
                    iRandomAccessReader.read(byArray, 0, 2);
                    int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                    if (n4 > 0) {
                        playReadySampleInfo.subSample = new PlayReadySubSampleInfo[n4];
                        for (int i = 0; i < n4; ++i) {
                            playReadySampleInfo.subSample[i] = new PlayReadySubSampleInfo();
                            iRandomAccessReader.read(byArray, 0, 2);
                            playReadySampleInfo.subSample[i].bytesClear = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                            iRandomAccessReader.read(byArray, 0, 4);
                            playReadySampleInfo.subSample[i].bytesEncrypted = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                        }
                    }
                }
                if (iRandomAccessReader.getFilePointer() >= this.prCacheIndex.getFilePos() + (long)this.prCacheIndex.getSize()) {
                    this.resetPlayReadyInfoCache();
                } else {
                    this.prCacheFilePos = iRandomAccessReader.getFilePointer();
                    ++this.prCacheSample;
                }
            } else {
                WMSLoggerFactory.getLogger(QTFragmentTrakData.class).warn("QTFragmentTrakData.getPlayReadySampleInfo[" + l + "]: Sample is missing.");
                this.resetPlayReadyInfoCache();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTFragmentTrakData.class).error("QTFragmentTrakData.getPlayReadySampleInfo: " + exception.toString());
            exception.printStackTrace();
        }
        return playReadySampleInfo;
    }
}

