/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexBase;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerCupertinoIndexPlaylist
extends HTTPStreamerCupertinoIndexBase {
    private List<PlaylistNode> nodes = new ArrayList<PlaylistNode>();
    private long maxFileSize = 66560L;

    @Override
    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PlaylistNode playlistNode : this.nodes) {
            arrayList.add(playlistNode.streamName);
        }
        return arrayList;
    }

    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PlaylistNode playlistNode : this.nodes) {
            String string = this.adjustStreamName(playlistNode.streamName);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getItemWidth(int n) {
        PlaylistNode playlistNode;
        int n2 = 0;
        if (n < this.nodes.size() && (playlistNode = this.nodes.get(n)) != null) {
            n2 = playlistNode.getWidth();
        }
        return n2;
    }

    public int getItemHeight(int n) {
        PlaylistNode playlistNode;
        int n2 = 0;
        if (n < this.nodes.size() && (playlistNode = this.nodes.get(n)) != null) {
            n2 = playlistNode.getHeight();
        }
        return n2;
    }

    public boolean isAudioOnlyItem(int n) {
        PlaylistNode playlistNode;
        boolean bl = false;
        if (n < this.nodes.size() && (playlistNode = this.nodes.get(n)) != null) {
            bl = playlistNode.isAudioOnly();
        }
        return bl;
    }

    @Override
    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession) {
        IRandomAccessReader iRandomAccessReader;
        block23: {
            String string = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + this.streamExt + ":" + this.streamName;
            iRandomAccessReader = null;
            try {
                int n;
                Object object;
                MediaStreamMap mediaStreamMap = this.appInstance.getStreams();
                MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                mediaStreamDisconnected.setName(this.streamName, null, this.streamExt, null, 0.0, -1.0, 1);
                String string2 = "com.wowza.io.DirectRandomAccessReader";
                string2 = this.appInstance.getMediaReaderProperties().getPropertyStr("randomAccessReaderClass", string2);
                String string3 = this.appInstance.getStreamStoragePath();
                iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)string2, (String)string3, (String)this.streamName, (String)this.streamExt, (IMediaStream)mediaStreamDisconnected);
                if (iRandomAccessReader == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: File not found.");
                    break block23;
                }
                iRandomAccessReader.open();
                if (iRandomAccessReader.length() > this.maxFileSize) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: File too large for playlist file: " + iRandomAccessReader.length() + ">" + this.maxFileSize);
                    break block23;
                }
                if (iHTTPStreamerSession != null) {
                    object = new HTTPStreamerFileInfo(this.getStreamName(), iRandomAccessReader.length(), 0.0);
                    iHTTPStreamerSession.putFileInfo(this.getStreamName(), (HTTPStreamerFileInfo)object);
                }
                if ((n = iRandomAccessReader.read(object = new byte[(int)iRandomAccessReader.length()], 0, ((byte[])object).length)) != ((byte[])object).length) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: Error reading file: " + n + " != " + ((byte[])object).length);
                    break block23;
                }
                try {
                    iRandomAccessReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iRandomAccessReader = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(dataInputStream);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                String string4 = "/smil/body/switch/video";
                XPathExpression xPathExpression = xPath.compile(string4);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                if (nodeList == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: No results: " + string4);
                    break block23;
                }
                if (nodeList.getLength() <= 0) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: Playlist file is empty. Entries must be of the form: " + string4);
                    break block23;
                }
                String string5 = "";
                int n2 = this.streamName.lastIndexOf("/");
                if (n2 > 0) {
                    string5 = this.streamName.substring(0, n2) + "/";
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element = (Element)node;
                    String string6 = string5 + element.getAttribute("src");
                    String string7 = element.getAttribute("system-bitrate");
                    if (string7 == null) {
                        string7 = element.getAttribute("systemBitrate");
                    }
                    long l = 0L;
                    try {
                        l = Long.parseLong(string7);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = false;
                    String string8 = element.getAttribute("wowza-audio-only");
                    if (string8 != null && ((string8 = string8.trim()).startsWith("y") || string8.startsWith("t"))) {
                        bl = true;
                    }
                    int n3 = 0;
                    int n4 = 0;
                    String string9 = element.getAttribute("width");
                    String string10 = element.getAttribute("height");
                    if (string9 != null && string10 != null) {
                        try {
                            n3 = Integer.parseInt(string9);
                            n4 = Integer.parseInt(string10);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    PlaylistNode playlistNode = new PlaylistNode(string6, l, bl);
                    if (n3 > 0 && n4 > 0) {
                        playlistNode.setWidth(n3);
                        playlistNode.setHeight(n4);
                    }
                    this.nodes.add(playlistNode);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).error("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: " + exception.toString());
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iRandomAccessReader = null;
        }
    }

    @Override
    public String getPlaylistStr(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#EXTM3U\n");
        for (PlaylistNode playlistNode : this.nodes) {
            int n = playlistNode.getWidth();
            int n2 = playlistNode.getHeight();
            String string = "";
            if (n > 0 && n2 > 0) {
                string = ",RESOLUTION=" + n + "x" + n2;
            }
            stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + playlistNode.bitrate + string + "\n");
            String string2 = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
            string2 = string2.replace("{stream}", playlistNode.streamName);
            string2 = string2.replace("{filename}", "playlist.m3u8");
            if (playlistNode.isAudioOnly()) {
                string2 = string2.replace("{query}", "{query}{audioOnly}");
            }
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer.toString();
    }

    class PlaylistNode {
        String streamName = null;
        long bitrate = 0L;
        boolean audioOnly = false;
        int width = 0;
        int height = 0;

        public PlaylistNode(String string, long l, boolean bl) {
            this.streamName = string;
            this.bitrate = l;
            this.audioOnly = bl;
        }

        public boolean isAudioOnly() {
            return this.audioOnly;
        }

        public void setAudioOnly(boolean bl) {
            this.audioOnly = bl;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }
    }
}

