/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.BufferUtils;
import com.wowza.util.FasterByteArrayOutputStream;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.response.IMediaStreamOutputControl;
import com.wowza.wms.response.ResponseStreams;
import com.wowza.wms.stream.IMediaStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class FasterByteArrayOutputStreamInterleave
extends FasterByteArrayOutputStream
implements IMediaStreamOutputControl {
    private boolean doIntercept = false;
    private ByteBuffer dataOutput = null;
    StreamInfo[] streamBuffers;
    int streamIndex = 0;

    public int write(byte[] byArray, int n, int n2, int n3, byte by, int n4) {
        if (this.doIntercept) {
            int n5;
            int n6 = 0;
            int n7 = 0;
            int n8 = n2;
            do {
                if ((n5 = n4 - n3 % n4) == n4 && n3 > 0) {
                    this.write(new byte[]{by}, 0, 1);
                    ++this.count;
                    ++this.currPos;
                    ++n6;
                }
                n5 = n5 > n8 ? n8 : n5;
                this.write(byArray, n + n7, n5);
                n7 += n5;
                n3 += n5;
                n6 += n5;
            } while ((n8 -= n5) != 0);
            return n6;
        }
        return super.write(byArray, n, n2, n3, by, n4);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.doIntercept) {
            this.dataOutput.put(byArray, n, n2);
        } else {
            super.write(byArray, n, n2);
        }
    }

    public void write(int n) {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void startResponseStreams(IClient iClient, ResponseStreams responseStreams) {
        boolean bl = this.doIntercept = responseStreams.size() > 1;
        if (this.doIntercept) {
            int n = responseStreams.size();
            this.streamBuffers = new StreamInfo[n];
            WMSLoggerFactory.getLogger(FasterByteArrayOutputStreamInterleave.class).debug("interleave: " + n);
        }
    }

    public void stopResponseStreams(IClient iClient, ResponseStreams responseStreams) {
        if (this.doIntercept) {
            this.doInterleave();
        }
        this.doIntercept = false;
    }

    public void startStreamPlay(IMediaStream iMediaStream) {
        if (this.doIntercept) {
            this.startStream(iMediaStream);
        }
    }

    public void stopStreamPlay(IMediaStream iMediaStream) {
        if (this.doIntercept) {
            this.stopStream(iMediaStream);
        }
    }

    private void doInterleave() {
        int n;
        for (StreamInfo streamInfo : this.streamBuffers) {
            streamInfo.dataOutput.flip();
            streamInfo.offset = 0;
            streamInfo.limit = streamInfo.dataOutput.limit();
            streamInfo.buffer = streamInfo.dataOutput.array();
        }
        do {
            int n2;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                AMFObj aMFObj;
                int n3;
                StreamInfo streamInfo = this.streamBuffers[i];
                byte[] byArray = streamInfo.buffer;
                int n4 = streamInfo.offset;
                int n5 = streamInfo.limit;
                if (n4 == n5) continue;
                int n6 = byArray[n4] & 0xFF;
                int n7 = 0;
                switch (n6 & 0xC0) {
                    case 0: {
                        n7 = 12;
                        break;
                    }
                    case 64: {
                        n7 = 8;
                        break;
                    }
                    case 128: {
                        n7 = 4;
                        break;
                    }
                    case 192: {
                        n7 = 1;
                    }
                }
                int n8 = byArray[n4] & 0x3F;
                ++n4;
                int n9 = 1;
                if (n8 <= 1) {
                    int n10 = n8 + 1;
                    n9 += n10;
                    n3 = BufferUtils.byteArrayToInt(byArray, n4, n10, true);
                    n8 = 64 + n3;
                    n4 += n10;
                }
                if ((aMFObj = (AMFObj)streamInfo.amfObjs.get(new Integer(n8))) == null) {
                    aMFObj = new AMFObj(n8);
                    streamInfo.amfObjs.put(new Integer(n8), aMFObj);
                }
                n3 = aMFObj.getSize();
                int n11 = -1;
                if (n7 >= 4) {
                    n11 = BufferUtils.byteArrayToInt(byArray, n4, 3, false);
                    if ((long)n11 != 0xFFFFFFL) {
                        aMFObj.setTimecode(n11);
                    }
                    n4 += 3;
                }
                if (n7 >= 8) {
                    n3 = BufferUtils.byteArrayToInt(byArray, n4, 3, false);
                    aMFObj.setSize(n3);
                    aMFObj.setType(0xFF & byArray[n4 += 3]);
                    ++n4;
                }
                if (n7 == 12) {
                    aMFObj.setSrc(BufferUtils.byteArrayToInt(byArray, n4, 4, true));
                    n4 += 4;
                }
                int n12 = 0;
                if ((long)n11 == 0xFFFFFFL) {
                    n11 = BufferUtils.byteArrayToInt(byArray, n4, 4, false);
                    aMFObj.setTimecode(n11);
                    n4 += 4;
                    n7 += 4;
                    n12 += 4;
                }
                int n13 = n3 / streamInfo.sendChunkSize;
                if (n3 > 0 && n3 % streamInfo.sendChunkSize == 0) {
                    --n13;
                }
                int n14 = n7 + (n9 - 1) + n13 * n9 + n13 * n12 + n3;
                super.write(byArray, streamInfo.offset, n14);
                streamInfo.offset += n14;
                if (streamInfo.offset >= streamInfo.limit) continue;
                ++n;
            }
        } while (n != 0);
    }

    private void startStream(IMediaStream iMediaStream) {
        Client client = (Client)iMediaStream.getClient();
        AMFObj aMFObj = client.getRespAMFAudioObj(iMediaStream);
        AMFObj aMFObj2 = client.getRespAMFVideoObj(iMediaStream);
        AMFObj aMFObj3 = client.getRespAMFDataObj(iMediaStream);
        this.dataOutput = ByteBuffer.allocate((int)65536, (boolean)false);
        this.dataOutput.setAutoExpand(true);
        this.streamBuffers[this.streamIndex++] = new StreamInfo(this.dataOutput, aMFObj, aMFObj2, aMFObj3, client);
    }

    private void stopStream(IMediaStream iMediaStream) {
    }

    class StreamInfo {
        ByteBuffer dataOutput = null;
        AMFObj wmsObjAudio;
        AMFObj wmsObjVideo;
        AMFObj wmsObjData;
        Map amfObjs = new HashMap();
        byte[] buffer;
        int offset;
        int limit;
        int sendChunkSize = 128;

        public StreamInfo(ByteBuffer byteBuffer, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, Client client) {
            this.dataOutput = byteBuffer;
            this.wmsObjAudio = new AMFObj(aMFObj.getId());
            this.wmsObjAudio.setSize(aMFObj.getSize());
            this.wmsObjAudio.setTimecode(aMFObj.getTimecode());
            this.amfObjs.put(new Integer(aMFObj.getId()), this.wmsObjAudio);
            this.wmsObjVideo = new AMFObj(aMFObj2.getId());
            this.wmsObjVideo.setSize(aMFObj2.getSize());
            this.wmsObjVideo.setTimecode(aMFObj2.getTimecode());
            this.amfObjs.put(new Integer(aMFObj2.getId()), this.wmsObjVideo);
            this.wmsObjData = new AMFObj(aMFObj3.getId());
            this.wmsObjData.setSize(aMFObj3.getSize());
            this.wmsObjData.setTimecode(aMFObj3.getTimecode());
            this.amfObjs.put(new Integer(aMFObj3.getId()), this.wmsObjData);
            this.sendChunkSize = client.getSendChunkSize();
        }
    }
}

