/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.SystemUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPUtils {
    public static final FastDateFormat COOKIEDATEFORMAT = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy hh:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)SystemUtils.defaultLocale);

    public static boolean HTTPRequestToFile(File file, String string, String string2, String string3, List list) {
        boolean bl = false;
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPUtils.class).error("HTTPUtils.HTTPRequestToFile delete (" + file + "): " + exception.toString());
        }
        try {
            int n;
            Object object;
            DataOutputStream dataOutputStream = null;
            DataInputStream dataInputStream = null;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            if (list != null) {
                for (Map map : list) {
                    for (String string4 : map.keySet()) {
                        String string5 = (String)map.get(string4);
                        uRLConnection.setRequestProperty(string4, string5);
                    }
                }
            }
            if (string3 != null) {
                object = string3.getBytes("UTF-8");
                dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                dataOutputStream.write((byte[])object);
                dataOutputStream.flush();
                dataOutputStream.close();
                dataOutputStream = null;
            }
            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            object = new DataOutputStream(new FileOutputStream(file, false));
            int n2 = 65536;
            Object object2 = new byte[n2];
            while ((n = dataInputStream.read((byte[])object2, 0, n2)) != -1) {
                ((DataOutputStream)object).write((byte[])object2, 0, n);
                Thread.sleep(1L);
            }
            dataInputStream.close();
            dataInputStream = null;
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static byte[] HTTPRequestToByteArray(String string, String string2, String string3, Map<String, String> map) {
        return HTTPUtils.HTTPRequestToByteArray(string, string2, string3, map, null, 0L);
    }

    public static byte[] HTTPRequestToByteArray(String string, String string2, String string3, Map<String, String> map, Map<String, List<String>> map2, long l) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            Object object;
            Object object2;
            DataOutputStream dataOutputStream = null;
            DataInputStream dataInputStream = null;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            if (map != null) {
                for (String string4 : map.keySet()) {
                    object2 = map.get(string4);
                    uRLConnection.setRequestProperty(string4, (String)object2);
                }
            }
            if (string3 != null) {
                object = string3.getBytes("UTF-8");
                dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                dataOutputStream.write((byte[])object);
                dataOutputStream.flush();
                dataOutputStream.close();
                dataOutputStream = null;
            }
            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new DataOutputStream(byteArrayOutputStream);
            int n2 = 65536;
            object2 = new byte[n2];
            long l2 = 0L;
            while ((n = dataInputStream.read((byte[])object2, 0, n2)) != -1) {
                ((DataOutputStream)object).write((byte[])object2, 0, n);
                Thread.sleep(1L);
                if (l <= 0L || (l2 += (long)n) < l) continue;
                break;
            }
            if (map2 != null && uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                map2.putAll(httpURLConnection.getHeaderFields());
            }
            dataInputStream.close();
            dataInputStream = null;
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("HTTPUtils.HTTPRequestToByteArray: " + exception.toString());
        }
        return byArray;
    }

    public static String assembleQueryStr(Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            if (string2 != null) {
                try {
                    string2 = URLEncoder.encode(string2, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringBuffer.append(string + "=" + string2);
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Map<String, String> splitQueryStr(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("[&]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf("=");
                if (n >= 0) {
                    String string3 = string2.substring(n + 1);
                    try {
                        string3 = URLDecoder.decode(string3, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hashMap.put(string2.substring(0, n), string3);
                    continue;
                }
                hashMap.put(string2, null);
            }
        }
        return hashMap;
    }

    public static String[] splitPragmas(String string) {
        int n;
        String[] stringArray = null;
        if (string.indexOf("\"") >= 0) {
            int n2;
            int n3;
            string = string.replace("\\\"", "%%ESCQUOTE%%");
            n = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = string.length();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = string.charAt(n3);
                if (n2 == 34) {
                    n = n == 0 ? 1 : 0;
                    continue;
                }
                if (n2 != 44 || n != 0) continue;
                arrayList.add(new Integer(n3));
            }
            stringArray = new String[arrayList.size() + 1];
            if (arrayList.size() == 0) {
                stringArray[0] = string;
            } else {
                n3 = 0;
                n2 = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    stringArray[n2] = string.substring(n3, n5).replace("%%ESCQUOTE%%", "\\\"");
                    n3 = n5 + 1;
                    ++n2;
                }
                stringArray[n2] = string.substring(n3).replace("%%ESCQUOTE%%", "\\\"");
            }
        } else {
            stringArray = string.split("[,]");
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].trim();
            }
        }
        return stringArray;
    }

    public static List<String[]> splitCookie(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            if (string != null) {
                String[] stringArray = string.split("[;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0) continue;
                    String string3 = string2;
                    String string4 = null;
                    int n = string2.indexOf("=");
                    if (n > 0) {
                        string3 = string2.substring(0, n);
                        string4 = string2.substring(n + 1);
                    }
                    String[] stringArray2 = new String[]{string3, string4};
                    arrayList.add(stringArray2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static String formatDeleteCookie(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "=null");
        Date date = new Date(System.currentTimeMillis() + -604800000L);
        stringBuffer.append(";expires=" + COOKIEDATEFORMAT.format(date));
        if (string2 != null) {
            stringBuffer.append(";path=" + string2);
        }
        if (string3 != null) {
            stringBuffer.append(";domain=" + string3);
        }
        return stringBuffer.toString();
    }

    public static String formatSetCookie(String string, String string2, int n, String string3, String string4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string + "=" + string2);
        }
        Date date = new Date(System.currentTimeMillis() + (long)(n * 1000));
        stringBuffer.append(";expires=" + COOKIEDATEFORMAT.format(date));
        if (string3 != null) {
            stringBuffer.append(";path=" + string3);
        }
        if (string4 != null) {
            stringBuffer.append(";domain=" + string4);
        }
        if (bl) {
            stringBuffer.append(";secure");
        }
        return stringBuffer.toString();
    }

    public static String statusCodeToStr(int n) {
        switch (n) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status";
            }
            case 226: {
                return "IM Used";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 424: {
                return "Failed Dependency";
            }
            case 426: {
                return "Upgrade Required";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 506: {
                return "Variant Also Negotiates";
            }
            case 507: {
                return "Insufficient Storage";
            }
            case 510: {
                return "Not Extended";
            }
        }
        return "OK";
    }
}

