/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataByteArray;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AMFData {
    public static final byte DATA_TYPE_UNKNOWN = -1;
    public static final byte DATA_TYPE_NUMBER = 0;
    public static final byte DATA_TYPE_BOOLEAN = 1;
    public static final byte DATA_TYPE_STRING = 2;
    public static final byte DATA_TYPE_OBJECT = 3;
    public static final byte DATA_TYPE_MOVIE_CLIP = 4;
    public static final byte DATA_TYPE_NULL = 5;
    public static final byte DATA_TYPE_UNDEFINED = 6;
    public static final byte DATA_TYPE_REFERENCE_OBJECT = 7;
    public static final byte DATA_TYPE_MIXED_ARRAY = 8;
    public static final byte DATA_TYPE_OBJECT_END = 9;
    public static final byte DATA_TYPE_ARRAY = 10;
    public static final byte DATA_TYPE_DATE = 11;
    public static final byte DATA_TYPE_LONG_STRING = 12;
    public static final byte DATA_TYPE_AS_OBJECT = 13;
    public static final byte DATA_TYPE_RECORDSET = 14;
    public static final byte DATA_TYPE_XML = 15;
    public static final byte DATA_TYPE_CUSTOM_CLASS = 16;
    public static final byte DATA_TYPE_AMF3 = 17;
    public static final byte DATA_TYPE_INTEGER = 32;
    public static final byte DATA_TYPE_BYTEARRAY = 33;
    public static final byte DATA_TYPE_XML_TOP = 34;
    public static final byte DATA_TYPE_AMF3_UNDEFINED = 0;
    public static final byte DATA_TYPE_AMF3_NULL = 1;
    public static final byte DATA_TYPE_AMF3_BOOLEAN_FALSE = 2;
    public static final byte DATA_TYPE_AMF3_BOOLEAN_TRUE = 3;
    public static final byte DATA_TYPE_AMF3_INTEGER = 4;
    public static final byte DATA_TYPE_AMF3_NUMBER = 5;
    public static final byte DATA_TYPE_AMF3_STRING = 6;
    public static final byte DATA_TYPE_AMF3_XML_LEGACY = 7;
    public static final byte DATA_TYPE_AMF3_DATE = 8;
    public static final byte DATA_TYPE_AMF3_ARRAY = 9;
    public static final byte DATA_TYPE_AMF3_OBJECT = 10;
    public static final byte DATA_TYPE_AMF3_XML_TOP = 11;
    public static final byte DATA_TYPE_AMF3_BYTEARRAY = 12;
    public static final byte AMF_LEVEL0 = 0;
    public static final byte AMF_LEVEL3 = 3;
    public static final int MILLS_PER_HOUR = 60000;
    protected int type = 5;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public static boolean testNextByte(ByteBuffer byteBuffer, int n) {
        boolean bl = false;
        try {
            if (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (by == n) {
                    bl = true;
                } else {
                    byteBuffer.position(byteBuffer.position() - 1);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFData.class).error("AMFData.testNextByte[" + byteBuffer.capacity() + ":" + byteBuffer.position() + "]: " + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    public static int peekByte(ByteBuffer byteBuffer) {
        byte by = 0;
        try {
            if (byteBuffer.hasRemaining()) {
                by = byteBuffer.get();
                byteBuffer.position(byteBuffer.position() - 1);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFData.class).error("peekByte: " + exception.toString());
            exception.printStackTrace();
        }
        return by;
    }

    public static int skipByte(ByteBuffer byteBuffer) {
        byte by = 0;
        try {
            if (byteBuffer.hasRemaining()) {
                by = byteBuffer.get();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFData.class).error("skipByte: " + exception.toString());
            exception.printStackTrace();
        }
        return by;
    }

    public static boolean isObjStart(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return AMFData.testNextByte(byteBuffer, aMFDataContextDeserialize.isAMF3() ? 10 : 3);
    }

    public static boolean isAMF3Start(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return aMFDataContextDeserialize.isAMF3() ? false : AMFData.testNextByte(byteBuffer, 17);
    }

    public static boolean isArrayStart(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return aMFDataContextDeserialize.isAMF3() ? false : AMFData.testNextByte(byteBuffer, 10);
    }

    public static boolean isMixedArrayStart(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return AMFData.testNextByte(byteBuffer, aMFDataContextDeserialize.isAMF3() ? 9 : 8);
    }

    public static boolean isObjEnd(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return aMFDataContextDeserialize.isAMF3() ? false : AMFData.testNextByte(byteBuffer, 9);
    }

    public static boolean isByteArrayStart(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        return aMFDataContextDeserialize.isAMF0() ? false : AMFData.testNextByte(byteBuffer, 12);
    }

    public static AMFData getReference(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        AMFData aMFData = null;
        try {
            if (aMFDataContextDeserialize.isAMF0()) {
                int n = BufferUtils.getUnsignedShort(byteBuffer);
                aMFData = (AMFData)aMFDataContextDeserialize.getObject(n);
            } else {
                int n = AMF3Utils.deserializeInt(byteBuffer);
                if ((n & 1) == 0) {
                    aMFData = (AMFData)aMFDataContextDeserialize.getObject(n >>= 1);
                } else {
                    aMFDataContextDeserialize.setIntData(n);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("AMFData.getReference: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFData;
    }

    public static AMFData deserializeInnerObject(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) throws IOException {
        AMFData aMFData;
        block15: {
            int n;
            aMFData = null;
            while ((n = AMFData.peekByte(byteBuffer)) == 17) {
                AMFData.skipByte(byteBuffer);
                aMFDataContextDeserialize.setObjectEncoding(3);
            }
            if (aMFDataContextDeserialize.isAMF0()) {
                switch (n) {
                    case 3: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = new AMFDataObj(byteBuffer, aMFDataContextDeserialize);
                        break;
                    }
                    case 16: {
                        AMFData.skipByte(byteBuffer);
                        int n2 = BufferUtils.getUnsignedShort(byteBuffer);
                        byte[] byArray = new byte[n2];
                        byteBuffer.get(byArray);
                        String string = new String(byArray, "UTF-8");
                        aMFData = new AMFDataObj(byteBuffer, aMFDataContextDeserialize);
                        if (aMFData == null) break;
                        ((AMFDataObj)aMFData).setClassName(string);
                        break;
                    }
                    case 8: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = new AMFDataMixedArray(byteBuffer, aMFDataContextDeserialize);
                        break;
                    }
                    case 10: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = new AMFDataArray(byteBuffer, aMFDataContextDeserialize);
                        break;
                    }
                    case 7: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = AMFData.getReference(byteBuffer, aMFDataContextDeserialize);
                    }
                }
            } else {
                switch (n) {
                    case 9: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = AMFData.getReference(byteBuffer, aMFDataContextDeserialize);
                        if (aMFData != null) break;
                        aMFData = new AMFDataMixedArray(byteBuffer, aMFDataContextDeserialize);
                        break;
                    }
                    case 10: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = AMFData.getReference(byteBuffer, aMFDataContextDeserialize);
                        if (aMFData != null) break;
                        aMFData = new AMFDataObj(byteBuffer, aMFDataContextDeserialize);
                        break;
                    }
                    case 12: {
                        AMFData.skipByte(byteBuffer);
                        aMFData = AMFData.getReference(byteBuffer, aMFDataContextDeserialize);
                        if (aMFData != null) break;
                        aMFData = new AMFDataByteArray(byteBuffer, aMFDataContextDeserialize);
                    }
                }
            }
            if (aMFData != null) break block15;
            aMFData = new AMFDataItem(byteBuffer, aMFDataContextDeserialize);
        }
        return aMFData;
    }

    public static AMFDataContextSerialize createContextSerialize() {
        return new AMFDataContextSerialize(0);
    }

    public static AMFDataContextSerialize createContextSerialize(int n) {
        return new AMFDataContextSerialize(n);
    }

    public static AMFDataContextDeserialize createContextDeserialize() {
        return new AMFDataContextDeserialize(0);
    }

    public static AMFDataContextDeserialize createContextDeserialize(int n) {
        return new AMFDataContextDeserialize(n);
    }

    public abstract void serialize(DataOutputStream var1);

    public abstract void serialize(DataOutputStream var1, int var2);

    public abstract void serialize(DataOutputStream var1, AMFDataContextSerialize var2);

    public abstract byte[] serialize();

    public abstract byte[] serialize(int var1);

    public abstract byte[] serialize(AMFDataContextSerialize var1);

    public abstract void deserialize(ByteBuffer var1);

    public abstract void deserialize(ByteBuffer var1, AMFDataContextDeserialize var2);

    public abstract Object getValue();

    public static boolean triggerAMF3Switch(AMFData aMFData) {
        boolean bl = false;
        if (aMFData instanceof AMFDataObj) {
            bl = true;
        } else if (aMFData instanceof AMFDataMixedArray) {
            bl = true;
        } else if (aMFData instanceof AMFDataByteArray) {
            bl = true;
        } else if (aMFData instanceof AMFDataArray) {
            bl = true;
        }
        return bl;
    }
}

