/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class AMFDataByteArray
extends AMFData {
    byte[] data = null;

    public AMFDataByteArray() {
        this.type = 33;
    }

    public AMFDataByteArray(byte[] byArray) {
        this.type = 33;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataByteArray(byte[] byArray, int n, int n2) {
        this.type = 33;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataByteArray(ByteBuffer byteBuffer) {
        this.type = 33;
        this.deserialize(byteBuffer);
    }

    public AMFDataByteArray(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.type = 33;
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public int size() {
        return this.data == null ? 0 : this.data.length;
    }

    public byte[] toArray() {
        return this.data;
    }

    public ByteBuffer toByteBuffer() {
        if (this.data != null) {
            return ByteBuffer.wrap(this.data);
        }
        return null;
    }

    public static AMFDataByteArray wrap(byte[] byArray) {
        AMFDataByteArray aMFDataByteArray = new AMFDataByteArray();
        aMFDataByteArray.data = byArray;
        return aMFDataByteArray;
    }

    public static AMFDataByteArray wrap(ByteBuffer byteBuffer) {
        AMFDataByteArray aMFDataByteArray = new AMFDataByteArray();
        try {
            aMFDataByteArray.data = byteBuffer.array();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aMFDataByteArray.data == null) {
            aMFDataByteArray.data = new byte[byteBuffer.limit()];
            int n = byteBuffer.position();
            byteBuffer.position(0);
            byteBuffer.get(aMFDataByteArray.data);
            byteBuffer.position(n);
        }
        return aMFDataByteArray;
    }

    public Object getValue() {
        return this.data;
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        try {
            if (!aMFDataContextDeserialize.isAMF0()) {
                int n = aMFDataContextDeserialize.isIntData() ? aMFDataContextDeserialize.clearIntData() : AMF3Utils.deserializeInt(byteBuffer);
                this.data = new byte[n >>= 1];
                byteBuffer.get(this.data);
                aMFDataContextDeserialize.addObject(this);
            } else {
                WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("AMDDataByteArray.deserialize: AMF0 does not support ByteArray data");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("AMFDataByteArray.deserialize[" + byteBuffer.capacity() + ":" + byteBuffer.position() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0));
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n));
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        try {
            if (!aMFDataContextSerialize.isAMF0()) {
                dataOutputStream.write(12);
                int n = aMFDataContextSerialize.getObjectReference(this);
                if (n >= 0) {
                    AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                } else {
                    int n2 = this.size();
                    n2 <<= 1;
                    AMF3Utils.serializeInt(dataOutputStream, n2 |= 1);
                    n2 = this.size();
                    if (n2 > 0) {
                        dataOutputStream.write(this.data);
                    }
                }
            } else {
                int n = this.size();
                AMFDataObj aMFDataObj = new AMFDataObj();
                aMFDataObj.put("endian", new AMFDataItem("bigEndian"));
                aMFDataObj.put("length", new AMFDataItem(n));
                aMFDataObj.put("position", new AMFDataItem(n));
                aMFDataObj.put("objectEncoding", new AMFDataItem(3));
                aMFDataObj.serialize(dataOutputStream, aMFDataContextSerialize);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] serialize() {
        return this.serialize(AMFData.createContextSerialize(0));
    }

    public byte[] serialize(int n) {
        return this.serialize(AMFData.createContextSerialize(n));
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream, aMFDataContextSerialize);
        return byteArrayOutputStream.toByteArray();
    }

    public int compress() {
        int n = this.size();
        if (n > 0) {
            Deflater deflater = new Deflater();
            deflater.setLevel(9);
            deflater.setInput(this.data);
            deflater.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            byte[] byArray = new byte[1024];
            while (!deflater.finished()) {
                int n2 = deflater.deflate(byArray);
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("decompress.decompressor: " + exception.toString());
                exception.printStackTrace();
            }
            this.data = byteArrayOutputStream.toByteArray();
        }
        return this.size();
    }

    public int decompress() {
        int n = this.size();
        if (n > 0) {
            Inflater inflater = new Inflater();
            inflater.setInput(this.data);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            byte[] byArray = new byte[1024];
            while (!inflater.finished()) {
                try {
                    int n2 = inflater.inflate(byArray);
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("decompress.decompressor: " + exception.toString());
                    exception.printStackTrace();
                }
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AMFDataByteArray.class).error("decompress.close: " + exception.toString());
                exception.printStackTrace();
            }
            this.data = byteArrayOutputStream.toByteArray();
        }
        return this.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.size();
        stringBuffer.append("{Array: size: " + n);
        if (n < 1024) {
            stringBuffer.append(", data: {");
            for (int i = 0; i < n; ++i) {
                String string = Integer.toHexString(this.data[i]);
                if (string.length() < 2) {
                    string = "0" + string;
                } else if (string.length() > 2) {
                    string = string.substring(string.length() - 2);
                }
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("0x" + string);
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append(", data: [largeblock]");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

