/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.drm.playready;

import com.wowza.io.IRandomAccessReader;
import com.wowza.wms.drm.playready.PlayReadyEncryptionResult;
import com.wowza.wms.drm.playready.PlayReadySampleInfo;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayReadySampleData {
    public static final int PLAYREADY_BUFFERSIZE = 2048;
    private List<RTPPacketFragment> buffers = new ArrayList<RTPPacketFragment>();
    private int count = 0;
    private int size = 0;
    private int subSampleCount = 0;
    private byte[] buffer = null;
    private int index = 0;
    private int ivLen = 16;
    private byte[] keyId = null;
    private int algorithmId = 1;

    public List<RTPPacketFragment> getFragments() {
        return this.buffers;
    }

    public int getSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSubSamples() {
        return this.subSampleCount > 0;
    }

    public void flush() {
        if (this.index > 0) {
            this.buffers.add(new RTPPacketFragment(this.buffer, 0, this.index));
            this.size += this.index;
        }
        this.buffer = null;
        this.index = 0;
    }

    public void add(PlayReadyEncryptionResult playReadyEncryptionResult) {
        block2: {
            int n = playReadyEncryptionResult.getSize();
            if (this.buffer == null || this.index + n > 2048) {
                if (this.buffer != null) {
                    this.buffers.add(new RTPPacketFragment(this.buffer, 0, this.index));
                    this.size += this.index;
                }
                this.buffer = new byte[2048];
                this.index = 0;
            }
            playReadyEncryptionResult.getBytes(this.buffer, this.index);
            this.index += n;
            ++this.count;
            if (!playReadyEncryptionResult.isSubSampleInfo()) break block2;
            ++this.subSampleCount;
        }
    }

    public void add(IRandomAccessReader iRandomAccessReader, QTAtomtrak qTAtomtrak, long l) {
        block3: {
            PlayReadySampleInfo playReadySampleInfo = qTAtomtrak.getPlayReadySampleInfo(iRandomAccessReader, l);
            if (playReadySampleInfo == null) break block3;
            int n = playReadySampleInfo.getSize();
            if (this.buffer == null || this.index + n > 2048) {
                if (this.buffer != null) {
                    this.buffers.add(new RTPPacketFragment(this.buffer, 0, this.index));
                    this.size += this.index;
                }
                this.buffer = new byte[2048];
                this.index = 0;
            }
            playReadySampleInfo.getBytes(this.buffer, this.index);
            this.index += n;
            ++this.count;
            if (playReadySampleInfo.isSubSampleInfo()) {
                ++this.subSampleCount;
            }
        }
    }

    public int getIvLen() {
        return this.ivLen;
    }

    public void setIvLen(int n) {
        this.ivLen = n;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public void setKeyId(byte[] byArray) {
        this.keyId = byArray;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(int n) {
        this.algorithmId = n;
    }
}

