/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.logging;

import com.wowza.wms.logging.PortBased;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class UDPAppender
extends AppenderSkeleton
implements PortBased {
    public static final int DEFAULT_PORT = 9991;
    String hostname;
    String remoteHost;
    String application;
    String encoding;
    InetAddress address;
    int port = 9991;
    DatagramSocket outSocket;
    boolean inError = false;

    public UDPAppender() {
        super(false);
    }

    public UDPAppender(InetAddress inetAddress, int n) {
        super(false);
        this.address = inetAddress;
        this.remoteHost = inetAddress.getHostName();
        this.port = n;
        this.activateOptions();
    }

    public UDPAppender(String string, int n) {
        super(false);
        this.port = n;
        this.address = this.getAddressByName(string);
        this.remoteHost = string;
        this.activateOptions();
    }

    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException2) {
                this.hostname = "unknown";
            }
        }
        if (this.application == null) {
            this.application = System.getProperty("application");
        } else if (System.getProperty("application") != null) {
            this.application = this.application + "-" + System.getProperty("application");
        }
        if (this.remoteHost == null) {
            String string = "The RemoteHost property is required for SocketAppender named " + this.name;
            LogLog.error((String)string);
            throw new IllegalStateException(string);
        }
        this.address = this.getAddressByName(this.remoteHost);
        this.connect(this.address, this.port);
        super.activateOptions();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception exception) {
                LogLog.error((String)"Could not close outSocket.", (Throwable)exception);
            }
            this.outSocket = null;
        }
    }

    void connect(InetAddress inetAddress, int n) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new DatagramSocket();
            this.outSocket.connect(inetAddress, n);
        }
        catch (IOException iOException) {
            LogLog.error((String)"Could not open UDP Socket for sending.", (Throwable)iOException);
            this.inError = true;
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (this.inError) {
            return;
        }
        if (loggingEvent == null) {
            return;
        }
        if (this.address == null) {
            return;
        }
        if (this.outSocket != null) {
            loggingEvent.setProperty("hostname", this.hostname);
            if (this.application != null) {
                loggingEvent.setProperty("application", this.application);
            }
            try {
                StringBuffer stringBuffer = new StringBuffer(this.layout.format(loggingEvent));
                byte[] byArray = this.encoding == null ? stringBuffer.toString().getBytes() : stringBuffer.toString().getBytes(this.encoding);
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.address, this.port);
                this.outSocket.send(datagramPacket);
            }
            catch (IOException iOException) {
                this.outSocket = null;
                LogLog.warn((String)("Detected problem with UDP connection: " + iOException));
            }
        }
    }

    public boolean isActive() {
        return !this.inError;
    }

    InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            LogLog.error((String)("Could not find address of [" + string + "]."), (Throwable)exception);
            return null;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public String getApplication() {
        return this.application;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }
}

