/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.media.mp3.model.idtags.ID3V2Utils;
import com.wowza.wms.media.mp3.model.idtags.IID3V2Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3Frames {
    public static final int ID3HEADER_VERSION = 1024;
    public static final int ID3HEADER_SIZE = 10;
    public static final int ID3FOOTER_SIZE = 10;
    public static final int ID3HEADERFLAGS_DEFAULT = 0;
    public static final int ID3HEADERFLAGS_UNSYNC = 128;
    public static final int ID3HEADERFLAGS_EXTENDED = 64;
    public static final int ID3HEADERFLAGS_EXPERIMENTAL = 32;
    public static final int ID3HEADERFLAGS_FOOTERPRESENT = 16;
    private Map<String, IID3V2Frame> frames = new HashMap<String, IID3V2Frame>();
    private Object lock = new Object();

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.frames.size() <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFrame(IID3V2Frame iID3V2Frame) {
        Object object = this.lock;
        synchronized (object) {
            this.frames.put(iID3V2Frame.getMapIdStr(), iID3V2Frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IID3V2Frame removeFrame(IID3V2Frame iID3V2Frame) {
        Object object = this.lock;
        synchronized (object) {
            return this.frames.remove(iID3V2Frame.getMapIdStr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IID3V2Frame> getFrames() {
        ArrayList<IID3V2Frame> arrayList = new ArrayList<IID3V2Frame>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.frames.values());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFrameMapIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.frames.keySet());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            for (IID3V2Frame iID3V2Frame : this.frames.values()) {
                n += iID3V2Frame.getSize();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int serializeTags(byte[] byArray, int n) {
        int n2 = 0;
        Object object = this.lock;
        synchronized (object) {
            for (IID3V2Frame iID3V2Frame : this.frames.values()) {
                int n3 = iID3V2Frame.serialize(byArray, n + n2);
                n2 += n3;
            }
        }
        return n2;
    }

    public static int serializeHeader(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        System.arraycopy("ID3".getBytes(), 0, byArray, n + n4, 3);
        BufferUtils.intToByteArray(1024, byArray, n + (n4 += 3), 2);
        byArray[n + (n4 += 2)] = (byte)(n2 & 0xFF);
        ID3V2Utils.intToByteArraySafeSync(n3, byArray, n + ++n4, 4);
        return n4 += 4;
    }

    public static int serializeFooter(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        System.arraycopy("3DI".getBytes(), 0, byArray, n + n4, 3);
        BufferUtils.intToByteArray(1024, byArray, n + (n4 += 3), 2);
        byArray[n + (n4 += 2)] = (byte)(n2 & 0xFF);
        ID3V2Utils.intToByteArraySafeSync(n3, byArray, n + ++n4, 4);
        return n4 += 4;
    }

    public byte[] serialize() {
        return this.serialize(false, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(boolean bl, boolean bl2, int n) {
        byte[] byArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (bl2) {
                n |= 0x10;
            }
            int n2 = this.getSize();
            int n3 = n2 + (bl ? 10 : 0) + (bl2 ? 10 : 0);
            byArray = new byte[n3];
            int n4 = 0;
            if (bl) {
                n4 += ID3Frames.serializeHeader(byArray, n4, n, n2);
            }
            n4 += this.serializeTags(byArray, n4);
            if (bl2) {
                n4 += ID3Frames.serializeFooter(byArray, n4, n, n2);
            }
        }
        return byArray;
    }
}

