/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FrameLinkedInformation
extends ID3V2FrameBase {
    private long frameIdentifier = 0L;
    private String url = null;
    private byte[] data = null;

    public ID3V2FrameLinkedInformation(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameLinkedInformation() {
        super("COMM", 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            BufferUtils.longToByteArray(this.frameIdentifier, byArray, n + n2, 4);
            int n3 = ID3V2FrameLinkedInformation.serializeString(this.url, byArray, n + (n2 += 4));
            n2 += n3;
            if (this.data != null) {
                System.arraycopy(this.data, 0, byArray, n + n2, this.data.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 4 < n2) {
                this.frameIdentifier = BufferUtils.byteArrayToLong(byArray, n, 4);
                String string = ID3V2FrameLinkedInformation.deserializeString(byArray, n += 4, n2);
                if (string != null) {
                    this.url = string;
                    int n3 = n2 - (n += string.length() + 1);
                    if (n3 > 0) {
                        this.data = new byte[n3];
                        System.arraycopy(byArray, n, this.data, 0, n3);
                        n += n3;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return 4 + ID3V2FrameLinkedInformation.serializeStringLen(this.url) + (this.data == null ? 0 : this.data.length);
    }

    public String getDescription() {
        return this.url;
    }

    public void setDescription(String string) {
        this.url = string;
    }

    public long getFrameIdentifier() {
        return this.frameIdentifier;
    }

    public void setFrameIdentifier(long l) {
        this.frameIdentifier = l;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }
}

