/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.wav;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.wav.WAVHeaderInfo;
import java.io.RandomAccessFile;

public class WAVUtils {
    public static WAVHeaderInfo readWAVHeader(RandomAccessFile randomAccessFile) {
        WAVHeaderInfo wAVHeaderInfo = new WAVHeaderInfo();
        try {
            byte[] byArray = new byte[8];
            randomAccessFile.readFully(byArray, 0, 4);
            String string = BufferUtils.byteArrayToString(byArray, 0, 4);
            randomAccessFile.readFully(byArray, 0, 4);
            long l = BufferUtils.byteArrayToLong(byArray, 0, 4, true);
            randomAccessFile.readFully(byArray, 0, 4);
            wAVHeaderInfo.riffType = BufferUtils.byteArrayToString(byArray, 0, 4);
            long l2 = randomAccessFile.getFilePointer();
            randomAccessFile.readFully(byArray, 0, 4);
            String string2 = BufferUtils.byteArrayToString(byArray, 0, 4);
            if (string2.equals("fmt ")) {
                randomAccessFile.readFully(byArray, 0, 4);
                long l3 = BufferUtils.byteArrayToLong(byArray, 0, 4, true);
                long l4 = randomAccessFile.getFilePointer();
                randomAccessFile.readFully(byArray, 0, 2);
                wAVHeaderInfo.compressionCode = BufferUtils.byteArrayToInt(byArray, 0, 2, true);
                randomAccessFile.readFully(byArray, 0, 2);
                wAVHeaderInfo.channelCount = BufferUtils.byteArrayToInt(byArray, 0, 2, true);
                randomAccessFile.readFully(byArray, 0, 4);
                wAVHeaderInfo.sampleRate = BufferUtils.byteArrayToLong(byArray, 0, 4, true);
                randomAccessFile.readFully(byArray, 0, 4);
                wAVHeaderInfo.byteRate = BufferUtils.byteArrayToLong(byArray, 0, 4, true);
                randomAccessFile.readFully(byArray, 0, 2);
                wAVHeaderInfo.blockAlign = BufferUtils.byteArrayToInt(byArray, 0, 2, true);
                randomAccessFile.readFully(byArray, 0, 2);
                wAVHeaderInfo.bitsPerSample = BufferUtils.byteArrayToInt(byArray, 0, 2, true);
                randomAccessFile.seek(l4 + l3 + 8L);
            } else if (string2.equals("data")) {
                randomAccessFile.seek(l2 + 8L);
            } else {
                System.out.println("unrecognized chunk: " + string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).debug("WAVUtils.readWAVHeader: " + exception.toString());
        }
        return wAVHeaderInfo;
    }

    public static byte[] readSamples(RandomAccessFile randomAccessFile, WAVHeaderInfo wAVHeaderInfo, int n) {
        byte[] byArray = null;
        try {
            int n2 = wAVHeaderInfo.blockAlign * n;
            if (randomAccessFile.getFilePointer() + (long)n2 > randomAccessFile.length()) {
                n2 = (int)(randomAccessFile.length() - randomAccessFile.getFilePointer());
            }
            if (n2 > 0) {
                byArray = new byte[n2];
                randomAccessFile.readFully(byArray);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).debug("WAVUtils.readSamples: " + exception.toString());
        }
        return byArray;
    }
}

