/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCasterValidateMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaCasterStreamMap {
    private IApplicationInstance appInstance = null;
    private Map<String, MediaCasterStreamItem> mediaCasters = new HashMap<String, MediaCasterStreamItem>();
    private Map<Long, String> streamToMediaCaster = new HashMap<Long, String>();
    private WMSReadWriteLock lock = null;
    private MediaCasterStreamManager streamManager = new MediaCasterStreamManager(this);
    private long nextStreamItemId = 0L;

    public MediaCasterStreamMap(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.lock = iApplicationInstance.getClientsLockObj();
    }

    public WMSReadWriteLock getLock() {
        return this.lock;
    }

    public MediaCasterStreamManager getStreamManager() {
        return this.streamManager;
    }

    public IApplicationInstance getApplicationInstance() {
        return this.appInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMediaCasterCount() {
        int n = 0;
        this.lock.readLock().lock();
        try {
            n = this.mediaCasters.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterCount: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWatchdog() {
        ArrayList<MediaCasterStreamItem> arrayList = null;
        this.lock.readLock().lock();
        try {
            arrayList = new ArrayList<MediaCasterStreamItem>(this.mediaCasters.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<MediaCasterStreamItem> arrayList2 = new ArrayList<MediaCasterStreamItem>();
        if (arrayList != null) {
            IMediaCasterValidateMediaCaster iMediaCasterValidateMediaCaster = this.appInstance.getMediaCasterValidator();
            if (iMediaCasterValidateMediaCaster != null) {
                iMediaCasterValidateMediaCaster.onValidateMediaCastersStart(this.appInstance);
            }
            for (MediaCasterStreamItem mediaCasterStreamItem : arrayList) {
                if (!mediaCasterStreamItem.doWatchdog()) continue;
                arrayList2.add(mediaCasterStreamItem);
            }
            if (iMediaCasterValidateMediaCaster != null) {
                iMediaCasterValidateMediaCaster.onValidateMediaCastersStop(this.appInstance);
            }
        }
        if (arrayList2.size() > 0) {
            this.lock.writeLock().lock();
            try {
                for (MediaCasterStreamItem mediaCasterStreamItem : arrayList2) {
                    String string = mediaCasterStreamItem.getMediaCasterId();
                    MediaCasterStreamItem mediaCasterStreamItem2 = this.mediaCasters.get(string);
                    if (mediaCasterStreamItem2 == null || mediaCasterStreamItem2.getUniqueId() != mediaCasterStreamItem.getUniqueId()) continue;
                    this.mediaCasters.remove(string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        ArrayList<MediaCasterStreamItem> arrayList = null;
        this.lock.writeLock().lock();
        try {
            arrayList = new ArrayList<MediaCasterStreamItem>();
            arrayList.addAll(this.mediaCasters.values());
            this.mediaCasters.clear();
            this.streamToMediaCaster.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.shutdown[1]: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (arrayList != null) {
            for (MediaCasterStreamItem mediaCasterStreamItem : arrayList) {
                try {
                    mediaCasterStreamItem.shutdown(bl);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.shutdown[2]: " + exception.toString());
                }
            }
        }
    }

    private String getMediaCasterId(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        IMediaStream iMediaStream = iMediaStreamPlay.getParent();
        return MediaCasterItem.getIdString(iMediaStream.getName(), iMediaStream.getLiveStreamPacketizer(), iMediaStream.getLiveStreamRepeater());
    }

    private String getMediaCasterId(String string, String string2, String string3, MediaCasterItem mediaCasterItem) {
        return MediaCasterItem.getIdString(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMediaCasterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.lock.readLock().lock();
        try {
            arrayList.addAll(this.mediaCasters.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterNames: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaCasterStreamItem getMediaCasterStreamItem(String string, String string2, MediaCasterItem mediaCasterItem, String string3, String string4) {
        MediaCasterStreamItem mediaCasterStreamItem = null;
        this.lock.writeLock().lock();
        try {
            mediaCasterStreamItem = this.mediaCasters.get(string);
            if (mediaCasterStreamItem != null && !mediaCasterStreamItem.isValid()) {
                mediaCasterStreamItem = null;
            }
            if (mediaCasterStreamItem == null) {
                ++this.nextStreamItemId;
                mediaCasterStreamItem = new MediaCasterStreamItem(this.nextStreamItemId);
                mediaCasterStreamItem.init(string, string2, mediaCasterItem, this, string3, string4);
                this.mediaCasters.put(string, mediaCasterStreamItem);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterStreamItem: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return mediaCasterStreamItem;
    }

    public MediaCasterStreamItem getMediaCaster(String string) {
        return this.getMediaCaster(string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaCasterStreamItem getMediaCaster(String string, String string2, String string3) {
        String string4 = MediaCasterItem.getIdString(string, string2, string3);
        MediaCasterStreamItem mediaCasterStreamItem = null;
        this.lock.readLock().lock();
        try {
            mediaCasterStreamItem = this.mediaCasters.get(string4);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterNames[" + string4 + "]: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return mediaCasterStreamItem;
    }

    public MediaCasterStreamItem acquire(String string, String string2, String string3) {
        return this.acquire(string, string2, string3, (String)null);
    }

    public MediaCasterStreamItem acquire(String string) {
        return this.acquire(string, (String)null, (String)null, (String)null);
    }

    public MediaCasterStreamItem acquire(String string, MediaCasterItem mediaCasterItem) {
        return this.acquire(string, null, null, mediaCasterItem);
    }

    public MediaCasterStreamItem acquire(String string, String string2, String string3, MediaCasterItem mediaCasterItem) {
        String string4;
        MediaCasterStreamItem mediaCasterStreamItem;
        MediaCasterStreamItem mediaCasterStreamItem2 = null;
        String string5 = string;
        String string6 = "flv";
        String string7 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string5, string6);
        string5 = stringArray[0];
        string6 = stringArray[1];
        boolean bl = string5.indexOf("://") >= 0;
        int n = string5.indexOf("?");
        if (!bl && n >= 0) {
            string7 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        if ((mediaCasterStreamItem = this.getMediaCasterStreamItem(string4 = this.getMediaCasterId(string5, string2, string3, mediaCasterItem), string6, mediaCasterItem, string2, string3)) != null) {
            mediaCasterStreamItem.acquire();
        }
        mediaCasterStreamItem2 = mediaCasterStreamItem;
        return mediaCasterStreamItem2;
    }

    public MediaCasterStreamItem acquire(String string, String string2) {
        return this.acquire(string, null, null, string2);
    }

    public MediaCasterStreamItem acquire(String string, String string2, String string3, String string4) {
        StreamList streamList;
        StreamItem streamItem;
        MediaCasterStreamItem mediaCasterStreamItem = null;
        String string5 = string;
        String string6 = "flv";
        String string7 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string5, string6);
        string5 = stringArray[0];
        string6 = stringArray[1];
        boolean bl = string5.indexOf("://") >= 0;
        int n = string5.indexOf("?");
        if (!bl && n >= 0) {
            string7 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        IVHost iVHost = this.appInstance.getVHost();
        if (string4 == null) {
            string4 = this.appInstance.getStreamType();
        }
        if ((streamItem = (streamList = iVHost.getStreamTypes()).getStreamDef(string4)) == null) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find StreamType definition: " + string4);
        } else {
            String string8 = null;
            WMSProperties wMSProperties = streamItem.getProperties();
            if (wMSProperties != null) {
                string8 = wMSProperties.getPropertyStr("mediaCasterType", string8);
            }
            if (string8 == null) {
                WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find MediaCaster definition for stream type: " + string4);
            } else {
                MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string8);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find MediaCaster definition: " + string8);
                } else {
                    String string9 = this.getMediaCasterId(string5, string2, string3, mediaCasterItem);
                    MediaCasterStreamItem mediaCasterStreamItem2 = this.getMediaCasterStreamItem(string9, string6, mediaCasterItem, string2, string3);
                    if (mediaCasterStreamItem2 != null) {
                        mediaCasterStreamItem2.acquire();
                    }
                    mediaCasterStreamItem = mediaCasterStreamItem2;
                }
            }
        }
        return mediaCasterStreamItem;
    }

    public void release(MediaCasterStreamItem mediaCasterStreamItem) {
        mediaCasterStreamItem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(MediaCasterStreamItem mediaCasterStreamItem, boolean bl) {
        boolean bl2 = false;
        this.lock.writeLock().lock();
        try {
            mediaCasterStreamItem.release();
            if (bl && mediaCasterStreamItem.getLockCount() == 0) {
                mediaCasterStreamItem.setValid(false);
                this.mediaCasters.remove(mediaCasterStreamItem.getMediaCasterId());
                bl2 = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (bl2) {
            mediaCasterStreamItem.shutdown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MediaCasterStreamItem mediaCasterStreamItem) {
        this.lock.writeLock().lock();
        try {
            this.mediaCasters.remove(mediaCasterStreamItem.getMediaCasterId());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String streamSrcToMediaCaster(long l) {
        if (l <= 0L) {
            return null;
        }
        String string = null;
        this.lock.readLock().lock();
        try {
            string = this.streamToMediaCaster.get(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.streamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamSrcToMediaCaster(long l, String string) {
        if (l <= 0L) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.streamToMediaCaster.put(new Long(l), string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.addStreamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamSrcToMediaCaster(long l) {
        if (l <= 0L) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.streamToMediaCaster.remove(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.clearStreamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private long playerToStreamSrc(IMediaStreamPlay iMediaStreamPlay) {
        long l;
        block1: {
            IMediaStream iMediaStream;
            l = -1L;
            if (iMediaStreamPlay == null || (iMediaStream = iMediaStreamPlay.getParent()) == null) break block1;
            l = iMediaStream.getSrc();
            IClient iClient = iMediaStream.getClient();
            if (iClient != null) {
                long l2 = iClient.getClientId();
                l += l2 << 32;
            }
        }
        return l;
    }

    private boolean mediaCasterEquals(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        block2: {
            long l = this.playerToStreamSrc(iMediaStreamPlay);
            String string = this.streamSrcToMediaCaster(l);
            String string2 = this.getMediaCasterId(iMediaStreamPlay, mediaCasterItem);
            String string3 = iMediaStreamPlay.getParent().getExt();
            String string4 = iMediaStreamPlay.getParent().getLiveStreamPacketizer();
            String string5 = iMediaStreamPlay.getParent().getLiveStreamRepeater();
            if (this.mediaCasterEquals(string, string2)) break block2;
            MediaCasterStreamItem mediaCasterStreamItem = null;
            if (string != null && (mediaCasterStreamItem = this.getMediaCasterStreamItem(string, string3, mediaCasterItem, string4, string5)) != null) {
                mediaCasterStreamItem.unregisterPlayer(iMediaStreamPlay);
            }
            if ((mediaCasterStreamItem = this.getMediaCasterStreamItem(string2, string3, mediaCasterItem, string4, string5)) != null) {
                mediaCasterStreamItem.registerPlayer(iMediaStreamPlay);
            }
            this.addStreamSrcToMediaCaster(l, string2);
        }
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        String string;
        String string2;
        String string3;
        long l = this.playerToStreamSrc(iMediaStreamPlay);
        String string4 = this.getMediaCasterId(iMediaStreamPlay, mediaCasterItem);
        MediaCasterStreamItem mediaCasterStreamItem = this.getMediaCasterStreamItem(string4, string3 = iMediaStreamPlay.getParent().getExt(), mediaCasterItem, string2 = iMediaStreamPlay.getParent().getLiveStreamPacketizer(), string = iMediaStreamPlay.getParent().getLiveStreamRepeater());
        if (mediaCasterStreamItem != null) {
            mediaCasterStreamItem.unregisterPlayer(iMediaStreamPlay);
        }
        this.clearStreamSrcToMediaCaster(l);
    }
}

