/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RTPPacketFragmentListReader {
    private List<RTPPacketFragment> fragments = null;
    private int findex = -1;
    private int bindex = 0;
    private int index = 0;
    private byte[] buffer = null;
    private int boffset = 0;
    private int blen = 0;
    private int size = 0;

    public RTPPacketFragmentListReader(List<RTPPacketFragment> list, int n) {
        this.fragments = list;
        this.size = n;
    }

    public static void trim(List<RTPPacketFragment> list, int n) {
        ArrayList<RTPPacketFragment> arrayList = null;
        int n2 = 0;
        for (RTPPacketFragment rTPPacketFragment : list) {
            if (n2 >= n) {
                if (arrayList == null) {
                    arrayList = new ArrayList<RTPPacketFragment>();
                }
                arrayList.add(rTPPacketFragment);
                continue;
            }
            int n3 = rTPPacketFragment.getLen();
            if (n2 + n3 <= n) {
                n2 += n3;
                continue;
            }
            rTPPacketFragment.setLen(n - n2);
            n2 += n - n2;
        }
        if (arrayList != null) {
            list.removeAll(arrayList);
        }
    }

    public int remaining() {
        return this.size - this.index;
    }

    public int count() {
        return this.index;
    }

    public int getByte() {
        int n = 0;
        if (this.findex == -1 || this.bindex >= this.blen) {
            do {
                ++this.findex;
                this.buffer = null;
                if (this.findex >= this.fragments.size()) break;
                RTPPacketFragment rTPPacketFragment = this.fragments.get(this.findex);
                this.buffer = rTPPacketFragment.getBuffer();
                this.boffset = rTPPacketFragment.getOffset();
                this.blen = rTPPacketFragment.getLen();
            } while (this.buffer != null && this.blen <= 0);
            this.bindex = 0;
        }
        if (this.buffer != null) {
            n = this.buffer[this.boffset + this.bindex] & 0xFF;
            ++this.bindex;
            ++this.index;
        }
        return n;
    }

    public void skip() {
        this.getByte();
    }

    public void skip(int n) {
        int n2;
        if (n <= 0) {
            if (n < 0) {
                WMSLoggerFactory.getLogger(RTPPacketFragmentListReader.class).warn("RTPPacketFragmentListReader.skip: Bad skip count: " + n);
            }
            return;
        }
        int n3 = 0;
        this.getByte();
        ++n3;
        while ((n2 = n - n3) != 0) {
            if (n2 > this.blen - this.bindex) {
                n2 = this.blen - this.bindex;
                n3 += n2;
                this.bindex += n2;
                this.index += n2;
                this.getByte();
                ++n3;
            } else {
                n3 += n2;
                this.bindex += n2;
                this.index += n2;
            }
            if (n3 != n) continue;
            break;
        }
    }

    public void get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)this.getByte();
        }
    }
}

