/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.IRTPSessionNotify;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPSessions {
    private Map<String, RTPSession> sessions = new HashMap<String, RTPSession>();
    private IVHost vhost = null;
    private List<IRTPSessionNotify> listeners = new ArrayList<IRTPSessionNotify>();

    public RTPSessions(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public String getNextSessionId() {
        return Server.getInstance().getClientIdGenerator().getNextId() + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            arrayList.addAll(this.sessions.keySet());
        }
        return arrayList;
    }

    public void releaseSessionId(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= 0) {
            Server.getInstance().getClientIdGenerator().releaseId(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession getSession(String string) {
        RTPSession rTPSession = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession = this.sessions.get(string);
        }
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession removeSession(String string) {
        RTPSession rTPSession = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession = this.sessions.remove(string);
        }
        this.releaseSessionId(string);
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession removeSession(RTPSession rTPSession) {
        RTPSession rTPSession2 = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession2 = this.sessions.remove(rTPSession.getSessionId());
        }
        this.releaseSessionId(rTPSession.getSessionId());
        return rTPSession2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession addSession(RTPSession rTPSession) {
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession.setVHost(this.vhost);
            this.sessions.put(rTPSession.getSessionId(), rTPSession);
        }
        return rTPSession;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(IRTPSessionNotify iRTPSessionNotify) {
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.add(iRTPSessionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(IRTPSessionNotify iRTPSessionNotify) {
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iRTPSessionNotify);
        }
    }

    public void notifySessionCreate(IApplicationInstance iApplicationInstance, RTPSession rTPSession) {
        try {
            this.notifySessionCreate(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessions.class).error("RTPSessions.notifySessionCreate: notifySessionCreate: " + exception.toString());
        }
        try {
            iApplicationInstance.getModFunctions().onRTPSessionCreate(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessions.class).error("RTPSessions.notifySessionCreate: onRTPSessionCreate: " + exception.toString());
        }
    }

    public void notifySessionDestroy(IApplicationInstance iApplicationInstance, RTPSession rTPSession) {
        try {
            this.notifySessionDestroy(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessions.class).error("RTPSessions.notifySessionDestroy: notifySessionDestroy: " + exception.toString());
        }
        try {
            iApplicationInstance.getModFunctions().onRTPSessionDestroy(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessions.class).error("RTPSessions.notifySessionDestroy: onRTPSessionDestroy: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionCreate(RTPSession rTPSession) {
        ArrayList<IRTPSessionNotify> arrayList = null;
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IRTPSessionNotify>(this.listeners);
        }
        for (IRTPSessionNotify iRTPSessionNotify : arrayList) {
            iRTPSessionNotify.onRTPSessionCreate(rTPSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionDestroy(RTPSession rTPSession) {
        ArrayList<IRTPSessionNotify> arrayList = null;
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IRTPSessionNotify>(this.listeners);
        }
        for (IRTPSessionNotify iRTPSessionNotify : arrayList) {
            iRTPSessionNotify.onRTPSessionDestroy(rTPSession);
        }
    }
}

