/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BitWriter;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;

public class RTPPacketizerMPEG4LATM
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    protected int timescale = -1;
    protected int channels = -1;
    protected int sampleCount = 1024;
    protected int lastAACSampleRate = -1;
    protected long lastAACTimecode = -1L;

    public RTPPacketizerMPEG4LATM() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 96;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 4) {
                int n2 = aMFPacket.getFirstByte();
                int n3 = aMFPacket.getSecondByte();
                int n4 = FLVUtils.getAudioCodec(n2);
                if (n4 != 10 || n3 == 1) {
                    AACFrame aACFrame;
                    AMFPacket aMFPacket2;
                    if (this.timescale < 0 && (aMFPacket2 = iMediaStream.getAudioCodecConfigPacket(l)) != null && aMFPacket2.getSize() >= 4 && (aACFrame = AACUtils.decodeAACCodecConfig(aMFPacket2.getData(), 2)) != null) {
                        this.timescale = aACFrame.getSampleRate();
                        this.channels = aACFrame.getChannels();
                        this.sampleCount = aACFrame.getSampleCount();
                    }
                    if (this.timescale > 0) {
                        int n5;
                        int n6;
                        long l2 = Math.round((double)(l * (long)this.timescale) / 1000.0);
                        if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.timescale) {
                            this.lastAACSampleRate = this.timescale;
                            this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                        } else {
                            long l3 = this.lastAACTimecode + (long)this.sampleCount;
                            long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastAACSampleRate);
                            n6 = (int)Math.abs(l4 - l);
                            if (n6 <= 1) {
                                l2 = l3;
                                this.lastAACTimecode = l3;
                            } else {
                                this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                            }
                        }
                        byte[] byArray = aMFPacket.getData();
                        int n7 = 2;
                        int n8 = aMFPacket.getSize() - n7;
                        byte[] byArray2 = new byte[6];
                        n6 = 0;
                        for (n5 = n8; n5 > 255; n5 -= 255) {
                            byArray2[n6] = -1;
                            ++n6;
                        }
                        if (n5 == 255) {
                            byArray2[n6] = -1;
                            byArray2[++n6] = 0;
                            ++n6;
                        } else {
                            byArray2[n6] = (byte)n5;
                            ++n6;
                        }
                        int n9 = 12 + n6 + n8;
                        byte[] byArray3 = new byte[n9];
                        this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n9, l2));
                        System.arraycopy(byArray2, 0, byArray3, 12, n6);
                        System.arraycopy(byArray, n7, byArray3, 12 + n6, n8);
                        n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.RTPPacketizerMPEG4LATM: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 0;
        this.timescale = n2;
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            RTPTrack rTPTrack2;
            RTPStream rTPStream;
            long l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            int n3 = 0;
            String string2 = null;
            int n4 = -1;
            int n5 = 15;
            int n6 = 2;
            int n7 = -1;
            int n8 = -1;
            if (iMediaStream != null && (rTPStream = iMediaStream.getRTPStream()) != null && (rTPTrack2 = rTPStream.getAudioTrack()) != null && (string = rTPTrack2.getTrackInfo("sample-type")) != null && string.equalsIgnoreCase("MP4A-LATM")) {
                String string3;
                String string4 = rTPTrack2.getTrackInfo("cpresent");
                if (string4 != null) {
                    try {
                        n3 = Integer.parseInt(string4);
                    }
                    catch (Exception exception) {}
                } else {
                    n3 = -1;
                }
                if ((string3 = rTPTrack2.getTrackInfo("config")) != null) {
                    string2 = string3;
                }
                if ((object3 = (Object)rTPTrack2.getTrackInfo("sbr-enabled")) != null) {
                    try {
                        n4 = Integer.parseInt((String)object3);
                    }
                    catch (Exception exception) {}
                } else {
                    n4 = -1;
                }
                if ((object2 = rTPTrack2.getTrackInfo("profile-level-id")) != null) {
                    try {
                        n5 = Integer.parseInt((String)object2);
                    }
                    catch (Exception exception) {}
                } else {
                    n5 = -1;
                }
                if ((object = rTPTrack2.getTrackInfo("object")) != null) {
                    try {
                        n6 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {}
                } else {
                    n6 = -1;
                }
                n8 = rTPTrack2.getTimescale();
                n7 = rTPTrack2.getChannelCount();
            }
            int n9 = 2;
            int n10 = 4;
            int n11 = 2;
            int n12 = 0;
            int n13 = 255;
            object3 = new byte[1];
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 4) {
                object3 = new byte[aMFPacket2.getSize() - 2];
                System.arraycopy(aMFPacket2.getData(), 2, object3, 0, ((byte[])object3).length);
                object2 = AACUtils.decodeAACCodecConfig(object3, 0);
                if (object2 != null) {
                    if (this.timescale <= 0) {
                        this.timescale = ((AACFrame)object2).getSampleRate();
                    }
                    this.channels = ((AACFrame)object2).getChannels();
                    n9 = ((AACFrame)object2).getProfileObjectType();
                    n10 = ((AACFrame)object2).getRateIndex();
                    n11 = ((AACFrame)object2).getChannelIndex();
                }
            }
            if (string2 == null) {
                object2 = new byte[6];
                object = new BitWriter((byte[])object2);
                ((BitWriter)object).putInt(1, 0);
                ((BitWriter)object).putInt(1, 1);
                ((BitWriter)object).putInt(6, 0);
                ((BitWriter)object).putInt(4, 0);
                ((BitWriter)object).putInt(3, 0);
                ((BitWriter)object).putInt(5, n9);
                ((BitWriter)object).putInt(4, n10);
                ((BitWriter)object).putInt(4, n11);
                ((BitWriter)object).putInt(3, n12);
                ((BitWriter)object).putInt(1, 0);
                ((BitWriter)object).putInt(1, 0);
                ((BitWriter)object).putInt(1, 0);
                ((BitWriter)object).putInt(8, n13);
                ((BitWriter)object).putInt(6, 0);
                string2 = BufferUtils.encodeHexString((byte[])object2);
            }
            if (n8 > 0) {
                if (n8 > this.timescale) {
                    this.sampleCount *= 2;
                }
                this.timescale = n8;
                this.channels = n7;
            }
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " MP4A-LATM/" + this.timescale + "/" + this.channels + "\r\n");
            object2 = "";
            if (n5 >= 0) {
                object2 = (String)object2 + ";profile-level-id=" + n5;
            }
            if (n6 >= 0) {
                object2 = (String)object2 + ";object=" + n6;
            }
            if (n3 >= 0) {
                object2 = (String)object2 + ";cpresent=" + n3;
            }
            if (string2 != null) {
                object2 = (String)object2 + ";config=" + string2.toUpperCase();
            }
            if (n4 >= 0) {
                object2 = (String)object2 + ";SBR-enabled=" + n4;
            }
            if (((String)object2).length() > 0) {
                object2 = ((String)object2).substring(1);
            }
            stringBuffer.append("a=fmtp:" + this.sdpTypeId + " " + (String)object2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4LATM.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(this.timescale);
        rTPDescribeInfo.setChannels(this.channels);
        rTPDescribeInfo.setSDPTypeId(this.sdpTypeId);
        return rTPDescribeInfo;
    }
}

