/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class RTSPCore {
    public static final String HEADER_SESSION = "session";
    public static final String HEADER_CONTEXT = "context";
    public static final String HEADER_PUBLIC = "public";
    public static final String HEADER_USERAGENT = "user-agent";
    public static final String HEADER_TRANSPORT = "transport";

    private static RTPStream createStream(RTPRequestStatus rTPRequestStatus, RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages, int n, String string) {
        RTPStream rTPStream = null;
        try {
            RTPUrl rTPUrl = RTSPRequestAdapter.getRTPUrl(rTSPRequestMessage, false);
            String string2 = rTPUrl.getUrlId();
            IVHost iVHost = rTSPRequestMessage.getVHost();
            RTPContext rTPContext = iVHost.getRTPContext();
            rTPStream = string == null ? new RTPStream(rTPContext, string2) : RTPUtils.decodeStreamInfo(rTPContext, string2, string);
            String string3 = rTSPRequestMessage.getWMSSessionInfo().getIpAddress();
            rTPStream.setRTSP(true);
            rTPStream.setMode(n);
            rTPStream.setOutHost(string3);
            rTPSession.addRTSPStream(rTPStream);
            if (rTPStream.getHost() == null) {
                rTPStream.setHost(rTPUrl.getHost());
            }
            rTPStream.setAppName(rTPUrl.getAppName());
            rTPStream.setAppInstanceName(rTPUrl.getAppInstanceName());
            String string4 = rTPUrl.getQueryStr();
            String string5 = rTPUrl.getStreamName();
            String string6 = "mp4";
            IApplicationInstance iApplicationInstance = rTPSession.getAppInstance();
            string5 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string5, rTPSession);
            if (string5 == null) {
                RTSPStatics.setStatus(rTPRequestStatus, 404);
                rTPSession.setSessionValid(false);
            } else {
                String[] stringArray = ModuleUtils.decodeStreamExtension(string5, string6);
                string5 = stringArray[0];
                string6 = stringArray[1];
                rTPStream.setStreamName(string5);
                rTPStream.setStreamNameLogging(string5);
                rTPStream.setStreamExt(string6);
                rTPStream.setStreamQueryStr(string4);
                rTPStream.createStream(rTPRequestStatus);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.describe: " + exception.toString());
            exception.printStackTrace();
        }
        return rTPStream;
    }

    /*
     * Unable to fully structure code
     */
    public static void describe(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        block22: {
            try {
                var3_3 = new RTPRequestStatus();
                var4_5 = null;
                var5_6 = null;
                var6_7 = false;
                var7_8 = null;
                var5_6 = var0.getRTSPStream();
                if (var5_6 == null) {
                    var5_6 = RTSPCore.createStream(var3_3, var0, var1_1, var2_2, 1, null);
                }
                if (var0 == null) ** GOTO lbl-1000
                var0.onDescribe(var1_1, var2_2);
                if (!var0.isSessionValid()) {
                    RTSPStatics.setStatus(var3_3, 403);
                } else lbl-1000:
                // 2 sources

                {
                    var8_9 = new ArrayList<String>();
                    var8_9.add(var5_6.getStreamName());
                    var5_6.lockRepeaterStreams((List<String>)var8_9);
                    var7_8 = var5_6.getAppInstance();
                    if (var7_8 == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("Application folder ([install-location]/applications/" + var5_6.getAppName() + ") is missing");
                        RTSPStatics.setStatus(var3_3, 403);
                        var0.setSessionValid(false);
                    } else {
                        if (var0 != null) {
                            var0.setDescribe(true);
                        }
                        if (!var1_1.isLastDefer() && !var5_6.isPublishStreamReady()) {
                            var6_7 = true;
                        } else {
                            var4_5 = var5_6.describe(var0, var3_3);
                            if (var4_5 != null && var0.isDebugRTSPSession()) {
                                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).info("DESCRIBE:\n" + var4_5);
                            }
                        }
                    }
                }
                if (!var3_3.isGood()) {
                    var0.setSessionValid(false);
                    var0.shutdown(var3_3);
                    var2_2.setIsDidClose(true);
                    var4_5 = null;
                }
                if (var6_7) {
                    var1_1.setDefer(true);
                    break block22;
                }
                var8_9 = new RTSPResponseMessage();
                var8_9.setResponseCode(var3_3.getResponseCode());
                var8_9.setResponseMessage(var3_3.getResponseMessage());
                var8_9.setCSeq(var1_1.getCSeq());
                var9_10 = new Date();
                var10_11 = FastDateFormat.getInstance((String)"EEE, d MMM yyyy HH:mm:ss z", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
                var11_12 = var10_11.format(var9_10);
                var8_9.setHeader("Date", var11_12);
                var8_9.setHeader("Expires", var11_12);
                var8_9.setHeader("Content-Type", "application/sdp");
                var12_13 = var1_1.getHeader("context");
                var13_14 = null;
                if (var12_13 != null && var12_13.indexOf("://") >= 0) {
                    var13_14 = var12_13.trim();
                    var14_15 = var13_14.indexOf("?");
                    if (var14_15 >= 0) {
                        var13_14 = var13_14.substring(0, var14_15);
                    }
                    if (!var13_14.endsWith("/")) {
                        var13_14 = var13_14 + "/";
                    }
                }
                if (var13_14 != null) {
                    var8_9.setHeader("Content-Base", var13_14);
                }
                if (var0 != null) {
                    var8_9.setSession(var0.getSessionId());
                }
                if (var4_5 != null) {
                    try {
                        var14_16 = var8_9.getOutputStream();
                        var14_16.write(var4_5.getBytes());
                    }
                    catch (Exception var14_17) {
                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.describe[2]: " + var14_17.toString());
                    }
                }
                var2_2.addMessage((RTSPResponseMessage)var8_9);
                if (var0.isSessionValid()) {
                    var0.updateLoggingValues();
                    WMSLoggerFactory.getLoggerObj(var7_8).info(null, null, "rtsp", "describe", 200, var0.getSessionId());
                    var0.clearLoggingValues();
                }
            }
            catch (Exception var3_4) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.describe: " + var3_4.toString());
                var3_4.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void announce(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        try {
            var3_3 = null;
            var4_5 = new RTPRequestStatus();
            if (var0 == null) ** GOTO lbl-1000
            var0.onAnnounce(var1_1, var2_2);
            if (!var0.isSessionValid()) {
                RTSPStatics.setStatus(var4_5, 403);
            } else lbl-1000:
            // 2 sources

            {
                var5_6 = var1_1.getVHost();
                var6_7 = var5_6.getRTPContext();
                var7_8 = var1_1.getBodyAsString();
                if (var7_8 != null && var0.isDebugRTSPSession()) {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).info("ANNOUNCE:\n" + var7_8);
                }
                var8_9 = RTSPCore.createStream(var4_5, var0, var1_1, var2_2, 2, var7_8);
                if (var0 == null) {
                    var6_7.cacheRTPStream(var8_9);
                } else {
                    var0.addRTSPStream(var8_9);
                }
                var3_3 = var8_9.getAppInstance();
                if (var3_3 == null) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).warn("Application folder ([install-location]/applications/" + var8_9.getAppName() + ") is missing");
                    RTSPStatics.setStatus(var4_5, 403);
                    var0.setSessionValid(false);
                } else {
                    if (var0 != null) {
                        var0.setAnnounce(true);
                    }
                    var8_9.announce(var4_5);
                    if (var0.isSessionValid()) {
                        var0.updateLoggingValues();
                        WMSLoggerFactory.getLoggerObj(var3_3).info(null, null, "rtsp", "announce", 200, var0.getSessionId());
                        var0.clearLoggingValues();
                    }
                }
            }
            if (!var4_5.isGood()) {
                var0.setSessionValid(false);
                var0.shutdown(var4_5);
                var2_2.setIsDidClose(true);
            }
            var5_6 = new RTSPResponseMessage();
            var5_6.setResponseCode(var4_5.getResponseCode());
            var5_6.setResponseMessage(var4_5.getResponseMessage());
            var5_6.setCSeq(var1_1.getCSeq());
            if (var0 != null) {
                var5_6.setSession(var0.getSessionId());
            }
            var2_2.addMessage((RTSPResponseMessage)var5_6);
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.announce: " + var3_4.toString());
            var3_4.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getParameter(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (rTPSession != null) {
                rTPSession.onGetParameter(rTSPRequestMessage, rTSPResponseMessages);
                if (!rTPSession.isSessionValid()) {
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    return;
                }
            }
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.getParameter: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setParameter(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (rTPSession != null) {
                rTPSession.onSetParameter(rTSPRequestMessage, rTSPResponseMessages);
                if (!rTPSession.isSessionValid()) {
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    return;
                }
            }
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setParameter: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void options(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (rTPSession != null) {
                rTPSession.onOptions(rTSPRequestMessage, rTSPResponseMessages);
                if (!rTPSession.isSessionValid()) {
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    return;
                }
            }
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessage.setHeader("Public", "DESCRIBE, SETUP, TEARDOWN, PLAY, PAUSE, OPTIONS, ANNOUNCE, RECORD, GET_PARAMETER");
            rTSPResponseMessage.setHeader("Supported", "play.basic, con.persistent");
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.announce: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pause(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        try {
            var3_3 = var1_1.getTrackId();
            var4_5 = null;
            var5_6 = false;
            var6_7 = new RTPRequestStatus();
            var7_8 = null;
            if (var0 == null) ** GOTO lbl-1000
            var0.onPause(var1_1, var2_2);
            if (!var0.isSessionValid()) {
                RTSPStatics.setStatus(var6_7, 403);
            } else if ((var8_9 = var0.getRTSPStream()) == null) {
                var9_10 = var1_1.getHeader("context");
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + var9_10);
            } else {
                var7_8 = var8_9.getAppInstance();
                var8_9.pause(var6_7);
            }
            var8_9 = new RTSPResponseMessage();
            var8_9.setResponseCode(var6_7.getResponseCode());
            var8_9.setResponseMessage(var6_7.getResponseMessage());
            var8_9.setCSeq(var1_1.getCSeq());
            var8_9.setSession(var0.getSessionId());
            var2_2.addMessage((RTSPResponseMessage)var8_9);
            if (var0.isSessionValid()) {
                var0.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(var7_8).info(null, null, "rtsp", "pause", 200, var0.getSessionId());
                var0.clearLoggingValues();
            }
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.play: " + var3_4.toString());
            var3_4.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void play(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        try {
            var3_3 = var1_1.getTrackId();
            var4_5 = null;
            var5_6 = false;
            var6_7 = new RTPRequestStatus();
            var7_8 = null;
            var8_9 = null;
            var9_10 = null;
            var10_11 = -1.0;
            var12_12 = -1.0;
            if (var0 == null) ** GOTO lbl-1000
            var0.onPlay(var1_1, var2_2);
            if (!var0.isSessionValid()) {
                RTSPStatics.setStatus(var6_7, 403);
            } else if ((var7_8 = var0.getRTSPStream()) == null) {
                var14_13 = var1_1.getHeader("context");
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + (String)var14_13);
            } else {
                var14_13 = var1_1.getHeader("range");
                if (var14_13 != null) {
                    var15_14 = RTPUtils.decodeRangeHeader((String)var14_13);
                    var10_11 = var15_14[0];
                    var12_12 = var15_14[1];
                    if (var12_12 < 0.0) {
                        var12_12 = var7_8.getDuration();
                    }
                }
                var9_10 = var7_8.play(var6_7, var10_11, var12_12);
                var10_11 = var9_10.getRangeStart();
                var12_12 = var9_10.getRangeStop();
                var7_8.attachToWMSSession(var1_1.getWMSSessionInfo());
                var8_9 = var7_8.getAppInstance();
            }
            var14_13 = new RTSPResponseMessage();
            var14_13.setResponseCode(var6_7.getResponseCode());
            var14_13.setResponseMessage(var6_7.getResponseMessage());
            var14_13.setCSeq(var1_1.getCSeq());
            var14_13.setSession(var0.getSessionId());
            if (var7_8 != null) {
                if (var7_8.isLive()) {
                    var14_13.setHeader("Range", "npt=now-");
                } else if (var10_11 >= 0.0 && var12_12 >= 0.0) {
                    var14_13.setHeader("Range", "npt=" + var10_11 + "-" + var12_12);
                } else if (var10_11 >= 0.0) {
                    var14_13.setHeader("Range", "npt=" + var10_11 + "-");
                }
            }
            if (var9_10 != null && var9_10.getRTPInfo() != null) {
                var14_13.setHeader("RTP-Info", var9_10.getRTPInfo());
            }
            var2_2.addMessage((RTSPResponseMessage)var14_13);
            if (var0.isSessionValid()) {
                var0.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(var8_9).info(null, null, "rtsp", "play", 200, var0.getSessionId());
                var0.clearLoggingValues();
            }
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.play: " + var3_4.toString());
            var3_4.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void record(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        try {
            var3_3 = var1_1.getTrackId();
            var4_5 = null;
            var5_6 = false;
            var6_7 = new RTPRequestStatus();
            var7_8 = null;
            var8_9 = null;
            var9_10 = null;
            var10_11 = -1.0;
            var12_12 = -1.0;
            if (var0 == null) ** GOTO lbl-1000
            var0.onRecord(var1_1, var2_2);
            if (!var0.isSessionValid()) {
                RTSPStatics.setStatus(var6_7, 403);
            } else if ((var7_8 = var0.getRTSPStream()) == null) {
                var14_13 = var1_1.getHeader("context");
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + (String)var14_13);
            } else {
                var14_13 = var1_1.getHeader("range");
                if (var14_13 != null) {
                    var15_14 = RTPUtils.decodeRangeHeader((String)var14_13);
                    var10_11 = var15_14[0];
                    var12_12 = var15_14[1];
                    if (var12_12 < 0.0) {
                        var12_12 = var7_8.getDuration();
                    }
                }
                var9_10 = var7_8.record(var6_7, var10_11, var12_12);
                var10_11 = var9_10.getRangeStart();
                var12_12 = var9_10.getRangeStop();
                var7_8.attachToWMSSession(var1_1.getWMSSessionInfo());
                var8_9 = var7_8.getAppInstance();
            }
            var14_13 = new RTSPResponseMessage();
            var14_13.setResponseCode(var6_7.getResponseCode());
            var14_13.setResponseMessage(var6_7.getResponseMessage());
            var14_13.setCSeq(var1_1.getCSeq());
            var14_13.setSession(var0.getSessionId());
            if (var7_8 != null) {
                if (var7_8.isLive()) {
                    var14_13.setHeader("Range", "npt=now-");
                } else if (var10_11 >= 0.0 && var12_12 >= 0.0) {
                    var14_13.setHeader("Range", "npt=" + var10_11 + "-" + var12_12);
                } else if (var10_11 >= 0.0) {
                    var14_13.setHeader("Range", "npt=" + var10_11 + "-");
                }
            }
            if (var9_10 != null && var9_10.getRTPInfo() != null) {
                var14_13.setHeader("RTP-Info", var9_10.getRTPInfo());
            }
            var2_2.addMessage((RTSPResponseMessage)var14_13);
            if (var0.isSessionValid()) {
                var0.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(var8_9).info(null, null, "rtsp", "publish", 200, var0.getSessionId());
                var0.clearLoggingValues();
            }
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.record: " + var3_4.toString());
            var3_4.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void redirect(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (rTPSession != null) {
                rTPSession.onRedirect(rTSPRequestMessage, rTSPResponseMessages);
                if (!rTPSession.isSessionValid()) {
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    return;
                }
            }
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.redirect: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setup(RTPSession var0, RTSPRequestMessage var1_1, RTSPResponseMessages var2_2) {
        try {
            var3_3 = new RTPRequestStatus();
            var4_5 = null;
            var5_6 = false;
            if (var0 == null) ** GOTO lbl-1000
            var0.onSetup(var1_1, var2_2);
            if (!var0.isSessionValid()) {
                RTSPStatics.setStatus(var3_3, 403);
            } else lbl-1000:
            // 2 sources

            {
                var6_7 = var0.getRTSPStream();
                var4_5 = var1_1.getHeader("transport");
                if (var4_5 == null) {
                    WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: transport missing");
                } else {
                    if (var6_7 == null) {
                        var7_8 = var1_1.getVHost();
                        var8_9 = var7_8.getRTPContext();
                        var6_7 = var8_9.uncacheRTPStream((String)(var10_11 = (var9_10 = RTSPRequestAdapter.getRTPUrl(var1_1, true)).getUrlId()));
                        if (var6_7 == null) {
                            var6_7 = RTSPCore.createStream(var3_3, var0, var1_1, var2_2, 0, null);
                        }
                        if (var6_7 != null) {
                            var0.addRTSPStream((RTPStream)var6_7);
                        }
                    }
                    if (var6_7 == null) {
                        var7_8 = var1_1.getHeader("context");
                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + (String)var7_8);
                    } else {
                        var7_8 = "";
                        var8_9 = var6_7.transportFindBestMatch(var4_5).split("[;]");
                        if (((String[])var8_9).length > 0) {
                            var7_8 = var8_9[0];
                        }
                        var9_10 = var0.isAnnounceOrDescribe() != false ? var1_1.getTrackId() : null;
                        var10_11 = null;
                        if (var9_10 == null) {
                            var6_7.setMPEGTSOut(true);
                            var6_7.switchSetupToMPEGTS();
                            var10_11 = var6_7.getStreamTrack();
                            var5_6 = true;
                        } else if (var9_10.equals(var6_7.getStreamName())) {
                            var10_11 = var6_7.getStreamTrack();
                            if (var10_11 == null && !var6_7.isMPEGTSOut()) {
                                var6_7.setMPEGTSOut(true);
                                var6_7.switchSetupToMPEGTS();
                                var10_11 = var6_7.getStreamTrack();
                            }
                        } else {
                            var10_11 = var6_7.getTrack((String)var9_10);
                            if (var10_11 == null) {
                                var10_11 = var6_7.sloppyGetTrack((String)var9_10);
                            }
                        }
                        if (var10_11 == null) {
                            var10_11 = var6_7.getTrack("mpegts-transport");
                        }
                        if (var10_11 == null) {
                            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: track missing: " + (String)var9_10);
                        } else {
                            if (!var6_7.streamExists()) {
                                var6_7.createStream(var3_3);
                            }
                            var10_11.clearPorts();
                            var10_11.setup(var3_3, var4_5);
                            if (var3_3.isGood()) {
                                var4_5 = var10_11.getTransportStr(var4_5);
                            }
                            if (var5_6) {
                                var6_7.play(var3_3);
                                var6_7.attachToWMSSession(var1_1.getWMSSessionInfo());
                            }
                        }
                    }
                }
            }
            if (!var3_3.isGood()) {
                var0.setSessionValid(false);
                var0.shutdown(var3_3);
                var2_2.setIsDidClose(true);
            }
            var6_7 = new RTSPResponseMessage();
            var6_7.setResponseCode(var3_3.getResponseCode());
            var6_7.setResponseMessage(var3_3.getResponseMessage());
            var6_7.setCSeq(var1_1.getCSeq());
            var6_7.setSession(var0.getSessionId());
            if (var3_3.isGood()) {
                var7_8 = new Date();
                var6_7.setHeader("Transport", var4_5);
                var8_9 = FastDateFormat.getInstance((String)"EEE, d MMM yyyy HH:mm:ss z", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
                var9_10 = var8_9.format((Date)var7_8);
                var6_7.setHeader("Date", (String)var9_10);
                var6_7.setHeader("Expires", (String)var9_10);
            }
            var2_2.addMessage((RTSPResponseMessage)var6_7);
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: " + var3_4.toString());
            var3_4.printStackTrace();
        }
    }

    public static void teardown(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            if (rTPSession != null) {
                rTPSession.onTeardown(rTSPRequestMessage, rTSPResponseMessages);
            }
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            RTPStream rTPStream = rTPSession.getRTSPStream();
            if (rTPStream != null) {
                rTPStream.detachFromWMSSession(rTSPRequestMessage.getWMSSessionInfo());
            }
            if (rTPSession != null) {
                rTPSession.shutdown(rTPRequestStatus);
            }
            rTSPResponseMessages.setIsDidClose(true);
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setResponseCode(rTPRequestStatus.getResponseCode());
            rTSPResponseMessage.setResponseMessage(rTPRequestStatus.getResponseMessage());
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.teardown: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

