/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.httpstreamer;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterPlay;
import com.wowza.wms.vhost.IVHost;

public class MediaStreamHTTPStreamerRepeaterEdgePlay
extends MediaStreamLivePlay {
    protected String mediaCasterType = "httprepeater";
    protected MediaCasterItem mediaCasterDef = null;
    protected MediaCasterStreamMap mediaCasterStreams = null;

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        WMSProperties wMSProperties = this.getParent().getProperties();
        if (wMSProperties != null) {
            this.mediaCasterType = wMSProperties.getPropertyStr("mediaCasterType", this.mediaCasterType);
        }
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        this.mediaCasterStreams = iApplicationInstance.getMediaCasterStreams();
        IVHost iVHost = iApplicationInstance.getVHost();
        MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
        this.mediaCasterDef = mediaCasterList.getMediaCasterDef(this.mediaCasterType);
        if (this.mediaCasterDef == null) {
            WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).error("MediaStreamHTTPStreamerRepeaterPlay.init: Can't find MediaCaster definition: " + this.mediaCasterType);
        }
    }

    public void startPlay() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info("MediaStreamHTTPStreamerRepeaterPlay: startPlay");
        this.mediaCasterStreams.registerPlayer((IMediaStreamPlay)((Object)this), this.mediaCasterDef);
        super.startPlay();
    }

    public void close() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info("MediaStreamHTTPStreamerRepeaterPlay: close");
        super.close();
        this.mediaCasterStreams.unregisterPlayer((IMediaStreamPlay)((Object)this), this.mediaCasterDef);
    }
}

