/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.util;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylist;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylistEntry;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTrack;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTrackData;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTrackDatas;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTrackQualityLevel;
import com.wowza.wms.httpstreamer.smoothstreaming.model.SmoothStreamingDataTracks;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiveStreamPacketizerSmoothStreamerUtils {
    private static final long MAXFILESIZE = 66560L;
    public static final String PROTECTIONHEADER_SYSTEMID = "9A04F079-9840-4286-AB92-E65BE0885F95";
    public static final String EMPTYISMCXML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<SmoothStreamingMedia></SmoothStreamingMedia>";
    public static final String CRLF_STR = "\n";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String SESSIONIDPLACHOLDER = "{sessionid}";
    public static final String VIDEOBITRATEPLACHOLDER = "{videobitrate}";
    public static final String AUDIOBITRATEPLACHOLDER = "{audiobitrate}";
    public static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    public static final String STREAMINDEXEND = "</StreamIndex>\n";
    public static final String SMOOTHSTREAMINGMEDIAEND = "</SmoothStreamingMedia>\n";

    public static PlayReadyKeyInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        PlayReadyKeyInfo playReadyKeyInfo = null;
        String string2 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string2 + "/" + string + ".key");
        if (file.exists()) {
            playReadyKeyInfo = PlayReadyUtils.parseKeyFile((File)file, (String)"smoothstreaming-playready-");
        }
        if (playReadyKeyInfo != null && !playReadyKeyInfo.isComplete()) {
            playReadyKeyInfo = null;
        }
        return playReadyKeyInfo;
    }

    public static void formatDataTracks(StringBuffer stringBuffer, SmoothStreamingDataTracks smoothStreamingDataTracks) {
        try {
            List<SmoothStreamingDataTrack> list = smoothStreamingDataTracks.getDataTracks();
            for (SmoothStreamingDataTrack smoothStreamingDataTrack : list) {
                Map<String, String> map = smoothStreamingDataTrack.getAttributes();
                SmoothStreamingDataTrackDatas smoothStreamingDataTrackDatas = smoothStreamingDataTrack.getDatas();
                List<SmoothStreamingDataTrackQualityLevel> list2 = smoothStreamingDataTrack.getQualityLevels();
                stringBuffer.append("<StreamIndex");
                if (smoothStreamingDataTrack.getType() != null) {
                    stringBuffer.append(" Type=\"" + smoothStreamingDataTrack.getType() + "\"");
                }
                if (smoothStreamingDataTrack.getName() != null) {
                    stringBuffer.append(" Name=\"" + smoothStreamingDataTrack.getName() + "\"");
                }
                if (smoothStreamingDataTrack.getSubType() != null) {
                    stringBuffer.append(" Subtype=\"" + smoothStreamingDataTrack.getSubType() + "\"");
                }
                if (smoothStreamingDataTrack.getTimeScale() >= 0L) {
                    stringBuffer.append(" TimeScale=\"" + smoothStreamingDataTrack.getTimeScale() + "\"");
                }
                if (smoothStreamingDataTrack.getParentStreamIndex() != null) {
                    stringBuffer.append(" ParentStreamIndex=\"" + smoothStreamingDataTrack.getParentStreamIndex() + "\"");
                }
                for (String string : map.keySet()) {
                    String string2 = map.get(string);
                    stringBuffer.append(" " + string + "=\"" + string2 + "\"");
                }
                stringBuffer.append(" ManifestOutput=\"" + (smoothStreamingDataTrack.isManifestOutput() ? "TRUE" : "FALSE") + "\"");
                stringBuffer.append(" QualityLevels=\"" + list2.size() + "\"");
                stringBuffer.append(" Chunks=\"" + smoothStreamingDataTrackDatas.datas.size() + "\"");
                stringBuffer.append(">\n");
                Iterator<SmoothStreamingDataTrackQualityLevel> object2 = list2.iterator();
                int n = 0;
                while (object2.hasNext()) {
                    SmoothStreamingDataTrackQualityLevel smoothStreamingDataTrackQualityLevel = object2.next();
                    stringBuffer.append("<QualityLevel");
                    stringBuffer.append(" Index=\"" + n + "\"");
                    if (smoothStreamingDataTrackQualityLevel.getBitrate() != null) {
                        stringBuffer.append(" Bitrate=\"" + smoothStreamingDataTrackQualityLevel.getBitrate() + "\"");
                    }
                    if (smoothStreamingDataTrackQualityLevel.getCodecPrivateData() != null) {
                        stringBuffer.append(" CodecPrivateData=\"" + smoothStreamingDataTrackQualityLevel.getCodecPrivateData() + "\"");
                    }
                    if (smoothStreamingDataTrackQualityLevel.getFourCC() != null) {
                        stringBuffer.append(" FourCC=\"" + smoothStreamingDataTrackQualityLevel.getFourCC() + "\"");
                    }
                    Map<String, String> map2 = smoothStreamingDataTrackQualityLevel.getAttributes();
                    for (String string : map2.keySet()) {
                        String string3 = map2.get(string);
                        stringBuffer.append(" " + string + "=\"" + string3 + "\"");
                    }
                    stringBuffer.append("/>\n");
                    ++n;
                }
                long l = smoothStreamingDataTrackDatas.indexOffset;
                for (SmoothStreamingDataTrackData smoothStreamingDataTrackData : smoothStreamingDataTrackDatas.datas) {
                    stringBuffer.append("<c  n=\"" + l + "\" t=\"" + smoothStreamingDataTrackData.getTimecode() + "\">" + CRLF_STR);
                    if (smoothStreamingDataTrackData.isCDATA()) {
                        stringBuffer.append("<f><![CDATA[" + smoothStreamingDataTrackData.getDataStr() + "]]></f>" + CRLF_STR);
                    } else {
                        stringBuffer.append("<f>" + smoothStreamingDataTrackData.getDataStr() + "</f>" + CRLF_STR);
                    }
                    stringBuffer.append("</c>\n");
                    ++l;
                }
                stringBuffer.append(STREAMINDEXEND);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).error("LiveStreamPacketizerSmoothStreamerUtils.formatDataTracks: " + exception.toString());
        }
    }

    public static SmoothStreamingLivePlaylist parseLivePlaylist(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, String string, String string2) {
        IRandomAccessReader iRandomAccessReader;
        SmoothStreamingLivePlaylist smoothStreamingLivePlaylist;
        block27: {
            smoothStreamingLivePlaylist = null;
            IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
            String string3 = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string2 + ":" + string;
            iRandomAccessReader = null;
            try {
                int n;
                String string4;
                String string5;
                String string6;
                String string7;
                Element element;
                Node node;
                int n2;
                XPathExpression xPathExpression;
                NodeList nodeList;
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                mediaStreamDisconnected.setName(string, null, string2, null, 0.0, -1.0, 1);
                String string8 = "com.wowza.io.DirectRandomAccessReader";
                string8 = iApplicationInstance.getMediaReaderProperties().getPropertyStr("randomAccessReaderClass", string8);
                String string9 = iApplicationInstance.getStreamStoragePath();
                iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)iApplicationInstance, (String)string8, (String)string9, (String)string, (String)string2, (IMediaStream)mediaStreamDisconnected);
                if (iRandomAccessReader == null) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: File not found.");
                    break block27;
                }
                iRandomAccessReader.open();
                if (iRandomAccessReader.length() > 66560L) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: File too large for playlist file: " + iRandomAccessReader.length() + ">" + 66560L);
                    break block27;
                }
                byte[] byArray = new byte[(int)iRandomAccessReader.length()];
                int n3 = iRandomAccessReader.read(byArray, 0, byArray.length);
                if (n3 != byArray.length) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: Error reading file: " + n3 + " != " + byArray.length);
                    break block27;
                }
                try {
                    iRandomAccessReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iRandomAccessReader = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(dataInputStream);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                String string10 = "";
                int n4 = string.lastIndexOf("/");
                if (n4 > 0) {
                    string10 = string.substring(0, n4) + "/";
                }
                if ((nodeList = (NodeList)(xPathExpression = xPath.compile("/smil/body/switch/audio")).evaluate(document, XPathConstants.NODESET)) != null) {
                    for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                        node = nodeList.item(n2);
                        element = (Element)node;
                        string7 = "flv";
                        string6 = string10 + element.getAttribute("src");
                        if (string6 == null) {
                            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: Source property [src] is missing from video entry.");
                            continue;
                        }
                        string5 = element.getAttribute("system-bitrate");
                        if (string5 == null) {
                            string5 = element.getAttribute("systemBitrate");
                        }
                        if ((string6 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string6)) == null) continue;
                        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string6, (String)string7);
                        string6 = stringArray[0];
                        string7 = stringArray[1];
                        string4 = "";
                        boolean bl = string6.indexOf("://") >= 0;
                        n = string6.indexOf("?");
                        if (!bl && n >= 0) {
                            string4 = string6.substring(n + 1);
                            string6 = string6.substring(0, n);
                        }
                        if (smoothStreamingLivePlaylist == null) {
                            smoothStreamingLivePlaylist = new SmoothStreamingLivePlaylist();
                        }
                        smoothStreamingLivePlaylist.setAudioStreamName(string6);
                        smoothStreamingLivePlaylist.setAudioBitrate(string5);
                    }
                }
                if ((nodeList = (NodeList)(xPathExpression = xPath.compile("/smil/body/switch/video")).evaluate(document, XPathConstants.NODESET)) == null) break block27;
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    node = nodeList.item(n2);
                    element = (Element)node;
                    string7 = "flv";
                    string6 = string10 + element.getAttribute("src");
                    if (string6 == null) {
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: Source property [src] is missing from video entry.");
                        continue;
                    }
                    string5 = element.getAttribute("system-bitrate");
                    if (string5 == null) {
                        string5 = element.getAttribute("systemBitrate");
                    }
                    if (string5 != null && string5.length() == 0) {
                        string5 = null;
                    }
                    if (string5 == null) {
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: System bitrate property [system-bitrate] is missing for entry: " + string6);
                        continue;
                    }
                    int n5 = 0;
                    try {
                        n5 = Integer.parseInt(string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string4 = "";
                    string6 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string6);
                    if (string6 == null) continue;
                    String[] stringArray = ModuleUtils.decodeStreamExtension((String)string6, (String)string7);
                    string6 = stringArray[0];
                    string7 = stringArray[1];
                    n = string6.indexOf("://") >= 0 ? 1 : 0;
                    int n6 = string6.indexOf("?");
                    if (n == 0 && n6 >= 0) {
                        string4 = string6.substring(n6 + 1);
                        string6 = string6.substring(0, n6);
                    }
                    if (smoothStreamingLivePlaylist == null) {
                        smoothStreamingLivePlaylist = new SmoothStreamingLivePlaylist();
                    }
                    if (smoothStreamingLivePlaylist.contains(string5)) {
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).warn("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: Two streams cannot share the same bitrate: " + string5);
                        continue;
                    }
                    SmoothStreamingLivePlaylistEntry smoothStreamingLivePlaylistEntry = new SmoothStreamingLivePlaylistEntry();
                    smoothStreamingLivePlaylistEntry.setBitrate(string5);
                    smoothStreamingLivePlaylistEntry.setPlaylistBitrate(string5);
                    smoothStreamingLivePlaylistEntry.setStreamName(string6);
                    smoothStreamingLivePlaylistEntry.setStreamExt(string7);
                    smoothStreamingLivePlaylistEntry.setBitrateNum(n5);
                    smoothStreamingLivePlaylist.put(string5, smoothStreamingLivePlaylistEntry);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreamerUtils.class).error("LiveStreamPacketizerSmoothStreamerUtils.parseLivePlaylist[" + string3 + "]: " + exception.toString());
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iRandomAccessReader = null;
        }
        return smoothStreamingLivePlaylist;
    }
}

