/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackAtomBase;

public class QTWriterContextTrackCTTS
extends QTWriterContextTrackAtomBase {
    public static final int ROWSPERBLOCK = 4096;
    public static final int BYTESPERROW = 8;
    public static final String TYPESTR = "ctts";
    private boolean isFirst = true;
    private long lastCTTS = 0L;
    private long countCTTS = 0L;

    public QTWriterContextTrackCTTS(QTWriterContextTrack qTWriterContextTrack) {
        super(qTWriterContextTrack, 4096, 8);
    }

    public void flush() {
        if (this.count > 0 || this.lastCTTS != 0L) {
            BufferUtils.longToByteArray((long)this.countCTTS, (byte[])this.block, (int)(this.currRow * this.bytesPerRow + 0), (int)4);
            BufferUtils.longToByteArray((long)this.lastCTTS, (byte[])this.block, (int)(this.currRow * this.bytesPerRow + 4), (int)4);
            ++this.currRow;
            ++this.count;
            if (this.currRow >= this.rowsPerBlock) {
                this.flushBlock(this.block, TYPESTR, this.currRow * this.bytesPerRow);
                this.currRow = 0;
            }
            this.isFirst = true;
        }
    }

    public boolean isAllZero() {
        return this.count <= 0 || this.count == 1 && this.lastCTTS == 0L;
    }

    public void addOffset(long l) {
        if (this.isFirst) {
            this.lastCTTS = l;
            this.countCTTS = 1L;
            this.isFirst = false;
        } else if (l != this.lastCTTS) {
            BufferUtils.longToByteArray((long)this.countCTTS, (byte[])this.block, (int)(this.currRow * this.bytesPerRow + 0), (int)4);
            BufferUtils.longToByteArray((long)this.lastCTTS, (byte[])this.block, (int)(this.currRow * this.bytesPerRow + 4), (int)4);
            ++this.currRow;
            ++this.count;
            if (this.currRow >= this.rowsPerBlock) {
                this.flushBlock(this.block, TYPESTR, this.currRow * this.bytesPerRow);
                this.currRow = 0;
            }
            this.lastCTTS = l;
            this.countCTTS = 1L;
        } else {
            ++this.countCTTS;
        }
    }
}

