/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public final class LevelPatternConverter
extends LoggingEventPatternConverter {
    private static final int TRACE_INT = 5000;
    private static final LevelPatternConverter INSTANCE = new LevelPatternConverter();

    private LevelPatternConverter() {
        super("Level", "level");
    }

    public static LevelPatternConverter newInstance(String[] stringArray) {
        return INSTANCE;
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        stringBuffer.append(loggingEvent.getLevel().toString());
    }

    public String getStyleClass(Object object) {
        if (object instanceof LoggingEvent) {
            int n = ((LoggingEvent)object).getLevel().toInt();
            switch (n) {
                case 5000: {
                    return "level trace";
                }
                case 10000: {
                    return "level debug";
                }
                case 20000: {
                    return "level info";
                }
                case 30000: {
                    return "level warn";
                }
                case 40000: {
                    return "level error";
                }
                case 50000: {
                    return "level fatal";
                }
            }
            return "level " + ((LoggingEvent)object).getLevel().toString();
        }
        return "level";
    }
}

